/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.officeonline.AccessToken;
import org.exoplatform.officeonline.Permissions;

public class EditorConfig {
    protected final AccessToken accessToken;
    protected final String userId;
    protected final String fileId;
    protected final String workspace;
    protected final String baseUrl;
    protected final List<Permissions> permissions;

    public EditorConfig(String userId, String fileId, String workspace, String baseUrl, List<Permissions> permissions, AccessToken accessToken) {
        this.userId = userId;
        this.fileId = fileId;
        this.workspace = workspace;
        this.baseUrl = baseUrl;
        this.permissions = permissions != null ? permissions : Collections.emptyList();
        this.accessToken = accessToken;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFileId() {
        return this.fileId;
    }

    protected List<Permissions> getPermissions() {
        return this.permissions;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public static class Builder {
        private AccessToken accessToken;
        private String userId;
        private String fileId;
        private String workspace;
        private String baseUrl;
        private List<Permissions> permissions = new ArrayList<Permissions>();

        public Builder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder workspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder permissions(List<Permissions> permissions) {
            this.permissions = permissions;
            return this;
        }

        public String userId() {
            return this.userId;
        }

        public String fileId() {
            return this.fileId;
        }

        public String workspace() {
            return this.workspace;
        }

        public String baseUrl() {
            return this.baseUrl;
        }

        public List<Permissions> permissions() {
            return this.permissions;
        }

        public AccessToken accessToken() {
            return this.accessToken;
        }

        public EditorConfig build() {
            return new EditorConfig(this.userId, this.fileId, this.workspace, this.baseUrl, this.permissions, this.accessToken);
        }
    }
}

