/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.officeonline.FileLock;
import org.exoplatform.officeonline.exception.LockMismatchException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WOPILockManagerPlugin
extends BaseComponentPlugin {
    protected ExoCache<String, FileLock> locks;
    protected static final String CACHE_NAME = "officeonline.locks.Cache".intern();
    protected static final String MIX_LOCKABLE = "mix:lockable";
    protected static final Log LOG = ExoLogger.getLogger(WOPILockManagerPlugin.class);
    protected static final long LOCK_EXPIRES = 1800000L;
    protected static final long EXPIRES_DELAY = 300000L;
    protected SessionProviderService sessionProviders;
    protected RepositoryService jcrService;
    protected LockService lockService;
    protected ScheduledExecutorService expiresExecutor = Executors.newScheduledThreadPool(1);

    public WOPILockManagerPlugin(CacheService cacheService, SessionProviderService sessionProviders, RepositoryService jcrService, LockService lockService) {
        this.locks = cacheService.getCacheInstance(CACHE_NAME);
        this.sessionProviders = sessionProviders;
        this.jcrService = jcrService;
        this.lockService = lockService;
        this.expiresExecutor.scheduleAtFixedRate(() -> this.removeExpired(), 300000L, 300000L, TimeUnit.MILLISECONDS);
    }

    public void lock(Node node, String lockId) throws RepositoryException, LockMismatchException {
        if (!node.isNodeType(MIX_LOCKABLE)) {
            node.addMixin(MIX_LOCKABLE);
            node.save();
        }
        if (!node.isLocked()) {
            this.lockNode(node, lockId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node successfully locked. UUID: {}, lockId: {}", new Object[]{node.getUUID(), lockId});
            }
        } else {
            FileLock fileLock = (FileLock)this.locks.get((Serializable)((Object)node.getUUID()));
            if (fileLock == null) {
                String lockToken = "";
                try {
                    lockToken = this.lockService.getLockToken(node);
                }
                catch (Exception e) {
                    LOG.error("Cannot get lock token from node. UUID: {}. {}", new Object[]{node.getUUID(), e.getMessage()});
                }
                throw new LockMismatchException("File locked by other service", lockToken);
            }
            if (lockId.equals(fileLock.getLockId())) {
                fileLock.setExpires(System.currentTimeMillis() + 1800000L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Lock refreshed. UUID: {}, lockId: {}", new Object[]{node.getUUID(), lockId});
                }
            } else {
                throw new LockMismatchException("Provided lock doesn't match lock on file", fileLock.getLockId());
            }
        }
    }

    public FileLock getLock(Node node) throws RepositoryException {
        return node.isLocked() ? (FileLock)this.locks.get((Serializable)((Object)node.getUUID())) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlock(Node node, String lockId, String workspace) throws RepositoryException, LockMismatchException {
        FileLock fileLock = (FileLock)this.locks.get((Serializable)((Object)node.getUUID()));
        if (fileLock == null) throw new LockMismatchException("File isn't locked", "");
        if (!lockId.equals(fileLock.getLockId())) throw new LockMismatchException("Provided lockId doesn't match lock on the file", fileLock.getLockId());
        this.getUserSession(workspace).addLockToken(fileLock.getLockToken());
        this.unlockNode(node);
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("Lock removed from node UUID: {}, lockId: {}", new Object[]{node.getUUID(), lockId});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshLock(Node node, String lockId) throws RepositoryException, LockMismatchException {
        FileLock fileLock = (FileLock)this.locks.get((Serializable)((Object)node.getUUID()));
        if (fileLock == null) throw new LockMismatchException("File isn't locked", "");
        if (!lockId.equals(fileLock.getLockId())) throw new LockMismatchException("Provided lockId doesn't match lock on the file", fileLock.getLockId());
        fileLock.setExpires(System.currentTimeMillis() + 1800000L);
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("Lock refreshed. UUID: {}, lockId: {}", new Object[]{node.getUUID(), lockId});
    }

    protected Session getUserSession(String workspace) throws RepositoryException {
        if (workspace == null) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        return sp.getSession(workspace, this.jcrService.getCurrentRepository());
    }

    protected Session getSystemSession() throws RepositoryException {
        String workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        SessionProvider sp = SessionProvider.createSystemProvider();
        return sp.getSession(workspace, this.jcrService.getCurrentRepository());
    }

    protected void removeExpired() {
        try {
            this.locks.select((CachedObjectSelector)new CachedObjectSelector<String, FileLock>(){

                public boolean select(String key, ObjectCacheInfo<? extends FileLock> ocinfo) {
                    FileLock lock = (FileLock)ocinfo.get();
                    return lock != null ? lock.getExpires() - System.currentTimeMillis() < 300000L : false;
                }

                public void onSelect(ExoCache<? extends String, ? extends FileLock> cache, String fileId, ObjectCacheInfo<? extends FileLock> ocinfo) throws Exception {
                    FileLock lock = (FileLock)ocinfo.get();
                    try {
                        Session session = WOPILockManagerPlugin.this.getSystemSession();
                        session.addLockToken(lock.getLockToken());
                        Node node = session.getNodeByUUID(fileId);
                        if (node.isLocked()) {
                            WOPILockManagerPlugin.this.unlockNode(node);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Node unlocked (lock expired). UUID: {}", new Object[]{fileId});
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        LOG.warn("Cannot unlock node. UUID {}, {}", new Object[]{fileId, e.getMessage()});
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot unlock expired nodes", (Throwable)e);
        }
    }

    private void lockNode(Node node, String lockId) throws RepositoryException {
        Lock lock = node.lock(true, false);
        try {
            LockUtil.keepLock((Lock)lock);
        }
        catch (Exception e) {
            LOG.warn("Cannot keep lock in lock service", new Object[]{e.getMessage()});
        }
        long expires = System.currentTimeMillis() + 1800000L;
        FileLock fileLock = new FileLock(lockId, lock.getLockToken(), expires);
        this.locks.put((Serializable)((Object)lock.getNode().getUUID()), (Object)fileLock);
    }

    private void unlockNode(Node node) throws RepositoryException {
        node.unlock();
        this.locks.remove((Serializable)((Object)node.getUUID()));
        try {
            LockUtil.removeLock((Node)node);
        }
        catch (Exception e) {
            LOG.warn("Cannot remove lock in lock service", new Object[]{e.getMessage()});
        }
    }
}

