/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.officeonline.portlet;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.officeonline.AccessToken;
import org.exoplatform.officeonline.EditorConfig;
import org.exoplatform.officeonline.EditorService;
import org.exoplatform.officeonline.RequestInfo;
import org.exoplatform.officeonline.WOPIService;
import org.exoplatform.officeonline.exception.ActionNotFoundException;
import org.exoplatform.officeonline.exception.FileExtensionNotFoundException;
import org.exoplatform.officeonline.exception.FileNotFoundException;
import org.exoplatform.officeonline.exception.OfficeOnlineException;
import org.exoplatform.officeonline.portlet.EditorPortlet;
import org.exoplatform.officeonline.webui.OfficeOnlineContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;

public class EditorPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(EditorPortlet.class);
    private static final String UTF_8 = "utf-8";
    private EditorService editorService;
    private WOPIService wopiService;
    private ResourceBundleService i18nService;

    public void init() throws PortletException {
        super.init();
        PortalContainer container = PortalContainer.getInstance();
        this.editorService = (EditorService)container.getComponentInstanceOfType(EditorService.class);
        this.wopiService = (WOPIService)container.getComponentInstanceOfType(WOPIService.class);
        this.i18nService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
    }

    @RenderMode(name="view")
    public void view(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        block12: {
            ResourceBundle i18n = this.i18nService.getResourceBundle(new String[]{"locale.officeonline.OfficeOnlineClient"}, request.getLocale());
            WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            String fileId = webuiContext.getRequestParameter("fileId");
            String action = webuiContext.getRequestParameter("action");
            if (fileId != null) {
                try {
                    RequestInfo requestInfo = new RequestInfo(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRemoteUser(), request.getLocale());
                    EditorConfig config = this.editorService.createEditorConfig(request.getRemoteUser(), fileId, null, requestInfo);
                    AccessToken token = config.getAccessToken();
                    Node node = this.wopiService.nodeByUUID(fileId, null);
                    if (action == null) {
                        action = "edit";
                    }
                    if (this.wopiService.isNewDocument(node)) {
                        action = "editnew";
                    }
                    if (this.validAction(node, action)) {
                        String actionURL = this.wopiService.getActionUrl(requestInfo, fileId, null, action);
                        String filename = this.wopiService.nodeTitle(node);
                        String versionsUrl = this.wopiService.getExplorerURL(node, config.getBaseUrl()).append("&versions=true").toString();
                        String workspace = node.getSession().getWorkspace().getName();
                        InitConfig initConfig = new InitConfig(node.getUUID(), workspace, token, actionURL, versionsUrl, filename);
                        OfficeOnlineContext.callModule((String)("officeonline.initEditor(" + initConfig.toJSON() + ");"));
                        break block12;
                    }
                    OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.EditorCannotBeCreated"));
                }
                catch (RepositoryException e) {
                    LOG.error("Error reading document node by ID: {}", new Object[]{fileId, e});
                    OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.CannotReadDocument"));
                }
                catch (JsonException e) {
                    LOG.error("Error creating JSON from access token for node by ID: {}", new Object[]{fileId, e});
                    OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.EditorCannotBeCreated"));
                }
                catch (FileNotFoundException e) {
                    LOG.error("Error creating editor config. File not found {}", new Object[]{fileId, e});
                    OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.FileNotFound"));
                }
                catch (FileExtensionNotFoundException e) {
                    LOG.error("Error while getting file extension. ID: {}", new Object[]{fileId, e});
                    OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.WrongExtension"));
                }
                catch (ActionNotFoundException e) {
                    LOG.error("Error getting actionURL by fileId and action. FileId: {}", new Object[]{fileId, e});
                    OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.ActionNotFound"));
                }
                catch (OfficeOnlineException e) {
                    LOG.error("Error creating document editor for node by ID: {}", new Object[]{fileId, e});
                    OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.EditorCannotBeCreated"));
                }
            } else {
                LOG.error("Error initializing editor configuration for node by ID: {}", new Object[]{fileId});
                OfficeOnlineContext.showError((String)i18n.getString("OfficeOnlineEditorClient.ErrorTitle"), (String)i18n.getString("OfficeOnlineEditor.error.DocumentIdRequired"));
            }
        }
        PortletRequestDispatcher prDispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/pages/editor.jsp");
        prDispatcher.include(request, response);
    }

    protected boolean validAction(Node node, String action) throws RepositoryException {
        if (action.equals("edit") && this.wopiService.canEdit(node)) {
            return true;
        }
        if (action.equals("editnew") && this.wopiService.canEdit(node) && this.wopiService.isNewDocument(node)) {
            return true;
        }
        return action.equals("view") && this.wopiService.canView(node);
    }
}

