/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.cometd;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.annotation.Service;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class CometdOnlyofficeService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CometdOnlyofficeService.class);
    public static final String CHANNEL_NAME = "/eXo/Application/Onlyoffice/editor/";
    public static final String DOCUMENT_SAVED_EVENT = "DOCUMENT_SAVED";
    protected final OnlyofficeEditorService onlyofficeEditorService;
    protected final EXoContinuationBayeux exoBayeux;
    protected final CometdService service;

    public CometdOnlyofficeService(EXoContinuationBayeux exoBayeux, OnlyofficeEditorService onlyofficeEditorService) {
        this.exoBayeux = exoBayeux;
        this.onlyofficeEditorService = onlyofficeEditorService;
        this.service = new CometdService();
    }

    public void start() {
        final AtomicReference processor = new AtomicReference();
        this.exoBayeux.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                ServerAnnotationProcessor p = new ServerAnnotationProcessor((BayeuxServer)CometdOnlyofficeService.this.exoBayeux);
                processor.set(p);
                p.process((Object)CometdOnlyofficeService.this.service);
            }

            public void lifeCycleStopped(LifeCycle event) {
                ServerAnnotationProcessor p = (ServerAnnotationProcessor)processor.get();
                if (p != null) {
                    p.deprocess((Object)CometdOnlyofficeService.this.service);
                }
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        if (PropertyManager.isDevelopping()) {
            this.exoBayeux.addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

                public void sessionRemoved(ServerSession session, boolean timedout) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionRemoved: " + session.getId() + " timedout:" + timedout + " channels: " + CometdOnlyofficeService.this.channelsAsString(session.getSubscriptions())));
                    }
                }

                public void sessionAdded(ServerSession session, ServerMessage message) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionAdded: " + session.getId() + " channels: " + CometdOnlyofficeService.this.channelsAsString(session.getSubscriptions())));
                    }
                }
            });
        }
    }

    protected String channelsAsString(Set<ServerChannel> channels) {
        return channels.stream().map(c -> c.getId()).collect(Collectors.joining(", "));
    }

    public void stop() {
    }

    public String getCometdServerPath() {
        return "/" + this.exoBayeux.getCometdContextName() + "/cometd";
    }

    public String getUserToken(String userId) {
        return this.exoBayeux.getUserToken(userId);
    }

    @Service(value="onlyoffice")
    public class CometdService {
        @Inject
        private BayeuxServer bayeux;
        @org.cometd.annotation.Session
        private LocalSession localSession;
        @org.cometd.annotation.Session
        private ServerSession serverSession;

        @PostConstruct
        public void postConstruct() {
            CometdOnlyofficeService.this.onlyofficeEditorService.addListener(new OnlyofficeEditorListener(){

                @Override
                public void onSaved(DocumentStatus status) {
                    String docId = status.getConfig().getDocId();
                    ServerChannel channel = CometdService.this.bayeux.getChannel(CometdOnlyofficeService.CHANNEL_NAME + docId);
                    if (channel != null) {
                        LOG.info("Document {} saved. Sending message to cometd channel", new Object[]{docId});
                        StringBuilder data = new StringBuilder();
                        data.append('{');
                        data.append("\"type\": \"");
                        data.append(CometdOnlyofficeService.DOCUMENT_SAVED_EVENT);
                        data.append("\", ");
                        data.append("\"docId\": \"");
                        data.append(docId);
                        data.append("\", ");
                        data.append("\"userId\": \"");
                        data.append(status.getLastUser());
                        data.append("\"");
                        data.append('}');
                        channel.publish((Session)CometdService.this.localSession, (Object)data.toString());
                    }
                }

                @Override
                public void onLeaved(DocumentStatus status) {
                }

                @Override
                public void onJoined(DocumentStatus status) {
                }

                @Override
                public void onGet(DocumentStatus status) {
                }

                @Override
                public void onError(DocumentStatus status) {
                }

                @Override
                public void onCreate(DocumentStatus status) {
                }
            });
        }
    }
}

