/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.cms.views.impl.ManageViewPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class CustomizeViewPlugin
extends ManageViewPlugin {
    protected final InitParams params;
    protected final RepositoryService repositoryService;
    protected final NodeHierarchyCreator nodeHierarchyCreator;
    protected final ConfigurationManager cservice;
    protected final DMSConfiguration dmsConfiguration;
    protected final TemplateService templateService;
    protected final Set<String> configuredTemplate = new HashSet<String>();
    protected final Set<String> configuredViews = new HashSet<String>();

    public CustomizeViewPlugin(RepositoryService repositoryService, InitParams params, ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration, TemplateService templateService) throws Exception {
        super(repositoryService, params, cservice, nodeHierarchyCreator, dmsConfiguration);
        this.params = params;
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.cservice = cservice;
        this.dmsConfiguration = dmsConfiguration;
        this.templateService = templateService;
    }

    public Set<String> getConfiguredTemplates() {
        return Collections.emptySet();
    }

    public Set<String> getConfiguredViews() {
        return Collections.emptySet();
    }

    public void init() throws Exception {
        this.importCustomizedViews();
    }

    private void importCustomizedViews() throws Exception {
        this.configuredTemplate.clear();
        this.configuredViews.clear();
        Iterator objectsIter = this.params.getObjectParamIterator();
        String viewsPath = this.nodeHierarchyCreator.getJcrPath("userViewsPath");
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration.getConfig();
        Session session = manageableRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
        Node viewHomeNode = (Node)session.getItem(viewsPath);
        while (objectsIter.hasNext()) {
            ViewConfig viewObject;
            String viewNodeName;
            Object object = ((ObjectParameter)objectsIter.next()).getObject();
            if (!(object instanceof ViewConfig) || !viewHomeNode.hasNode(viewNodeName = (viewObject = (ViewConfig)object).getName())) continue;
            this.configuredViews.add(viewNodeName);
            Node viewNode = this.customizeView(viewHomeNode, viewNodeName, viewObject.getPermissions(), viewObject.isHideExplorerPanel(), viewObject.getTemplate());
            for (ViewConfig.Tab tab : viewObject.getTabList()) {
                this.customizeTab(viewNode, tab.getTabName(), tab.getButtons());
            }
        }
        session.save();
        session.logout();
    }

    protected Node customizeView(Node viewManager, String viewName, String permissions, Boolean hideExplorerPanel, String template) throws Exception {
        Node viewNode = viewManager.getNode(viewName);
        return viewNode;
    }

    protected void customizeTab(Node view, String tabName, String buttons) throws Exception {
        buttons = buttons.trim();
        if (view.hasNode(tabName) && buttons.length() > 0) {
            Node tab = view.getNode(tabName);
            LinkedHashSet<String> addButtons = new LinkedHashSet<String>();
            for (String action : buttons.split(";")) {
                if ((action = action.trim()).length() <= 0) continue;
                addButtons.add(action);
            }
            if (tab.hasProperty("exo:buttons")) {
                Property exoButtons = tab.getProperty("exo:buttons");
                String newButtons = this.mergeButtons(exoButtons.getString(), addButtons);
                exoButtons.setValue(newButtons);
            }
            view.save();
        }
    }

    protected String mergeButtons(String buttons, Set<String> addButtons) throws RepositoryException {
        StringBuilder buttonStr = new StringBuilder();
        for (String action : addButtons) {
            if (buttons.indexOf(action) >= 0) continue;
            if (buttonStr.length() > 0) {
                buttonStr.append(';');
                buttonStr.append(' ');
            }
            buttonStr.append(action);
        }
        if (buttonStr.length() > 0 && buttons.length() > 0) {
            buttonStr.append(';');
            buttonStr.append(' ');
        }
        buttonStr.append(buttons);
        return buttonStr.toString();
    }
}

