/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.RequiredTypeException;
import io.jsonwebtoken.impl.JwtMap;
import java.util.Date;
import java.util.Map;

public class DefaultClaims
extends JwtMap
implements Claims {
    public DefaultClaims() {
    }

    public DefaultClaims(Map<String, Object> map) {
        super(map);
    }

    public String getIssuer() {
        return this.getString("iss");
    }

    public Claims setIssuer(String iss) {
        this.setValue("iss", iss);
        return this;
    }

    public String getSubject() {
        return this.getString("sub");
    }

    public Claims setSubject(String sub) {
        this.setValue("sub", sub);
        return this;
    }

    public String getAudience() {
        return this.getString("aud");
    }

    public Claims setAudience(String aud) {
        this.setValue("aud", aud);
        return this;
    }

    public Date getExpiration() {
        return this.get("exp", Date.class);
    }

    public Claims setExpiration(Date exp) {
        this.setDateAsSeconds("exp", exp);
        return this;
    }

    public Date getNotBefore() {
        return this.get("nbf", Date.class);
    }

    public Claims setNotBefore(Date nbf) {
        this.setDateAsSeconds("nbf", nbf);
        return this;
    }

    public Date getIssuedAt() {
        return this.get("iat", Date.class);
    }

    public Claims setIssuedAt(Date iat) {
        this.setDateAsSeconds("iat", iat);
        return this;
    }

    public String getId() {
        return this.getString("jti");
    }

    public Claims setId(String jti) {
        this.setValue("jti", jti);
        return this;
    }

    private static boolean isSpecDate(String claimName) {
        return "exp".equals(claimName) || "iat".equals(claimName) || "nbf".equals(claimName);
    }

    @Override
    public Object put(String s, Object o) {
        if (o instanceof Date && DefaultClaims.isSpecDate(s)) {
            Date date = (Date)o;
            return this.setDateAsSeconds(s, date);
        }
        return super.put(s, o);
    }

    public <T> T get(String claimName, Class<T> requiredType) {
        Object value = this.get(claimName);
        if (value == null) {
            return null;
        }
        if (Date.class.equals(requiredType)) {
            value = DefaultClaims.isSpecDate(claimName) ? DefaultClaims.toSpecDate(value, claimName) : DefaultClaims.toDate(value, claimName);
        }
        return this.castClaimValue(value, requiredType);
    }

    private <T> T castClaimValue(Object value, Class<T> requiredType) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (requiredType == Long.class) {
                value = (long)intValue;
            } else if (requiredType == Short.class && Short.MIN_VALUE <= intValue && intValue <= Short.MAX_VALUE) {
                value = (short)intValue;
            } else if (requiredType == Byte.class && -128 <= intValue && intValue <= 127) {
                value = (byte)intValue;
            }
        }
        if (!requiredType.isInstance(value)) {
            throw new RequiredTypeException("Expected value to be of type: " + requiredType + ", but was " + value.getClass());
        }
        return requiredType.cast(value);
    }
}

