/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class Config
implements Externalizable {
    private static final Log LOG = ExoLogger.getLogger(Config.class);
    protected static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    protected static final String NO_LANG = "no_lang".intern();
    protected static final String EMPTY = "".intern();
    private String documentserverUrl;
    private String documentserverJsUrl;
    private String platformRestUrl;
    private String editorUrl;
    private transient URI explorerUri;
    private String workspace;
    private String path;
    private String displayPath;
    private String comment;
    private Boolean renameAllowed;
    private Boolean isActivity;
    private String docId;
    private String documentType;
    private String token;
    private Document document;
    private Editor editorConfig;
    private String error;
    private transient Node node;
    private transient ThreadLocal<Boolean> sameModifier = new ThreadLocal();
    private transient ThreadLocal<Calendar> previousModified = new ThreadLocal();
    private Boolean open;
    private Boolean closing;
    private Long openedTime;
    private Long closedTime;

    protected static Builder editor(String documentserverUrl, String documentType, String workspace, String path, String docId) {
        return new Builder(documentserverUrl, documentType, workspace, path, docId);
    }

    protected static String fileUrl(CharSequence baseUrl, String userId, String key) {
        return new StringBuilder(baseUrl).append("/onlyoffice/editor/content/").append(userId).append("/").append(key).toString();
    }

    protected static String callbackUrl(CharSequence baseUrl, String userId, String key) {
        return new StringBuilder(baseUrl).append("/onlyoffice/editor/status/").append(userId).append("/").append(key).toString();
    }

    public Config() {
    }

    protected Config(String documentserverUrl, String platformRestUrl, String editorUrl, URI explorerUri, String documentType, String workspace, String path, String displayPath, String comment, Boolean renameAllowed, Boolean isActivity, String docId, Document document, Editor editor) {
        this.workspace = workspace;
        this.path = path;
        this.displayPath = displayPath;
        this.isActivity = isActivity;
        this.comment = comment;
        this.renameAllowed = renameAllowed;
        this.docId = docId;
        this.documentType = documentType;
        this.documentserverUrl = documentserverUrl;
        this.documentserverJsUrl = documentserverUrl + "apps/api/documents/api.js";
        this.platformRestUrl = platformRestUrl;
        this.editorUrl = editorUrl;
        this.explorerUri = explorerUri;
        this.document = document;
        this.editorConfig = editor;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.workspace);
        out.writeUTF(this.path);
        out.writeUTF(this.documentType);
        out.writeUTF(this.documentserverUrl);
        out.writeUTF(this.documentserverJsUrl);
        out.writeUTF(this.platformRestUrl.toString());
        out.writeUTF(this.editorUrl);
        out.writeUTF(this.displayPath);
        out.writeUTF(this.comment);
        out.writeBoolean(this.renameAllowed);
        out.writeBoolean(this.isActivity);
        try {
            out.writeObject(this.explorerUri);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error serializing explorer URI for " + this.path), (Throwable)e);
        }
        out.writeUTF(this.open != null ? this.open.toString() : EMPTY);
        out.writeUTF(this.error != null ? this.error : EMPTY);
        out.writeUTF(this.document.getKey());
        out.writeUTF(this.document.getFileType());
        out.writeUTF(this.document.getTitle());
        out.writeUTF(this.document.getUrl());
        out.writeUTF(this.document.getLastModifier());
        out.writeLong(this.document.getLastModified());
        out.writeUTF(this.document.getInfo().getAuthor());
        out.writeUTF(this.document.getInfo().getCreated());
        out.writeUTF(this.document.getInfo().getFolder());
        out.writeUTF(this.editorConfig.getCallbackUrl());
        String elang = this.editorConfig.getLang();
        out.writeUTF(elang != null ? elang : NO_LANG);
        out.writeUTF(this.editorConfig.getMode());
        out.writeUTF(this.editorConfig.getUser().getId());
        out.writeUTF(this.editorConfig.getUser().getFirstname());
        out.writeUTF(this.editorConfig.getUser().getLastname());
        out.writeLong(this.editorConfig.getUser().getLastModified());
        out.writeLong(this.editorConfig.getUser().getLastSaved());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workspace = in.readUTF();
        this.path = in.readUTF();
        this.documentType = in.readUTF();
        this.documentserverUrl = in.readUTF();
        this.documentserverJsUrl = in.readUTF();
        this.platformRestUrl = in.readUTF();
        this.editorUrl = in.readUTF();
        this.displayPath = in.readUTF();
        this.comment = in.readUTF();
        this.renameAllowed = in.readBoolean();
        this.isActivity = in.readBoolean();
        try {
            this.explorerUri = (URI)in.readObject();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error deserializing explorer URI for " + this.path), (Throwable)e);
            this.explorerUri = null;
        }
        String openString = in.readUTF();
        if (EMPTY.equals(openString)) {
            this.closing = null;
            this.open = null;
        } else {
            this.open = Boolean.valueOf(openString);
            this.closing = new Boolean(false);
        }
        String errorString = in.readUTF();
        this.error = EMPTY.equals(errorString) ? null : errorString;
        String dkey = in.readUTF();
        String dfileType = in.readUTF();
        String dtitle = in.readUTF();
        String durl = in.readUTF();
        String dmodifier = in.readUTF();
        Long dmodified = in.readLong();
        String diauthor = in.readUTF();
        String dicreated = in.readUTF();
        String difolder = in.readUTF();
        Document.Info dinfo = new Document.Info(diauthor, dicreated, difolder);
        this.document = new Document(dkey, dfileType, dtitle, durl, dinfo, new Document.EditPermissions(), dmodifier, dmodified);
        String ecallbackUrl = in.readUTF();
        String elang = in.readUTF();
        if (NO_LANG.equals(elang)) {
            elang = null;
        }
        String emode = in.readUTF();
        String euid = in.readUTF();
        String eufirstname = in.readUTF();
        String eulastname = in.readUTF();
        long lastModified = in.readLong();
        long lastSaved = in.readLong();
        Editor.User euser = new Editor.User(euid, eufirstname, eulastname);
        euser.setLastModified(lastModified);
        euser.setLastSaved(lastSaved);
        this.editorConfig = new Editor(ecallbackUrl, elang, emode, euser);
    }

    public String getDocumentserverJsUrl() {
        return this.documentserverJsUrl;
    }

    public String getDocumentserverUrl() {
        return this.documentserverUrl;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Node getContextNode() {
        return this.node;
    }

    protected void setContextNode(Node node) {
        this.node = node;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getPath() {
        return this.path;
    }

    public String getDisplayPath() {
        return this.displayPath;
    }

    public Boolean isActivity() {
        return this.isActivity;
    }

    public String getComment() {
        return this.comment;
    }

    public Boolean isRenameAllowed() {
        return this.renameAllowed;
    }

    public String getDocId() {
        return this.docId;
    }

    public String getEditorUrl() {
        return this.editorUrl;
    }

    public String getExplorerUrl() {
        return this.explorerUri.toString();
    }

    public URI getExplorerUri() {
        return this.explorerUri;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public Document getDocument() {
        return this.document;
    }

    public Long getOpenedTime() {
        return this.openedTime;
    }

    public Long getClosedTime() {
        return this.closedTime;
    }

    protected void setOpenedTime(Long openedTime) {
        this.openedTime = openedTime;
    }

    protected void setClosedTime(Long closedTime) {
        this.closedTime = closedTime;
    }

    protected void setComment(String comment) {
        this.comment = comment;
    }

    protected void setDisplayPath(String displayPath) {
        this.displayPath = displayPath;
    }

    protected void setRenameAllowed(Boolean renameAllowed) {
        this.renameAllowed = renameAllowed;
    }

    public Editor getEditorConfig() {
        return this.editorConfig;
    }

    public void setPreviousModified(Calendar previousModified) {
        this.previousModified.set(previousModified);
    }

    public Calendar getPreviousModified() {
        return this.previousModified.get();
    }

    public void setSameModifier(Boolean samemodifier) {
        this.sameModifier.set(samemodifier);
    }

    public Boolean getSameModifier() {
        return this.sameModifier.get();
    }

    public Config forUser(String id, String firstName, String lastName, String lang, String documentserverSecret) {
        Document userDocument = this.document.forUser(id, firstName, lastName, Config.fileUrl(this.platformRestUrl, id, this.document.getKey()));
        Editor userEditor = this.editorConfig.forUser(id, firstName, lastName, lang, Config.callbackUrl(this.platformRestUrl, id, this.document.getKey()));
        Config config = new Config(this.documentserverUrl, this.platformRestUrl, this.editorUrl, this.explorerUri, this.documentType, this.workspace, this.path, this.displayPath, this.comment, this.renameAllowed, this.isActivity, this.docId, userDocument, userEditor);
        if (documentserverSecret != null && !documentserverSecret.trim().isEmpty()) {
            String jwtToken = Jwts.builder().setSubject("exo-onlyoffice").claim("document", (Object)userDocument).claim("editorConfig", (Object)userEditor).claim("documentType", (Object)this.documentType).signWith((Key)Keys.hmacShaKeyFor((byte[])documentserverSecret.getBytes())).compact();
            config.setToken(jwtToken);
        }
        return config;
    }

    public boolean isCreated() {
        return this.open == null;
    }

    public boolean isOpen() {
        return this.open != null ? this.open : false;
    }

    public boolean isClosed() {
        return this.open != null ? !this.open.booleanValue() : false;
    }

    public boolean isClosing() {
        return this.closing != null ? this.closing : false;
    }

    public void open() {
        this.open = new Boolean(true);
        this.closing = new Boolean(false);
        this.openedTime = System.currentTimeMillis();
    }

    public void closing() {
        if (this.open != null && this.open.booleanValue()) {
            this.open = new Boolean(false);
            this.closing = new Boolean(true);
            this.closedTime = System.currentTimeMillis();
        }
    }

    public void closed() {
        this.open = new Boolean(false);
        this.closing = new Boolean(false);
        if (this.closedTime == null) {
            this.closedTime = System.currentTimeMillis();
        }
    }

    protected void setError(String error) {
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Config) {
            Config other = (Config)obj;
            return this.documentType.equals(other.documentType) && this.workspace.equals(other.workspace) && this.path.equals(other.path);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.documentType);
        s.append(' ');
        s.append(this.workspace);
        s.append(':');
        s.append(this.path);
        if (this.open != null) {
            s.append(" (");
            s.append(this.open != false ? "open" : (this.closing != false ? "closing" : "closed"));
            s.append(')');
        }
        return s.toString();
    }

    public String toJSON() throws JsonException {
        JsonGeneratorImpl gen = new JsonGeneratorImpl();
        return gen.createJsonObject((Object)this).toString();
    }

    public static class Editor {
        protected final String callbackUrl;
        protected final String mode;
        protected final User user;
        protected String lang;

        protected Editor(String callbackUrl, String lang, String mode, User user) {
            this.callbackUrl = callbackUrl;
            this.lang = lang;
            this.mode = mode;
            this.user = user;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        public String getLang() {
            return this.lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public String getMode() {
            return this.mode;
        }

        public User getUser() {
            return this.user;
        }

        protected Editor forUser(String id, String firstName, String lastName, String lang, String callbackUrl) {
            User otherUser = new User(id, firstName, lastName);
            return new Editor(callbackUrl, lang, this.mode, otherUser);
        }

        public static class User {
            protected final String id;
            protected final String firstname;
            protected final String lastname;
            protected Long lastModified = 0L;
            protected Long lastSaved = 0L;
            protected Long linkSaved = 0L;
            protected String downloadLink;
            @Deprecated
            protected transient String lockToken;

            protected User(String id, String firstname, String lastname) {
                this.id = id;
                this.firstname = firstname;
                this.lastname = lastname;
            }

            public String getId() {
                return this.id;
            }

            public String getFirstname() {
                return this.firstname;
            }

            public String getLastname() {
                return this.lastname;
            }

            public long getLastModified() {
                return this.lastModified;
            }

            public void setLastModified(long lastModified) {
                this.lastModified = lastModified;
            }

            public long getLinkSaved() {
                return this.linkSaved;
            }

            public void setLinkSaved(long linkSaved) {
                this.linkSaved = linkSaved;
            }

            public String getDownloadLink() {
                return this.downloadLink;
            }

            public void setDownloadLink(String downloadLink) {
                this.downloadLink = downloadLink;
            }

            public long getLastSaved() {
                return this.lastSaved;
            }

            public void setLastSaved(long lastSaved) {
                this.lastSaved = lastSaved;
            }

            @Deprecated
            protected String getLockToken() {
                return this.lockToken;
            }

            @Deprecated
            protected void setLockToken(String lockToken) {
                this.lockToken = lockToken;
            }
        }
    }

    public static class Document {
        protected final String fileType;
        protected final String key;
        protected final String title;
        protected final String url;
        protected final Info info;
        protected final Permissions permissions;
        protected String lastModifier;
        protected Long lastModified;

        protected Document(String key, String fileType, String title, String url, Info info, Permissions permissions, String lastModifier, Long lastModified) {
            this.fileType = fileType;
            this.key = key;
            this.title = title;
            this.url = url;
            this.info = info;
            this.permissions = permissions;
            this.lastModifier = lastModifier;
            this.lastModified = lastModified;
        }

        protected Document forUser(String id, String firstName, String lastName, String url) {
            return new Document(this.key, this.fileType, this.title, url, this.info, this.permissions, this.lastModifier, this.lastModified);
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getKey() {
            return this.key;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public Info getInfo() {
            return this.info;
        }

        public Permissions getPermissions() {
            return this.permissions;
        }

        public String getLastModifier() {
            return this.lastModifier;
        }

        public Long getLastModified() {
            return this.lastModified;
        }

        public static class EditPermissions
        extends Permissions {
            protected EditPermissions() {
                super(true, true);
            }
        }

        public static abstract class Permissions {
            protected final boolean download;
            protected final boolean edit;

            protected Permissions(boolean download, boolean edit) {
                this.download = download;
                this.edit = edit;
            }

            public boolean isDownload() {
                return this.download;
            }

            public boolean isEdit() {
                return this.edit;
            }
        }

        public static class Info {
            protected final String author;
            protected final String created;
            protected final String folder;

            protected Info(String author, String created, String folder) {
                this.author = author;
                this.created = created;
                this.folder = folder;
            }

            public String getAuthor() {
                return this.author;
            }

            public String getCreated() {
                return this.created;
            }

            public String getFolder() {
                return this.folder;
            }
        }
    }

    public static class Builder {
        protected final String docId;
        protected final String workspace;
        protected final String path;
        protected final String documentType;
        protected final String documentserverUrl;
        protected String platformRestUrl;
        protected String editorUrl;
        protected String documentserverSecret;
        protected String lastModifier;
        protected Long lastModified;
        @Deprecated
        protected String explorerUrl;
        protected String displayPath;
        protected String comment;
        protected Boolean renameAllowed;
        protected Boolean isActivity;
        protected URI explorerUri;
        protected String fileType;
        protected String key;
        protected String title;
        protected String url;
        protected String author;
        protected String created;
        protected String folder;
        protected String callbackUrl;
        protected String lang;
        protected String mode;
        protected String userId;
        protected String firstname;
        protected String lastname;

        protected Builder(String documentserverUrl, String documentType, String workspace, String path, String docId) {
            this.documentserverUrl = documentserverUrl;
            this.documentType = documentType;
            this.docId = docId;
            this.workspace = workspace;
            this.path = path;
        }

        public Builder generateUrls(String platformRestUrl) {
            this.platformRestUrl = platformRestUrl;
            return this;
        }

        public Builder editorUrl(String editorUrl) {
            this.editorUrl = editorUrl;
            return this;
        }

        @Deprecated
        public Builder explorerUrl(String explorerUrl) {
            this.explorerUrl = explorerUrl;
            return this;
        }

        public Builder explorerUri(URI uri) {
            this.explorerUri = uri;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder created(Calendar createdTime) {
            this.created = DATETIME_FORMAT.format(createdTime.getTime());
            return this;
        }

        public Builder displayPath(String displayPath) {
            this.displayPath = displayPath;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder renameAllowed(Boolean renameAllowed) {
            this.renameAllowed = renameAllowed;
            return this;
        }

        public Builder isActivity(Boolean isActivity) {
            this.isActivity = isActivity;
            return this;
        }

        public Builder folder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder lang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder userFirstName(String firstname) {
            this.firstname = firstname;
            return this;
        }

        public Builder userLastName(String lastname) {
            this.lastname = lastname;
            return this;
        }

        public Builder secret(String documentServerSecret) {
            this.documentserverSecret = documentServerSecret;
            return this;
        }

        public Builder lastModifier(String lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public Builder lastModified(Long lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public Config build() {
            if (this.platformRestUrl != null) {
                this.url = this.platformRestUrl + "/onlyoffice/editor/content/" + this.userId + "/" + this.key;
                this.callbackUrl = this.platformRestUrl + "/onlyoffice/editor/status/" + this.userId + "/" + this.key;
            }
            Document.Info info = new Document.Info(this.author, this.created, this.folder);
            Document.EditPermissions permissions = new Document.EditPermissions();
            Document document = new Document(this.key, this.fileType, this.title, this.url, info, permissions, this.lastModifier, this.lastModified);
            Editor.User user = new Editor.User(this.userId, this.firstname, this.lastname);
            Editor editor = new Editor(this.callbackUrl, this.lang, this.mode, user);
            Config config = new Config(this.documentserverUrl, this.platformRestUrl, this.editorUrl, this.explorerUri, this.documentType, this.workspace, this.path, this.displayPath, this.comment, this.renameAllowed, this.isActivity, this.docId, document, editor);
            if (this.documentserverSecret != null && !this.documentserverSecret.trim().isEmpty()) {
                String jwtToken = Jwts.builder().setSubject("exo-onlyoffice").claim("document", (Object)document).claim("editorConfig", (Object)editor).claim("documentType", (Object)this.documentType).signWith((Key)Keys.hmacShaKeyFor((byte[])this.documentserverSecret.getBytes())).compact();
                config.setToken(jwtToken);
            }
            return config;
        }
    }
}

