/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.documents;

import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.onlyoffice.documents.NewDocumentType;
import org.exoplatform.onlyoffice.documents.NewDocumentTypePlugin;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.picocontainer.Startable;

public class NewDocumentService
implements Startable {
    protected static final Log LOG = ExoLogger.getLogger(NewDocumentService.class);
    private static final String DEFAULT_NAME = "untitled";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    protected NewDocumentTypePlugin documentTypePlugin;

    public void start() {
    }

    public void stop() {
    }

    public List<NewDocumentType> getTypes() {
        return this.documentTypePlugin.getTypes();
    }

    public void addTypePlugin(ComponentPlugin plugin) {
        Class<NewDocumentTypePlugin> pclass = NewDocumentTypePlugin.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            NewDocumentTypePlugin newPlugin = (NewDocumentTypePlugin)((Object)pclass.cast(plugin));
            if (this.documentTypePlugin != null) {
                LOG.info("Replace existing DocumentTypePlugin [{}] with new one [{}]", new Object[]{this.documentTypePlugin.getTypes().stream().map(p -> p.toString()).collect(Collectors.joining(",")), newPlugin.getTypes().stream().map(p -> p.toString()).collect(Collectors.joining(","))});
            } else {
                LOG.info("Use DocumentTypePlugin [{}]", new Object[]{newPlugin.getTypes().stream().map(p -> p.toString()).collect(Collectors.joining(","))});
            }
            this.documentTypePlugin = (NewDocumentTypePlugin)((Object)pclass.cast(plugin));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set newDocumentTypePlugin instance of {}", new Object[]{plugin.getClass().getName()});
            }
        } else {
            LOG.error((Object)("The newDocumentTypePlugin plugin is not an instance of " + pclass.getName()));
        }
    }

    public Node createDocument(Node currentNode, String title, String label) throws Exception {
        NewDocumentType selectedType = this.getDocumentTypeByLabel(label);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ApplicationResourceResolver appResolver = context.getApplication().getResourceResolver();
        ResourceResolver resolver = appResolver.getResourceResolver(selectedType.getPath());
        InputStream inputStream = resolver.getInputStream(selectedType.getPath());
        Node addedNode = currentNode.addNode(title, "nt:file");
        if (!addedNode.hasProperty("exo:title")) {
            addedNode.addMixin("exo:rss-enable");
        }
        if (addedNode.canAddMixin(MIX_VERSIONABLE)) {
            addedNode.addMixin(MIX_VERSIONABLE);
        }
        addedNode.setProperty("exo:title", title);
        Node content = addedNode.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:data", inputStream);
        content.setProperty("jcr:mimeType", selectedType.getMimeType());
        content.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        ListenerService listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
        listenerService.broadcast(ActivityCommonService.FILE_CREATED_ACTIVITY, null, (Object)addedNode);
        currentNode.save();
        inputStream.close();
        return addedNode;
    }

    public String getFileName(String title, String label) {
        NewDocumentType type = this.getDocumentTypeByLabel(label);
        if (StringUtils.isEmpty((String)(title = Text.escapeIllegalJcrChars((String)title)))) {
            title = DEFAULT_NAME;
        }
        String path = type.getPath();
        String extension = "";
        if (path.contains(".")) {
            extension = path.substring(path.lastIndexOf("."));
        }
        if (!title.endsWith(extension)) {
            title = title + extension;
        }
        return title;
    }

    public NewDocumentType getDocumentTypeByLabel(String label) {
        return this.getTypes().stream().filter(type -> label.equals(type.getLabel())).findAny().orElse(null);
    }

    public static class NewDocumentTypesConfig {
        protected List<NewDocumentType> types;

        public List<NewDocumentType> getTypes() {
            return this.types;
        }

        public void setTypes(List<NewDocumentType> types) {
            this.types = types;
        }
    }
}

