/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.rest;

import java.net.InetAddress;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.security.RolesAllowed;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.onlyoffice.BadParameterException;
import org.exoplatform.onlyoffice.ChangeState;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.DocumentContent;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.rest.ServiceResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/onlyoffice/editor")
public class EditorService
implements ResourceContainer {
    public static final String API_VERSION = "1.1";
    protected static final Log LOG = ExoLogger.getLogger(EditorService.class);
    protected final OnlyofficeEditorService editors;
    protected final Map<UUID, Config> initiated = new ConcurrentHashMap<UUID, Config>();

    public EditorService(OnlyofficeEditorService editors) {
        this.editors = editors;
    }

    @POST
    @Path(value="/status/{userId}/{key}")
    @Produces(value={"application/json"})
    public Response status(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key, String statusText) {
        EditorResponse resp;
        block13: {
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice document status: " + userId + "@" + key + " " + statusText + " from " + clientHost + "(" + clientIp + ")"));
            }
            resp = new EditorResponse();
            if (this.editors.canDownloadBy(clientHost) || this.editors.canDownloadBy(clientIp)) {
                try {
                    String[] statusUsers;
                    DocumentStatus status = new DocumentStatus();
                    JSONParser parser = new JSONParser();
                    Object obj = parser.parse(statusText);
                    JSONObject jsonObj = (JSONObject)obj;
                    String statusKey = (String)jsonObj.get((Object)"key");
                    long statusCode = (Long)jsonObj.get((Object)"status");
                    String statusUrl = (String)jsonObj.get((Object)"url");
                    JSONArray statusUsersArray = (JSONArray)jsonObj.get((Object)"users");
                    String[] stringArray = statusUsers = statusUsersArray != null ? (String[])statusUsersArray.toArray((Object[])new String[statusUsersArray.size()]) : new String[]{};
                    if (key != null && key.length() > 0) {
                        if (userId != null && userId.length() > 0) {
                            status.setKey(statusKey != null && statusKey.length() > 0 ? statusKey : key);
                            status.setStatus(statusCode);
                            status.setUrl(statusUrl);
                            status.setUsers(statusUsers);
                            try {
                                this.editors.updateDocument(userId, status);
                                resp.entity("{\"error\": 0}");
                            }
                            catch (BadParameterException e) {
                                LOG.warn((Object)("Bad parameter to update status for " + key + ". " + e.getMessage()));
                                resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                            }
                            catch (OnlyofficeEditorException e) {
                                LOG.error((Object)("Error handling status for " + key), (Throwable)e);
                                resp.error("Error handling status. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                            }
                            catch (RepositoryException e) {
                                LOG.error((Object)("Storage error while handling status for " + key), (Throwable)e);
                                resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                            }
                            catch (Throwable e) {
                                LOG.error((Object)("Runtime error while handling status for " + key), e);
                                resp.error("Runtime error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                            }
                        } else {
                            LOG.warn((Object)"Error processing editor status. User not provided");
                            resp.error("User not provided").status(Response.Status.BAD_REQUEST);
                        }
                        break block13;
                    }
                    resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
                }
                catch (ParseException e) {
                    LOG.warn((Object)("JSON parse error while handling status for " + key + ". JSON: " + statusText), (Throwable)e);
                    resp.error("JSON parse error: " + e.getMessage()).status(Response.Status.BAD_REQUEST);
                }
            } else {
                LOG.warn((Object)("Attempt to update status by not allowed host: " + clientHost + "(" + clientIp + ")"));
                resp.error("Not a document server").status(Response.Status.UNAUTHORIZED);
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/content/{userId}/{key}")
    public Response content(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        EditorResponse resp;
        block11: {
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice document content: " + userId + "@" + key + " to " + clientHost + "(" + clientIp + ")"));
            }
            resp = new EditorResponse();
            if (this.editors.canDownloadBy(clientHost) || this.editors.canDownloadBy(clientIp)) {
                if (key != null && key.length() > 0) {
                    try {
                        if (userId != null && userId.length() > 0) {
                            DocumentContent content = this.editors.getContent(userId, key);
                            resp.entity(content.getData()).type(content.getType()).ok();
                            break block11;
                        }
                        LOG.error((Object)"Error downloading content. User identity not provided");
                        resp.error("User not provided").status(Response.Status.BAD_REQUEST);
                    }
                    catch (BadParameterException e) {
                        LOG.warn((Object)("Bad parameter to downloading content for " + key + ". " + e.getMessage()));
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error downloading content for " + key), (Throwable)e);
                        resp.error("Error downloading content. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while downloading content for " + key), (Throwable)e);
                        resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while downloading content for " + key), e);
                        resp.error("Runtime error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
                }
            } else {
                LOG.warn((Object)("Attempt to download content by not allowed host: " + clientHost + "(" + clientIp + ")"));
                resp.error("Not a document server").status(Response.Status.UNAUTHORIZED);
            }
        }
        return resp.build();
    }

    @POST
    @Path(value="/config/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response configPost(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        EditorResponse resp;
        block16: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice configPost: " + workspace + ":" + path));
            }
            resp = new EditorResponse();
            if (workspace != null) {
                if (path != null) {
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    try {
                        ConversationState convo = ConversationState.getCurrent();
                        if (convo != null) {
                            String username = convo.getIdentity().getUserId();
                            URI requestUri = uriInfo.getRequestUri();
                            Config config = this.editors.createEditor(requestUri.getScheme(), this.requestHost(requestUri), username, workspace, path);
                            if (config.getEditorConfig().getLang() == null) {
                                if (request.getLocale() != null) {
                                    config.getEditorConfig().setLang(request.getLocale().getLanguage());
                                } else {
                                    config.getEditorConfig().setLang(Locale.getDefault().getLanguage());
                                }
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("> Onlyoffice document config: " + workspace + ":" + path + " -> " + config.getDocument().getKey()));
                            }
                            resp.config(config).ok();
                            break block16;
                        }
                        LOG.warn((Object)"ConversationState not set to create editor config");
                        resp.error("User not authenticated").status(Response.Status.UNAUTHORIZED);
                    }
                    catch (BadParameterException e) {
                        LOG.warn((Object)("Bad parameter for creating editor config " + workspace + ":" + path + ". " + e.getMessage()));
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error creating editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Error creating editor config. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while creating editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while creating editor config " + workspace + ":" + path), e);
                        resp.error("Error creating editor config.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null path.");
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null workspace.");
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/config/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response configGet(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        EditorResponse resp;
        block18: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice configGet: " + workspace + ":" + path));
            }
            resp = new EditorResponse();
            if (workspace != null) {
                if (path != null) {
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    try {
                        ConversationState convo = ConversationState.getCurrent();
                        if (convo != null) {
                            String username = convo.getIdentity().getUserId();
                            Config config = this.editors.getEditor(username, workspace, path);
                            if (config != null) {
                                if (config.getEditorConfig().getLang() == null) {
                                    if (request.getLocale() != null) {
                                        config.getEditorConfig().setLang(request.getLocale().getLanguage());
                                    } else {
                                        config.getEditorConfig().setLang(Locale.getDefault().getLanguage());
                                    }
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("> Onlyoffice document config: " + workspace + ":" + path + " -> " + config.getDocument().getKey()));
                                }
                                resp.config(config).ok();
                            } else {
                                resp.error("Not found").status(Response.Status.NOT_FOUND);
                            }
                            break block18;
                        }
                        LOG.warn((Object)"ConversationState not set to get editor config");
                        resp.error("User not authenticated").status(Response.Status.UNAUTHORIZED);
                    }
                    catch (BadParameterException e) {
                        LOG.warn((Object)("Bad parameter for getting editor config " + workspace + ":" + path + ". " + e.getMessage()));
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error getting editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Error getting editor config. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while getting editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while getting editor config " + workspace + ":" + path), e);
                        resp.error("Error getting editor config.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null path.");
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null workspace.");
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/api/version")
    @Produces(value={"application/json"})
    public Response versionGet(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        String title = this.getClass().getPackage().getImplementationTitle();
        String version = this.getClass().getPackage().getImplementationVersion();
        String clientHost = this.getClientHost(request);
        String clientIp = this.getClientIpAddr(request);
        return Response.ok().entity((Object)("{\"user\": \"" + request.getRemoteUser() + "\",\n\"requestIP\": \"" + clientIp + "\",\n\"requestHost\": \"" + clientHost + "\",\n\"product\":{ \"name\": \"" + title + "\",\n\"version\": \"" + version + "\"},\n\"version\": \"" + API_VERSION + "\"}")).build();
    }

    @POST
    @Path(value="/document/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response initDocument(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        EditorResponse resp;
        block12: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice initDocument: " + workspace + ":" + path));
            }
            resp = new EditorResponse();
            if (workspace != null) {
                if (path != null) {
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    try {
                        ConversationState convo = ConversationState.getCurrent();
                        if (convo != null) {
                            String docId = this.editors.initDocument(workspace, path);
                            URI requestUri = uriInfo.getRequestUri();
                            resp.document(this.editors.getEditorLink(requestUri.getScheme(), this.requestHost(requestUri), workspace, docId)).ok();
                            break block12;
                        }
                        LOG.warn((Object)"ConversationState not set to get editor config");
                        resp.error("User not authenticated").status(Response.Status.UNAUTHORIZED);
                    }
                    catch (BadParameterException e) {
                        LOG.warn((Object)("Bad parameter for getting editor config " + workspace + ":" + path + ". " + e.getMessage()));
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error getting editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Error getting editor config. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while getting editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while getting editor config " + workspace + ":" + path), e);
                        resp.error("Error getting editor config.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null path.");
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null workspace.");
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/state/{userId}/{key}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response localState(@Context UriInfo uriInfo, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> localState: " + userId + "@" + key));
        }
        EditorResponse resp = new EditorResponse();
        if (userId != null) {
            if (key != null) {
                try {
                    ChangeState status = this.editors.getState(userId, key);
                    resp.entity(status).ok();
                }
                catch (BadParameterException e) {
                    LOG.warn((Object)("Bad parameter for getting document state " + userId + "@" + key + ". " + e.getMessage()));
                    resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                }
                catch (OnlyofficeEditorException e) {
                    LOG.error((Object)("Error getting document state " + userId + "@" + key), (Throwable)e);
                    resp.error("Error getting document state. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (Throwable e) {
                    LOG.error((Object)("Runtime error while getting document state " + userId + "@" + key), e);
                    resp.error("Error getting document state.").status(Response.Status.INTERNAL_SERVER_ERROR);
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
            }
        } else {
            LOG.warn((Object)"Error getting document state. User identity not provided");
            resp.error("User not provided").status(Response.Status.BAD_REQUEST);
        }
        return resp.build();
    }

    @Deprecated
    public Response updateUI(@Context UriInfo uriInfo, @PathParam(value="userId") String userId, @PathParam(value="key") String key, @FormParam(value="command") String command) {
        EditorResponse resp;
        block11: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> updateUI: " + userId + "@" + key + " command: " + command));
            }
            resp = new EditorResponse();
            if (userId != null) {
                if (key != null) {
                    try {
                        Config config = this.editors.getEditorByKey(userId, key);
                        if (config != null) {
                            if (!"close".equals(command)) {
                                LOG.warn((Object)("Bad command for editor UI " + userId + "@" + key + " command: " + command));
                                resp.error("Bad command").status(Response.Status.BAD_REQUEST);
                            }
                            break block11;
                        }
                        resp.error("Editor not found").status(Response.Status.NOT_FOUND);
                    }
                    catch (BadParameterException e) {
                        LOG.warn((Object)("Bad parameter for updating editor UI " + userId + "@" + key + ". " + e.getMessage()));
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error updating editor UI " + userId + "@" + key), (Throwable)e);
                        resp.error("Error updating editor UI. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while updating editor UI " + userId + "@" + key), e);
                        resp.error("Error updating editor UI.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
                }
            } else {
                LOG.warn((Object)"Error updating editor UI. User identity not provided");
                resp.error("User not provided").status(Response.Status.BAD_REQUEST);
            }
        }
        return resp.build();
    }

    protected String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (this.isValidHost(ip)) {
            int commaIdx = ip.indexOf(44);
            if (commaIdx > 0 && commaIdx < ip.length() - 1) {
                ip = ip.substring(0, commaIdx);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED_FOR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("REMOTE_ADDR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (this.isValidHost(ip)) {
            return ip;
        }
        return null;
    }

    protected String getClientHost(HttpServletRequest request) {
        String host = request.getHeader("X-Forwarded-Host");
        if (this.isValidHost(host)) {
            return host;
        }
        String clientIp = request.getHeader("X-Forwarded-For");
        if (this.notEmpty(clientIp)) {
            int commaIdx = clientIp.indexOf(44);
            if (commaIdx > 0 && commaIdx < clientIp.length() - 1) {
                clientIp = clientIp.substring(0, commaIdx);
            }
        } else {
            clientIp = request.getHeader("X-Real-IP");
        }
        if (this.notEmpty(clientIp)) {
            try {
                host = InetAddress.getByName(clientIp).getHostName();
                if (this.notEmpty(host)) {
                    return host;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot obtain client hostname by its IP " + clientIp + ": " + e.getMessage()));
            }
        }
        if (this.isValidHost(host = request.getRemoteHost())) {
            return host;
        }
        return clientIp;
    }

    protected boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    protected boolean isValidHost(String host) {
        return this.notEmpty(host) && !"unknown".equalsIgnoreCase(host);
    }

    protected String requestHost(URI requestUri) {
        StringBuilder host = new StringBuilder(requestUri.getHost());
        int port = requestUri.getPort();
        if (port >= 0 && port != 80 && port != 443) {
            host.append(':');
            host.append(port);
        }
        return host.toString();
    }

    class EditorResponse
    extends ServiceResponse {
        Config config;
        String editorUrl;
        String error;

        EditorResponse() {
        }

        EditorResponse config(Config config) {
            this.config = config;
            return this;
        }

        EditorResponse document(String editorUrl) {
            this.editorUrl = editorUrl;
            return this;
        }

        EditorResponse error(String error) {
            this.error = error;
            return this;
        }

        EditorResponse error(String error, String host) {
            this.error = error;
            return this;
        }

        @Override
        Response build() {
            if (this.config != null) {
                super.entity(this.config);
            } else if (this.editorUrl != null) {
                super.entity("{\"editorUrl\":\"" + this.editorUrl + "\"}");
            } else if (this.error != null) {
                super.entity("{\"error\":\"" + this.error + "\"}");
            }
            return super.build();
        }
    }
}

