/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.cometd.CometdInfo;
import org.exoplatform.onlyoffice.cometd.CometdOnlyofficeService;
import org.exoplatform.onlyoffice.webui.FileFilter;
import org.exoplatform.onlyoffice.webui.OnlyofficeClientContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={OnlyofficeOpenActionListener.class})})
public class OnlyofficeOpenManageComponent
extends UIAbstractManagerComponent {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeOpenManageComponent.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new FileFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public String renderEventURL(boolean ajax, String name, String beanId, Parameter[] params) throws Exception {
        if (name.equals("OnlyofficeOpen")) {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            if (uiExplorer != null) {
                OnlyofficeEditorService editorService = (OnlyofficeEditorService)this.getApplicationComponent(OnlyofficeEditorService.class);
                CometdOnlyofficeService cometdService = (CometdOnlyofficeService)this.getApplicationComponent(CometdOnlyofficeService.class);
                String editorLink = editorService.getEditorLink(uiExplorer.getCurrentNode());
                ConversationState convo = ConversationState.getCurrent();
                String userId = null;
                if (convo != null && convo.getIdentity() != null) {
                    userId = convo.getIdentity().getUserId();
                }
                String cometdPath = cometdService.getCometdServerPath();
                String userToken = cometdService.getUserToken(userId);
                String containerName = PortalContainer.getCurrentPortalContainerName();
                String docId = editorService.initDocument(uiExplorer.getCurrentNode());
                CometdInfo cometdInfo = new CometdInfo(userId, userToken, cometdPath, containerName, docId);
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                String cometdInfoJson = ow.writeValueAsString((Object)cometdInfo);
                OnlyofficeClientContext.callModule("initExplorer(" + cometdInfoJson + ");");
                if (editorLink != null && !editorLink.isEmpty()) {
                    return "javascript:window.open('" + editorLink + "');";
                }
            } else {
                LOG.warn((Object)("Cannot find ancestor of type UIJCRExplorer in component " + (Object)((Object)this) + ", parent: " + this.getParent()));
            }
        }
        return super.renderEventURL(ajax, name, beanId, params);
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class OnlyofficeOpenActionListener
    extends UIActionBarActionListener<OnlyofficeOpenManageComponent> {
        public void processEvent(Event<OnlyofficeOpenManageComponent> event) throws Exception {
        }
    }
}

