/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.onlyoffice.webui.AbstractOnlyofficeLifecycle;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Application;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;

public class OnlyofficeEditorLifecycle
extends AbstractOnlyofficeLifecycle {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorLifecycle.class);
    public static final String TOOLBAR_HIDDEN = "TOOLBAR_HIDDEN";
    public static final String[] EMPTY_PERMISSIONS = new String[0];

    @Override
    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        UIContainer leftnav;
        HashSet<RenderedState> hidden = new HashSet<RenderedState>();
        UIApplication uiApp = context.getUIApplication();
        UIContainer toolbar = (UIContainer)uiApp.findComponentById("UIToolbarContainer");
        if (toolbar != null) {
            toolbar.setRendered(false);
            hidden.add(() -> toolbar.setRendered(true));
        }
        if ((leftnav = (UIContainer)uiApp.findComponentById("LeftNavigation")) != null) {
            leftnav.setRendered(false);
            if (UIPortalComponent.class.isAssignableFrom(leftnav.getClass())) {
                UIPortalComponent portalComp = (UIPortalComponent)UIPortalComponent.class.cast(leftnav);
                String[] origPermissions = portalComp.getAccessPermissions();
                portalComp.setAccessPermissions(EMPTY_PERMISSIONS);
                hidden.add(() -> {
                    leftnav.setRendered(true);
                    portalComp.setAccessPermissions(origPermissions);
                });
            } else {
                hidden.add(() -> leftnav.setRendered(true));
            }
        }
        app.setAttribute(TOOLBAR_HIDDEN, hidden);
        super.onStartRequest(app, context);
    }

    @Override
    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        Set hidden = (Set)app.getAttribute(TOOLBAR_HIDDEN);
        if (hidden != null) {
            for (RenderedState redered : hidden) {
                redered.restore();
            }
            app.setAttribute(TOOLBAR_HIDDEN, Collections.emptySet());
        }
        super.onEndRequest(app, context);
    }

    static interface RenderedState {
        public void restore();
    }
}

