/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.cometd;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.cometd.annotation.Param;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.annotation.Service;
import org.cometd.annotation.Subscription;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.Userdata;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class CometdOnlyofficeService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(CometdOnlyofficeService.class);
    public static final String CHANNEL_NAME = "/eXo/Application/Onlyoffice/editor/";
    public static final String CHANNEL_NAME_PARAMS = "/eXo/Application/Onlyoffice/editor/{docId}";
    public static final String DOCUMENT_SAVED_EVENT = "DOCUMENT_SAVED";
    public static final String DOCUMENT_CHANGED_EVENT = "DOCUMENT_CHANGED";
    public static final String DOCUMENT_VERSION_EVENT = "DOCUMENT_VERSION";
    public static final String DOCUMENT_LINK_EVENT = "DOCUMENT_LINK";
    public static final String EDITOR_CLOSED_EVENT = "EDITOR_CLOSED";
    public static final int MIN_THREADS = 2;
    public static final int MIN_MAX_THREADS = 4;
    public static final int THREAD_IDLE_TIME = 120;
    public static final int MAX_FACTOR = 20;
    public static final int QUEUE_FACTOR = 40;
    public static final String THREAD_PREFIX = "onlyoffice-comet-thread-";
    protected final OnlyofficeEditorService editors;
    protected final EXoContinuationBayeux exoBayeux;
    protected final CometdService service;
    protected final ExecutorService eventsHandlers;

    public CometdOnlyofficeService(EXoContinuationBayeux exoBayeux, OnlyofficeEditorService onlyofficeEditorService) {
        this.exoBayeux = exoBayeux;
        this.editors = onlyofficeEditorService;
        this.service = new CometdService();
        this.eventsHandlers = this.createThreadExecutor(THREAD_PREFIX, 20, 40);
    }

    public void start() {
        final AtomicReference processor = new AtomicReference();
        this.exoBayeux.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                ServerAnnotationProcessor p = new ServerAnnotationProcessor((BayeuxServer)CometdOnlyofficeService.this.exoBayeux);
                processor.set(p);
                p.process((Object)CometdOnlyofficeService.this.service);
            }

            public void lifeCycleStopped(LifeCycle event) {
                ServerAnnotationProcessor p = (ServerAnnotationProcessor)processor.get();
                if (p != null) {
                    p.deprocess((Object)CometdOnlyofficeService.this.service);
                }
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        if (PropertyManager.isDevelopping()) {
            this.exoBayeux.addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

                public void sessionRemoved(ServerSession session, boolean timedout) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionRemoved: " + session.getId() + " timedout:" + timedout + " channels: " + CometdOnlyofficeService.this.channelsAsString(session.getSubscriptions())));
                    }
                }

                public void sessionAdded(ServerSession session, ServerMessage message) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionAdded: " + session.getId() + " channels: " + CometdOnlyofficeService.this.channelsAsString(session.getSubscriptions())));
                    }
                }
            });
        }
    }

    protected String channelsAsString(Set<ServerChannel> channels) {
        return channels.stream().map(c -> c.getId()).collect(Collectors.joining(", "));
    }

    public void stop() {
    }

    public String getCometdServerPath() {
        return "/" + this.exoBayeux.getCometdContextName() + "/cometd";
    }

    public String getUserToken(String userId) {
        return this.exoBayeux.getUserToken(userId);
    }

    protected ExecutorService createThreadExecutor(String threadNamePrefix, int maxFactor, int queueFactor) {
        int cpus = Runtime.getRuntime().availableProcessors();
        int poolThreads = cpus / 4;
        poolThreads = poolThreads < 2 ? 2 : poolThreads;
        int maxThreads = Math.round((float)cpus * 1.0f * (float)maxFactor);
        maxThreads = maxThreads > 0 ? maxThreads : 1;
        maxThreads = maxThreads < 4 ? 4 : maxThreads;
        int queueSize = cpus * queueFactor;
        int n = queueSize = queueSize < queueFactor ? queueFactor : queueSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating thread executor " + threadNamePrefix + "* for " + poolThreads + ".." + maxThreads + " threads, queue size " + queueSize));
        }
        return new ThreadPoolExecutor(poolThreads, maxThreads, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new CommandThreadFactory(threadNamePrefix), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Service(value="onlyoffice")
    public class CometdService {
        @Inject
        private BayeuxServer bayeux;
        @org.cometd.annotation.Session
        private LocalSession localSession;
        @org.cometd.annotation.Session
        private ServerSession serverSession;

        @PostConstruct
        public void postConstruct() {
            CometdOnlyofficeService.this.editors.addListener(new OnlyofficeEditorListener(){

                @Override
                public void onSaved(DocumentStatus status) {
                    CometdService.this.publishSavedEvent(status.getConfig().getDocId(), status.getLastUser());
                }

                @Override
                public void onLeaved(DocumentStatus status) {
                }

                @Override
                public void onJoined(DocumentStatus status) {
                }

                @Override
                public void onGet(DocumentStatus status) {
                }

                @Override
                public void onError(DocumentStatus status) {
                }

                @Override
                public void onCreate(DocumentStatus status) {
                }
            });
        }

        @Subscription(value={"/eXo/Application/Onlyoffice/editor/{docId}"})
        public void subscribeDocuments(Message message, @Param(value="docId") String docId) throws OnlyofficeEditorException, RepositoryException {
            String type;
            Object objData = message.getData();
            if (!Map.class.isInstance(objData)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Couldn't get data as a map from event");
                }
                return;
            }
            Map data = message.getDataAsMap();
            switch (type = (String)data.get("type")) {
                case "DOCUMENT_CHANGED": {
                    this.handleDocumentChangeEvent(data, docId);
                    break;
                }
                case "DOCUMENT_VERSION": {
                    this.handleDocumentVersionEvent(data, docId);
                    break;
                }
                case "DOCUMENT_LINK": {
                    this.handleDocumentLinkEvent(data, docId);
                    break;
                }
                case "EDITOR_CLOSED": {
                    this.handleEditorClosedEvent(data, docId);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Event published in " + message.getChannel() + ", docId: " + docId + ", data: " + message.getJSON()));
            }
        }

        protected void handleDocumentLinkEvent(Map<String, Object> data, String docId) {
            String userId = (String)data.get("userId");
            String key = (String)data.get("key");
            CometdOnlyofficeService.this.editors.forceSave(new Userdata(userId, key, false));
        }

        protected void handleEditorClosedEvent(Map<String, Object> data, String docId) {
            String userId = (String)data.get("userId");
            String key = (String)data.get("key");
            try {
                String[] users = CometdOnlyofficeService.this.editors.getState(userId, key).getUsers();
                if (users.length > 1) {
                    CometdOnlyofficeService.this.editors.forceSave(new Userdata(userId, key, true));
                }
            }
            catch (OnlyofficeEditorException e) {
                LOG.error((Object)("Cannot get state of document key: " + key + ", user: " + userId));
            }
        }

        protected void handleDocumentVersionEvent(Map<String, Object> data, String docId) {
            final String userId = (String)data.get("userId");
            final String key = (String)data.get("key");
            Config.Editor.User lastUser = CometdOnlyofficeService.this.editors.getLastModifier(key);
            if (LOG.isDebugEnabled()) {
                if (lastUser != null) {
                    LOG.debug("Handle document version: {} for {}, lastUser: {}. LastSaved: {}", new Object[]{userId, docId, lastUser.getId(), lastUser.getLastSaved()});
                } else {
                    LOG.debug("Handle document version: {} for {}, lastUser: null", new Object[]{userId, docId});
                }
            }
            CometdOnlyofficeService.this.eventsHandlers.submit(new ContainerCommand(PortalContainer.getCurrentPortalContainerName()){

                @Override
                void onContainerError(String error) {
                    LOG.error("An error has occured in container: {}", new Object[]{this.containerName});
                }

                @Override
                void execute(ExoContainer exoContainer) {
                    Config.Editor.User user = CometdOnlyofficeService.this.editors.getUser(key, userId);
                    if (user.getLinkSaved() >= user.getLastModified()) {
                        LOG.debug("Downloading from existing link. User: {}, Key: {}, Link: {}", new Object[]{user.getId(), key, user.getDownloadLink()});
                        CometdOnlyofficeService.this.editors.downloadVersion(new Userdata(userId, key, false), user.getDownloadLink());
                    } else {
                        CometdOnlyofficeService.this.editors.forceSave(new Userdata(userId, key, true));
                    }
                }
            });
        }

        protected void handleDocumentChangeEvent(Map<String, Object> data, final String docId) {
            String userId = (String)data.get("userId");
            final String key = (String)data.get("key");
            final Config.Editor.User lastUser = CometdOnlyofficeService.this.editors.getLastModifier(key);
            if (lastUser != null && !userId.equals(lastUser.getId())) {
                CometdOnlyofficeService.this.eventsHandlers.submit(new ContainerCommand(PortalContainer.getCurrentPortalContainerName()){

                    @Override
                    void onContainerError(String error) {
                        LOG.error("An error has occured in container: {}", new Object[]{this.containerName});
                    }

                    @Override
                    void execute(ExoContainer exoContainer) {
                        if (lastUser.getLinkSaved() >= lastUser.getLastModified()) {
                            LOG.debug("Downloading from existing link. User: {}, Key: {}, Link: {}", new Object[]{lastUser.getId(), key, lastUser.getDownloadLink()});
                            CometdOnlyofficeService.this.editors.downloadVersion(new Userdata(lastUser.getId(), key, false), lastUser.getDownloadLink());
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Download a new version of document: user " + lastUser.getId() + ", docId: " + docId));
                            }
                            CometdOnlyofficeService.this.editors.forceSave(new Userdata(lastUser.getId(), key, true));
                        }
                    }
                });
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Started collecting changes for: " + userId + ", docId: " + docId));
                }
            }
            CometdOnlyofficeService.this.editors.setLastModifier(key, userId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Changes collected from: " + userId + ", docId: " + docId));
            }
        }

        protected void publishSavedEvent(String docId, String userId) {
            ServerChannel channel = this.bayeux.getChannel(CometdOnlyofficeService.CHANNEL_NAME + docId);
            if (channel != null) {
                StringBuilder data = new StringBuilder();
                data.append('{');
                data.append("\"type\": \"");
                data.append(CometdOnlyofficeService.DOCUMENT_SAVED_EVENT);
                data.append("\", ");
                data.append("\"docId\": \"");
                data.append(docId);
                data.append("\", ");
                data.append("\"userId\": \"");
                data.append(userId);
                data.append("\"");
                data.append('}');
                channel.publish((Session)this.localSession, (Object)data.toString());
            }
        }
    }

    abstract class ContainerCommand
    implements Runnable {
        final String containerName;

        ContainerCommand(String containerName) {
            this.containerName = containerName;
        }

        abstract void execute(ExoContainer var1);

        abstract void onContainerError(String var1);

        @Override
        public void run() {
            ExoContainer exoContainer = ExoContainerContext.getContainerByName((String)this.containerName);
            if (exoContainer != null) {
                ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
                try {
                    ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                    RequestLifeCycle.begin((ExoContainer)exoContainer);
                    this.execute(exoContainer);
                }
                finally {
                    RequestLifeCycle.end();
                    ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
                }
            } else {
                this.onContainerError("Container not found");
            }
        }
    }

    static class CommandThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        CommandThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L){

                protected void finalize() throws Throwable {
                    super.finalize();
                    threadNumber.decrementAndGet();
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

