/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.security.RolesAllowed;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.onlyoffice.BadParameterException;
import org.exoplatform.onlyoffice.ChangeState;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.DocumentContent;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.Userdata;
import org.exoplatform.onlyoffice.Version;
import org.exoplatform.onlyoffice.rest.ServiceResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/onlyoffice/editor")
public class EditorService
implements ResourceContainer {
    public static final String API_VERSION = "1.1";
    protected static final Log LOG = ExoLogger.getLogger(EditorService.class);
    protected final OnlyofficeEditorService editors;
    protected final Map<UUID, Config> initiated = new ConcurrentHashMap<UUID, Config>();

    public EditorService(OnlyofficeEditorService editors) {
        this.editors = editors;
    }

    @POST
    @Path(value="/status/{userId}/{key}")
    @Produces(value={"application/json"})
    public Response status(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key, String statusText) {
        EditorResponse resp;
        block20: {
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice document status: " + userId + "@" + key + " " + statusText + " from " + clientHost + "(" + clientIp + ")"));
            }
            resp = new EditorResponse(this);
            if (this.editors.canDownloadBy(clientHost) || this.editors.canDownloadBy(clientIp)) {
                try {
                    String[] statusUsers;
                    JSONParser parser = new JSONParser();
                    Object obj = parser.parse(statusText);
                    JSONObject jsonObj = (JSONObject)obj;
                    String token = request.getHeader("Authorization");
                    if (token != null) {
                        token = token.replace("Bearer", "").trim();
                    }
                    String statusKey = (String)jsonObj.get((Object)"key");
                    String userdataJson = (String)jsonObj.get((Object)"userdata");
                    long statusCode = (Long)jsonObj.get((Object)"status");
                    String statusUrl = (String)jsonObj.get((Object)"url");
                    Object errorObj = jsonObj.get((Object)"error");
                    long error = errorObj != null ? Long.parseLong(errorObj.toString()) : 0L;
                    JSONArray statusUsersArray = (JSONArray)jsonObj.get((Object)"users");
                    String[] stringArray = statusUsers = statusUsersArray != null ? (String[])statusUsersArray.toArray((Object[])new String[statusUsersArray.size()]) : new String[]{};
                    if (key != null && key.length() > 0) {
                        if (userId != null && userId.length() > 0) {
                            if (this.editors.validateToken(token, key)) {
                                Userdata userdata;
                                DocumentStatus.Builder statusBuilder = new DocumentStatus.Builder();
                                statusBuilder.key(statusKey != null && statusKey.length() > 0 ? statusKey : key).status(statusCode).url(statusUrl).users(statusUsers).error(error);
                                Userdata userdata2 = userdata = userdataJson != null ? (Userdata)new ObjectMapper().readValue(userdataJson, Userdata.class) : null;
                                if (userdata != null) {
                                    statusBuilder.userId(userdata.getUserId());
                                    statusBuilder.coEdited(userdata.getCoEdited());
                                    statusBuilder.forcesaved(userdata.isForcesaved());
                                    statusBuilder.saved(userdata.isDownload());
                                    statusBuilder.comment(userdata.getComment());
                                } else if (statusUsers != null && statusUsers.length > 0) {
                                    statusBuilder.userId(statusUsers[0]);
                                } else {
                                    statusBuilder.userId(userId);
                                }
                                try {
                                    this.editors.updateDocument(statusBuilder.build());
                                    resp.entity("{\"error\": 0}");
                                }
                                catch (BadParameterException e) {
                                    LOG.warn((Object)("Bad parameter to update status for " + key + ". " + e.getMessage()));
                                    resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                                }
                                catch (OnlyofficeEditorException e) {
                                    LOG.error((Object)("Error handling status for " + key), (Throwable)e);
                                    resp.error("Error handling status. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                                }
                                catch (RepositoryException e) {
                                    LOG.error((Object)("Storage error while handling status for " + key), (Throwable)e);
                                    resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                                }
                                catch (Throwable e) {
                                    LOG.error((Object)("Runtime error while handling status for " + key), e);
                                    resp.error("Runtime error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                                }
                            } else {
                                LOG.warn((Object)"Error processing editor status. The token is not valid");
                                resp.error("The token is not valid").status(Response.Status.UNAUTHORIZED);
                            }
                        } else {
                            LOG.warn((Object)"Error processing editor status. User not provided");
                            resp.error("User not provided").status(Response.Status.BAD_REQUEST);
                        }
                        break block20;
                    }
                    resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
                }
                catch (IOException | ParseException e) {
                    LOG.warn((Object)("JSON parse error while handling status for " + key + ". JSON: " + statusText), e);
                    resp.error("JSON parse error: " + e.getMessage()).status(Response.Status.BAD_REQUEST);
                }
            } else {
                LOG.warn((Object)("Attempt to update status by not allowed host: " + clientHost + "(" + clientIp + ")"));
                resp.error("Not a document server").status(Response.Status.UNAUTHORIZED);
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/content/{userId}/{key}")
    public Response content(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        EditorResponse resp;
        block14: {
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice document content: " + userId + "@" + key + " to " + clientHost + "(" + clientIp + ")"));
            }
            resp = new EditorResponse(this);
            if (this.editors.canDownloadBy(clientHost) || this.editors.canDownloadBy(clientIp)) {
                if (key != null && key.length() > 0) {
                    String token = request.getHeader("Authorization");
                    if (token != null) {
                        token = token.replace("Bearer", "").trim();
                    }
                    if (this.editors.validateToken(token, key)) {
                        try {
                            if (userId != null && userId.length() > 0) {
                                DocumentContent content = this.editors.getContent(userId, key);
                                resp.entity(content.getData()).type(content.getType()).ok();
                                break block14;
                            }
                            LOG.error((Object)"Error downloading content. User identity not provided");
                            resp.error("User not provided").status(Response.Status.BAD_REQUEST);
                        }
                        catch (BadParameterException e) {
                            LOG.warn((Object)("Bad parameter to downloading content for " + key + ". " + e.getMessage()));
                            resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                        }
                        catch (OnlyofficeEditorException e) {
                            LOG.error((Object)("Error downloading content for " + key), (Throwable)e);
                            resp.error("Error downloading content. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                        }
                        catch (RepositoryException e) {
                            LOG.error((Object)("Storage error while downloading content for " + key), (Throwable)e);
                            resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Runtime error while downloading content for " + key), e);
                            resp.error("Runtime error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                        }
                    } else {
                        LOG.warn((Object)"Error downloading content. The token is not valid");
                        resp.error("The token is not valid").status(Response.Status.UNAUTHORIZED);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
                }
            } else {
                LOG.warn((Object)("Attempt to download content by not allowed host: " + clientHost + "(" + clientIp + ")"));
                resp.error("Not a document server").status(Response.Status.UNAUTHORIZED);
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/viewer/{workspace}/{fileId}")
    @Produces(value={"application/json"})
    public Response viewerConfig(@Context HttpServletRequest request, @PathParam(value="workspace") String workspace, @PathParam(value="fileId") String fileId) {
        try {
            Config config = this.editors.createViewer(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRemoteUser(), workspace, fileId);
            return Response.ok().entity((Object)config).build();
        }
        catch (RepositoryException | OnlyofficeEditorException e) {
            LOG.error((Object)("Cannot create viewer config for fileId: " + fileId + ", workspace: " + workspace), e);
            return Response.status((int)500).entity((Object)("{\"error\":\"" + e.getMessage() + "\"}")).build();
        }
    }

    @POST
    @Path(value="/config/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response configPost(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        EditorResponse resp;
        block16: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice configPost: " + workspace + ":" + (String)path));
            }
            resp = new EditorResponse(this);
            if (workspace != null) {
                if (path != null) {
                    if (!((String)path).startsWith("/")) {
                        path = "/" + (String)path;
                    }
                    try {
                        ConversationState convo = ConversationState.getCurrent();
                        if (convo != null) {
                            String username = convo.getIdentity().getUserId();
                            URI requestUri = uriInfo.getRequestUri();
                            Config config = this.editors.createEditor(requestUri.getScheme(), requestUri.getHost(), requestUri.getPort(), username, workspace, (String)path);
                            if (config.getEditorConfig().getLang() == null) {
                                if (request.getLocale() != null) {
                                    config.getEditorConfig().setLang(request.getLocale().getLanguage());
                                } else {
                                    config.getEditorConfig().setLang(Locale.getDefault().getLanguage());
                                }
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("> Onlyoffice document config: " + workspace + ":" + (String)path + " -> " + config.getDocument().getKey()));
                            }
                            resp.config(config).ok();
                            break block16;
                        }
                        LOG.warn((Object)"ConversationState not set to create editor config");
                        resp.error("User not authenticated").status(Response.Status.UNAUTHORIZED);
                    }
                    catch (BadParameterException e) {
                        LOG.warn((Object)("Bad parameter for creating editor config " + workspace + ":" + (String)path + ". " + e.getMessage()));
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error creating editor config " + workspace + ":" + (String)path), (Throwable)e);
                        resp.error("Error creating editor config. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while creating editor config " + workspace + ":" + (String)path), (Throwable)e);
                        resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while creating editor config " + workspace + ":" + (String)path), e);
                        resp.error("Error creating editor config.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null path.");
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null workspace.");
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/api/version")
    @Produces(value={"application/json"})
    public Response versionGet(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        String title = this.getClass().getPackage().getImplementationTitle();
        String version = this.getClass().getPackage().getImplementationVersion();
        String clientHost = this.getClientHost(request);
        String clientIp = this.getClientIpAddr(request);
        return Response.ok().entity((Object)("{\"user\": \"" + request.getRemoteUser() + "\",\n\"requestIP\": \"" + clientIp + "\",\n\"requestHost\": \"" + clientHost + "\",\n\"product\":{ \"name\": \"" + title + "\",\n\"version\": \"" + version + "\"},\n\"version\": \"1.1\"}")).type("application/json").build();
    }

    @GET
    @Path(value="/state/{userId}/{key}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response localState(@Context UriInfo uriInfo, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> localState: " + userId + "@" + key));
        }
        EditorResponse resp = new EditorResponse(this);
        if (userId != null) {
            if (key != null) {
                try {
                    ChangeState status = this.editors.getState(userId, key);
                    resp.entity(status).ok();
                }
                catch (BadParameterException e) {
                    LOG.warn((Object)("Bad parameter for getting document state " + userId + "@" + key + ". " + e.getMessage()));
                    resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                }
                catch (OnlyofficeEditorException e) {
                    LOG.error((Object)("Error getting document state " + userId + "@" + key), (Throwable)e);
                    resp.error("Error getting document state. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (Throwable e) {
                    LOG.error((Object)("Runtime error while getting document state " + userId + "@" + key), e);
                    resp.error("Error getting document state.").status(Response.Status.INTERNAL_SERVER_ERROR);
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
            }
        } else {
            LOG.warn((Object)"Error getting document state. User identity not provided");
            resp.error("User not provided").status(Response.Status.BAD_REQUEST);
        }
        return resp.build();
    }

    @GET
    @Path(value="/versions/{workspace}/{key}/{itemParPage}/{pageNum}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response getVersions(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="workspace") String workspace, @PathParam(value="key") String key, @PathParam(value="itemParPage") int itemParPage, @PathParam(value="pageNum") int pageNum) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> get versions of doc " + key + " in workspace " + workspace));
        }
        try {
            if (StringUtils.isBlank((CharSequence)workspace)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (StringUtils.isBlank((CharSequence)key)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            List<Version> versions = this.editors.getVersions(workspace, key, itemParPage = itemParPage <= 0 ? 3 : itemParPage, pageNum = pageNum < 0 ? 0 : pageNum);
            if (versions != null) {
                return Response.ok(versions).build();
            }
            return Response.ok((Object)Collections.EMPTY_LIST).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when fetching the versions of the document " + key), (Throwable)e);
            return Response.serverError().build();
        }
    }

    protected String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (this.isValidHost(ip)) {
            int commaIdx = ip.indexOf(44);
            if (commaIdx > 0 && commaIdx < ip.length() - 1) {
                ip = ip.substring(0, commaIdx);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED_FOR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getHeader("REMOTE_ADDR");
        if (this.isValidHost(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (this.isValidHost(ip)) {
            return ip;
        }
        return null;
    }

    protected String getClientHost(HttpServletRequest request) {
        String host = request.getHeader("X-Forwarded-Host");
        if (this.isValidHost(host)) {
            return host;
        }
        String clientIp = request.getHeader("X-Forwarded-For");
        if (this.notEmpty(clientIp)) {
            int commaIdx = clientIp.indexOf(44);
            if (commaIdx > 0 && commaIdx < clientIp.length() - 1) {
                clientIp = clientIp.substring(0, commaIdx);
            }
        } else {
            clientIp = request.getHeader("X-Real-IP");
        }
        if (this.notEmpty(clientIp)) {
            try {
                host = InetAddress.getByName(clientIp).getHostName();
                if (this.notEmpty(host)) {
                    return host;
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot obtain client hostname by its IP " + clientIp + ": " + e.getMessage()));
            }
        }
        if (this.isValidHost(host = request.getRemoteHost())) {
            return host;
        }
        return clientIp;
    }

    protected boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    protected boolean isValidHost(String host) {
        return this.notEmpty(host) && !"unknown".equalsIgnoreCase(host);
    }

    class EditorResponse
    extends ServiceResponse {
        Config config;
        String editorUrl;
        String error;

        EditorResponse(EditorService this$0) {
        }

        EditorResponse config(Config config) {
            this.config = config;
            return this;
        }

        EditorResponse document(String editorUrl) {
            this.editorUrl = editorUrl;
            return this;
        }

        EditorResponse error(String error) {
            this.error = error;
            return this;
        }

        EditorResponse error(String error, String host) {
            this.error = error;
            return this;
        }

        @Override
        Response build() {
            if (this.config != null) {
                super.entity(this.config);
            } else if (this.editorUrl != null) {
                super.entity("{\"editorUrl\":\"" + this.editorUrl + "\"}");
            } else if (this.error != null) {
                super.entity("{\"error\":\"" + this.error + "\"}");
            }
            return super.build();
        }
    }
}

