/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.io.InputStream;
import java.security.Key;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.commons.testing.BaseCommonsTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.onlyoffice.BadParameterException;
import org.exoplatform.onlyoffice.ChangeState;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.DocumentContent;
import org.exoplatform.onlyoffice.DocumentNotFoundException;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.OnlyofficeEditorServiceImpl;
import org.exoplatform.onlyoffice.Version;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/test/exo-onlyoffice-editor-services-test-configuration.xml")})
public class OnlyofficeEditorServiceTest
extends BaseCommonsTestCase {
    private static final String USER_FULL_NAME = "John Anthony";
    private static final String USER_USERNAME = "john";
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorServiceTest.class);
    protected static final String SECRET_KEY = "1fRW5pBZu3UIBEdebbpDpKJ4hwExSQoSe97tw8gyYNhqnM1biHb";
    protected OnlyofficeEditorService editorService;
    protected SessionProviderService sessionProviderService;
    protected Session session;
    protected ManageDriveService driveService;
    protected OnlyofficeEditorServiceImpl onlyofficeEditorService;
    protected DocumentService documentService;

    public void beforeClass() {
        super.beforeClass();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        this.editorService = (OnlyofficeEditorService)this.getContainer().getComponentInstanceOfType(OnlyofficeEditorService.class);
        this.onlyofficeEditorService = (OnlyofficeEditorServiceImpl)this.getContainer().getComponentInstanceOfType(OnlyofficeEditorServiceImpl.class);
        this.sessionProviderService = (SessionProviderService)this.getContainer().getComponentInstanceOfType(SessionProviderService.class);
        this.driveService = (ManageDriveService)this.getContainer().getComponentInstanceOfType(ManageDriveService.class);
        this.documentService = (DocumentService)this.getContainer().getComponentInstanceOfType(DocumentService.class);
    }

    @Test
    public void testGetDrive() throws Exception {
        Node node = (Node)Mockito.mock(Node.class);
        Space space = (Space)Mockito.mock(Space.class);
        this.driveService.addDrive(".spaces.test", "collaboration", "*:/spaces/test", "/Groups/spaces/test/Documents", "admin-view, List, Icons", "", true, true, true, true, "nt:folder", "*");
        DriveData driveData = this.driveService.getDriveByName(".spaces.test");
        space.setPrettyName("test");
        SpaceService spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/Groups/spaces/test/Documents/test.docx");
        Mockito.when((Object)spaceService.getSpaceByPrettyName((String)Matchers.any())).thenReturn((Object)space);
        String driveName = this.onlyofficeEditorService.getDrive(node);
        OnlyofficeEditorServiceTest.assertNotNull((Object)driveName);
    }

    @Test
    public void testAddFilePreferences() throws Exception {
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Object[] initialMixinNodeTypes = node.getMixinTypeNames();
        Boolean nodePreference = node.hasNode("eoo:preferences");
        this.editorService.addFilePreferences((Node)node, USER_USERNAME, "path");
        OnlyofficeEditorServiceTest.assertFalse((boolean)ArrayUtils.contains((Object[])initialMixinNodeTypes, (Object)"eoo:onlyofficeFile"));
        OnlyofficeEditorServiceTest.assertFalse((boolean)nodePreference);
        Object[] newMixinNodeTypes = node.getMixinTypeNames();
        OnlyofficeEditorServiceTest.assertTrue((boolean)ArrayUtils.contains((Object[])newMixinNodeTypes, (Object)"eoo:onlyofficeFile"));
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.hasNode("eoo:preferences"));
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.getNode("eoo:preferences").hasNode(USER_USERNAME));
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.getNode("eoo:preferences").getNode(USER_USERNAME).hasProperty("path"));
        OnlyofficeEditorServiceTest.assertEquals((String)node.getNode("eoo:preferences").getNode(USER_USERNAME).getProperty("path").getValue().getString(), (String)"path");
        node.remove();
    }

    protected NodeImpl createDocument(String title, String type, String data, Boolean createAtRoot) throws Exception {
        this.startSessionAs("root");
        NodeImpl rootNode = (NodeImpl)this.session.getRootNode();
        rootNode.setPermission(USER_USERNAME, new String[]{"add_node", "set_property"});
        NodeImpl node = createAtRoot != false ? (NodeImpl)rootNode.addNode(title, type) : (NodeImpl)rootNode.addNode("Users", "nt:folder").addNode(title, type);
        node.addMixin("exo:privilegeable");
        node.addMixin("exo:activityInfo");
        node.addMixin("exo:datetime");
        node.addMixin("exo:modify");
        node.addMixin("exo:sortable");
        node.setProperty("exo:activityId", Calendar.getInstance());
        node.setProperty("exo:dateModified", Calendar.getInstance());
        node.setProperty("exo:lastModifier", USER_USERNAME);
        node.setProperty("exo:lastModifiedDate", Calendar.getInstance());
        if (type.equals("nt:file")) {
            Node contentNode = node.addNode("jcr:content", "nt:unstructured");
            contentNode.addMixin("exo:datetime");
            contentNode.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.text");
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            contentNode.setProperty("jcr:data", data);
            contentNode.setProperty("exo:dateCreated", Calendar.getInstance());
            contentNode.setProperty("exo:dateModified", Calendar.getInstance());
        }
        node.addMixin("mix:referenceable");
        node.addMixin("mix:versionable");
        rootNode.getSession().save();
        return node;
    }

    @Test
    public void testCallListenerOnCreateWhenAddingListener() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        final AtomicBoolean onCreateCalled = new AtomicBoolean(false);
        OnlyofficeEditorListener listener = new OnlyofficeEditorListener(){

            public void onCreate(DocumentStatus status) {
                onCreateCalled.set(true);
            }

            public void onGet(DocumentStatus status) {
            }

            public void onJoined(DocumentStatus status) {
            }

            public void onLeaved(DocumentStatus status) {
            }

            public void onSaved(DocumentStatus status) {
            }

            public void onError(DocumentStatus status) {
            }
        };
        this.editorService.addListener(listener);
        this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        OnlyofficeEditorServiceTest.assertTrue((boolean)onCreateCalled.get());
        node.remove();
    }

    protected void startSessionAs(String user) throws Exception {
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        memberships.add(new MembershipEntry("/platform/administrators"));
        Identity identity = new Identity(user, memberships);
        ConversationState state = new ConversationState(identity);
        state.setAttribute("subject", (Object)identity.getSubject());
        ConversationState.setCurrent((ConversationState)state);
        SessionProvider provider = new SessionProvider(state);
        this.sessionProviderService.setSessionProvider(null, provider);
        SessionProvider systemSessionProvider = SessionProviderService.getSystemSessionProvider();
        this.session = systemSessionProvider.getSession("portal-test", SessionProviderService.getRepository());
    }

    @Test
    public void testCallListenerOnCreateWhenRemovingListener() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        final AtomicBoolean onCreateCalled = new AtomicBoolean(false);
        OnlyofficeEditorListener listener = new OnlyofficeEditorListener(){

            public void onCreate(DocumentStatus status) {
                onCreateCalled.set(true);
            }

            public void onGet(DocumentStatus status) {
            }

            public void onJoined(DocumentStatus status) {
            }

            public void onLeaved(DocumentStatus status) {
            }

            public void onSaved(DocumentStatus status) {
            }

            public void onError(DocumentStatus status) {
            }
        };
        this.editorService.addListener(listener);
        this.editorService.removeListener(listener);
        this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        OnlyofficeEditorServiceTest.assertFalse((boolean)onCreateCalled.get());
        node.remove();
    }

    @Test
    public void testCreateDocumentWhenUserDataNotNull() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", false);
        this.editorService.addFilePreferences((Node)node, USER_USERNAME, node.getPath());
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        String docId = node.getUUID();
        String editorURL = "http://127.0.0.1:8080/portal/classic/oeditor?docId=" + docId;
        OnlyofficeEditorServiceTest.assertNotNull((Object)config);
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.getPath().startsWith("/Users"));
        OnlyofficeEditorServiceTest.assertTrue((boolean)config.getPath().endsWith("/Test Document.docx"));
        OnlyofficeEditorServiceTest.assertTrue((boolean)config.isCreated());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isClosing());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isOpen());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isClosed());
        OnlyofficeEditorServiceTest.assertNull((Object)config.getError());
        OnlyofficeEditorServiceTest.assertEquals((String)docId, (String)config.getDocId());
        OnlyofficeEditorServiceTest.assertEquals((String)editorURL, (String)config.getEditorUrl());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getDocument());
        OnlyofficeEditorServiceTest.assertEquals((String)"Test Document.docx", (String)config.getDocument().getTitle());
        OnlyofficeEditorServiceTest.assertEquals((String)"docx", (String)config.getDocument().getFileType());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getEditorConfig());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getEditorConfig().getUser());
        node.remove();
    }

    @Test
    public void testCreateEditorIncorrectFile() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:base", "testContent", true);
        try {
            this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        }
        catch (OnlyofficeEditorException e) {
            node.remove();
            return;
        }
        OnlyofficeEditorServiceTest.fail();
    }

    @Test
    public void testCreateEditorWhenCopyEditorForUserFromAnotherEntry() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, "root", null, node.getUUID(), "edit");
        String docId = node.getUUID();
        String editorURL = "http://127.0.0.1:8080/portal/classic/oeditor?docId=" + docId;
        OnlyofficeEditorServiceTest.assertNotNull((Object)config);
        OnlyofficeEditorServiceTest.assertTrue((boolean)config.isCreated());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isClosing());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isOpen());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isClosed());
        OnlyofficeEditorServiceTest.assertNull((Object)config.getError());
        OnlyofficeEditorServiceTest.assertEquals((String)docId, (String)config.getDocId());
        OnlyofficeEditorServiceTest.assertEquals((String)editorURL, (String)config.getEditorUrl());
        OnlyofficeEditorServiceTest.assertEquals((String)"/Test Document.docx", (String)config.getPath());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getDocument());
        OnlyofficeEditorServiceTest.assertEquals((String)"Test Document.docx", (String)config.getDocument().getTitle());
        OnlyofficeEditorServiceTest.assertEquals((String)"docx", (String)config.getDocument().getFileType());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getEditorConfig());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getEditorConfig().getUser());
        node.remove();
    }

    @Test
    public void testCreateNewEditorConfigAndDocumentKey() throws Exception {
        this.startSessionAs(USER_USERNAME);
        Node node = this.session.getRootNode().addNode("Test Document.docx", "nt:file");
        node.addMixin("mix:referenceable");
        Node contentNode = node.addNode("jcr:content", "nt:unstructured");
        contentNode.setProperty("jcr:mimeType", "application/vnd.oasis.opendocument.text");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        contentNode.setProperty("jcr:data", "testContent");
        this.session.save();
        String docId = node.getUUID();
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, docId, "edit");
        String editorURL = "http://127.0.0.1:8080/portal/classic/oeditor?docId=" + docId;
        OnlyofficeEditorServiceTest.assertNotNull((Object)config);
        OnlyofficeEditorServiceTest.assertTrue((boolean)config.isCreated());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isClosing());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isOpen());
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isClosed());
        OnlyofficeEditorServiceTest.assertNull((Object)config.getError());
        OnlyofficeEditorServiceTest.assertEquals((String)docId, (String)config.getDocId());
        OnlyofficeEditorServiceTest.assertEquals((String)editorURL, (String)config.getEditorUrl());
        OnlyofficeEditorServiceTest.assertEquals((String)"/Test Document.docx", (String)config.getPath());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getDocument());
        OnlyofficeEditorServiceTest.assertEquals((String)"Test Document.docx", (String)config.getDocument().getTitle());
        OnlyofficeEditorServiceTest.assertEquals((String)"docx", (String)config.getDocument().getFileType());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getEditorConfig());
        OnlyofficeEditorServiceTest.assertNotNull((Object)config.getEditorConfig().getUser());
        node.remove();
        this.session.save();
    }

    @Test
    public void testDownloadVersionToJcrNodeAndAddingCommentToCurrentFile() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        ActivityTypeUtils.attachActivityId((Node)node, (String)"activityId");
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        this.editorService.downloadVersion(USER_USERNAME, config.getDocument().getKey(), false, false, "comment", null);
        node = this.editorService.getDocumentById(config.getWorkspace(), config.getDocId());
        Object[] newMixinNodeTypes = node.getMixinTypeNames();
        OnlyofficeEditorServiceTest.assertTrue((boolean)ArrayUtils.contains((Object[])newMixinNodeTypes, (Object)"eoo:onlyofficeFile"));
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.hasProperty("eoo:commentId"));
        OnlyofficeEditorServiceTest.assertEquals((String)"", (String)node.getProperty("eoo:commentId").getValue().getString());
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.hasProperty("exo:lastModifiedDate"));
        OnlyofficeEditorServiceTest.assertNotNull((Object)node.getProperty("exo:lastModifiedDate").getValue().getString());
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.hasProperty("exo:lastModifier"));
        OnlyofficeEditorServiceTest.assertEquals((String)USER_USERNAME, (String)node.getProperty("exo:lastModifier").getValue().getString());
        OnlyofficeEditorServiceTest.assertNotSame((Object)config.getEditorConfig().getUser().lastSaved.toString(), (Object)"0");
        node.remove();
    }

    @Test
    public void testDownloadVersionWhenContentUrlNotNull() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        this.editorService.downloadVersion(USER_USERNAME, config.getDocument().getKey(), false, false, "comment", config.getEditorUrl());
        Config result = this.editorService.getEditorByKey(USER_USERNAME, config.getDocument().getKey());
        OnlyofficeEditorServiceTest.assertNotSame((Object)result.getEditorConfig().getUser().lastSaved.toString(), (Object)"0");
        node.remove();
    }

    @Test
    public void testGetContent() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentContent documentContent = this.editorService.getContent(USER_USERNAME, config.getDocument().getKey());
        OnlyofficeEditorServiceTest.assertNotNull((Object)documentContent);
        String content = IOUtils.toString((InputStream)documentContent.getData(), (String)"UTF-8");
        OnlyofficeEditorServiceTest.assertEquals((String)"testContent", (String)content);
        OnlyofficeEditorServiceTest.assertEquals((String)"application/vnd.oasis.opendocument.text", (String)documentContent.getType());
        node.remove();
    }

    @Test
    public void testGetContentWhenFileKeyNotFound() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        try {
            this.editorService.getContent(USER_USERNAME, "key");
            OnlyofficeEditorServiceTest.fail();
        }
        catch (BadParameterException e) {
            OnlyofficeEditorServiceTest.assertTrue((boolean)(e instanceof BadParameterException));
        }
        finally {
            node.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetContentWhenUserEditorNotFound() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        try {
            this.editorService.getContent("Thomas", config.getDocument().getKey());
            OnlyofficeEditorServiceTest.fail();
        }
        catch (BadParameterException e) {
            OnlyofficeEditorServiceTest.assertTrue((boolean)(e instanceof BadParameterException));
        }
        finally {
            node.remove();
        }
    }

    @Test
    public void testGetDocument() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Node nodeDocument = this.editorService.getDocument(null, node.getPath());
        OnlyofficeEditorServiceTest.assertNotNull((Object)nodeDocument);
        OnlyofficeEditorServiceTest.assertEquals((String)nodeDocument.getName(), (String)"Test Document.docx");
        OnlyofficeEditorServiceTest.assertEquals((String)nodeDocument.getPrimaryNodeType().getName(), (String)"nt:file");
        node.remove();
    }

    @Test
    public void testGetDocumentByIdWhenDocumentExists() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Node nodeDocument = this.editorService.getDocumentById(null, node.getUUID());
        OnlyofficeEditorServiceTest.assertNotNull((Object)nodeDocument);
        OnlyofficeEditorServiceTest.assertEquals((String)nodeDocument.getName(), (String)"Test Document.docx");
        OnlyofficeEditorServiceTest.assertEquals((String)nodeDocument.getPrimaryNodeType().getName(), (String)"nt:file");
        node.remove();
    }

    @Test
    public void testGetDocumentByIdWhenWrongId() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        try {
            this.editorService.getDocumentById(null, USER_USERNAME);
            OnlyofficeEditorServiceTest.fail();
        }
        catch (DocumentNotFoundException e) {
            OnlyofficeEditorServiceTest.assertTrue((boolean)(e instanceof DocumentNotFoundException));
        }
        finally {
            node.remove();
        }
    }

    @Test
    public void testGetDocumentId() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        String documentId = this.editorService.getDocumentId((Node)node);
        OnlyofficeEditorServiceTest.assertNotNull((Object)documentId);
        OnlyofficeEditorServiceTest.assertEquals((String)node.getUUID(), (String)documentId);
        node.remove();
    }

    @Test
    public void testGetEditorByKeyWhenNoConfig() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config configTest = this.editorService.getEditorByKey(USER_USERNAME, null);
        OnlyofficeEditorServiceTest.assertNull((Object)configTest);
        node.remove();
    }

    @Test
    public void testGetEditorLink() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        String editorLink = this.editorService.getEditorLink((Node)node, "http", "127.0.0.1", 8080);
        String editorLinkTest = "http://127.0.0.1:8080/portal/classic/oeditor?docId=" + node.getUUID();
        OnlyofficeEditorServiceTest.assertNotNull((Object)editorLink);
        OnlyofficeEditorServiceTest.assertEquals((String)editorLink, (String)editorLinkTest);
        node.remove();
    }

    @Test
    public void testGetEditorWhenEditorAlreadyExists() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        Config configTest = this.editorService.getEditor(USER_USERNAME, config.getWorkspace(), node.getPath());
        OnlyofficeEditorServiceTest.assertNotNull((Object)configTest);
        OnlyofficeEditorServiceTest.assertEquals((Object)configTest, (Object)config);
        node.remove();
    }

    @Test
    public void testGetEditorWhenNoMixNode() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        node.removeMixin("mix:versionable");
        node.save();
        node.removeMixin("mix:referenceable");
        node.save();
        Config configTest = this.editorService.getEditor(USER_USERNAME, config.getWorkspace(), node.getPath());
        OnlyofficeEditorServiceTest.assertNull((Object)configTest);
        node.remove();
    }

    @Test
    public void testGetEditorWithCreateCoEditing() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        Config configTest = this.editorService.getEditor(USER_USERNAME, config.getWorkspace(), node.getPath());
        OnlyofficeEditorServiceTest.assertNotNull((Object)configTest);
        OnlyofficeEditorServiceTest.assertEquals((Object)configTest, (Object)config);
        node.remove();
    }

    @Test
    public void testGetLastModifier() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config editor = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        this.editorService.setLastModifier(editor.getDocument().getKey(), USER_USERNAME);
        Config.Editor.User user = this.editorService.getLastModifier(editor.getDocument().getKey());
        OnlyofficeEditorServiceTest.assertNotNull((Object)user);
        OnlyofficeEditorServiceTest.assertEquals((String)user.getName(), (String)USER_FULL_NAME);
        OnlyofficeEditorServiceTest.assertNotSame((Object)user.lastModified, (Object)"0");
        node.remove();
    }

    @Test
    public void testGetState() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        ChangeState changeStateTosaved = this.editorService.getState(USER_USERNAME, node.getUUID());
        Config editor = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        ChangeState changeStateToNotSaved = this.editorService.getState(USER_USERNAME, editor.getDocument().getKey());
        OnlyofficeEditorServiceTest.assertTrue((boolean)changeStateTosaved.saved);
        OnlyofficeEditorServiceTest.assertFalse((boolean)changeStateToNotSaved.saved);
        node.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetStateWhenUserEditorNotFound() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config editor = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        try {
            this.editorService.getState("Thomas", editor.getDocument().getKey());
            OnlyofficeEditorServiceTest.fail();
        }
        catch (BadParameterException e) {
            OnlyofficeEditorServiceTest.assertTrue((boolean)(e instanceof BadParameterException));
        }
        finally {
            node.remove();
        }
    }

    @Test
    public void testGetUserWhenConfigIsNull() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        Config.Editor.User user = this.editorService.getUser("key", USER_USERNAME);
        OnlyofficeEditorServiceTest.assertNull((Object)user);
        node.remove();
    }

    @Test
    public void testGetUserWithKeyAndUserId() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        Config.Editor.User user = this.editorService.getUser(config.getDocument().getKey(), USER_USERNAME);
        OnlyofficeEditorServiceTest.assertNotNull((Object)user);
        OnlyofficeEditorServiceTest.assertEquals((String)user.getName(), (String)USER_FULL_NAME);
        node.remove();
    }

    @Test
    public void testInitDocumentByNode() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        String initDocument = this.editorService.initDocument((Node)node);
        OnlyofficeEditorServiceTest.assertNotNull((Object)initDocument);
        OnlyofficeEditorServiceTest.assertEquals((String)node.getUUID(), (String)initDocument);
        node.remove();
    }

    @Test
    public void testInitDocumentByWorkspaceAndPath() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        String initDocument = this.editorService.initDocument(config.getWorkspace(), node.getPath());
        OnlyofficeEditorServiceTest.assertNotNull((Object)initDocument);
        OnlyofficeEditorServiceTest.assertEquals((String)node.getUUID(), (String)initDocument);
        node.remove();
    }

    @Test
    public void testIsDocumentMimeSupported() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        OnlyofficeEditorServiceTest.assertTrue((boolean)this.editorService.isDocumentMimeSupported((Node)node));
        node.getNode("jcr:content").setProperty("jcr:mimeType", "text/plain");
        this.session.save();
        OnlyofficeEditorServiceTest.assertFalse((boolean)this.editorService.isDocumentMimeSupported((Node)node));
        Node unsctructuredNode = this.session.getRootNode().addNode("Test Document.docx", "nt:unstructured");
        this.session.save();
        OnlyofficeEditorServiceTest.assertTrue((boolean)this.editorService.isDocumentMimeSupported(unsctructuredNode));
        node.remove();
        unsctructuredNode.remove();
    }

    @Test
    public void testIsDocumentMimeSupportedWhenNullNode() throws Exception {
        Boolean isDocumentSupported = this.editorService.isDocumentMimeSupported(null);
        OnlyofficeEditorServiceTest.assertFalse((boolean)isDocumentSupported);
    }

    @Test
    public void testSetLastModifier() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        this.editorService.setLastModifier(node.getUUID(), USER_USERNAME);
        OnlyofficeEditorServiceTest.assertNotSame((Object)config.getEditorConfig().getUser().lastModified.toString(), (Object)"0");
        node.remove();
    }

    @Test
    public void testUpdateDocumentErrorSavingInOnlyOffice() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(3L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).url("http://127.0.0.1:8080/editor/").key(config.getDocument().getKey()).build();
        this.editorService.updateDocument(status);
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig());
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig().getError());
        node.remove();
    }

    @Test
    public void testUpdateDocumentErrorWithoutContentUrl() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(3L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).key(config.getDocument().getKey()).build();
        this.editorService.updateDocument(status);
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig());
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig().getError());
        OnlyofficeEditorServiceTest.assertEquals((String)status.getConfig().getError(), (String)"Error in editor (0). No changes saved");
        node.remove();
    }

    @Test
    public void testUpdateDocumentForUnknownCode() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(5L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).saved(Boolean.valueOf(true)).key(config.getDocument().getKey()).build();
        this.editorService.updateDocument(status);
        Node document = this.editorService.getDocumentById("portal-test", node.getUUID());
        OnlyofficeEditorServiceTest.assertNotNull((Object)document);
        OnlyofficeEditorServiceTest.assertEquals((String)node.getUUID(), (String)document.getUUID());
        OnlyofficeEditorServiceTest.assertEquals((String)node.getPath(), (String)document.getPath());
        OnlyofficeEditorServiceTest.assertEquals((String)node.getPrimaryNodeType().getName(), (String)document.getPrimaryNodeType().getName());
        node.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateDocumentForUnknownDocument() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(0L)).userId(USER_USERNAME).users(new String[0]).key(config.getDocument().getKey()).build();
        try {
            this.editorService.updateDocument(status);
            OnlyofficeEditorServiceTest.fail();
        }
        catch (OnlyofficeEditorException e) {
            OnlyofficeEditorServiceTest.assertTrue((boolean)(e instanceof OnlyofficeEditorException));
        }
        finally {
            node.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateDocumentForUnknownFileKey() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(5L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).saved(Boolean.valueOf(true)).key("key").build();
        try {
            this.editorService.updateDocument(status);
            OnlyofficeEditorServiceTest.fail();
        }
        catch (BadParameterException e) {
            OnlyofficeEditorServiceTest.assertTrue((boolean)(e instanceof BadParameterException));
        }
        finally {
            node.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateDocumentForUnknownUser() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(5L)).users(new String[]{"Thomas"}).userId("Thomas").saved(Boolean.valueOf(true)).key(config.getDocument().getKey()).build();
        try {
            this.editorService.updateDocument(status);
            OnlyofficeEditorServiceTest.fail();
        }
        catch (BadParameterException e) {
            OnlyofficeEditorServiceTest.assertTrue((boolean)(e instanceof BadParameterException));
        }
        finally {
            node.remove();
        }
    }

    @Test
    public void testUpdateDocumentForceSaveDone() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(6L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).saved(Boolean.valueOf(true)).key(config.getDocument().getKey()).build();
        this.editorService.updateDocument(status);
        Node document = this.editorService.getDocumentById("portal-test", node.getUUID());
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig());
        OnlyofficeEditorServiceTest.assertNotSame((Object)config.getEditorConfig().getUser().getLastSaved(), (Object)0);
        OnlyofficeEditorServiceTest.assertNotNull((Object)document);
        OnlyofficeEditorServiceTest.assertEquals((String)node.getUUID(), (String)document.getUUID());
        OnlyofficeEditorServiceTest.assertEquals((String)node.getPath(), (String)document.getPath());
        OnlyofficeEditorServiceTest.assertEquals((String)node.getPrimaryNodeType().getName(), (String)document.getPrimaryNodeType().getName());
        node.remove();
    }

    @Test
    public void testUpdateDocumentIfThereWereModificationAfterSaving() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(2L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).key(config.getDocument().getKey()).build();
        String documentKey = config.getDocument().getKey();
        this.editorService.setLastModifier(config.getDocument().getKey(), USER_USERNAME);
        this.editorService.updateDocument(status);
        OnlyofficeEditorServiceTest.assertNull((Object)this.editorService.getEditorByKey(USER_USERNAME, documentKey));
        node.remove();
    }

    @Test
    public void testUpdateDocumentWhenDocumentStillInEditing() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        Config configTest = this.editorService.createEditor("http", "127.0.0.1", 8080, "root", null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(3L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).key(config.getDocument().getKey()).build();
        this.editorService.updateDocument(status);
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig());
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig().getError());
        OnlyofficeEditorServiceTest.assertEquals((String)status.getConfig().getError(), (String)"Error in editor. Document still in editing state");
        node.remove();
    }

    @Test
    public void testUpdateDocumentWhileErrorInForceSaving() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(7L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).saved(Boolean.valueOf(true)).key(config.getDocument().getKey()).build();
        this.editorService.updateDocument(status);
        Node document = this.editorService.getDocumentById("portal-test", node.getUUID());
        OnlyofficeEditorServiceTest.assertNotNull((Object)document);
        OnlyofficeEditorServiceTest.assertEquals((String)node.getUUID(), (String)document.getUUID());
        OnlyofficeEditorServiceTest.assertEquals((String)node.getPath(), (String)document.getPath());
        OnlyofficeEditorServiceTest.assertEquals((String)node.getPrimaryNodeType().getName(), (String)document.getPrimaryNodeType().getName());
        node.remove();
    }

    @Test
    public void testUpdateDocumentWithSaveLink() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(6L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).saved(Boolean.valueOf(false)).url("http://127.0.0.1:8080/editor/").key(config.getDocument().getKey()).build();
        String key = config.getDocument().getKey();
        this.editorService.updateDocument(status);
        Config configAfterAction = this.editorService.getEditorByKey(USER_USERNAME, key);
        OnlyofficeEditorServiceTest.assertNotNull((Object)status.getConfig());
        OnlyofficeEditorServiceTest.assertNotSame((Object)configAfterAction.getEditorConfig().getUser().getLinkSaved(), (Object)0);
        OnlyofficeEditorServiceTest.assertNotNull((Object)configAfterAction.getEditorConfig().getUser().getDownloadLink());
        node.remove();
    }

    @Test
    public void testUpdateTitle() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", false);
        this.editorService.updateTitle("portal-test", node.getUUID(), "TestDocumentMary.docx", USER_USERNAME);
        OnlyofficeEditorServiceTest.assertFalse((boolean)node.getParent().hasNode("Test Document.docx"));
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.getParent().hasNode("TestDocumentMary.docx"));
        node.remove();
    }

    @Test
    public void testUpdateTitleRootNode() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        this.editorService.updateTitle("portal-test", node.getUUID(), "TestDocumentMary.docx", USER_USERNAME);
        OnlyofficeEditorServiceTest.assertFalse((boolean)node.getParent().hasNode("Test Document.docx"));
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.getParent().hasNode("TestDocumentMary.docx"));
        node.remove();
    }

    @Test
    public void testUpdateTitleWhenNewTitleIsEmpty() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", false);
        this.editorService.updateTitle("portal-test", node.getUUID(), "", USER_USERNAME);
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.getParent().hasNode("Test Document.docx"));
        node.remove();
    }

    @Test
    public void testUpdateTitleWhenNotFoundDocument() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", false);
        this.editorService.updateTitle(null, "docId", "TestDocumentMary.docx", USER_USERNAME);
        OnlyofficeEditorServiceTest.assertTrue((boolean)node.getParent().hasNode("Test Document.docx"));
        node.remove();
    }

    @Test
    public void testUserJoinedAndLeaved() throws Exception {
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(1L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).key(config.getDocument().getKey()).build();
        OnlyofficeEditorServiceTest.assertFalse((boolean)config.isOpen());
        this.editorService.updateDocument(status);
        Config currentConfig = this.editorService.getEditorByKey(USER_USERNAME, config.getDocument().getKey());
        OnlyofficeEditorServiceTest.assertTrue((boolean)currentConfig.isOpen());
        OnlyofficeEditorServiceTest.assertFalse((boolean)currentConfig.isClosed());
        status = new DocumentStatus.Builder().status(Long.valueOf(4L)).userId(USER_USERNAME).users(new String[0]).key(config.getDocument().getKey()).build();
        this.editorService.updateDocument(status);
        Config result = this.editorService.getEditorByKey(USER_USERNAME, config.getDocument().getKey());
        OnlyofficeEditorServiceTest.assertNull((Object)result);
        node.remove();
    }

    @Test
    public void testValidateToken() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", true);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        String key = config.getDocument().getKey();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("key", key);
        String token = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", payload).signWith((Key)Keys.hmacShaKeyFor((byte[])SECRET_KEY.getBytes())).compact();
        String wrongSignToken = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", payload).signWith((Key)Keys.hmacShaKeyFor((byte[])"WRONG-SECRET-KEY-hwExSQoSe97tw8gyYNhqnM1biHb".getBytes())).compact();
        payload.replace("key", "wrong-document-key");
        String wrongKeyToken = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", payload).signWith((Key)Keys.hmacShaKeyFor((byte[])SECRET_KEY.getBytes())).compact();
        OnlyofficeEditorServiceTest.assertTrue((boolean)this.editorService.validateToken(token, key));
        OnlyofficeEditorServiceTest.assertFalse((boolean)this.editorService.validateToken(wrongSignToken, key));
        OnlyofficeEditorServiceTest.assertFalse((boolean)this.editorService.validateToken(wrongKeyToken, key));
        payload.clear();
        payload.put("url", "http://127.0.0.1:8080/editor/" + key);
        token = Jwts.builder().setSubject("exo-onlyoffice").claim("payload", payload).signWith((Key)Keys.hmacShaKeyFor((byte[])SECRET_KEY.getBytes())).compact();
        OnlyofficeEditorServiceTest.assertTrue((boolean)this.editorService.validateToken(token, key));
        node.remove();
    }

    @Test
    public void testGetVersions() throws Exception {
        this.startSessionAs(USER_USERNAME);
        NodeImpl node = this.createDocument("Test Document.docx", "nt:file", "testContent", false);
        Config config = this.editorService.createEditor("http", "127.0.0.1", 8080, USER_USERNAME, null, node.getUUID(), "edit");
        DocumentStatus status = new DocumentStatus.Builder().status(Long.valueOf(6L)).users(new String[]{USER_USERNAME}).userId(USER_USERNAME).saved(Boolean.valueOf(true)).key(config.getDocument().getKey()).comment("Document updated").build();
        this.editorService.updateDocument(status);
        List versions = this.editorService.getVersions("portal-test", node.getUUID(), 3, 0);
        OnlyofficeEditorServiceTest.assertNotNull((Object)versions);
        OnlyofficeEditorServiceTest.assertEquals((int)1, (int)versions.size());
        Version version1 = (Version)versions.get(0);
        OnlyofficeEditorServiceTest.assertEquals((String)USER_USERNAME, (String)version1.getAuthor());
        OnlyofficeEditorServiceTest.assertEquals((int)1, (int)version1.getVersionPageNumber());
        OnlyofficeEditorServiceTest.assertEquals((String)USER_FULL_NAME, (String)version1.getFullName());
        OnlyofficeEditorServiceTest.assertNotNull((Object)version1.getVersionLabels());
        OnlyofficeEditorServiceTest.assertEquals((int)1, (int)version1.getVersionLabels().length);
        OnlyofficeEditorServiceTest.assertEquals((String)"Document updated", (String)version1.getVersionLabels()[0]);
        node.remove();
    }
}

