/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import io.meeds.portal.thumbnail.model.FileContent;
import io.meeds.portal.thumbnail.plugin.ImageThumbnailPlugin;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class OfficeDocumentsThumbnailPlugin
extends ImageThumbnailPlugin {
    public static final String DOCUMENTS_OFFICE = "officeThumbnail";
    public static final String EXO_TITLE = "exo:title";
    public static final String FILE_TYPE = "jpeg";
    public static final String FILE_MIME_TYPE = "image/jpeg";
    private static final Log log = ExoLogger.getExoLogger(OfficeDocumentsThumbnailPlugin.class);

    public static SessionProvider getUserSessionProvider(RepositoryService repositoryService, Identity aclIdentity) {
        SessionProvider sessionProvider = new SessionProvider(new ConversationState(aclIdentity));
        try {
            ManageableRepository repository = repositoryService.getCurrentRepository();
            String workspace = repository.getConfiguration().getDefaultWorkspaceName();
            sessionProvider.setCurrentRepository(repository);
            sessionProvider.setCurrentWorkspace(workspace);
            return sessionProvider;
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Can't build a SessionProvider", e);
        }
    }

    public String getFileType() {
        return DOCUMENTS_OFFICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContent getImage(String fileId, String userName) throws ObjectNotFoundException {
        UserACL userACL = (UserACL)CommonsUtils.getService(UserACL.class);
        RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = OfficeDocumentsThumbnailPlugin.getUserSessionProvider(repositoryService, userACL.getUserIdentity(userName));
            Session session = sessionProvider.getSession("collaboration", repositoryService.getDefaultRepository());
            Node file = session.getNodeByUUID(fileId);
            OnlyofficeEditorService onlyofficeEditorService = (OnlyofficeEditorService)CommonsUtils.getService(OnlyofficeEditorService.class);
            String fileName = file.getProperty(EXO_TITLE).getString();
            String originalFileType = fileName.substring(fileName.lastIndexOf(46) + 1);
            byte[] convertedContent = onlyofficeEditorService.convertNodeContent(file, FILE_TYPE, originalFileType, userName);
            if (convertedContent == null || convertedContent.length == 0) {
                log.error((Object)("Provided file with id " + fileId + " cannot be converted"));
                FileContent fileContent = null;
                return fileContent;
            }
            FileContent fileContent = new FileContent(fileId, file.getProperty(EXO_TITLE).getString(), FILE_MIME_TYPE, (InputStream)new ByteArrayInputStream(convertedContent));
            return fileContent;
        }
        catch (RepositoryException | RepositoryConfigurationException e) {
            throw new ObjectNotFoundException("File with id " + fileId + " not found");
        }
        catch (Exception e) {
            log.error("Cannot get content stream of node with uid {}", new Object[]{fileId, e});
        }
        finally {
            assert (sessionProvider != null);
            sessionProvider.close();
        }
        return null;
    }
}

