/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.portlet;

import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.webui.OnlyofficeContext;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;

public class EditorPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(EditorPortlet.class);
    private OnlyofficeEditorService onlyoffice;
    private ResourceBundleService i18nService;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.onlyoffice = (OnlyofficeEditorService)container.getComponentInstanceOfType(OnlyofficeEditorService.class);
        this.i18nService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
    }

    @RenderMode(name="view")
    public void view(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle i18n = this.i18nService.getResourceBundle(new String[]{"locale.onlyoffice.Onlyoffice", "locale.onlyoffice.OnlyofficeClient"}, request.getLocale());
        String docId = webuiContext.getRequestParameter("docId");
        if (docId != null) {
            try {
                Config config = this.onlyoffice.createEditor(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRemoteUser(), null, docId);
                if (config != null) {
                    if (config.getEditorConfig().getLang() == null) {
                        if (request.getLocale() != null) {
                            config.getEditorConfig().setLang(request.getLocale().getLanguage());
                        } else {
                            config.getEditorConfig().setLang(Locale.getDefault().getLanguage());
                        }
                    }
                    OnlyofficeContext.callModule((String)("initEditor(" + config.toJSON() + ");"));
                } else {
                    OnlyofficeContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.EditorCannotBeCreated"));
                }
                try {
                    ListenerService listenerService = (ListenerService)webuiContext.getApplication().getApplicationServiceContainer().getComponentInstanceOfType(ListenerService.class);
                    listenerService.broadcast("exo.onlyoffice.editor.open", (Object)this.onlyoffice, (Object)config);
                }
                catch (Exception e) {
                    LOG.error("Error firing listener with Onlyoffice event for user: {}, document: {}", new Object[]{request.getRemoteUser(), docId, e});
                }
            }
            catch (RepositoryException e) {
                LOG.error("Error reading document node by ID: {}", new Object[]{docId, e});
                OnlyofficeContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.CannotReadDocument"));
            }
            catch (OnlyofficeEditorException e) {
                LOG.error("Error creating document editor for node by ID: {}", new Object[]{docId, e});
                OnlyofficeContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.CannotCreateEditor"));
            }
            catch (JsonException e) {
                LOG.error("Error converting editor configuration to JSON for node by ID: {}", new Object[]{docId, e});
                OnlyofficeContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.CannotSendEditorConfiguration"));
            }
            catch (Exception e) {
                LOG.error("Error initializing editor for node by ID: {}", new Object[]{docId, e});
                OnlyofficeContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.CannotSendEditorConfiguration"));
            }
        } else {
            OnlyofficeContext.showError((String)i18n.getString("OnlyofficeEditorClient.ErrorTitle"), (String)i18n.getString("OnlyofficeEditor.error.DocumentIdRequired"));
        }
        PortletRequestDispatcher prDispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/pages/editor.jsp");
        prDispatcher.include(request, response);
    }
}

