/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URL;
import java.util.Arrays;

public class FileSystemLinux
extends FileSystemOperations {
    public static final int COUNT_OF_TRY = 10;
    private URL mountPath;

    public FileSystemLinux(URL uRL) {
        this.mountPath = uRL;
    }

    @Override
    public void OpenFolder(URL uRL) throws Exception {
        this.open2(uRL);
    }

    @Override
    public void OpenDocument(URL uRL) throws Exception {
        this.open2(uRL);
    }

    protected void open2(URL uRL) throws Exception {
        String string = this.getServerUrl();
        String string2 = this.mountPath.toString();
        String string3 = uRL.toString();
        String string4 = "";
        if (string3.startsWith(string2)) {
            string4 = string3.replace(string2, "");
        }
        if (this.isDolphinInstalled()) {
            this.openInKde(string, string4);
        } else {
            this.openWithDavfs2(string, string4);
        }
    }

    private boolean isDolphinInstalled() {
        return ExecUtils.exec((String[])new String[]{"dolphin", "--help"}).success;
    }

    private boolean openInKde(String string, String string2) {
        ProcessExecResult processExecResult = ExecUtils.exec(new String[]{"xdg-open", "webdav://" + string + "/" + string2});
        return processExecResult.exitCode == 0;
    }

    private void openWithDavfs2(String string, String string2) throws Exception {
        if (!this.isDavfsInstalled()) {
            throw new UnsupportedOperationException("Could not mount webdav file system cause davfs is not installed.");
        }
        String string3 = this.isLocationMounted(string) ? this.getLocalMountFolder(string) : this.mountDavfs(string, CredentialsDialog.getCredentials("Enter web dav credentials"), CredentialsDialog.getCredentials("Enter sudo credentials"));
        ExecUtils.exec(new String[]{"xdg-open", string3 + "/" + string2});
    }

    private boolean isLocationMounted(String string) {
        File file = new File(this.getLocalMountFolder(string));
        return file.exists() && file.list().length > 0;
    }

    private String getLocalMountFolder(String string) {
        String string2 = "webdav" + this.mountPath.toString().replaceAll("[\\W]", "_");
        File file = new File(".tmp/webdav/");
        if (!file.exists()) {
            file.mkdirs();
        }
        return ".tmp/webdav/" + string2;
    }

    private String mountDavfs(String string, Credentials credentials, Credentials credentials2) throws Exception {
        File file = new File(this.getLocalMountFolder(string));
        file.mkdir();
        String string2 = String.format("mount -t davfs -o uid=%s %s %s", credentials2.login, string, file.getAbsolutePath());
        ProcessExecResult processExecResult = ExecUtils.sudo(string2, credentials2.password, new String[]{credentials.login, credentials.password});
        if (!processExecResult.success || processExecResult.exitCode != 0) {
            throw new RuntimeException("Could not mount webdav server, please verify provided credentials");
        }
        return file.getAbsolutePath();
    }

    private boolean isDavfsInstalled() {
        return ExecUtils.exec((String[])new String[]{"mount.davfs"}).success;
    }

    private String getServerUrl() {
        return this.mountPath.toString().replaceAll("(http://|https://)", "");
    }

    private String buildFailMessage(ProcessExecResult processExecResult) {
        return String.format("Failed to execute command: %s %s %s The command exited with code: %d %s The command returned: %s", Arrays.deepToString(processExecResult.cmd), MODApplet.NEW_LINE, MODApplet.NEW_LINE, processExecResult.exitCode, MODApplet.NEW_LINE, processExecResult.output);
    }
}

