/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;

class FileSystemWindowsVista
extends FileSystemOperations {
    private static String WINDOWSMOUNTER_FILE_PATH = null;
    private URL urlMountRoot = null;

    protected FileSystemWindowsVista(URL uRL) {
        this.urlMountRoot = uRL;
    }

    @Override
    public void OpenFolder(URL uRL) throws Exception {
        this.openWebDAVPath(uRL, false);
    }

    @Override
    public void OpenDocument(URL uRL) throws Exception {
        this.openWebDAVPath(uRL, true);
    }

    private void openWebDAVPath(URL uRL, boolean bl) throws Exception {
        String string = FileSystemWindowsVista.urlToWinVistaDavPath(uRL, bl);
        Process process = Runtime.getRuntime().exec(FileSystemWindowsVista.getWindowsMounterFilePath() + " \"" + this.urlMountRoot + "\"");
        process.waitFor();
        if (process.exitValue() != 0) {
            return;
        }
        String string2 = "explorer.exe \"" + string + "\"";
        Runtime.getRuntime().exec(string2);
    }

    private static String urlToWinVistaDavPath(URL uRL, boolean bl) throws Exception {
        String string = "\\\\" + uRL.getHost();
        if (uRL.getProtocol().equalsIgnoreCase("https")) {
            string = string + "@SSL";
        }
        if (uRL.getPort() != -1) {
            string = string + "@" + uRL.getPort();
        }
        string = string + "\\DavWWWRoot";
        string = !bl ? string + uRL.getPath().replace('/', '\\') : string + URLEncoder.encode(uRL.getPath(), "UTF-8").replace("%2F", "\\").replace("+", "%20");
        return string;
    }

    private static String getWindowsMounterFilePath() throws Exception {
        int n;
        if (WINDOWSMOUNTER_FILE_PATH != null && new File(WINDOWSMOUNTER_FILE_PATH).exists()) {
            return WINDOWSMOUNTER_FILE_PATH;
        }
        InputStream inputStream = FileSystemWindowsVista.class.getResourceAsStream("WindowsMounter.exe");
        InputStream inputStream2 = FileSystemWindowsVista.class.getResourceAsStream("WindowsMounter.exe.config");
        if (inputStream == null || inputStream2 == null) {
            throw new Exception("WindowsMounter is not found.");
        }
        File file = File.createTempFile("WindowsMounter", ".exe");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        inputStream.close();
        File file2 = new File(file.getPath() + ".config");
        file2.createNewFile();
        FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
        while ((n = inputStream2.read(byArray)) != -1) {
            fileOutputStream2.write(byArray, 0, n);
        }
        fileOutputStream2.flush();
        fileOutputStream2.close();
        inputStream2.close();
        WINDOWSMOUNTER_FILE_PATH = file.getPath();
        return WINDOWSMOUNTER_FILE_PATH;
    }
}

