/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.rest;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.rest.resource.ResourceContainer;

abstract class RESTServiceBase
implements ResourceContainer {
    RESTServiceBase() {
    }

    protected String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED_FOR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("REMOTE_ADDR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (this.isValidName(ip)) {
            return ip;
        }
        return null;
    }

    protected String getClientHost(HttpServletRequest request) {
        String host = request.getHeader("X-Forwarded-Host");
        if (this.isValidName(host)) {
            return host;
        }
        host = request.getRemoteHost();
        if (this.isValidName(host)) {
            return host;
        }
        return null;
    }

    protected boolean isValidName(String hostName) {
        return hostName != null && hostName.length() > 0 && !"unknown".equalsIgnoreCase(hostName);
    }
}

