/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.jcr.Folder;
import org.exoplatform.outlook.jcr.HierarchyNode;

public abstract class File
extends HierarchyNode {
    public File(Folder parent, Node node) throws RepositoryException, OutlookException {
        super(parent, node);
        if (!File.isFile(node)) {
            throw new OutlookException("Not a file node");
        }
    }

    public File(String parentPath, Node node) throws RepositoryException, OutlookException {
        super(parentPath, node);
        if (!File.isFile(node)) {
            throw new OutlookException("Not a file node");
        }
    }

    @Override
    public final boolean isFolder() {
        return false;
    }

    public long getSize() throws RepositoryException {
        Node node = this.getNode();
        if (node != null) {
            return node.getNode("jcr:content").getProperty("jcr:data").getLength();
        }
        return 0L;
    }
}

