/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.server.filter;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.outlook.security.OutlookTokenService;
import org.exoplatform.outlook.web.RequestUtils;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.security.Credentials;

public class OutlookRememberMeFilter
implements Filter {
    protected static final Logger LOG = LoggerFactory.getLogger(OutlookRememberMeFilter.class);
    public static final String INITIAL_COOKIE_VALUE = "_init_me";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object httpReq = (HttpServletRequest)request;
        HttpServletResponse httpRes = (HttpServletResponse)response;
        String uri = httpReq.getRequestURI();
        String rememberMeOutlook = RequestUtils.getCookie(httpReq, "remembermeoutlook");
        if (httpReq.getRemoteUser() == null) {
            if (rememberMeOutlook != null) {
                if (!INITIAL_COOKIE_VALUE.equals(rememberMeOutlook)) {
                    OutlookTokenService outlookTokens = (OutlookTokenService)AbstractTokenService.getInstance(OutlookTokenService.class);
                    Credentials credentials = outlookTokens.validateToken(rememberMeOutlook, false);
                    if (credentials != null) {
                        try {
                            ServletContainer servletContainer = ServletContainerFactory.getServletContainer();
                            servletContainer.login(httpReq, httpRes, credentials);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Cookie remembermeoutlook restored user (" + credentials.getUsername() + ") credentials for " + uri));
                            }
                            LOG.info((Object)("Restored user (" + credentials.getUsername() + ") credentials for " + uri));
                            httpRes.sendRedirect(uri + '?' + httpReq.getQueryString());
                            return;
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Cannot restore user credentials from remembermeoutlook cookie value '" + rememberMeOutlook + "' for " + uri + ". " + e.getMessage()));
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cookie remembermeoutlook found with initial value but remote user not set for " + uri));
                }
            }
        } else if (rememberMeOutlook != null && INITIAL_COOKIE_VALUE.equals(rememberMeOutlook)) {
            String rememberMe = RequestUtils.getCookie(httpReq, "rememberme");
            CookieTokenService rememberMeTokens = (CookieTokenService)AbstractTokenService.getInstance(CookieTokenService.class);
            Credentials credentials = rememberMeTokens.validateToken(rememberMe, false);
            if (credentials != null) {
                OutlookTokenService outlookTokens = (OutlookTokenService)AbstractTokenService.getInstance(OutlookTokenService.class);
                rememberMeOutlook = outlookTokens.createToken(credentials);
                Cookie cookie = new Cookie("remembermeoutlook", rememberMeOutlook);
                cookie.setPath(uri);
                cookie.setMaxAge((int)outlookTokens.getValidityTime());
                httpRes.addCookie(cookie);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cookie remembermeoutlook initialized with user (" + credentials.getUsername() + ") credentials for " + uri));
                }
            }
        }
        if (httpReq.getRemoteUser() == null) {
            Cookie cookie = new Cookie("remembermeoutlook", "");
            cookie.setPath(uri);
            cookie.setMaxAge(0);
            httpRes.addCookie(cookie);
            String query = httpReq.getQueryString();
            if (query != null && query.indexOf("_host_Info") > 0) {
                StringBuilder fixedQuery = new StringBuilder();
                for (String qp : query.split("&")) {
                    int qpdi;
                    if (fixedQuery.length() > 0) {
                        fixedQuery.append('&');
                    }
                    if ((qpdi = qp.indexOf("=")) > 0) {
                        fixedQuery.append(qp.substring(0, ++qpdi));
                        if (qpdi >= qp.length()) continue;
                        fixedQuery.append(URLEncoder.encode(qp.substring(qpdi), "ISO-8859-1"));
                        continue;
                    }
                    fixedQuery.append(qp);
                }
                httpReq = new FixedQueryRequest((HttpServletRequest)httpReq, fixedQuery.toString());
            }
        }
        chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpRes);
    }

    public static class FixedQueryRequest
    extends HttpServletRequestWrapper {
        final String fixedQuery;

        protected FixedQueryRequest(HttpServletRequest request, String fixedQuery) {
            super(request);
            this.fixedQuery = fixedQuery;
        }

        public String getQueryString() {
            return this.fixedQuery;
        }
    }
}

