/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.jcr;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.jcr.File;
import org.exoplatform.outlook.jcr.HierarchyNode;

public abstract class Folder
extends HierarchyNode {
    protected final ThreadLocal<Set<Folder>> subfolders = new ThreadLocal();
    protected final ThreadLocal<Set<File>> files = new ThreadLocal();
    protected Folder defaultSubfolder;

    public Folder(Folder parent, Node node) throws RepositoryException, OutlookException {
        super(parent, node);
        if (!Folder.isFolder(node)) {
            throw new OutlookException("Not a folder node");
        }
    }

    public Folder(String parentPath, Node node) throws RepositoryException, OutlookException {
        super(parentPath, node);
        if (!Folder.isFolder(node)) {
            throw new OutlookException("Not a folder node");
        }
    }

    public boolean isRoot() {
        return this.parentPath.equals(this.path);
    }

    public Folder getDefaultSubfolder() {
        return this.defaultSubfolder;
    }

    public boolean hasSubfolders() throws RepositoryException, OutlookException {
        Set<Folder> subfolders = this.subfolders.get();
        if (subfolders == null) {
            subfolders = this.readSubnodes();
        }
        return subfolders.size() > 0;
    }

    public Set<Folder> getSubfolders() throws RepositoryException, OutlookException {
        Set<Folder> subfolders = this.subfolders.get();
        if (subfolders == null) {
            subfolders = this.readSubnodes();
        }
        return Collections.unmodifiableSet(subfolders);
    }

    public boolean hasFiles() throws RepositoryException, OutlookException {
        Set<File> files = this.files.get();
        if (files == null) {
            files = this.readFiles();
        }
        return files.size() > 0;
    }

    public Set<File> getFiles() throws RepositoryException, OutlookException {
        Set<File> files = this.files.get();
        if (files == null) {
            files = this.readFiles();
        }
        return Collections.unmodifiableSet(files);
    }

    public Set<HierarchyNode> getChildren() throws RepositoryException, OutlookException {
        LinkedHashSet<HierarchyNode> children = new LinkedHashSet<HierarchyNode>();
        children.addAll(this.getSubfolders());
        children.addAll(this.getFiles());
        return Collections.unmodifiableSet(children);
    }

    @Override
    public final boolean isFolder() {
        return true;
    }

    protected Set<Folder> readSubnodes() throws RepositoryException, OutlookException {
        this.readChildNodes();
        return this.subfolders.get();
    }

    protected Set<File> readFiles() throws RepositoryException, OutlookException {
        this.readChildNodes();
        return this.files.get();
    }

    protected void readChildNodes() throws RepositoryException, OutlookException {
        LinkedHashSet<Folder> folders = new LinkedHashSet<Folder>();
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        if (this.node.hasNodes()) {
            NodeIterator niter = this.node.getNodes();
            while (niter.hasNext()) {
                Node f = niter.nextNode();
                if ((f.isNodeType("nt:folder") || f.isNodeType("nt:unstructured")) && !f.isNodeType("exo:hiddenable")) {
                    folders.add(this.newFolder(this, f));
                    continue;
                }
                if (!f.isNodeType("nt:file")) continue;
                files.add(this.newFile(this, f));
            }
        }
        this.subfolders.set(folders);
        this.files.set(files);
    }

    protected abstract Folder newFolder(Folder var1, Node var2) throws RepositoryException, OutlookException;

    protected abstract Folder newFolder(String var1, Node var2) throws RepositoryException, OutlookException;

    protected abstract File newFile(Folder var1, Node var2) throws RepositoryException, OutlookException;

    public abstract Folder addSubfolder(String var1) throws RepositoryException, OutlookException;
}

