/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.webui;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

public class OutlookLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    protected static final Log LOG = ExoLogger.getLogger(OutlookLifecycle.class);
    protected static final String TOPBAR_COMPONENT_ID = "UITopBarContainerParent";
    protected static final String TOOLBAR_COMPONENT_ID = "UIToolbarContainer";
    protected final ThreadLocal<Boolean> toolbarRendered = new ThreadLocal();

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        UIComponent navbar = this.findNavbarComponent(app, context);
        if (navbar != null && navbar.isRendered()) {
            this.toolbarRendered.set(true);
            navbar.setRendered(false);
        }
        if (((HttpServletRequest)context.getRequest()).getRequestURI().indexOf("/outlook/search") > 0) {
            context.getJavascriptManager().require("SHARED/bts_dropdown");
            context.getJavascriptManager().require("SHARED/wcm-utils", "wcm_utils");
        }
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        Boolean render;
        UIComponent navbar = this.findNavbarComponent(app, context);
        if (navbar != null && (render = this.toolbarRendered.get()) != null && render.booleanValue()) {
            navbar.setRendered(true);
        }
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onDestroy(Application app) throws Exception {
    }

    protected UIComponent findNavbarComponent(Application app, WebuiRequestContext context) throws Exception {
        UIContainer viewContainer;
        UIApplication uiApp;
        UIComponentDecorator uiViewWS;
        ExoContainer container = app.getApplicationServiceContainer();
        if (container != null && (uiViewWS = (UIComponentDecorator)(uiApp = context.getUIApplication()).findComponentById("UIViewWS")) != null && (viewContainer = (UIContainer)uiViewWS.getUIComponent()) != null) {
            UIComponent navbar = viewContainer.findComponentById(TOPBAR_COMPONENT_ID);
            if (navbar != null) {
                return navbar;
            }
            navbar = viewContainer.findComponentById(TOOLBAR_COMPONENT_ID);
            if (navbar != null) {
                return navbar.getParent();
            }
        }
        return null;
    }
}

