/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook;

import com.ibm.icu.text.Transliterator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.entity.ContentType;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.ext.activity.BuildLinkUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumAdministration;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.outlook.BadParameterException;
import org.exoplatform.outlook.OutlookEmail;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.OutlookFormatException;
import org.exoplatform.outlook.OutlookMessage;
import org.exoplatform.outlook.OutlookService;
import org.exoplatform.outlook.OutlookSpace;
import org.exoplatform.outlook.OutlookSpaceException;
import org.exoplatform.outlook.OutlookUser;
import org.exoplatform.outlook.forum.ForumUtils;
import org.exoplatform.outlook.jcr.File;
import org.exoplatform.outlook.jcr.Folder;
import org.exoplatform.outlook.jcr.HierarchyNode;
import org.exoplatform.outlook.jcr.NodeFinder;
import org.exoplatform.outlook.jcr.UserDocuments;
import org.exoplatform.outlook.mail.MailAPI;
import org.exoplatform.outlook.mail.MailServerException;
import org.exoplatform.outlook.social.OutlookAttachmentActivity;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Permission;
import org.exoplatform.wiki.mow.api.PermissionEntry;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.resolver.TitleResolver;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.picocontainer.Startable;
import org.xwiki.rendering.syntax.Syntax;

public class OutlookServiceImpl
implements OutlookService,
Startable {
    public static final String MAILSERVER_URL = "mailserver-url";
    protected static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    protected static final String OUTLOOK_MESSAGES_TITLE = "Outlook Messages";
    protected static final String OUTLOOK_MESSAGES_NAME = "outlook-messages";
    protected static final String WIKI_PERMISSION_ANY = "any";
    protected static final String UPLAODS_FOLDER_TITLE = "Uploads";
    protected static final String SPACES_HOME = "/Groups/spaces";
    protected static final String PERSONAL_DOCUMENTS = "Personal Documents";
    protected static final String[] READER_PERMISSION = new String[]{"read"};
    protected static final String[] MANAGER_PERMISSION = new String[]{"read", "remove"};
    protected static final Log LOG = ExoLogger.getLogger(OutlookServiceImpl.class);
    protected static final Random RANDOM = new Random();
    protected static final Transliterator accentsConverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeFinder finder;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final OrganizationService organization;
    protected final ManageDriveService driveService;
    protected final ListenerService listenerService;
    protected final WikiService wikiService;
    protected final ForumService forumService;
    protected final TrashService trashService;
    protected final RenderingService wikiRenderingService;
    protected final ResourceBundleService resourceBundleService;
    protected final PolicyFactory htmlPolicy = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(Sanitizers.IMAGES).and(Sanitizers.LINKS).and(Sanitizers.TABLES).and(new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements(new String[]{"table", "th", "tr", "td"}).allowAttributes(new String[]{"border", "cellpadding", "cellspacing", "width", "height"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"bgcolor", "width", "height", "colspan", "rowspan"}).onElements(new String[]{"td", "tr", "th"}).toFactory()).and(Sanitizers.STYLES);
    protected final PolicyFactory textPolicy = new HtmlPolicyBuilder().toFactory();
    protected final PolicyFactory activityPolicy = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http", "https"}).allowElements(new String[]{"b", "i", "a", "span", "em", "strong", "p", "ol", "ul", "li", "br", "img", "blockquote", "q"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"target"}).matching(true, new String[]{"_blank"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"alt", "src"}).onElements(new String[]{"img"}).toFactory();
    protected final Pattern linkWithTarget = Pattern.compile("<a(?=\\s|>).*?(target=['\"].*?['\"])[^>]*>.*?<\\/a>", 42);
    protected final Pattern linkWithoutTarget = Pattern.compile("<a(?=\\s)(?:(?!target=).)*?([.\\W\\w\\S\\s[^>]])*?(>)", 42);
    protected final ConcurrentHashMap<String, OutlookUser> authenticated = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, OutlookSpaceImpl> spaces = new ConcurrentHashMap();
    protected MailAPI mailserverApi;
    protected String trashHomePath;

    public OutlookServiceImpl(RepositoryService jcrService, SessionProviderService sessionProviders, NodeHierarchyCreator hierarchyCreator, NodeFinder finder, OrganizationService organization, ListenerService listenerService, ManageDriveService driveService, TrashService trashService, WikiService wikiService, ForumService forumService, RenderingService wikiRenderingService, ResourceBundleService resourceBundleService, InitParams params) throws ConfigurationException, MailServerException {
        MailAPI api;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.hierarchyCreator = hierarchyCreator;
        this.finder = finder;
        this.organization = organization;
        this.driveService = driveService;
        this.listenerService = listenerService;
        this.wikiService = wikiService;
        this.forumService = forumService;
        this.trashService = trashService;
        this.wikiRenderingService = wikiRenderingService;
        this.resourceBundleService = resourceBundleService;
        this.mailserverApi = api = new MailAPI();
    }

    @Override
    @Deprecated
    public Folder getFolder(String path) throws OutlookException, RepositoryException {
        Node node = this.node(path);
        UserFolder folder = new UserFolder(path, node);
        return folder;
    }

    @Override
    @Deprecated
    public Folder getFolder(Folder parent, String path) throws OutlookException, RepositoryException {
        Node node = this.node(path);
        return new UserFolder(parent, node);
    }

    @Override
    public List<File> saveAttachment(OutlookSpace space, Folder destFolder, OutlookUser user, String comment, String messageId, String attachmentToken, String ... attachmentIds) throws OutlookException, RepositoryException {
        ArrayList<File> files = new ArrayList<File>();
        Node parent = destFolder.getNode();
        for (String attachmentId : attachmentIds) {
            JsonValue vatt = this.mailserverApi.getAttachment(user, messageId, attachmentToken, attachmentId);
            JsonValue vName = vatt.getElement("Name");
            if (this.isNull(vName)) {
                throw new OutlookFormatException("Attachment doesn't contain Name");
            }
            String name = vName.getStringValue();
            JsonValue vContentType = vatt.getElement("ContentType");
            if (this.isNull(vContentType)) {
                throw new OutlookFormatException("Attachment (" + name + ") doesn't contain ContentType");
            }
            String contentType = vContentType.getStringValue();
            JsonValue vContentBytes = vatt.getElement("ContentBytes");
            if (this.isNull(vContentBytes)) {
                throw new OutlookFormatException("Attachment (" + name + ") doesn't contain ContentBytes");
            }
            String contentBytes = vContentBytes.getStringValue();
            byte[] decoded = Base64.decodeBase64((String)contentBytes);
            try (ByteArrayInputStream contentStream = new ByteArrayInputStream(decoded);){
                Node attachmentNode = this.addFile(parent, name, contentType, contentStream);
                if (space != null) {
                    this.setPermissions(attachmentNode, "member:" + space.getGroupId());
                } else {
                    this.setPermissions(attachmentNode, user.getLocalUser(), "member:/platform/users");
                }
                files.add(new UserFile(destFolder, attachmentNode));
            }
            catch (IOException e) {
                throw new OutlookException("Error saving attachment in a file " + name, e);
            }
        }
        parent.save();
        this.postAttachmentActivity(destFolder, files, user, this.safeText(comment));
        if (space != null) {
            for (File f : files) {
                this.initDocumentLink(space, (HierarchyNode)f);
            }
        }
        return files;
    }

    @Override
    public List<File> saveAttachment(Folder destFolder, OutlookUser user, String comment, String messageId, String attachmentToken, String ... attachmentIds) throws OutlookException, RepositoryException {
        return this.saveAttachment(null, destFolder, user, comment, messageId, attachmentToken, attachmentIds);
    }

    @Override
    public OutlookEmail getAddress(String email, String displayName) throws OutlookException {
        return new OutlookEmail(email, displayName);
    }

    @Override
    public OutlookUser getUser(String email, String displayName, String ewsUrl) throws OutlookException, RepositoryException {
        String exoUsername;
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null && !IdentityConstants.ANONIM.equals(exoUsername = contextState.getIdentity().getUserId())) {
            URI mailServerUrl;
            if (ewsUrl != null) {
                try {
                    URI ewsUri = new URI(ewsUrl);
                    String host = ewsUri.getHost();
                    int port = ewsUri.getPort();
                    String scheme = ewsUri.getScheme();
                    if (port <= 0) {
                        port = "https".equalsIgnoreCase(scheme) ? 443 : 80;
                    }
                    mailServerUrl = new URI(scheme, null, host, port, null, null, null);
                }
                catch (URISyntaxException e) {
                    throw new MailServerException("Error parsing EWS API URL " + ewsUrl, e);
                }
            } else {
                mailServerUrl = null;
            }
            OutlookUser user = this.authenticated.get(exoUsername);
            if (user == null) {
                user = new UserImpl(email, displayName, exoUsername);
                this.authenticated.put(exoUsername, user);
            }
            if (email != null) {
                user.setEmail(email);
            }
            if (mailServerUrl != null) {
                user.setMailServerUrl(mailServerUrl);
            }
            return user;
        }
        return null;
    }

    @Override
    public OutlookMessage buildMessage(String id, OutlookUser user, OutlookEmail from, List<OutlookEmail> to, Calendar created, Calendar modified, String subject, String body) throws OutlookException {
        OutlookMessage message = new OutlookMessage(user);
        message.setId(id);
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setBody(body);
        message.setCreated(created);
        message.setModified(modified);
        return message;
    }

    @Override
    public OutlookMessage getMessage(OutlookUser user, String messageId, String messageToken) throws OutlookException {
        JsonValue vatt = this.mailserverApi.getMessage(user, messageId, messageToken);
        JsonValue vSubject = vatt.getElement("Subject");
        if (this.isNull(vSubject)) {
            throw new OutlookFormatException("Message " + messageId + " doesn't contain Subject");
        }
        String subject = vSubject.getStringValue();
        JsonValue vTo = vatt.getElement("ToRecipients");
        if (this.isNull(vTo)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain ToRecipients");
        }
        if (!vTo.isArray()) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ")'s ToRecipients isn't an array");
        }
        ArrayList<OutlookEmail> to = new ArrayList<OutlookEmail>(vTo.size());
        Iterator toiter = vTo.getElements();
        while (toiter.hasNext()) {
            to.add(this.readEmail((JsonValue)toiter.next()));
        }
        JsonValue vFrom = vatt.getElement("From");
        OutlookEmail from = this.isNull(vFrom) ? null : this.readEmail(vFrom);
        JsonValue vCreatedDateTime = vatt.getElement("CreatedDateTime");
        if (this.isNull(vCreatedDateTime)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain CreatedDateTime");
        }
        Calendar created = Calendar.getInstance();
        try {
            created.setTime(OutlookMessage.DATE_FORMAT.parse(vCreatedDateTime.getStringValue()));
        }
        catch (ParseException e) {
            LOG.error((Object)("Error parsing message date " + vCreatedDateTime.getStringValue()), (Throwable)e);
        }
        JsonValue vLastModifiedDateTime = vatt.getElement("LastModifiedDateTime");
        if (this.isNull(vLastModifiedDateTime)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain LastModifiedDateTime");
        }
        Calendar modified = Calendar.getInstance();
        try {
            modified.setTime(OutlookMessage.DATE_FORMAT.parse(vLastModifiedDateTime.getStringValue()));
        }
        catch (ParseException e) {
            LOG.error((Object)("Error parsing message date " + vCreatedDateTime.getStringValue()), (Throwable)e);
        }
        JsonValue vBody = vatt.getElement("Body");
        if (this.isNull(vBody)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain Body");
        }
        JsonValue vContentType = vBody.getElement("ContentType");
        if (this.isNull(vContentType)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ")'s body doesn't contain ContentType");
        }
        String contentType = vContentType.getStringValue();
        JsonValue vContent = vBody.getElement("Content");
        if (this.isNull(vContent)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ")'s body doesn't contain Content");
        }
        String content = vContent.getStringValue();
        OutlookMessage message = new OutlookMessage(user);
        message.setId(messageId);
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setBody(content);
        message.setType(contentType);
        message.setCreated(created);
        message.setModified(modified);
        return message;
    }

    public void start() {
        try {
            this.trashHomePath = this.trashService.getTrashHomeNode().getPath();
        }
        catch (RepositoryException e) {
            LOG.warn((Object)"Error getting Trash home node", (Throwable)e);
            this.trashHomePath = "/Trash";
        }
        LOG.info((Object)"Outlook service successfuly started");
    }

    public void stop() {
        this.authenticated.clear();
        try {
            this.mailserverApi.close();
            LOG.info((Object)"Outlook service successfuly stopped");
        }
        catch (MailServerException e) {
            LOG.warn((Object)"Outlook service stop encountered with API error", (Throwable)e);
        }
    }

    @Override
    public OutlookSpace getSpace(String groupId) throws OutlookSpaceException, RepositoryException, OutlookException {
        Space socialSpace;
        OutlookSpaceImpl space = this.spaces.get(groupId);
        if (space == null && (socialSpace = this.spaceService().getSpaceByGroupId(groupId)) != null) {
            space = new OutlookSpaceImpl(socialSpace);
            this.spaces.put(socialSpace.getGroupId(), space);
        }
        return space;
    }

    @Override
    public List<OutlookSpace> getUserSpaces() throws OutlookSpaceException {
        return this.userSpaces(this.currentUserId());
    }

    @Override
    public UserDocuments getUserDocuments() throws RepositoryException, OutlookException {
        String userName = this.currentUserId();
        try {
            Node userDocsNode = this.userDocumentsNode(userName);
            PersonalDocumentsFolder folder = new PersonalDocumentsFolder(userDocsNode);
            this.initDocumentLink(folder, (HierarchyNode)folder);
            return folder;
        }
        catch (Exception e) {
            throw new OutlookException("Error reading user's Personal Documents node for " + userName, e);
        }
    }

    void setAPI(MailAPI mockedAPI) {
        this.mailserverApi = mockedAPI;
    }

    protected String nodeTitle(Node node) throws RepositoryException {
        return node.getProperty("exo:title").getString();
    }

    protected Node nodeContent(Node node) throws RepositoryException {
        return node.getNode("jcr:content");
    }

    protected Calendar nodeCreated(Node node) throws RepositoryException {
        return node.getProperty("jcr:created").getDate();
    }

    protected String mimeType(Node content) throws RepositoryException {
        return content.getProperty("jcr:mimeType").getString();
    }

    protected Property data(Node content) throws RepositoryException {
        return content.getProperty("jcr:data");
    }

    protected UUID generateId(String workspace, String path) {
        StringBuilder s = new StringBuilder();
        s.append(workspace);
        s.append(path);
        s.append(System.currentTimeMillis());
        s.append(String.valueOf(RANDOM.nextLong()));
        return UUID.nameUUIDFromBytes(s.toString().getBytes());
    }

    protected User getExoUser(String userName) throws OutlookException {
        try {
            return this.organization.getUserHandler().findUserByName(userName);
        }
        catch (Exception e) {
            throw new OutlookException("Error searching user " + userName, e);
        }
    }

    protected Node node(String nodePath) throws BadParameterException, RepositoryException {
        String path;
        String workspace;
        if (nodePath.startsWith("/")) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            path = nodePath;
        } else {
            int i = nodePath.indexOf(47);
            if (i > 0) {
                workspace = nodePath.substring(0, i);
                path = nodePath.substring(i);
            } else {
                throw new BadParameterException("Invalid path " + nodePath);
            }
        }
        return this.node(workspace, path);
    }

    protected Node node(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(userSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected Node systemNode(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSystemSessionProvider(null);
        Session sysSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(sysSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected boolean checkout(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable")) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            return true;
        }
        return false;
    }

    protected boolean isNull(JsonValue json) {
        return json == null || json.isNull();
    }

    protected boolean isNotNull(JsonValue json) {
        return json != null && !json.isNull();
    }

    protected Locale currentUserLocale() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return context != null ? context.getLocale() : null;
    }

    protected Node addFile(Node parent, String title, String contentType, InputStream content) throws RepositoryException {
        String baseName;
        String name = baseName = OutlookServiceImpl.cleanName(title);
        int siblingNumber = 0;
        try {
            while (true) {
                Node file = parent.getNode(name);
                ++siblingNumber;
                int extIndex = baseName.lastIndexOf(".");
                if (extIndex > 0 && extIndex < title.length()) {
                    String jcrName = baseName.substring(0, extIndex);
                    String jcrExt = baseName.substring(extIndex + 1);
                    name = jcrName + '-' + siblingNumber + '.' + jcrExt;
                    continue;
                }
                name = baseName + '-' + siblingNumber;
            }
        }
        catch (PathNotFoundException e) {
            Node file = parent.addNode(name, "nt:file");
            Node resource = file.addNode("jcr:content", "nt:resource");
            resource.setProperty("jcr:mimeType", contentType != null ? contentType : ContentType.APPLICATION_OCTET_STREAM.getMimeType());
            Calendar fileDate = Calendar.getInstance();
            resource.setProperty("jcr:lastModified", fileDate);
            resource.setProperty("jcr:data", content);
            if (siblingNumber > 0) {
                int extIndex = title.lastIndexOf(".");
                if (extIndex > 0 && extIndex < title.length()) {
                    String titleName = title.substring(0, extIndex);
                    String titleExt = title.substring(extIndex + 1);
                    title = titleName + " (" + siblingNumber + ")." + titleExt;
                } else {
                    title = title + " (" + siblingNumber + ')';
                }
            }
            if (!file.hasProperty("exo:title")) {
                file.addMixin("exo:rss-enable");
            }
            file.setProperty("exo:title", title);
            try {
                file.setProperty("exo:name", title);
            }
            catch (ValueFormatException | ConstraintViolationException e2) {
                LOG.warn((Object)("Cannot set exo:name property to '" + title + "' for file " + file.getPath() + ": " + e2));
            }
            if (file.isNodeType("exo:datetime")) {
                file.setProperty("exo:dateCreated", fileDate);
                file.setProperty("exo:dateModified", fileDate);
            }
            if (file.isNodeType("exo:modify")) {
                file.setProperty("exo:lastModifiedDate", fileDate);
                file.setProperty("exo:lastModifier", file.getSession().getUserID());
            }
            if (!file.isNodeType("mix:referenceable")) {
                file.addMixin("mix:referenceable");
            }
            if (!file.isNodeType("mix:commentable")) {
                file.addMixin("mix:commentable");
            }
            if (!file.isNodeType("mix:votable")) {
                file.addMixin("mix:votable");
            }
            if (!file.isNodeType("mix:i18n")) {
                file.addMixin("mix:i18n");
            }
            return file;
        }
    }

    protected Node addFolder(Node parent, String title, boolean forceNew) throws RepositoryException {
        Node folder;
        String baseName;
        String name = baseName = OutlookServiceImpl.cleanName(title);
        int siblingNumber = 0;
        try {
            while (true) {
                folder = parent.getNode(name);
                if (forceNew) {
                    ++siblingNumber;
                    int extIndex = baseName.lastIndexOf(".");
                    if (extIndex > 0 && extIndex < title.length()) {
                        String jcrName = baseName.substring(0, extIndex);
                        String jcrExt = baseName.substring(extIndex + 1);
                        name = jcrName + '-' + siblingNumber + '.' + jcrExt;
                        continue;
                    }
                    name = baseName + '-' + siblingNumber;
                    continue;
                }
                break;
            }
        }
        catch (PathNotFoundException e) {
            folder = parent.addNode(name, "nt:folder");
        }
        if (folder.isNew()) {
            if (siblingNumber > 0) {
                int extIndex = title.lastIndexOf(".");
                if (extIndex > 0 && extIndex < title.length()) {
                    String titleName = title.substring(0, extIndex);
                    String titleExt = title.substring(extIndex + 1);
                    title = titleName + " (" + siblingNumber + ")." + titleExt;
                } else {
                    title = title + " (" + siblingNumber + ')';
                }
            }
            folder.setProperty("exo:title", title);
            try {
                folder.setProperty("exo:name", title);
            }
            catch (ValueFormatException | ConstraintViolationException e) {
                LOG.warn((Object)("Cannot set exo:name property to '" + title + "' for folder " + folder.getPath() + ": " + e));
            }
            Calendar folderDate = Calendar.getInstance();
            if (folder.isNodeType("exo:datetime")) {
                folder.setProperty("exo:dateCreated", folderDate);
                folder.setProperty("exo:dateModified", folderDate);
            }
            if (folder.isNodeType("exo:modify")) {
                folder.setProperty("exo:lastModifiedDate", folderDate);
                folder.setProperty("exo:lastModifier", folder.getSession().getUserID());
            }
        }
        return folder;
    }

    protected String currentUserId() {
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null) {
            return contextState.getIdentity().getUserId();
        }
        return IdentityConstants.ANONIM;
    }

    protected SpaceService spaceService() {
        return (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    protected IdentityManager socialIdentityManager() {
        return (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    protected ActivityManager socialActivityManager() {
        return (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    protected List<OutlookSpace> userSpaces(String userId) throws OutlookSpaceException {
        ArrayList<OutlookSpace> spaces = new ArrayList<OutlookSpace>();
        ListAccess list = this.spaceService().getMemberSpaces(userId);
        try {
            for (Space socialSpace : (Space[])list.load(0, list.getSize())) {
                spaces.add(new OutlookSpaceImpl(socialSpace));
            }
            return spaces;
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error loading user spaces", e);
            }
            throw new OutlookSpaceException("Error loading user spaces", e);
        }
    }

    protected String groupDocsPath(String groupId) {
        return "/Groups${groupId}/Documents".replace("${groupId}", groupId);
    }

    protected String userDocsPath(String userId) {
        return "/Users/${userId}/Private".replace("${userId}", userId) + "/Documents";
    }

    protected String groupPath(String groupId) throws Exception {
        String groupsPath = this.hierarchyCreator.getJcrPath("groupsPath");
        return groupsPath + groupId;
    }

    protected void initWebDAVLink(HierarchyNode node) throws OutlookException {
        try {
            node.setWebdavUrl(Utils.getWebdavURL((Node)node.getNode(), (boolean)false, (boolean)true));
        }
        catch (Exception e) {
            throw new OutlookException("Error generating WebDav URL for node " + node.getFullPath(), e);
        }
    }

    protected void initDocumentLink(SiteType siteType, String driveName, String portalName, String nodeURI, HierarchyNode node) throws OutlookException {
        this.initWebDAVLink(node);
        String npath = node.getPath().replaceAll("/+", "/");
        String path = driveName + npath;
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        if (portalRequest != null) {
            NodeURL nodeURL = (NodeURL)portalRequest.createURL(NodeURL.TYPE);
            NavigationResource resource = new NavigationResource(siteType, portalName, nodeURI);
            nodeURL.setResource(resource);
            nodeURL.setQueryParameterValue("path", path);
            HttpServletRequest request = portalRequest.getRequest();
            try {
                URI requestUri = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), null, null, null);
                StringBuilder url = new StringBuilder();
                url.append(requestUri.toASCIIString());
                url.append(nodeURL.toString());
                node.setUrl(url.toString());
            }
            catch (URISyntaxException e) {
                throw new OutlookException("Error creating server URL " + request.getRequestURI().toString(), e);
            }
        } else {
            LOG.warn((Object)("Portal request not found. Node URL will be its WebDAV link. Node: " + node.getPath()));
            node.setUrl(node.getWebdavUrl());
        }
    }

    protected void initDocumentLink(OutlookSpace space, HierarchyNode file) throws OutlookException {
        this.initWebDAVLink(file);
        this.initDocumentLink(SiteType.GROUP, space.getGroupId().replace("/", "."), space.getGroupId(), space.getShortName() + "/documents", file);
    }

    protected void initDocumentLink(PersonalDocumentsFolder personalDocuments, HierarchyNode file) throws OutlookException {
        this.initWebDAVLink(file);
        this.initDocumentLink(SiteType.PORTAL, personalDocuments.getDriveName(), "intranet", "documents", file);
    }

    protected Node userDocumentsNode(String userName) throws Exception {
        for (DriveData userDrive : this.driveService.getPersonalDrives(userName)) {
            String homePath = userDrive.getHomePath();
            if (!homePath.endsWith("/Private")) continue;
            String driveRootPath = org.exoplatform.services.cms.impl.Utils.getPersonalDrivePath((String)homePath, (String)userName);
            return this.node(driveRootPath);
        }
        return null;
    }

    protected Node spaceDocumentsNode(String groupId) throws Exception {
        return this.node(this.groupDocsPath(groupId));
    }

    protected void setPermissions(Node node, String ... identities) throws AccessControlException, RepositoryException {
        this.setPermissions(node, true, false, identities);
    }

    protected void setPermissions(Node node, boolean deep, boolean forcePrivilegeable, String ... identities) throws AccessControlException, RepositoryException {
        ExtendedNode target = (ExtendedNode)node;
        boolean setPermissions = true;
        if (target.canAddMixin(EXO_PRIVILEGEABLE)) {
            if (forcePrivilegeable) {
                target.addMixin(EXO_PRIVILEGEABLE);
            } else {
                setPermissions = false;
            }
        }
        if (setPermissions) {
            for (String identity : identities) {
                String[] ids = identity.split(":");
                if (ids.length == 2) {
                    String managerMembership;
                    try {
                        MembershipType managerType = this.organization.getMembershipTypeHandler().findMembershipType("manager");
                        managerMembership = managerType.getName();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error finding manager membership in organization service. Will use any (*) to allow remove shared cloud file link", (Throwable)e);
                        managerMembership = "*";
                    }
                    target.setPermission(managerMembership + ':' + ids[1], MANAGER_PERMISSION);
                    target.setPermission(identity, READER_PERMISSION);
                    continue;
                }
                target.setPermission(identity, MANAGER_PERMISSION);
            }
        }
        if (deep) {
            NodeIterator niter = target.getNodes();
            while (niter.hasNext()) {
                Node child = niter.nextNode();
                this.setPermissions(child, true, false, identities);
            }
        }
    }

    protected Node messagesFolder(Node parent, String ... identity) throws RepositoryException {
        Node messagesFolder;
        if (!parent.hasNode(OUTLOOK_MESSAGES_NAME)) {
            messagesFolder = parent.addNode(OUTLOOK_MESSAGES_NAME, "nt:folder");
            messagesFolder.setProperty("exo:title", OUTLOOK_MESSAGES_TITLE);
            try {
                messagesFolder.setProperty("exo:name", OUTLOOK_MESSAGES_TITLE);
            }
            catch (ValueFormatException | ConstraintViolationException e) {
                LOG.warn((Object)("Cannot set exo:name property for folder " + messagesFolder.getPath() + ": " + e));
            }
            if (identity != null) {
                this.setPermissions(messagesFolder, identity);
            }
            parent.save();
        } else {
            messagesFolder = parent.getNode(OUTLOOK_MESSAGES_NAME);
        }
        return messagesFolder;
    }

    protected Node addMessageFile(Node parent, OutlookMessage message) throws RepositoryException, UnsupportedEncodingException, IOException {
        String safeTitle = this.safeText(message.getSubject());
        String safeContent = this.safeHtml(message.getBody());
        try (ByteArrayInputStream content = new ByteArrayInputStream(safeContent.getBytes("UTF-8"));){
            Node messageFile = this.addFile(parent, safeTitle, "text/html", content);
            messageFile.addMixin("mso:message");
            messageFile.setProperty("mso:userEmail", message.getUser().getEmail());
            messageFile.setProperty("mso:userName", message.getUser().getDisplayName());
            messageFile.setProperty("mso:fromEmail", message.getFrom().getEmail());
            messageFile.setProperty("mso:fromName", message.getFrom().getDisplayName());
            messageFile.setProperty("mso:created", message.getCreated());
            messageFile.setProperty("mso:modified", message.getModified());
            messageFile.setProperty("mso:messageId", message.getId());
            Node node = messageFile;
            return node;
        }
    }

    protected ExoSocialActivity postAttachmentActivity(Folder destFolder, List<File> files, OutlookUser user, String comment) throws RepositoryException {
        String author = user.getLocalUser();
        LinkedHashMap<String, String> activityParams = new LinkedHashMap<String, String>();
        StringBuilder filesLine = new StringBuilder();
        for (File f : files) {
            if (filesLine.length() > 0) {
                filesLine.append(',');
            }
            filesLine.append(OutlookAttachmentActivity.attachmentString(f.getNode().getUUID(), f.getTitle()));
        }
        activityParams.put("files", filesLine.toString());
        activityParams.put("workspace", destFolder.getNode().getSession().getWorkspace().getName());
        activityParams.put("comment", comment);
        activityParams.put("author", author);
        Calendar activityDate = Calendar.getInstance();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String dateString = dateFormatter.format(activityDate.getTime());
        activityParams.put("dateCreated", dateString);
        activityParams.put("lastModified", dateString);
        IdentityManager identityManager = this.socialIdentityManager();
        Identity authorIdentity = identityManager.getOrCreateIdentity("organization", author, true);
        String title = comment != null && comment.length() > 0 ? comment : "User " + author + " has saved " + files.size() + (files.size() > 1 ? " files" : " file");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(authorIdentity.getId(), "outlook:attachment", title, null);
        activity.setTemplateParams(activityParams);
        ActivityManager activityManager = this.socialActivityManager();
        String spaceGroupName = OutlookServiceImpl.getSpaceName(destFolder.getNode());
        Space space = this.spaceService().getSpaceByGroupId("/spaces/" + spaceGroupName);
        if (spaceGroupName != null && spaceGroupName.length() > 0 && space != null) {
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName(), true);
            activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        } else {
            activityManager.saveActivityNoReturn(authorIdentity, (ExoSocialActivity)activity);
        }
        activity = activityManager.getActivity(activity.getId());
        return activity;
    }

    protected OutlookEmail readEmail(JsonValue vElem) throws OutlookException {
        JsonValue vEmailAddress = vElem.getElement("EmailAddress");
        if (this.isNull(vEmailAddress)) {
            throw new OutlookFormatException("Element doesn't contain EmailAddress");
        }
        JsonValue vAddress = vEmailAddress.getElement("Address");
        if (this.isNull(vAddress)) {
            throw new OutlookFormatException("Element doesn't contain Address");
        }
        String email = vAddress.getStringValue();
        JsonValue vName = vEmailAddress.getElement("Name");
        String name = this.isNull(vName) ? "".intern() : vName.getStringValue();
        return this.getAddress(email, name);
    }

    protected void fetchQuery(QueryResult qr, int limit, Set<File> res) throws RepositoryException, OutlookException {
        SpaceService spaceService = this.spaceService();
        NodeIterator niter = qr.getNodes();
        while (niter.getPosition() < (long)limit && niter.hasNext()) {
            Node node = niter.nextNode();
            String path = node.getPath();
            if (path.indexOf("/ApplicationData") < 0 && path.indexOf("exo:applications") < 0) {
                Space space;
                block15: {
                    block14: {
                        try {
                            AccessControlList acl = ((ExtendedNode)node).getACL();
                            String owner = acl.getOwner();
                            if ("root".equals(owner)) {
                                ++limit;
                                continue;
                            }
                        }
                        catch (RepositoryException e) {
                            if (!LOG.isDebugEnabled()) break block14;
                            LOG.debug((Object)"Error getting node ACL/owner", (Throwable)e);
                        }
                    }
                    if (org.exoplatform.ecm.webui.utils.Utils.isInTrash((Node)node)) {
                        ++limit;
                        continue;
                    }
                    if (path.startsWith(SPACES_HOME)) {
                        try {
                            String groupId = path.substring(7, path.indexOf("/", SPACES_HOME.length() + 1));
                            space = spaceService.getSpaceByGroupId(groupId);
                            if (space == null) break block15;
                            HashSet<String> allMemembers = new HashSet<String>();
                            for (String s : space.getManagers()) {
                                allMemembers.add(s);
                            }
                            for (String s : space.getMembers()) {
                                allMemembers.add(s);
                            }
                            if (!allMemembers.contains(this.currentUserId())) {
                                ++limit;
                                continue;
                            }
                            break block15;
                        }
                        catch (IndexOutOfBoundsException e) {
                            space = null;
                            break block15;
                        }
                    }
                    space = null;
                }
                UserFile file = new UserFile(node.getParent().getPath(), node);
                if (space != null) {
                    this.initDocumentLink(SiteType.GROUP, space.getGroupId().replace("/", "."), space.getGroupId(), space.getShortName() + "/documents", file);
                } else {
                    this.initDocumentLink(SiteType.PORTAL, PERSONAL_DOCUMENTS, "intranet", "documents", file);
                }
                res.add(file);
                continue;
            }
            ++limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Page createWikiPage(String wikiType, String wikiOwner, String creator, String title, String summary, String content, List<String> users) throws Exception {
        String parentTitle = OUTLOOK_MESSAGES_TITLE;
        String parentId = TitleResolver.getId((String)OUTLOOK_MESSAGES_TITLE, (boolean)false);
        String defaultSyntax = this.wikiService.getDefaultWikiSyntaxId();
        String xhtmlSyntax = Syntax.XHTML_1_0.toIdString();
        WikiService wikiService = this.wikiService;
        synchronized (wikiService) {
            Wiki wiki;
            Page parentPage = this.wikiService.getPageOfWikiByName(wikiType, wikiOwner, parentId);
            if (parentPage == null) {
                parentPage = new Page();
                parentPage.setTitle(OUTLOOK_MESSAGES_TITLE);
                parentPage.setContent("= Outlook Messages =\n");
                parentPage.setSyntax(defaultSyntax);
                wiki = this.wikiService.getWikiByTypeAndOwner(wikiType, wikiOwner);
                if (wiki == null) {
                    wiki = this.wikiService.createWiki(wikiType, wikiOwner);
                }
                Page wikiHome = wiki.getWikiHome();
                this.setPermissionForWikiPage(Collections.emptyList(), parentPage, wikiHome);
                List permissions = parentPage.getPermissions();
                permissions.add(new PermissionEntry(WIKI_PERMISSION_ANY, "", IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true)}));
                parentPage.setPermissions(permissions);
                Wiki pwiki = new Wiki();
                pwiki.setOwner(wikiOwner);
                pwiki.setType(wikiType);
                parentPage = this.wikiService.createPage(pwiki, "WikiHome", parentPage);
            }
            wiki = new Wiki();
            wiki.setOwner(wikiOwner);
            wiki.setType(wikiType);
            Page page = new Page();
            if (this.isHTML(content) && !defaultSyntax.equals(xhtmlSyntax)) {
                String xwikiMarkup;
                page.setSyntax(defaultSyntax);
                StringBuilder quotedContent = new StringBuilder();
                if (summary != null) {
                    quotedContent.append("(% style='word-wrap: break-word; min-height: 30px;' %)(((\r");
                    xwikiMarkup = this.wikiRenderingService.render(summary, xhtmlSyntax, defaultSyntax, false);
                    quotedContent.append(xwikiMarkup);
                    quotedContent.append("\r)))\r");
                }
                quotedContent.append("|=(% style='background-color: #999999; border-style: hidden;' %)");
                quotedContent.append("|=(% style='background-color: inherit; border-style: hidden;' %)");
                quotedContent.append("|=(% style='background-color: inherit; border-style: hidden;' %)\r");
                quotedContent.append("|(% style='background-color: #999999; border-style: hidden;' %) ");
                quotedContent.append("|(% style='border-style: hidden;' %) ");
                quotedContent.append("|(% style='border-style: hidden;' %) (((\r");
                xwikiMarkup = this.wikiRenderingService.render(this.safeHtml(content), xhtmlSyntax, defaultSyntax, false);
                quotedContent.append(xwikiMarkup);
                quotedContent.append("\r)))\r");
                page.setContent(quotedContent.toString());
            } else {
                page.setSyntax(defaultSyntax);
                page.setContent(content);
            }
            this.setPermissionForWikiPage(users, page, parentPage);
            page.setOwner(creator);
            page.setAuthor(creator);
            page.setMinorEdit(false);
            String baseTitle = title = this.safeText(title);
            int siblingNumber = 0;
            while (true) {
                String pageId = TitleResolver.getId((String)title, (boolean)false);
                page.setTitle(title);
                String path = "";
                if (wikiType.equals(PortalConfig.GROUP_TYPE)) {
                    path = "/portal/intranet/wiki/" + wikiType + wikiOwner + "/" + pageId;
                } else if (wikiType.equals(PortalConfig.PORTAL_TYPE)) {
                    path = "/portal/intranet/wiki/" + pageId;
                }
                page.setUrl(path);
                if (!this.wikiService.isExisting(wikiType, wikiOwner, pageId)) {
                    try {
                        page = this.wikiService.createPage(wiki, parentId, page);
                        break;
                    }
                    catch (WikiException e) {
                        LOG.warn((Object)("Error creating wiki page " + title + " (" + pageId + "). " + e.getMessage()));
                        try {
                            this.wikiService.getPageById(pageId);
                        }
                        catch (WikiException ge) {
                            throw e;
                        }
                    }
                }
                title = baseTitle + " (" + ++siblingNumber + ')';
            }
            return page;
        }
    }

    protected String messageSummary(OutlookMessage message) {
        String fromEmail = message.getFrom().getEmail();
        String fromName = message.getFrom().getDisplayName();
        Date time = message.getCreated().getTime();
        Locale locale = Locale.ENGLISH;
        ResourceBundle res = this.resourceBundleService.getResourceBundle("locale.outlook.Outlook", locale);
        DateFormat dateFormat = DateFormat.getDateInstance(0, locale);
        DateFormat timeFormat = DateFormat.getTimeInstance(3, locale);
        StringBuilder fromLine = new StringBuilder();
        fromLine.append(fromName);
        fromLine.append('<');
        fromLine.append(fromEmail);
        fromLine.append('>');
        StringBuilder summary = new StringBuilder();
        summary.append(res.getString("Outlook.activity.from"));
        summary.append(": <a href='mailto:");
        summary.append(fromEmail);
        summary.append("' target='_top'>");
        summary.append(ContentReader.simpleEscapeHtml((String)fromLine.toString()));
        summary.append("</a> ");
        summary.append(res.getString("Outlook.activity.on"));
        summary.append(' ');
        summary.append(dateFormat.format(time));
        summary.append(' ');
        summary.append(res.getString("Outlook.activity.at"));
        summary.append(' ');
        summary.append(timeFormat.format(time));
        return summary.toString();
    }

    protected boolean isHTML(String content) {
        int istart = content.indexOf("<html");
        int iend = content.indexOf("</html>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<body");
        iend = content.indexOf("</body>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<div");
        iend = content.indexOf("</div>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<table");
        iend = content.indexOf("</table>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<style");
        iend = content.indexOf("</style>");
        return istart >= 0 && iend > 0 && istart < iend;
    }

    protected String safeHtml(String content) {
        String safe = this.htmlPolicy.sanitize(content);
        safe = this.makeLinksOpenNewWindow(safe);
        return safe;
    }

    protected String safeText(String content) {
        String safe = this.textPolicy.sanitize(content);
        safe = this.makeLinksOpenNewWindow(safe);
        safe = StringEscapeUtils.unescapeHtml((String)safe);
        return safe;
    }

    protected String safeActivityMessage(String text) {
        String safe = this.activityPolicy.sanitize(text);
        safe = this.makeLinksOpenNewWindow(safe);
        safe = StringEscapeUtils.unescapeHtml((String)safe);
        return safe;
    }

    protected String makeLinksOpenNewWindow(String text) {
        int end;
        int start;
        Matcher m = this.linkWithTarget.matcher(text);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (m.find()) {
            start = m.start(1);
            end = m.end(1);
            if (start >= 0 && end >= 0) {
                sb.append(text.substring(pos, start));
                sb.append("target=\"_blank\"");
                pos = end;
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Cannot find link target group in " + m.group(1)));
        }
        if (pos < text.length()) {
            sb.append(text.substring(pos));
        }
        text = sb.toString();
        m = this.linkWithoutTarget.matcher(text);
        sb = new StringBuilder();
        pos = 0;
        while (m.find()) {
            start = m.start(2);
            end = m.end(2);
            if (start >= 0 && end >= 0) {
                sb.append(text.substring(pos, start));
                sb.append(" target=\"_blank\"");
                sb.append(text.substring(start, end));
                pos = end;
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Cannot find link end group in " + m.group(2)));
        }
        if (pos < text.length()) {
            sb.append(text.substring(pos));
        }
        return sb.toString();
    }

    protected void setPermissionForWikiPage(List<String> users, Page page, Page parentPage) {
        Permission[] allPermissions = new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true)};
        List permissions = parentPage.getPermissions();
        if (permissions != null) {
            int i;
            int anyIndex = -1;
            for (i = 0; i < permissions.size(); ++i) {
                PermissionEntry any = (PermissionEntry)permissions.get(i);
                if (!WIKI_PERMISSION_ANY.equals(any.getId())) continue;
                anyIndex = i;
            }
            if (anyIndex > -1) {
                permissions.remove(anyIndex);
            }
            for (i = 0; i < users.size(); ++i) {
                String strUser = users.get(i).toString();
                PermissionEntry userPermission = new PermissionEntry(strUser, strUser, IDType.USER, allPermissions);
                permissions.add(userPermission);
            }
            page.setPermissions(permissions);
        }
    }

    protected Topic createForumTopic(String categoryId, String forumId, String creator, String title, String summary, String content) throws Exception {
        UserProfile userProfile = this.forumService.getUserSettingProfile(creator);
        if (this.checkForumHasAddTopic(userProfile, categoryId, forumId)) {
            Topic topic = new Topic();
            String message = this.isHTML(content) ? this.safeHtml(content) : content;
            String safeTitle = this.safeText(title);
            if (safeTitle.length() <= 0 || safeTitle.equals("null")) {
                safeTitle = summary != null ? this.safeText(summary) : this.safeText(message.substring(0, 95) + "...");
            }
            if (safeTitle.length() > 100) {
                safeTitle = safeTitle.substring(0, 97) + "...";
            }
            String checksms = TransformHTML.cleanHtmlCode((String)message, new ArrayList(new ExtendedBBCodeProvider().getSupportedBBCodes()));
            int t = (checksms = checksms.replaceAll("&nbsp;", " ")).trim().length();
            if (t <= 0 || !checksms.equals("null")) {
                // empty if block
            }
            Date currentDate = CommonUtils.getGreenwichMeanTime().getTime();
            message = CommonUtils.encodeSpecialCharInSearchTerm((String)message);
            message = TransformHTML.fixAddBBcodeAction((String)message);
            boolean isOffend = false;
            ForumAdministration forumAdministration = this.forumService.getForumAdministration();
            String[] censoredKeyword = ForumUtils.getCensoredKeyword(forumAdministration.getCensoredKeyword());
            checksms = checksms.toLowerCase();
            for (String string : censoredKeyword) {
                if (checksms.indexOf(string.trim()) >= 0) {
                    isOffend = true;
                    break;
                }
                if (safeTitle.toLowerCase().indexOf(string.trim()) < 0) continue;
                isOffend = true;
                break;
            }
            boolean topicClosed = false;
            boolean topicLocked = false;
            boolean sticky = false;
            boolean moderatePost = true;
            boolean whenNewPost = true;
            String canPost = ForumUtils.EMPTY_STR;
            String canView = ForumUtils.EMPTY_STR;
            String link = BuildLinkUtils.buildLink((String)forumId, (String)topic.getId(), (BuildLinkUtils.PORTLET_INFO)BuildLinkUtils.PORTLET_INFO.FORUM);
            safeTitle = CommonUtils.encodeSpecialCharInTitle((String)safeTitle);
            topic.setTopicName(safeTitle);
            topic.setModifiedBy(creator);
            topic.setModifiedDate(currentDate);
            if (summary != null) {
                StringBuilder topicContent = new StringBuilder();
                if (summary != null) {
                    topicContent.append("<div class='messageSummary' style='word-wrap: break-word; min-height: 30px;'>");
                    topicContent.append(summary);
                    topicContent.append("</div>");
                }
                topicContent.append("<div class='messageQuote' style='overflow:auto;'><div class='messageContent' style='position: relative; float: left;box-sizing: border-box; padding-left: 7px; min-width: 100%; max-height: 100%;border-width: 0px 0px 0px 12px; border-style: solid; border-color: #999999; background-color: white;'>");
                topicContent.append(message);
                topicContent.append("</div></div>");
                message = topicContent.toString();
            }
            topic.setDescription(message);
            topic.setLink(link);
            if (whenNewPost) {
                String email = userProfile.getEmail();
                if (email == null || email.length() <= 0) {
                    try {
                        email = this.organization.getUserHandler().findUserByName(creator).getEmail();
                    }
                    catch (Exception e) {
                        email = "true";
                    }
                }
                topic.setIsNotifyWhenAddPost(email);
            } else {
                topic.setIsNotifyWhenAddPost(ForumUtils.EMPTY_STR);
            }
            topic.setIsWaiting(isOffend);
            topic.setIsClosed(topicClosed);
            topic.setIsLock(topicLocked);
            topic.setIsModeratePost(moderatePost);
            topic.setIsSticky(sticky);
            topic.setIcon("uiIconForumTopic uiIconForumLightGray");
            String[] canPosts = ForumUtils.splitForForum(canPost);
            String[] canViews = ForumUtils.splitForForum(canView);
            topic.setCanView(canViews);
            topic.setCanPost(canPosts);
            topic.setIsApproved(true);
            MessageBuilder messageBuilder = new MessageBuilder();
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = this.resourceBundleService.getResourceBundle("locale.portlet.forum.ForumPortlet", context.getLocale());
            if (res != null) {
                try {
                    messageBuilder.setContent(res.getString("UINotificationForm.label.notifyEmailContentDefault"));
                    String header = res.getString("UINotificationForm.label.notifyEmailHeaderSubjectDefault");
                    messageBuilder.setHeaderSubject(header == null || header.trim().length() == 0 ? ForumUtils.EMPTY_STR : header);
                    messageBuilder.setTypes(res.getString("UIForumPortlet.label.category"), res.getString("UIForumPortlet.label.forum"), res.getString("UIForumPortlet.label.topic"), res.getString("UIForumPortlet.label.post"));
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Failed to get resource bundle for Forum default content email notification", (Throwable)e);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Locale resource bundle cannot be found for Forum default content email notification");
            }
            messageBuilder.setLink(link);
            topic.setOwner(creator);
            topic.setCreatedDate(currentDate);
            topic.setLastPostBy(creator);
            topic.setLastPostDate(currentDate);
            topic.setVoteRating(Double.valueOf(0.0));
            topic.setUserVoteRating(new String[0]);
            try {
                String remoteAddr = ForumUtils.EMPTY_STR;
                remoteAddr = WebUIUtils.getRemoteIP();
                topic.setRemoteAddr(remoteAddr);
                this.forumService.saveTopic(categoryId, forumId, topic, true, false, messageBuilder);
                if (userProfile.getIsAutoWatchMyTopics()) {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(userProfile.getEmail());
                    String path = categoryId + ForumUtils.SLASH + forumId + ForumUtils.SLASH + topic.getId();
                    this.forumService.addWatch(1, path, values, creator);
                }
            }
            catch (PathNotFoundException e) {
                throw new OutlookException("Error saving forum topic '" + title + "'", e);
            }
            return topic;
        }
        throw new BadParameterException("Cannot add forum topic. Check user permissions or forum settings.");
    }

    protected boolean checkForumHasAddTopic(UserProfile userProfile, String categoryId, String forumId) throws Exception {
        if (userProfile.getUserRole() == 3L || userProfile.getIsBanned() || userProfile.isDisabled()) {
            return false;
        }
        try {
            String[] morderators;
            Category cate = this.forumService.getCategory(categoryId);
            Forum forum = this.forumService.getForum(categoryId, forumId);
            if (forum == null) {
                return false;
            }
            if (forum.getIsClosed() || forum.getIsLock()) {
                return false;
            }
            if (userProfile.getUserRole() == 0L) {
                return true;
            }
            if (userProfile.getUserRole() == 1L && ForumServiceUtils.isModerator((String[])(morderators = ForumUtils.arraysMerge(cate.getModerators(), forum.getModerators())), (String)userProfile.getUserId())) {
                return true;
            }
            if (!ForumServiceUtils.hasPermission((String[])cate.getUserPrivate(), (String)userProfile.getUserId())) {
                return false;
            }
            String[] canCreadTopic = ForumUtils.arraysMerge(forum.getCreateTopicRole(), cate.getCreateTopicRole());
            if (!ForumServiceUtils.hasPermission((String[])canCreadTopic, (String)userProfile.getUserId())) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Check permission to add topic of category %s, forum %s unsuccessfully.", categoryId, forumId));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return false;
        }
        return true;
    }

    private static String getSpaceName(Node node) throws RepositoryException {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        String spacesFolder = groupPath + "/spaces/";
        String spaceName = "";
        String nodePath = node.getPath();
        if (nodePath.startsWith(spacesFolder)) {
            spaceName = nodePath.substring(spacesFolder.length());
            spaceName = spaceName.substring(0, spaceName.indexOf("/"));
        }
        return spaceName;
    }

    public static String cleanName(String name) {
        String str = accentsConverter.transliterate(name.trim());
        StringBuilder cleanedStr = new StringBuilder(str.trim());
        if (cleanedStr.length() == 1) {
            char c = cleanedStr.charAt(0);
            if (c == '.' || c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                cleanedStr.deleteCharAt(0);
                cleanedStr.append('_');
                cleanedStr.append(Integer.toHexString(c).toUpperCase());
            }
        } else {
            for (int i = 0; i < cleanedStr.length(); ++i) {
                char c = cleanedStr.charAt(i);
                if (c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                    cleanedStr.deleteCharAt(i);
                    cleanedStr.insert(i, '_');
                    continue;
                }
                if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '.' || c == '-' || c == '_') continue;
                cleanedStr.deleteCharAt(i--);
            }
        }
        return cleanedStr.toString().trim();
    }

    protected class OutlookSpaceImpl
    extends OutlookSpace {
        protected final String rootPath;
        protected final ThreadLocal<RootFolder> rootFolder;
        protected final IdentityManager socialIdentityManager;
        protected final ActivityManager socialActivityManager;

        protected OutlookSpaceImpl(Space socialSpace) throws RepositoryException, OutlookException {
            super(socialSpace.getGroupId(), socialSpace.getDisplayName(), socialSpace.getShortName(), socialSpace.getPrettyName());
            this.rootFolder = new ThreadLocal();
            this.rootPath = OutlookServiceImpl.this.groupDocsPath(this.groupId);
            this.socialIdentityManager = OutlookServiceImpl.this.socialIdentityManager();
            this.socialActivityManager = OutlookServiceImpl.this.socialActivityManager();
        }

        @Override
        public Folder getFolder(String path) throws OutlookException, RepositoryException {
            Folder folder;
            Folder parent = this.getRootFolder();
            String folderPath = HierarchyNode.getPath(path);
            if (this.rootPath.equals(folderPath)) {
                folder = parent;
            } else if (folderPath.startsWith(this.rootPath)) {
                folder = new SpaceFolder(parent, OutlookServiceImpl.this.node(folderPath));
            } else {
                throw new BadParameterException("Path does not belong to space documents: " + path);
            }
            OutlookServiceImpl.this.initDocumentLink(this, (HierarchyNode)folder);
            return folder;
        }

        @Override
        public Folder getRootFolder() throws OutlookException, RepositoryException {
            RootFolder root = this.rootFolder.get();
            if (root != null) {
                try {
                    root.getNode().getIndex();
                    return root;
                }
                catch (InvalidItemStateException invalidItemStateException) {
                    // empty catch block
                }
            }
            root = new RootFolder(this.rootPath, OutlookServiceImpl.this.node(this.rootPath));
            this.rootFolder.set(root);
            return root;
        }

        @Override
        public Collection<File> findLastDocuments(String text) throws RepositoryException, OutlookException {
            Folder root = this.getRootFolder();
            QueryManager qm = root.getNode().getSession().getWorkspace().getQueryManager();
            LinkedHashSet<File> res = new LinkedHashSet<File>();
            if (text == null || text.length() == 0) {
                Query qOwn = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' AND jcr:path LIKE '" + root.getPath() + "/%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOwn.execute(), 3, res);
                Query qOthers = qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + root.getPath() + "/%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOthers.execute(), 17, res);
            } else {
                Query qOwn = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' AND jcr:path LIKE '" + root.getPath() + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOwn.execute(), 3, res);
                Query qOthers = qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + root.getPath() + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOthers.execute(), 17, res);
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExoSocialActivity postActivity(OutlookMessage message) throws Exception {
            Node spaceDocs = OutlookServiceImpl.this.spaceDocumentsNode(this.groupId);
            Node messagesFolder = OutlookServiceImpl.this.messagesFolder(spaceDocs, this.groupId);
            Node messageFile = OutlookServiceImpl.this.addMessageFile(messagesFolder, message);
            OutlookServiceImpl.this.setPermissions(messageFile, "member:" + this.groupId);
            messagesFolder.save();
            message.setFileNode(messageFile);
            String origType = org.exoplatform.wcm.ext.component.activity.listener.Utils.getActivityType();
            try {
                org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)"outlook:message");
                ExoSocialActivity activity = org.exoplatform.wcm.ext.component.activity.listener.Utils.postFileActivity((Node)messageFile, (String)"SocialIntegration.messages.createdBy", (boolean)true, (boolean)false, (String)"", (String)"");
                activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
                ExoSocialActivity exoSocialActivity = activity;
                return exoSocialActivity;
            }
            finally {
                org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)origType);
            }
        }

        @Override
        public ExoSocialActivity postActivity(OutlookUser user, String title, String body) throws Exception {
            Identity spaceIdentity = this.socialIdentityManager.getOrCreateIdentity("space", this.prettyName, true);
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeTitle = OutlookServiceImpl.this.safeText(title);
            String safeBody = OutlookServiceImpl.this.safeHtml(body);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "exosocial:spaces", safeTitle, safeBody);
            this.socialActivityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        @Override
        public ExoSocialActivity postActivity(OutlookUser user, String text) throws Exception {
            Identity spaceIdentity = this.socialIdentityManager.getOrCreateIdentity("space", this.prettyName, true);
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeText = OutlookServiceImpl.this.safeActivityMessage(text);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "exosocial:spaces", safeText, null);
            activity.setType("DEFAULT_ACTIVITY");
            this.socialActivityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        @Override
        public Page addWikiPage(OutlookMessage message) throws Exception {
            String wikiType = PortalConfig.GROUP_TYPE;
            String creator = message.getUser().getLocalUser();
            ArrayList<String> users = new ArrayList<String>();
            users.add(creator);
            return OutlookServiceImpl.this.createWikiPage(wikiType, this.getGroupId(), creator, message.getSubject(), OutlookServiceImpl.this.messageSummary(message), message.getBody(), users);
        }

        @Override
        public Topic addForumTopic(OutlookMessage message) throws Exception {
            String creator = message.getUser().getLocalUser();
            Group group = OutlookServiceImpl.this.organization.getGroupHandler().findGroupById(this.getGroupId());
            String parentGrId = group.getParentId();
            String categoryId = org.exoplatform.forum.service.Utils.CATEGORY + parentGrId.replaceAll("/", "");
            String forumId = org.exoplatform.forum.service.Utils.FORUM_SPACE_ID_PREFIX + group.getGroupName();
            return OutlookServiceImpl.this.createForumTopic(categoryId, forumId, creator, message.getSubject(), OutlookServiceImpl.this.messageSummary(message), message.getBody());
        }

        @Override
        public Topic addForumTopic(OutlookUser user, String name, String text) throws Exception {
            String creator = user.getLocalUser();
            Group group = OutlookServiceImpl.this.organization.getGroupHandler().findGroupById(this.getGroupId());
            String parentGrId = group.getParentId();
            String categoryId = org.exoplatform.forum.service.Utils.CATEGORY + parentGrId.replaceAll("/", "");
            String forumId = org.exoplatform.forum.service.Utils.FORUM_SPACE_ID_PREFIX + group.getGroupName();
            return OutlookServiceImpl.this.createForumTopic(categoryId, forumId, creator, name, null, text);
        }

        class RootFolder
        extends SpaceFolder {
            protected RootFolder(String rootPath, Node node) throws RepositoryException, OutlookException {
                super(rootPath, node);
                OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)this);
                this.hasSubfolders();
            }

            @Override
            protected Set<Folder> readSubnodes() throws RepositoryException, OutlookException {
                Folder uploads = null;
                Set<Folder> subfolders = super.readSubnodes();
                for (Folder sf : subfolders) {
                    if (!sf.getTitle().equals(OutlookServiceImpl.UPLAODS_FOLDER_TITLE)) continue;
                    uploads = this.defaultSubfolder = sf;
                    break;
                }
                if (uploads == null) {
                    Node parent = this.getNode();
                    Node subfolderNode = OutlookServiceImpl.this.addFolder(this.node, OutlookServiceImpl.UPLAODS_FOLDER_TITLE, false);
                    uploads = this.newFolder(this, subfolderNode);
                    parent.save();
                    OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)uploads);
                    subfolders.add(uploads);
                    this.defaultSubfolder = uploads;
                }
                return subfolders;
            }
        }

        class SpaceFolder
        extends UserFolder {
            protected SpaceFolder(Folder parent, Node node) throws RepositoryException, OutlookException {
                super(parent, node);
            }

            protected SpaceFolder(String rootPath, Node node) throws RepositoryException, OutlookException {
                super(rootPath, node);
            }

            @Override
            protected void readChildNodes() throws RepositoryException, OutlookException {
                super.readChildNodes();
                for (Folder sf : (Set)this.subfolders.get()) {
                    OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)sf);
                }
                for (File f : (Set)this.files.get()) {
                    OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)f);
                }
            }
        }
    }

    protected class UserImpl
    extends OutlookUser {
        protected final IdentityManager socialIdentityManager;
        protected final ActivityManager socialActivityManager;

        protected UserImpl(String email, String displayName, String userName) {
            super(email, displayName, userName);
            this.socialIdentityManager = OutlookServiceImpl.this.socialIdentityManager();
            this.socialActivityManager = OutlookServiceImpl.this.socialActivityManager();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ExoSocialActivity postActivity(OutlookMessage message) throws OutlookException {
            ExoSocialActivity exoSocialActivity;
            Node userDocs = OutlookServiceImpl.this.userDocumentsNode(this.localUser);
            if (userDocs == null) throw new OutlookException("Has no Personal Documents folder for user " + this.localUser);
            Node userPublicFolder = userDocs.getParent().getNode("Public");
            Node messagesFolder = OutlookServiceImpl.this.messagesFolder(userPublicFolder, this.localUser, "member:/platform/users");
            Node messageFile = OutlookServiceImpl.this.addMessageFile(messagesFolder, message);
            OutlookServiceImpl.this.setPermissions(messageFile, this.localUser, "member:/platform/users");
            messagesFolder.save();
            message.setFileNode(messageFile);
            String origType = org.exoplatform.wcm.ext.component.activity.listener.Utils.getActivityType();
            try {
                org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)"outlook:message");
                ExoSocialActivity activity = org.exoplatform.wcm.ext.component.activity.listener.Utils.postFileActivity((Node)messageFile, (String)"SocialIntegration.messages.createdBy", (boolean)true, (boolean)false, (String)"", (String)"");
                activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
                exoSocialActivity = activity;
            }
            catch (Throwable throwable) {
                try {
                    org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)origType);
                    throw throwable;
                }
                catch (Exception e) {
                    throw new OutlookException("Error posting activity for user " + this.localUser, e);
                }
            }
            org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)origType);
            return exoSocialActivity;
        }

        @Override
        public ExoSocialActivity postActivity(String title, String body) throws Exception {
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeTitle = OutlookServiceImpl.this.safeText(title);
            String safeBody = OutlookServiceImpl.this.safeHtml(body);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), null, safeTitle, safeBody);
            this.socialActivityManager.saveActivityNoReturn(userIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        @Override
        public ExoSocialActivity postActivity(String text) throws Exception {
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeText = OutlookServiceImpl.this.safeActivityMessage(text);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "exosocial:people", safeText, null);
            activity.setType("DEFAULT_ACTIVITY");
            this.socialActivityManager.saveActivityNoReturn(userIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        @Override
        public Page addWikiPage(OutlookMessage message) throws Exception {
            String wikiType = PortalConfig.PORTAL_TYPE;
            String creator = message.getUser().getLocalUser();
            ArrayList<String> users = new ArrayList<String>();
            users.add(creator);
            return OutlookServiceImpl.this.createWikiPage(wikiType, "intranet", creator, message.getSubject(), OutlookServiceImpl.this.messageSummary(message), message.getBody(), users);
        }

        @Override
        public Topic addForumTopic(String categoryId, String forumId, OutlookMessage message) throws Exception {
            return OutlookServiceImpl.this.createForumTopic(categoryId, forumId, message.getUser().getLocalUser(), message.getSubject(), OutlookServiceImpl.this.messageSummary(message), message.getBody());
        }
    }

    protected class UserFile
    extends File {
        protected UserFile(Folder parent, Node node) throws RepositoryException, OutlookException {
            super(parent, node);
        }

        protected UserFile(String parentPath, Node node) throws RepositoryException, OutlookException {
            super(parentPath, node);
        }

        @Override
        protected Locale userLocale() {
            return OutlookServiceImpl.this.currentUserLocale();
        }
    }

    protected class PersonalDocumentsFolder
    extends UserFolder
    implements UserDocuments {
        protected PersonalDocumentsFolder(Node node) throws RepositoryException, OutlookException {
            super(node);
        }

        @Override
        public Folder getRootFolder() throws OutlookException {
            return this;
        }

        @Override
        public Folder getFolder(String path) throws OutlookException, RepositoryException {
            UserFolder folder;
            String folderPath;
            String rootPath = this.getPath();
            if (rootPath.equals(folderPath = HierarchyNode.getPath(path))) {
                folder = this;
            } else if (folderPath.startsWith(rootPath)) {
                Node node = OutlookServiceImpl.this.node(folderPath);
                folder = new UserFolder(node.getParent().getPath(), node);
            } else {
                throw new BadParameterException("Path does not belong to space documents: " + path);
            }
            OutlookServiceImpl.this.initDocumentLink(this, (HierarchyNode)folder);
            return folder;
        }

        @Override
        public Collection<File> findAllLastDocuments(String text) throws RepositoryException, OutlookException {
            QueryManager qm = this.getNode().getSession().getWorkspace().getQueryManager();
            LinkedHashSet<File> res = new LinkedHashSet<File>();
            if (text == null || text.length() == 0) {
                Query q = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(q.execute(), 20, res);
            } else {
                Query qOwn = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' AND jcr:path LIKE '" + this.getPath() + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOwn.execute(), 3, res);
                Query qOthers = qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + this.getPath() + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOthers.execute(), 17, res);
            }
            return res;
        }

        @Override
        public Collection<File> findLastDocuments(String text) throws RepositoryException, OutlookException {
            QueryManager qm = this.getNode().getSession().getWorkspace().getQueryManager();
            LinkedHashSet<File> res = new LinkedHashSet<File>();
            Query q = text == null || text.length() == 0 ? qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + this.getPath() + "/%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql") : qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + this.getPath() + "/%' AND exo:title LIKE '%" + text + "%'", "sql");
            OutlookServiceImpl.this.fetchQuery(q.execute(), 20, res);
            return res;
        }

        protected String getDriveName() {
            return OutlookServiceImpl.PERSONAL_DOCUMENTS;
        }
    }

    protected class UserFolder
    extends Folder {
        protected UserFolder(Folder parent, Node node) throws RepositoryException, OutlookException {
            super(parent, node);
        }

        protected UserFolder(String parentPath, Node node) throws RepositoryException, OutlookException {
            super(parentPath, node);
        }

        protected UserFolder(Node node) throws RepositoryException, OutlookException {
            super(node.getPath(), node);
        }

        @Override
        public Folder addSubfolder(String name) throws RepositoryException, OutlookException {
            Node parent = this.getNode();
            Node subfolderNode = OutlookServiceImpl.this.addFolder(parent, name, true);
            Folder subfolder = this.newFolder(this, subfolderNode);
            parent.save();
            Set subfolders = (Set)this.subfolders.get();
            if (subfolders != null) {
                subfolders.add(subfolder);
            }
            return subfolder;
        }

        @Override
        protected Locale userLocale() {
            return OutlookServiceImpl.this.currentUserLocale();
        }

        @Override
        protected Folder newFolder(Folder parent, Node node) throws RepositoryException, OutlookException {
            UserFolder folder = new UserFolder(parent, node);
            return folder;
        }

        @Override
        protected Folder newFolder(String rootPath, Node node) throws RepositoryException, OutlookException {
            UserFolder folder = new UserFolder(rootPath, node);
            return folder;
        }

        @Override
        protected File newFile(Folder parent, Node node) throws RepositoryException, OutlookException {
            UserFile file = new UserFile(parent, node);
            return file;
        }
    }
}

