/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.web;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestUtils {
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String TIME_ZONE = "GMT";
    public static final String SAME_SITE_NONE_ATTRIBUTE_VALUE = "None";

    private RequestUtils() {
    }

    public static String getCookie(HttpServletRequest req, String name) {
        String val = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            Cookie cookie;
            Cookie[] cookieArray = cookies;
            int n = cookieArray.length;
            for (int i = 0; !(i >= n || name.equals((cookie = cookieArray[i]).getName()) && (val = cookie.getValue()) != null); ++i) {
            }
        }
        return val;
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie, String sameSite) {
        StringBuilder c = new StringBuilder(64 + cookie.getValue().length());
        c.append(cookie.getName());
        c.append('=');
        c.append(cookie.getValue());
        RequestUtils.appendToCookie(c, "domain", cookie.getDomain());
        RequestUtils.appendToCookie(c, "path", cookie.getPath());
        RequestUtils.appendToCookie(c, "SameSite", sameSite);
        if (cookie.getSecure()) {
            c.append("; secure");
        }
        if (cookie.isHttpOnly()) {
            c.append("; HttpOnly");
        }
        if (cookie.getMaxAge() >= 0) {
            RequestUtils.appendToCookie(c, "Expires", RequestUtils.getExpires(cookie.getMaxAge()));
        }
        response.addHeader("Set-Cookie", c.toString());
    }

    private static String getExpires(int maxAge) {
        if (maxAge < 0) {
            return "";
        }
        Calendar expireDate = Calendar.getInstance();
        expireDate.setTime(new Date());
        expireDate.add(13, maxAge);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        return dateFormat.format(expireDate.getTime());
    }

    private static void appendToCookie(StringBuilder cookie, String key, String value) {
        if (key == null || value == null || key.trim().equals("") || value.trim().equals("")) {
            return;
        }
        cookie.append("; ");
        cookie.append(key);
        cookie.append('=');
        cookie.append(value);
    }
}

