/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.common;

import java.util.ResourceBundle;
import juzu.RequestScoped;

@RequestScoped
public class ResourceBundleSerializer {
    public String toJSON(ResourceBundle bundle) {
        StringBuilder str = new StringBuilder();
        str.append("{\"locale\":\"");
        str.append(bundle.getLocale().getLanguage());
        String country = bundle.getLocale().getCountry();
        if (country != null && country.length() > 0) {
            str.append('_');
            str.append(country);
        }
        str.append("\",");
        str.append("\"messages\":{");
        boolean addComma = false;
        for (String k : bundle.keySet()) {
            if (!k.startsWith("Outlook.messages")) continue;
            if (addComma) {
                str.append(',');
            }
            str.append('\"');
            str.append(k);
            str.append("\":\"");
            str.append(bundle.getString(k));
            str.append('\"');
            addComma = true;
        }
        str.append("}}");
        return str.toString();
    }
}

