/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.portlet;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.SessionScoped;
import juzu.View;
import juzu.request.HttpContext;
import juzu.request.RequestContext;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.outlook.AccessException;
import org.exoplatform.outlook.BadParameterException;
import org.exoplatform.outlook.OutlookEmail;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.OutlookMessage;
import org.exoplatform.outlook.OutlookService;
import org.exoplatform.outlook.OutlookSpace;
import org.exoplatform.outlook.OutlookUser;
import org.exoplatform.outlook.common.ResourceBundleSerializer;
import org.exoplatform.outlook.jcr.ContentLink;
import org.exoplatform.outlook.jcr.Folder;
import org.exoplatform.outlook.jcr.LinkResource;
import org.exoplatform.outlook.portlet.AttachmentSource;
import org.exoplatform.outlook.portlet.MenuItem;
import org.exoplatform.outlook.portlet.Outlook;
import org.exoplatform.outlook.portlet.templates.addAttachment;
import org.exoplatform.outlook.portlet.templates.addFolderDialog;
import org.exoplatform.outlook.portlet.templates.convertToForum;
import org.exoplatform.outlook.portlet.templates.convertToStatus;
import org.exoplatform.outlook.portlet.templates.convertToWiki;
import org.exoplatform.outlook.portlet.templates.convertedForum;
import org.exoplatform.outlook.portlet.templates.convertedStatus;
import org.exoplatform.outlook.portlet.templates.convertedWiki;
import org.exoplatform.outlook.portlet.templates.error;
import org.exoplatform.outlook.portlet.templates.filesExplorer;
import org.exoplatform.outlook.portlet.templates.filesSearch;
import org.exoplatform.outlook.portlet.templates.folders;
import org.exoplatform.outlook.portlet.templates.home;
import org.exoplatform.outlook.portlet.templates.index;
import org.exoplatform.outlook.portlet.templates.postStatus;
import org.exoplatform.outlook.portlet.templates.postedStatus;
import org.exoplatform.outlook.portlet.templates.saveAttachment;
import org.exoplatform.outlook.portlet.templates.savedAttachment;
import org.exoplatform.outlook.portlet.templates.startDiscussion;
import org.exoplatform.outlook.portlet.templates.startedDiscussion;
import org.exoplatform.outlook.portlet.templates.unifiedSearch;
import org.exoplatform.outlook.portlet.templates.userInfo;
import org.exoplatform.outlook.security.OutlookTokenService;
import org.exoplatform.outlook.web.RequestUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.web.login.LoginServlet;
import org.exoplatform.web.login.LogoutControl;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.wiki.mow.api.Page;
import org.gatein.wci.ServletContainer;
import org.gatein.wci.ServletContainerFactory;
import org.gatein.wci.security.Credentials;

/*
 * Exception performing whole class analysis ignored.
 */
@SessionScoped
@PermitAll
public class Outlook {
    public static final String SOURCE_ID_ALL_SPACES = "*";
    public static final String SOURCE_ID_PERSONAL = "PERSONAL_DOCUMENTS";
    private static final String GMT_TIME_ZONE_ID = "GMT";
    private static final String COOKIE_DATE_FORMAT_STRING = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final String NAME_VALUE_DELIMITER = "=";
    private static final String ATTRIBUTE_DELIMITER = "; ";
    private static final String COOKIE_HEADER_NAME = "Set-Cookie";
    private static final String PATH_ATTRIBUTE_NAME = "Path";
    private static final String EXPIRES_ATTRIBUTE_NAME = "Expires";
    private static final String MAXAGE_ATTRIBUTE_NAME = "Max-Age";
    private static final String DOMAIN_ATTRIBUTE_NAME = "Domain";
    private static final Log LOG = ExoLogger.getLogger(Outlook.class);
    @Inject
    Provider<PortletPreferences> preferences;
    @Inject
    OutlookService outlook;
    @Inject
    CookieTokenService rememberMeTokens;
    @Inject
    OutlookTokenService outlookTokens;
    @Inject
    ContentLink contentLink;
    @Inject
    @Path(value="index.gtmpl")
    index index;
    @Inject
    @Path(value="saveAttachment.gtmpl")
    saveAttachment saveAttachment;
    @Inject
    @Path(value="savedAttachment.gtmpl")
    savedAttachment savedAttachment;
    @Inject
    @Path(value="folders.gtmpl")
    folders folders;
    @Inject
    @Path(value="filesExplorer.gtmpl")
    filesExplorer filesExplorer;
    @Inject
    @Path(value="filesSearch.gtmpl")
    filesSearch filesSearch;
    @Inject
    @Path(value="addFolderDialog.gtmpl")
    addFolderDialog addFolderDialog;
    @Inject
    @Path(value="addAttachment.gtmpl")
    addAttachment addAttachment;
    @Inject
    @Path(value="postStatus.gtmpl")
    postStatus postStatus;
    @Inject
    @Path(value="postedStatus.gtmpl")
    postedStatus postedStatus;
    @Inject
    @Path(value="startDiscussion.gtmpl")
    startDiscussion startDiscussion;
    @Inject
    @Path(value="startedDiscussion.gtmpl")
    startedDiscussion startedDiscussion;
    @Inject
    @Path(value="unifiedSearch.gtmpl")
    unifiedSearch unifiedSearch;
    @Inject
    @Path(value="userInfo.gtmpl")
    userInfo userInfo;
    @Inject
    @Path(value="convertToStatus.gtmpl")
    convertToStatus convertToStatus;
    @Inject
    @Path(value="convertedStatus.gtmpl")
    convertedStatus convertedStatus;
    @Inject
    @Path(value="convertToWiki.gtmpl")
    convertToWiki convertToWiki;
    @Inject
    @Path(value="convertedWiki.gtmpl")
    convertedWiki convertedWiki;
    @Inject
    @Path(value="convertToForum.gtmpl")
    convertToForum convertToForum;
    @Inject
    @Path(value="convertedForum.gtmpl")
    convertedForum convertedForum;
    @Inject
    @Path(value="home.gtmpl")
    home home;
    @Inject
    @Path(value="error.gtmpl")
    error error;
    @Inject
    ResourceBundle i18n;
    @Inject
    ResourceBundleSerializer i18nJSON;
    private final Map<String, MenuItem> allMenuItems = new LinkedHashMap();
    private final Set<MenuItem> rootMenuItems = new LinkedHashSet();

    public Outlook() {
        this.addRootMenuItem(new MenuItem("home"));
        this.addRootMenuItem(new MenuItem("saveAttachment"));
        this.addRootMenuItem(new MenuItem("addAttachment"));
        MenuItem convertTo = new MenuItem("convertTo");
        convertTo.addSubmenu("convertToStatus");
        convertTo.addSubmenu("convertToWiki");
        convertTo.addSubmenu("convertToForum");
        this.addRootMenuItem(convertTo);
        MenuItem create = new MenuItem("create");
        create.addSubmenu("postStatus");
        create.addSubmenu("startDiscussion");
        this.addRootMenuItem(create);
    }

    private void addRootMenuItem(MenuItem item) {
        this.rootMenuItems.add(item);
        this.addMenuItem(item);
    }

    private void addMenuItem(MenuItem item) {
        this.allMenuItems.put(item.getName(), item);
        if (item.hasSubmenu()) {
            for (MenuItem sm : item.getSubmenu()) {
                this.addMenuItem(sm);
            }
        }
    }

    @View
    public Response index(String command, RequestContext resourceContext) {
        ArrayList<MenuItem> menu = new ArrayList<MenuItem>();
        if (command == null) {
            command = this.requestCommand();
        }
        if (command == null) {
            for (MenuItem m : this.rootMenuItems) {
                menu.add(this.userMenuItem(m));
            }
        } else {
            for (String mn : command.split(",")) {
                MenuItem m = (MenuItem)this.allMenuItems.get(mn);
                if (m != null) {
                    menu.add(this.userMenuItem(m));
                    continue;
                }
                LOG.warn((Object)("Skipping not defined menu name '" + mn + "' for user '" + resourceContext.getSecurityContext().getRemoteUser() + "'"));
            }
        }
        try {
            return this.index.with().menu(menu).messages((Object)this.i18nJSON.toJSON(this.i18n)).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)("Portlet error: " + e.getMessage()), e);
            return this.error(e.getMessage());
        }
    }

    @View
    public Response error(String message) {
        return this.error.with().message((Object)message).ok();
    }

    @Ajax
    @Resource
    public Response logout() {
        try {
            this.fullLogout();
            return Response.ok().content((CharSequence)"{\"logout\":\"success\", \"loginLink\":\"/outlook/login\"}").withMimeType("application/json");
        }
        catch (Throwable e) {
            LOG.error((Object)"Error doing logout", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response homeForm() {
        try {
            return this.home.ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing Home page", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response saveAttachmentForm() {
        try {
            return this.saveAttachment.with().spaces((Object)this.outlook.getUserSpaces()).ok();
        }
        catch (AccessException e) {
            return this.errorMessage(e.getMessage(), 403);
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing save attachments form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response folders(String groupId, String path) {
        try {
            return this.folders.with().folder((Object)this.outlook.getSpace(groupId).getFolder(path)).ok();
        }
        catch (BadParameterException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading folder " + path + ". " + e.getMessage()));
            }
            return this.errorMessage(e.getMessage(), 400);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error reading folder " + path), e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response addFolderDialog() {
        try {
            return this.addFolderDialog.ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing add folder dialog", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response addFolder(String groupId, String path, String name) {
        if (name != null && name.length() > 0) {
            try {
                Folder folder = this.outlook.getSpace(groupId).getFolder(path);
                folder.addSubfolder(name);
                return this.folders.with().folder((Object)folder).ok();
            }
            catch (BadParameterException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error adding folder " + path + "/" + name + ". " + e.getMessage()));
                }
                return this.errorMessage(e.getMessage(), 400);
            }
            catch (Throwable e) {
                LOG.error((Object)("Error adding folder " + path + "/" + name), e);
                return this.errorMessage(e.getMessage(), 500);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Null or zero-length folder name to add in " + path));
        }
        return this.errorMessage("Folder name required", 400);
    }

    @Ajax
    @Resource
    public Response saveAttachment(String groupId, String path, String comment, String ewsUrl, String userEmail, String userName, String messageId, String attachmentToken, String attachmentIds, RequestContext context) {
        if (groupId != null && path != null && ewsUrl != null && userEmail != null && messageId != null && attachmentToken != null && attachmentIds != null) {
            try {
                OutlookSpace space = this.outlook.getSpace(groupId);
                if (space != null) {
                    ArrayList<String> attachments = new ArrayList<String>();
                    for (String aid : attachmentIds.split(",")) {
                        if ((aid = aid.trim()).length() <= 0) continue;
                        attachments.add(aid);
                    }
                    if (attachments.size() > 0) {
                        Folder folder = space.getFolder(path);
                        OutlookUser user = this.outlook.getUser(userEmail, userName, ewsUrl);
                        List files = this.outlook.saveAttachment(space, folder, user, comment, messageId, attachmentToken, attachments.toArray(new String[attachments.size()]));
                        return this.savedAttachment.with().files((Object)files).ok();
                    }
                    return this.savedAttachment.with().files(Collections.emptyList()).ok();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error saving attachment: space not found " + groupId + ". OutlookUser " + userEmail));
                }
                return this.errorMessage("Error saving attachment: space not found " + groupId, 404);
            }
            catch (Throwable e) {
                LOG.error((Object)("Error saving attachment in the space " + groupId + ": " + e.getMessage()), e);
                return this.errorMessage("Error saving attachment in the space. Please contact your administrator.", 500);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Error in saving attachment request: spaceName='" + groupId + "' path=" + path + " ewsUrl='" + ewsUrl + "' userEmail='" + userEmail + "' messageId='" + messageId + "' attachmentToken(size)='" + (attachmentToken != null ? Integer.valueOf(attachmentToken.length()) : "null") + "' attachmentIds='" + attachmentIds + "'"));
        }
        return this.errorMessage("Error in saving attachment request. Please reload the page.", 400);
    }

    @Ajax
    @Resource
    public Response addAttachmentForm() {
        try {
            ArrayList<AttachmentSource> sources = new ArrayList<AttachmentSource>();
            sources.add(new AttachmentSource("*", this.i18n.getString("Outlook.allSpaces")));
            Folder userFolder = this.outlook.getUserDocuments().getRootFolder();
            sources.add(new AttachmentSource("PERSONAL_DOCUMENTS", this.i18n.getString("Outlook.personalDocuments"), userFolder.getFullPath(), userFolder.getPathLabel()));
            for (OutlookSpace space : this.outlook.getUserSpaces()) {
                Folder spaceFolder = space.getRootFolder();
                sources.add(new AttachmentSource(space.getGroupId(), space.getTitle(), spaceFolder.getFullPath(), spaceFolder.getPathLabel()));
            }
            return this.addAttachment.with().sources(sources).ok();
        }
        catch (AccessException e) {
            return this.errorMessage(e.getMessage(), 403);
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing add attachments form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response exploreFiles(String sourceId, String path) {
        try {
            Folder folder;
            if ("PERSONAL_DOCUMENTS".equals(sourceId)) {
                folder = this.outlook.getUserDocuments().getFolder(path);
            } else {
                if ("*".equals(sourceId)) {
                    return this.errorMessage("Source not explorable", 400);
                }
                OutlookSpace space = this.outlook.getSpace(sourceId);
                folder = space.getFolder(path);
            }
            return this.filesExplorer.with().folder((Object)folder).ok();
        }
        catch (BadParameterException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading filesExplorer " + path + ". " + e.getMessage()));
            }
            return this.errorMessage(e.getMessage(), 400);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error reading filesExplorer " + path), e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response searchFiles(String sourceId, String text) {
        if (sourceId != null) {
            try {
                Collection res;
                if ("*".equals(sourceId)) {
                    res = this.outlook.getUserDocuments().findAllLastDocuments(text);
                } else if ("PERSONAL_DOCUMENTS".equals(sourceId)) {
                    res = this.outlook.getUserDocuments().findLastDocuments(text);
                } else {
                    OutlookSpace space = this.outlook.getSpace(sourceId);
                    res = space.findLastDocuments(text);
                }
                return this.filesSearch.with().files((Object)res).ok();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error searching filesExplorer in " + sourceId), e);
                return this.errorMessage(e.getMessage(), 500);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Null or zero-length source ID to searhc filesExplorer");
        }
        return this.errorMessage("Source ID required", 400);
    }

    @Ajax
    @Resource
    public Response fileLink(String nodePath, RequestContext context) {
        if (nodePath != null) {
            try {
                StringBuilder prefix = new StringBuilder();
                String scheme = context.getHttpContext().getScheme();
                if (scheme != null) {
                    prefix.append(scheme);
                } else {
                    scheme = "http";
                    prefix.append("http");
                }
                prefix.append("://");
                prefix.append(context.getHttpContext().getServerName());
                int port = context.getHttpContext().getServerPort();
                if (port > 0 && (port != 80 || port == 80 && !scheme.equalsIgnoreCase("http")) && (port != 443 || port == 443 && !scheme.equalsIgnoreCase("https"))) {
                    prefix.append(':');
                    prefix.append(port);
                }
                String userId = context.getSecurityContext().getRemoteUser();
                LinkResource res = this.contentLink.createUrl(userId, nodePath, prefix.toString());
                return Response.ok().content((CharSequence)("{\"link\":\"" + res.getLink() + "\", \"name\":\"" + res.getName() + "\"}")).withMimeType("application/json");
            }
            catch (Throwable e) {
                LOG.error((Object)("Error creating link for node " + nodePath), e);
                return this.errorMessage(e.getMessage(), 500);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Null or zero-length nodePath");
        }
        return this.errorMessage("Node path required", 400);
    }

    @Ajax
    @Resource
    public Response postStatusForm() {
        try {
            return this.postStatus.with().spaces((Object)this.outlook.getUserSpaces()).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing status post form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response postStatus(String groupId, String message, String userName, String userEmail, RequestContext context) {
        try {
            OutlookUser user = this.outlook.getUser(userEmail, userName, null);
            if (groupId != null && groupId.length() > 0) {
                OutlookSpace space = this.outlook.getSpace(groupId);
                if (space != null) {
                    ExoSocialActivity activity = space.postActivity(user, message);
                    return this.convertedStatus.with().status((Object)new UserStatus(this, null, space.getTitle(), activity.getPermaLink())).ok();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error converting message to activity status : space not found " + groupId + ". OutlookUser " + userEmail));
                }
                return this.errorMessage("Error converting message to activity status : space not found " + groupId, 404);
            }
            ExoSocialActivity activity = user.postActivity(message);
            return this.convertedStatus.with().status((Object)new UserStatus(this, user.getLocalUser(), null, activity.getPermaLink())).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error converting message to activity status for " + userEmail), e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response startDiscussionForm() {
        try {
            return this.startDiscussion.with().spaces((Object)this.outlook.getUserSpaces()).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing discussion start form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response startDiscussion(String groupId, String name, String text, String userName, String userEmail, RequestContext context) {
        try {
            OutlookUser user = this.outlook.getUser(userEmail, userName, null);
            if (groupId != null && groupId.length() > 0) {
                OutlookSpace space = this.outlook.getSpace(groupId);
                if (space != null) {
                    Topic topic = space.addForumTopic(user, name, text);
                    return this.startedDiscussion.with().topic((Object)new UserForumTopic(this, topic.getId(), topic.getTopicName(), topic.getLink(), space.getTitle())).ok();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error starting discussion: space not found " + groupId + ". OutlookUser " + userEmail));
                }
                return this.errorMessage("Error starting discussion: space not found " + groupId, 404);
            }
            return this.errorMessage("Error starting discussion: space not selected", 400);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error starting discussion for " + userEmail), e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response searchForm(HttpContext httpContext) {
        try {
            StringBuilder link = new StringBuilder();
            link.append("outlook/quicksearch");
            return this.unifiedSearch.with().searchLink((Object)link.toString()).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing unified search form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    @Deprecated
    public Response search(String sourceId, String text) {
        if (sourceId != null) {
            try {
                Collection res;
                if ("*".equals(sourceId)) {
                    res = this.outlook.getUserDocuments().findAllLastDocuments(text);
                } else if ("PERSONAL_DOCUMENTS".equals(sourceId)) {
                    res = this.outlook.getUserDocuments().findLastDocuments(text);
                } else {
                    OutlookSpace space = this.outlook.getSpace(sourceId);
                    res = space.findLastDocuments(text);
                }
                return this.filesSearch.with().files((Object)res).ok();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error searching filesExplorer in " + sourceId), e);
                return this.errorMessage(e.getMessage(), 500);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Null or zero-length source ID to searhc filesExplorer");
        }
        return this.errorMessage("Source ID required", 400);
    }

    @Ajax
    @Resource
    public Response userInfoForm() {
        try {
            return this.userInfo.ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing search form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response convertToStatusForm() {
        try {
            return this.convertToStatus.with().spaces((Object)this.outlook.getUserSpaces()).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing conversion to status form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response convertToStatus(String groupId, String messageId, String title, String subject, String body, String created, String modified, String userName, String userEmail, String fromName, String fromEmail, RequestContext context) {
        try {
            OutlookUser user = this.outlook.getUser(userEmail, userName, null);
            OutlookMessage message = this.message(user, messageId, fromEmail, fromName, created, modified, title, subject, body);
            if (groupId != null && groupId.length() > 0) {
                OutlookSpace space = this.outlook.getSpace(groupId);
                if (space != null) {
                    ExoSocialActivity activity = space.postActivity(message);
                    return this.convertedStatus.with().status((Object)new UserStatus(this, null, space.getTitle(), activity.getPermaLink())).ok();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error converting message to activity status : space not found " + groupId + ". OutlookUser " + userEmail));
                }
                return this.errorMessage("Error converting message to activity status : space not found " + groupId, 404);
            }
            ExoSocialActivity activity = user.postActivity(message);
            return this.convertedStatus.with().status((Object)new UserStatus(this, user.getLocalUser(), null, activity.getPermaLink())).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error converting message to activity status for " + userEmail), e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response getMessage(String ewsUrl, String userEmail, String userName, String messageId, String messageToken) {
        if (ewsUrl != null && userEmail != null && messageId != null && messageToken != null) {
            try {
                OutlookUser user = this.outlook.getUser(userEmail, userName, ewsUrl);
                OutlookMessage message = this.outlook.getMessage(user, messageId, messageToken);
                return Response.ok((CharSequence)message.getBody()).withHeader("X-MessageBodyContentType", new String[]{message.getType()}).withCharset(Charset.forName("UTF-8"));
            }
            catch (BadParameterException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error reading message " + messageId + ". " + e.getMessage()));
                }
                return this.errorMessage(e.getMessage(), 400);
            }
            catch (Throwable e) {
                LOG.error((Object)("Error reading message " + messageId), e);
                return this.errorMessage(e.getMessage(), 500);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Null or zero-length message ID or user parameters to read message");
        }
        return this.errorMessage("Message ID and user parameters required", 400);
    }

    @Ajax
    @Resource
    public Response convertToWikiForm() {
        try {
            return this.convertToWiki.with().spaces((Object)this.outlook.getUserSpaces()).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing conversion to wiki form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response convertToWiki(String groupId, String messageId, String subject, String body, String created, String modified, String userName, String userEmail, String fromName, String fromEmail, RequestContext context) {
        try {
            OutlookUser user = this.outlook.getUser(userEmail, userName, null);
            OutlookMessage message = this.message(user, messageId, fromEmail, fromName, created, modified, null, subject, body);
            if (groupId != null && groupId.length() > 0) {
                OutlookSpace space = this.outlook.getSpace(groupId);
                if (space != null) {
                    Page page = space.addWikiPage(message);
                    return this.convertedWiki.with().page((Object)new UserWikiPage(this, page.getId(), page.getTitle(), page.getUrl(), space.getTitle())).ok();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error converting message to wiki page: space not found " + groupId + ". OutlookUser " + userEmail));
                }
                return this.errorMessage("Error converting message to wiki page: space not found " + groupId, 404);
            }
            Page page = user.addWikiPage(message);
            return this.convertedWiki.with().page((Object)new UserWikiPage(this, page.getId(), page.getTitle(), page.getUrl())).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)("Error converting message to wiki page for " + userEmail), e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response convertToForumForm() {
        try {
            return this.convertToForum.with().spaces((Object)this.outlook.getUserSpaces()).ok();
        }
        catch (Throwable e) {
            LOG.error((Object)"Error showing conversion to forum form", e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response convertToForum(String groupId, String messageId, String subject, String body, String created, String modified, String userName, String userEmail, String fromName, String fromEmail, RequestContext context) {
        try {
            OutlookUser user = this.outlook.getUser(userEmail, userName, null);
            OutlookMessage message = this.message(user, messageId, fromEmail, fromName, created, modified, null, subject, body);
            if (groupId != null && groupId.length() > 0) {
                OutlookSpace space = this.outlook.getSpace(groupId);
                if (space != null) {
                    Topic topic = space.addForumTopic(message);
                    return this.convertedForum.with().topic((Object)new UserForumTopic(this, topic.getId(), topic.getTopicName(), topic.getLink(), space.getTitle())).ok();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error converting message to forum post: space not found " + groupId + ". OutlookUser " + userEmail));
                }
                return this.errorMessage("Error converting message to forum post: space not found " + groupId, 404);
            }
            return this.errorMessage("Error creating forum topic: space not selected", 400);
        }
        catch (Throwable e) {
            LOG.error((Object)("Error converting message to forum post for " + userEmail), e);
            return this.errorMessage(e.getMessage(), 500);
        }
    }

    @Ajax
    @Resource
    public Response rememberme(RequestContext context) throws IOException {
        String userName = context.getSecurityContext().getRemoteUser();
        String rememberMe = null;
        for (Cookie c : context.getHttpContext().getCookies()) {
            if (!c.getName().equals("rememberme")) continue;
            rememberMe = c.getValue();
        }
        if (rememberMe != null) {
            Credentials credentials = this.rememberMeTokens.validateToken(rememberMe, false);
            if (credentials != null) {
                try {
                    PortalRequestContext portalRequest = Util.getPortalRequestContext();
                    if (portalRequest != null) {
                        String rememberMeOutlook = this.outlookTokens.createToken(credentials);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Found a remembermeoutlook request parameter, created a persistent token " + rememberMeOutlook + " for it and set it up in the next response"));
                        }
                        ServletContainer servletContainer = ServletContainerFactory.getServletContainer();
                        servletContainer.login(portalRequest.getRequest(), portalRequest.getResponse(), credentials);
                        String cookie = Outlook.buildCookieValue((String)"remembermeoutlook", (String)rememberMeOutlook, (String)portalRequest.getRequest().getServerName(), (String)portalRequest.getPortalContextPath(), (int)((int)this.outlookTokens.getValidityTime()));
                        return Response.ok().withHeader("Set-Cookie", new String[]{cookie});
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Error saving user: portal request not found for " + userName));
                    }
                    return this.errorMessage("Error saving user: portal request not found", 400);
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Error saving user " + userName + ". " + e.getMessage()), (Throwable)e);
                    }
                    return this.errorMessage("Error saving user " + userName + ". " + e.getMessage(), 500);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OutlookUser not authenticated " + userName));
            }
            return this.errorMessage("Not authenticated", 401);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RememberMe token not found for " + userName));
        }
        return this.errorMessage("Authentication not complete", 401);
    }

    Response errorMessage(String text, int status) {
        return Response.content((int)status, (CharSequence)(text != null ? text : ""));
    }

    MenuItem userMenuItem(MenuItem item) {
        MenuItem userItem = item.clone();
        userItem.setTitle(this.i18n.getString("Outlook.command." + userItem.name));
        if (userItem.hasSubmenu()) {
            for (MenuItem sm : userItem.getSubmenu()) {
                sm.setTitle(this.i18n.getString("Outlook.command." + sm.name));
            }
        }
        return userItem;
    }

    void fullLogout() {
        AbstractTokenService tokenService;
        PortalRequestContext prContext = Util.getPortalRequestContext();
        HttpServletRequest req = prContext.getRequest();
        HttpServletResponse res = prContext.getResponse();
        String token = RequestUtils.getCookie((HttpServletRequest)req, (String)"rememberme");
        if (token != null) {
            tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
            tokenService.deleteToken((Object)token);
        }
        if ((token = LoginServlet.getOauthRememberMeTokenCookie((HttpServletRequest)req)) != null) {
            tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
            tokenService.deleteToken((Object)token);
        }
        LogoutControl.wantLogout();
        Cookie cookie = new Cookie("rememberme", "");
        cookie.setPath(req.getContextPath());
        cookie.setMaxAge(0);
        res.addCookie(cookie);
        Cookie oauthCookie = new Cookie("oauth_rememberme", "");
        oauthCookie.setPath(req.getContextPath());
        oauthCookie.setMaxAge(0);
        res.addCookie(oauthCookie);
        String rememberMeOutlook = RequestUtils.getCookie((HttpServletRequest)req, (String)"remembermeoutlook");
        if (rememberMeOutlook != null) {
            OutlookTokenService outlookTokens = (OutlookTokenService)AbstractTokenService.getInstance(OutlookTokenService.class);
            outlookTokens.deleteToken(rememberMeOutlook);
        }
        Cookie rememberMeOutlookCookie = new Cookie("remembermeoutlook", "");
        rememberMeOutlookCookie.setPath(req.getRequestURI());
        rememberMeOutlookCookie.setMaxAge(0);
        res.addCookie(rememberMeOutlookCookie);
    }

    private OutlookMessage message(OutlookUser user, String messageId, String fromEmail, String fromName, String created, String modified, String title, String subject, String body) throws OutlookException, ParseException {
        OutlookEmail from = this.outlook.getAddress(fromEmail, fromName);
        Calendar createdDate = Calendar.getInstance();
        createdDate.setTime(OutlookMessage.DATE_FORMAT.parse(created));
        Calendar modifiedDate = Calendar.getInstance();
        modifiedDate.setTime(OutlookMessage.DATE_FORMAT.parse(modified));
        OutlookMessage message = this.outlook.buildMessage(messageId, user, from, null, createdDate, modifiedDate, title, subject, body);
        return message;
    }

    private String requestCommand() {
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        if (portalRequest != null) {
            return portalRequest.getRequestParameter("command");
        }
        return null;
    }

    private static String buildCookieValue(String name, String value, String domain, String path, int maxAge) {
        StringBuilder sb = new StringBuilder(name).append("=");
        if (value != null && !value.isEmpty()) {
            sb.append(value);
        }
        if (domain != null && !domain.isEmpty()) {
            sb.append("; ");
            sb.append("Domain").append("=").append(domain);
        }
        if (path != null && !path.isEmpty()) {
            sb.append("; ");
            sb.append("Path").append("=").append(path);
        }
        if (maxAge >= 0) {
            sb.append("; ");
            sb.append("Max-Age").append("=").append(maxAge);
            sb.append("; ");
            Calendar cal = Calendar.getInstance();
            cal.add(13, maxAge);
            Date expires = cal.getTime();
            String formatted = Outlook.toCookieDate((Date)expires);
            sb.append("Expires").append("=").append(formatted);
        }
        return sb.toString();
    }

    private static String toCookieDate(Date date) {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        fmt.setTimeZone(tz);
        return fmt.format(date);
    }
}

