/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.utils;

import io.meeds.poll.entity.PollEntity;
import io.meeds.poll.entity.PollOptionEntity;
import io.meeds.poll.entity.PollVoteEntity;
import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;

public class EntityMapper {
    private EntityMapper() {
    }

    public static Poll fromPollEntity(PollEntity pollEntity) {
        if (pollEntity == null) {
            return null;
        }
        return new Poll(pollEntity.getId() == null ? 0L : pollEntity.getId(), pollEntity.getQuestion(), pollEntity.getCreatedDate(), pollEntity.getEndDate(), pollEntity.getCreatorId(), pollEntity.getActivityId(), pollEntity.getSpaceId());
    }

    public static PollEntity toPollEntity(Poll poll) {
        if (poll == null) {
            return null;
        }
        PollEntity pollEntity = new PollEntity();
        if (poll.getId() != 0L) {
            pollEntity.setId(poll.getId());
        }
        pollEntity.setQuestion(poll.getQuestion());
        pollEntity.setCreatedDate(poll.getCreatedDate());
        pollEntity.setEndDate(poll.getEndDate());
        pollEntity.setActivityId(poll.getActivityId());
        pollEntity.setSpaceId(poll.getSpaceId());
        pollEntity.setCreatorId(poll.getCreatorId());
        return pollEntity;
    }

    public static PollOption fromPollOptionEntity(PollOptionEntity pollOptionEntity, long pollId) {
        if (pollOptionEntity == null) {
            return null;
        }
        return new PollOption(pollOptionEntity.getId().longValue(), pollId == 0L ? pollOptionEntity.getPoll().getId() : pollId, pollOptionEntity.getDescription());
    }

    public static PollOption fromPollOptionEntity(PollOptionEntity pollOptionEntity) {
        return EntityMapper.fromPollOptionEntity(pollOptionEntity, 0L);
    }

    public static PollOptionEntity toPollOptionEntity(PollOption pollOption, PollEntity pollEntity) {
        if (pollOption == null) {
            return null;
        }
        PollOptionEntity pollOptionEntity = new PollOptionEntity();
        pollOptionEntity.setPoll(pollEntity);
        pollOptionEntity.setDescription(pollOption.getDescription());
        return pollOptionEntity;
    }

    public static PollVote fromPollVoteEntity(PollVoteEntity pollVoteEntity, long pollOptionId) {
        if (pollVoteEntity == null) {
            return null;
        }
        return new PollVote(pollVoteEntity.getId().longValue(), pollOptionId == 0L ? pollVoteEntity.getPollOption().getId() : pollOptionId, pollVoteEntity.getVoterId().longValue(), pollVoteEntity.getVoteDate());
    }

    public static PollVoteEntity toPollVoteEntity(PollVote pollVote, PollOptionEntity pollOptionEntity) {
        if (pollVote == null) {
            return null;
        }
        PollVoteEntity pollVoteEntity = new PollVoteEntity();
        if (pollVote.getId() != 0L) {
            pollVoteEntity.setId(pollVote.getId());
        }
        pollVoteEntity.setPollOption(pollOptionEntity);
        pollVoteEntity.setVoterId(pollVote.getVoterId());
        pollVoteEntity.setVoteDate(pollVote.getVoteDate());
        return pollVoteEntity;
    }
}

