/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.activity.processor;

import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.rest.model.PollOptionRestEntity;
import io.meeds.poll.rest.model.PollRestEntity;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.RestEntityBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PollActivityProcessor
extends BaseActivityProcessorPlugin {
    private static final Log LOG = ExoLogger.getLogger(PollActivityProcessor.class);
    private static final String ACTIVITY_PROCESSOR_NAME = "PollActivityProcessor";
    @Value(value="${meeds.poll.activity.processor.priority:30}")
    private static int processorPriority;
    @Autowired
    private PollService pollService;
    @Autowired
    private ActivityManager activityManager;

    public PollActivityProcessor() {
        super(PollActivityProcessor.getPriorityInitParam());
    }

    @PostConstruct
    public void init() {
        this.activityManager.addProcessor((ActivityProcessor)this);
    }

    public String getName() {
        return ACTIVITY_PROCESSOR_NAME;
    }

    public void processActivity(ExoSocialActivity activity) {
        PollRestEntity pollRestEntity;
        if (activity.isComment() || activity.getType() == null || !activity.getTemplateParams().containsKey("pollId")) {
            return;
        }
        if (activity.getLinkedProcessedEntities() == null) {
            activity.setLinkedProcessedEntities(new HashMap());
        }
        if ((pollRestEntity = (PollRestEntity)activity.getLinkedProcessedEntities().get("poll")) == null) {
            ConversationState currentState = ConversationState.getCurrent();
            if (currentState == null) {
                LOG.warn((Object)"Error processing Poll due to null ConversationState.getCurrent() inside activity storage layer processor. Ignore processing.");
                return;
            }
            Identity currentIdentity = currentState.getIdentity();
            String pollId = (String)activity.getTemplateParams().get("pollId");
            try {
                Poll poll = this.pollService.getPollById(Long.parseLong(pollId), currentIdentity);
                List pollOptions = this.pollService.getPollOptionsByPollId(Long.parseLong(pollId), currentIdentity);
                ArrayList<PollOptionRestEntity> pollOptionRestEntities = new ArrayList<PollOptionRestEntity>();
                for (PollOption pollOption : pollOptions) {
                    int pollOptionVotes = this.pollService.getPollOptionTotalVotes(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                    boolean isPollOptionVoted = this.pollService.isPollOptionVoted(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                    PollOptionRestEntity pollOptionRestEntity = RestEntityBuilder.fromPollOption(pollOption, pollOptionVotes, isPollOptionVoted);
                    pollOptionRestEntities.add(pollOptionRestEntity);
                }
                pollRestEntity = RestEntityBuilder.fromPoll(poll, pollOptionRestEntities);
            }
            catch (IllegalAccessException e) {
                LOG.warn("User {} attempt to access a non authorized poll with id {}", new Object[]{currentIdentity.getUserId(), pollId, e});
            }
            activity.getLinkedProcessedEntities().put("poll", pollRestEntity);
        }
    }

    private static InitParams getPriorityInitParam() {
        return new InitParams(){
            private static final long serialVersionUID = 6692556831691417605L;

            public ValueParam getValueParam(String name) {
                if (StringUtils.equals((CharSequence)"priority", (CharSequence)name)) {
                    return new ValueParam(){

                        public String getValue() {
                            return String.valueOf(processorPriority);
                        }
                    };
                }
                return super.getValueParam(name);
            }
        };
    }
}

