/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.utils;

import io.meeds.kernel.test.KernelExtension;
import io.meeds.poll.BasePollTest;
import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.rest.model.PollOptionRestEntity;
import io.meeds.poll.rest.model.PollRestEntity;
import io.meeds.poll.utils.RestEntityBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.poll", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase"})
@EnableJpaRepositories(basePackages={"io.meeds.poll"})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/poll-rdbms.db.changelog-master.xml"})
public class RestEntityBuilderTest
extends BasePollTest {
    private static final String POLL_OPTION_DESCRIPTION = "pollOption";
    private Date createdDate = new Date(1508484583259L);
    private Date endDate = new Date(11508484583260L);

    @Test
    public void testFromPoll() {
        Poll poll = new Poll();
        poll.setId(1L);
        poll.setQuestion("q1");
        poll.setCreatedDate(this.createdDate);
        poll.setEndDate(this.endDate);
        poll.setCreatorId(Long.parseLong(this.user1Identity.getId()));
        poll.setSpaceId(1L);
        PollOptionRestEntity pollOptionRestEntity = new PollOptionRestEntity();
        pollOptionRestEntity.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOptionRestEntity> pollOptionRestEntities = new ArrayList<PollOptionRestEntity>();
        pollOptionRestEntities.add(pollOptionRestEntity);
        PollRestEntity pollRestEntity = RestEntityBuilder.fromPoll((Poll)poll, pollOptionRestEntities);
        Assertions.assertEquals((long)1L, (long)pollRestEntity.getId());
    }

    @Test
    public void testFromPollOption() {
        PollOption pollOption = new PollOption();
        pollOption.setId(1L);
        pollOption.setDescription(POLL_OPTION_DESCRIPTION);
        PollOptionRestEntity pollOptionRestEntity = RestEntityBuilder.fromPollOption((PollOption)pollOption, (int)2, (boolean)true);
        Assertions.assertEquals((long)1L, (long)pollOptionRestEntity.getId());
    }

    @Test
    public void testToPoll() {
        PollRestEntity pollRestEntity = new PollRestEntity();
        pollRestEntity.setQuestion("q1");
        pollRestEntity.setDuration("");
        try {
            RestEntityBuilder.toPoll((PollRestEntity)pollRestEntity);
            Assertions.fail((String)"Should fail when a poll has an unexpected duration value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        pollRestEntity.setDuration("1day");
        Poll poll = RestEntityBuilder.toPoll((PollRestEntity)pollRestEntity);
        Assertions.assertEquals((Object)"q1", (Object)poll.getQuestion());
    }

    @Test
    public void testToPollOptions() {
        PollOptionRestEntity pollOptionRestEntity = new PollOptionRestEntity();
        pollOptionRestEntity.setDescription(POLL_OPTION_DESCRIPTION);
        ArrayList<PollOptionRestEntity> pollOptionRestEntities = new ArrayList<PollOptionRestEntity>();
        pollOptionRestEntities.add(pollOptionRestEntity);
        List options = RestEntityBuilder.toPollOptions(pollOptionRestEntities);
        Assertions.assertEquals((int)1, (int)options.size());
        Assertions.assertEquals((Object)POLL_OPTION_DESCRIPTION, (Object)((PollOption)options.get(0)).getDescription());
    }
}

