/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubContractorDAO;
import org.exoplatform.ps.entity.CategoryEntity;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubCatGroupEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.rest.ChangeBidScopeStatusRunner;
import org.exoplatform.ps.storage.api.BBCategoryStorage;
import org.exoplatform.ps.storage.api.CompanyInfoStorage;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.ps.storage.api.SubCatGroupRelationStorage;
import org.exoplatform.ps.storage.api.SubCatStorage;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/bbprojectservice")
public class ProjectRestService
implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String DefaultAvatar = "/Project-Space-portlets/skin/images/form-aside.png";
    private static final Log LOG = ExoLogger.getLogger((String)ProjectRestService.class.getName());
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String REPOSITORY = "repository";
    private static final String SOCIAL_WORKSPACE = "social";
    private static final String COLLABORATION_WORKSPACE = "collaboration";
    private static final String TITLE = "dc:title";
    private static final String TOTAL_VISITS = "exo:totalVisits";
    private static final String LAST_VISIT = "exo:lastVisit";
    private static final String TOTAL_VIEWS = "exo:totalViews";
    private static final String TOTAL_DOWNLOADS = "exo:totalDownloads";
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String SUBS_GROUP = "/organization/subcontractors";
    private static final String ADMIN_GROUP = "/platform/administrators";
    private static final String PLAN_ROOM_TEAM = "planroomteam";
    private static final String INTEGRATION_USER = "integrationuser";
    private static final String socialNameSpace = "social";
    public static final int WIDTH = 200;
    public static final int HEIGHT = 200;
    OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);

    public static String getStructure(Object structure) {
        try {
            if (structure == null) {
                return "";
            }
            String structureId = structure.toString();
            if (structureId.equals("RSB")) {
                return "Residential Building";
            }
            if (structureId.equals("RSB1")) {
                return "House";
            }
            if (structureId.equals("RSB2")) {
                return "Tract Housing";
            }
            if (structureId.equals("RSB3")) {
                return "Apartments & Condominiums";
            }
            if (structureId.equals("NRS")) {
                return "Non-Residential Building";
            }
            if (structureId.equals("NRS01")) {
                return "Animal Hospital / Kennel";
            }
            if (structureId.equals("NRS03")) {
                return "Arena / Stadium";
            }
            if (structureId.equals("NRS95")) {
                return "Assisted Living";
            }
            if (structureId.equals("NRS02")) {
                return "Auto Dealership / Service";
            }
            if (structureId.equals("NRS04")) {
                return "Bank";
            }
            if (structureId.equals("NRS91")) {
                return "Casino";
            }
            if (structureId.equals("NRS06")) {
                return "Church / Synagogue";
            }
            if (structureId.equals("NRS09")) {
                return "City / Town Hall";
            }
            if (structureId.equals("NRS12")) {
                return "Club House / Community Center";
            }
            if (structureId.equals("NRS92")) {
                return "Convention Center";
            }
            if (structureId.equals("NRS21")) {
                return "Court House";
            }
            if (structureId.equals("NRS24")) {
                return "Fitness Center";
            }
            if (structureId.equals("NRS27")) {
                return "Fire / Police Station";
            }
            if (structureId.equals("NRS28")) {
                return "Gas Station";
            }
            if (structureId.equals("NRS30")) {
                return "Hospital / Nursing Home";
            }
            if (structureId.equals("NRS34")) {
                return "Hotel / Motel";
            }
            if (structureId.equals("NRS32")) {
                return "Industrial Maintenance";
            }
            if (structureId.equals("NRS38")) {
                return "Jail / Prison";
            }
            if (structureId.equals("NRS42")) {
                return "Laboratory";
            }
            if (structureId.equals("NRS43")) {
                return "Library";
            }
            if (structureId.equals("NRS46")) {
                return "Manufacturing Plant";
            }
            if (structureId.equals("NRS48")) {
                return "Medical Office";
            }
            if (structureId.equals("NRS49")) {
                return "Mixed Use";
            }
            if (structureId.equals("NRS50")) {
                return "Museum";
            }
            if (structureId.equals("NRS58")) {
                return "Office Building";
            }
            if (structureId.equals("NRS62")) {
                return "Parking Garage";
            }
            if (structureId.equals("NRS67")) {
                return "Post Office";
            }
            if (structureId.equals("NRS68")) {
                return "Radio / Television Station";
            }
            if (structureId.equals("NRS70")) {
                return "Restaurant";
            }
            if (structureId.equals("NRS74")) {
                return "Retail Store";
            }
            if (structureId.equals("NRS78")) {
                return "School / College / University";
            }
            if (structureId.equals("NRS82")) {
                return "Sewage / Water Treatment Plant";
            }
            if (structureId.equals("NRS83")) {
                return "Storage Facility / Warehouse";
            }
            if (structureId.equals("NRS84")) {
                return "Terminal - Airport / Bus / Railroad";
            }
            if (structureId.equals("NRS86")) {
                return "Theater";
            }
            if (structureId.equals("NRS90")) {
                return "Theme Park";
            }
            if (structureId.equals("NBC")) {
                return "Non-Building Construction";
            }
            if (structureId.equals("NBC10")) {
                return "Airport Runway";
            }
            if (structureId.equals("NBC20")) {
                return "Athletic Field";
            }
            if (structureId.equals("NBC25")) {
                return "Bridge";
            }
            if (structureId.equals("NBC40")) {
                return "Golf Course";
            }
            if (structureId.equals("NBC50")) {
                return "Marine";
            }
            if (structureId.equals("NBC52")) {
                return "Park / Playground";
            }
            if (structureId.equals("NBC60")) {
                return "Road / Highway";
            }
            if (structureId.equals("NBC61")) {
                return "Parking Lots";
            }
            if (structureId.equals("NBC62")) {
                return "Swimming Pool";
            }
            if (structureId.equals("NBC68")) {
                return "Tennis Court";
            }
            if (structureId.equals("NBC70")) {
                return "Tunnel";
            }
            if (structureId.equals("NBC80")) {
                return "Utilities";
            }
            return structureId;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getType(Object type) {
        try {
            if (type == null) {
                return "";
            }
            String typeId = type.toString();
            if (typeId.equals("NEW")) {
                return "New";
            }
            if (typeId.equals("AAP")) {
                return "Addition";
            }
            if (typeId.equals("IFV")) {
                return "Interior Fit-Up";
            }
            if (typeId.equals("TNI")) {
                return "Tenant Improvements";
            }
            if (typeId.equals("RNR")) {
                return "Alterations / Renovations";
            }
            if (typeId.equals("IMP")) {
                return "Improvements";
            }
            if (typeId.equals("SCN")) {
                return "Service Contract";
            }
            if (typeId.equals("IVT")) {
                return "Individual Trade";
            }
            if (typeId.equals("EQP")) {
                return "Equipment";
            }
            if (typeId.equals("MAT")) {
                return "Material";
            }
            return typeId;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getOwnerType(Object oType) {
        try {
            if (oType == null) {
                return "";
            }
            String oTypeId = oType.toString();
            if (oTypeId.equals("PRV")) {
                return "Private";
            }
            if (oTypeId.equals("LOG")) {
                return "Local Government";
            }
            if (oTypeId.equals("STA")) {
                return "State Government";
            }
            if (oTypeId.equals("FED")) {
                return "Federal Government";
            }
            if (oTypeId.equals("MIL")) {
                return "Military";
            }
            return oTypeId;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static boolean isLowerCaseLetter(char character) {
        return character >= 'a' && character <= 'z';
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public static boolean isAdmin(Identity userId) {
        return userId.isMemberOf(ADMIN_GROUP) || userId.isMemberOf(GCS_GROUP) || userId.getUserId().equals(PropertyManager.getProperty((String)"exo.super.user")) || userId.getUserId().equals(PLAN_ROOM_TEAM) || userId.getUserId().equals(INTEGRATION_USER);
    }

    @POST
    @Path(value="create")
    @Consumes(value={"application/json"})
    public Response addProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo, Map<String, String> project) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        ListenerService listenerService = (ListenerService)PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
        UploadService uploadService = (UploadService)PortalContainer.getInstance().getComponentInstanceOfType(UploadService.class);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (staffEntity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = this.orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            String owner = sourceIdentity.getRemoteId();
            Calendar cal = Calendar.getInstance();
            Date date = cal.getTime();
            User oUser = uh.findUserByName(owner);
            String name = String.valueOf(oUser.getFirstName().toLowerCase().charAt(0)) + String.valueOf(oUser.getLastName().toLowerCase().charAt(0)) + String.valueOf(date.getTime());
            while (!ProjectRestService.isLowerCaseLetter(name.charAt(0))) {
                name = name.substring(1);
            }
            while (spaceService.getSpaceByPrettyName(name) != null) {
                name = String.valueOf(oUser.getFirstName().toLowerCase().charAt(0)) + String.valueOf(oUser.getLastName().toLowerCase().charAt(0)) + String.valueOf(date.getTime() + 1L);
                while (!ProjectRestService.isLowerCaseLetter(name.charAt(0))) {
                    name = name.substring(1);
                }
            }
            Space project_ = new Space();
            project_.setDisplayName(project.get("projectName"));
            project_.setPrettyName(name);
            project_.setRegistration("open");
            project_.setDescription(project.get("projectDescription"));
            project_.setType("classic");
            project_.setVisibility("public");
            project_.setRegistration("validation");
            project_.setPriority("2");
            spaceService.createSpace(project_, owner);
            org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", project_.getPrettyName(), true);
            Profile sProfile = prIdentity.getProfile();
            sProfile.setProperty("ownerType", (Object)project.get("ownerType"));
            sProfile.setProperty("ownerTypeId", (Object)project.get("ownerTypeId"));
            sProfile.setProperty("projectType", (Object)project.get("projectType"));
            sProfile.setProperty("projectTypeId", (Object)project.get("projectTypeId"));
            sProfile.setProperty("nbBuildings", (Object)project.get("nbBuildings"));
            sProfile.setProperty("storiesAboveGrd", (Object)project.get("storiesAboveGrd"));
            sProfile.setProperty("storiesBelowGrd", (Object)project.get("storiesBelowGrd"));
            sProfile.setProperty("totalSqFt", (Object)project.get("totalSqFt"));
            sProfile.setProperty("projectValuation", (Object)project.get("projectValuation"));
            sProfile.setProperty("projectStatus", (Object)project.get("projectStatus"));
            sProfile.setProperty("projectStatusId", (Object)project.get("projectStatusId"));
            sProfile.setProperty("preBidMeetingDate", (Object)project.get("preBidMeetingDate"));
            sProfile.setProperty("bidsDueDate", (Object)project.get("bidsDueDate"));
            sProfile.setProperty("startDate", (Object)project.get("startDate"));
            sProfile.setProperty("creator", (Object)owner);
            sProfile.setProperty("union", (Object)project.get("union"));
            sProfile.setProperty("nonUnion", (Object)project.get("nonUnion"));
            sProfile.setProperty("prevailingWage", (Object)project.get("prevailingWage"));
            sProfile.setProperty("chkleed", (Object)project.get("chkleed"));
            sProfile.setProperty("chkbim", (Object)project.get("chkbim"));
            sProfile.setProperty("goal1", (Object)project.get("goal1"));
            sProfile.setProperty("goal1Id", (Object)project.get("goal1Id"));
            sProfile.setProperty("goal2", (Object)project.get("goal2"));
            sProfile.setProperty("goal2Id", (Object)project.get("goal2Id"));
            sProfile.setProperty("goal3", (Object)project.get("goal3"));
            sProfile.setProperty("goal3Id", (Object)project.get("goal3Id"));
            sProfile.setProperty("goal1pct", (Object)project.get("goal1pct"));
            sProfile.setProperty("goal2pct", (Object)project.get("goal2pct"));
            sProfile.setProperty("goal3pct", (Object)project.get("goal3pct"));
            sProfile.setProperty("bidSecurity", (Object)project.get("bidSecurity"));
            sProfile.setProperty("performanceBond", (Object)project.get("performanceBond"));
            sProfile.setProperty("paymentBond", (Object)project.get("paymentBond"));
            sProfile.setProperty("mbeGoal", (Object)project.get("mbeGoal"));
            sProfile.setProperty("dbeGoal", (Object)project.get("dbeGoal"));
            sProfile.setProperty("hubzone", (Object)project.get("hubzone"));
            sProfile.setProperty("leed", (Object)project.get("leed"));
            sProfile.setProperty("bim", (Object)project.get("bim"));
            sProfile.setProperty("adress", (Object)project.get("adress"));
            sProfile.setProperty("city", (Object)project.get("city"));
            sProfile.setProperty("state", (Object)project.get("state"));
            sProfile.setProperty("zip", (Object)project.get("zip"));
            sProfile.setProperty("country", (Object)project.get("country"));
            sProfile.setProperty("architect", (Object)project.get("architect"));
            sProfile.setProperty("engineer", (Object)project.get("engineer"));
            sProfile.setProperty("owner", (Object)project.get("owner"));
            sProfile.setProperty("geoPosition", (Object)project.get("geoPosition"));
            sProfile.setProperty("url", (Object)project.get("url"));
            sProfile.setProperty("gc", (Object)staffEntity.getGeneralContractorEntity().getId());
            Util.getIdentityManager((String)portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
            LOG.info((Object)"Project has been created successfully");
            Space createdSpace = spaceService.getSpaceByPrettyName(name);
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("projectName", (Object)createdSpace.getPrettyName());
            jsonGlobal.put("projectDisplayName", (Object)createdSpace.getDisplayName());
            jsonGlobal.put("projectDescription", (Object)createdSpace.getDescription());
            jsonGlobal.put("projectUrl", (Object)("/portal/g/:spaces:" + createdSpace.getPrettyName() + "/" + createdSpace.getPrettyName()));
            try {
                Object fileItem = null;
                if (project.get("uploadId") != null) {
                    UploadResource uploadResource = uploadService.getUploadResource(project.get("uploadId"));
                    String mimeType = uploadResource.getMimeType();
                    FileInputStream uploadedStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
                    AvatarAttachment avatarAttachment = ImageUtils.createResizedAvatarAttachment((InputStream)uploadedStream, (int)200, (int)200, null, (String)uploadResource.getFileName(), (String)mimeType, null);
                    if (avatarAttachment == null) {
                        avatarAttachment = new AvatarAttachment(null, uploadResource.getFileName(), mimeType, (InputStream)uploadedStream, null, System.currentTimeMillis());
                    }
                    createdSpace.setAvatarAttachment(avatarAttachment);
                    spaceService.updateSpace(createdSpace);
                    spaceService.updateSpaceAvatar(createdSpace);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            listenerService.broadcast("CreateProject", (Object)createdSpace, (Object)sourceIdentity.getRemoteId());
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="get/{projectId}")
    @Consumes(value={"application/json"})
    public Response getProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        String status = "";
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubContractorDAO subContractorDAO = (SubContractorDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubContractorDAO.class));
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            MembershipHandler mHandler = this.orgService.getMembershipHandler();
            MembershipTypeHandler mtHandler = this.orgService.getMembershipTypeHandler();
            boolean canEdit = false;
            boolean isSub = false;
            if (subContractorDAO.find((Serializable)((Object)sourceIdentity.getRemoteId())) != null) {
                isSub = true;
                ListAccess<ProjectSubEntity> relations = projectSubRelationShipStorage.getRelationShipByProjectIdAndSubIdListAccess(project.getPrettyName(), sourceIdentity.getRemoteId());
                for (ProjectSubEntity rel : (ProjectSubEntity[])relations.load(0, relations.getSize())) {
                    status = rel.getStatus();
                    if (!rel.getStatus().equals("INVITED")) continue;
                    projectSubRelationShipStorage.updateProjectSubRelationShip(rel.getId(), null, "REVIEWING", null, null, null, null);
                }
            }
            JSONObject json = new JSONObject();
            json.put("projectId", (Object)project.getPrettyName());
            json.put("projectName", (Object)project.getDisplayName());
            json.put("projectDescription", (Object)project.getDescription());
            json.put("url", (Object)project.getUrl());
            json.put("avatar", (Object)project.getAvatarUrl());
            org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", projectId, true);
            Profile sProfile = prIdentity.getProfile();
            json.put("ownerType", (Object)ProjectRestService.getOwnerType(sProfile.getProperty("ownerTypeId")));
            json.put("ownerTypeId", sProfile.getProperty("ownerTypeId"));
            json.put("projectStatus", sProfile.getProperty("projectStatus"));
            json.put("projectStatusId", sProfile.getProperty("projectStatusId"));
            json.put("projectType", (Object)ProjectRestService.getType(sProfile.getProperty("projectTypeId")));
            json.put("projectTypeId", sProfile.getProperty("projectTypeId"));
            json.put("nbBuildings", sProfile.getProperty("nbBuildings"));
            json.put("storiesAboveGrd", sProfile.getProperty("storiesAboveGrd"));
            json.put("storiesBelowGrd", sProfile.getProperty("storiesBelowGrd"));
            json.put("totalSqFt", sProfile.getProperty("totalSqFt"));
            json.put("projectValuation", sProfile.getProperty("projectValuation"));
            json.put("preBidMeetingDate", sProfile.getProperty("preBidMeetingDate"));
            json.put("bidsDueDate", sProfile.getProperty("bidsDueDate"));
            json.put("startDate", sProfile.getProperty("startDate"));
            json.put("creator", sProfile.getProperty("creator"));
            json.put("union", Boolean.parseBoolean((String)sProfile.getProperty("union")));
            json.put("nonUnion", Boolean.parseBoolean((String)sProfile.getProperty("nonUnion")));
            json.put("prevailingWage", Boolean.parseBoolean((String)sProfile.getProperty("prevailingWage")));
            json.put("chkleed", Boolean.parseBoolean((String)sProfile.getProperty("chkleed")));
            json.put("chkbim", Boolean.parseBoolean((String)sProfile.getProperty("chkbim")));
            json.put("goal1", sProfile.getProperty("goal1"));
            json.put("goal1Id", sProfile.getProperty("goal1Id"));
            json.put("goal2", sProfile.getProperty("goal2"));
            json.put("goal2Id", sProfile.getProperty("goal2Id"));
            json.put("goal3", sProfile.getProperty("goal3"));
            json.put("goal3Id", sProfile.getProperty("goal3Id"));
            json.put("goal1pct", sProfile.getProperty("goal1pct"));
            json.put("goal2pct", sProfile.getProperty("goal2pct"));
            json.put("goal3pct", sProfile.getProperty("goal3pct"));
            json.put("bidSecurity", sProfile.getProperty("bidSecurity"));
            json.put("performanceBond", sProfile.getProperty("performanceBond"));
            json.put("paymentBond", sProfile.getProperty("paymentBond"));
            json.put("mbeGoal", sProfile.getProperty("mbeGoal"));
            json.put("dbeGoal", sProfile.getProperty("dbeGoal"));
            json.put("hubzone", sProfile.getProperty("hubzone"));
            json.put("leed", sProfile.getProperty("leed"));
            json.put("bim", sProfile.getProperty("bim"));
            json.put("adress", sProfile.getProperty("adress"));
            json.put("city", sProfile.getProperty("city"));
            json.put("state", sProfile.getProperty("state"));
            json.put("zip", sProfile.getProperty("zip"));
            json.put("country", sProfile.getProperty("country"));
            json.put("architect", sProfile.getProperty("architect"));
            json.put("engineer", sProfile.getProperty("engineer"));
            json.put("owner", sProfile.getProperty("owner"));
            json.put("geoPosition", sProfile.getProperty("geoPosition"));
            json.put("url", sProfile.getProperty("url"));
            json.put("bidScop", (Object)(sProfile.getProperty("bidScop") != null ? ProjectRestService.getStructure(sProfile.getProperty("bidScop")) : "false"));
            json.put("canEdit", spaceService.isManager(project, sourceIdentity.getRemoteId()));
            json.put("isSub", isSub);
            json.put("status", (Object)status);
            return Response.ok((Object)json.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="archive/{projectId}")
    @Consumes(value={"application/json"})
    public Response archiveProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Node socArchiveNode;
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = manageableRepository.getSystemSession("social");
            Node socialRootNode = session.getRootNode();
            if (!socialRootNode.hasNode("soc:archive")) {
                socialRootNode.addNode("soc:archive", "soc:archive");
                session.save();
            }
            if (!(socArchiveNode = socialRootNode.getNode("soc:archive")).hasNode("soc:archivedSpaces")) {
                socArchiveNode.addNode("soc:archivedSpaces", "soc:spaces");
                session.save();
            }
            session.move("/production/soc:spaces/soc:" + projectId, "/soc:archive/soc:archivedSpaces/soc:" + projectId);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String query = "select * from soc:spaceref where jcr:path like '/production/soc:providers/soc:organization/%' and exo:name = 'soc:" + projectId + "' order by exo:dateCreated DESC";
            QueryImpl queryImpl = (QueryImpl)queryManager.createQuery(query, "sql");
            QueryResult queryResult = queryImpl.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!node.getParent().getName().equals("soc:spacemember")) continue;
                if (!socArchiveNode.hasNode("soc:" + node.getProperty("exo:lastModifier").getString())) {
                    socArchiveNode.addNode("soc:" + node.getProperty("exo:lastModifier").getString(), "soc:spaceslist");
                    session.save();
                }
                session.move(node.getPath(), "/soc:archive/soc:" + node.getProperty("exo:lastModifier").getString() + "/soc:" + projectId);
            }
            session.save();
            return Response.ok((Object)"Archived").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="delete/{projectId}")
    @Consumes(value={"application/json"})
    public Response deleteProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            spaceService.deleteSpace(project);
            ListAccess<ProjectSubEntity> relations = projectSubRelationShipStorage.getRelationShipByProjectIdListAccess(projectId);
            for (ProjectSubEntity rel : (ProjectSubEntity[])relations.load(0, relations.getSize())) {
                projectSubRelationShipStorage.deleteProjectSubRelationShip(rel.getId());
            }
            return Response.ok((Object)"Deleted").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="update/{projectId}")
    @Consumes(value={"application/json"})
    public Response updateProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, Map<String, String> project) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project_ = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            project_.setDisplayName(project.get("projectName"));
            project_.setDescription(project.get("projectDescription"));
            spaceService.updateSpace(project_);
            org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", projectId, true);
            Profile sProfile = prIdentity.getProfile();
            sProfile.setProperty("ownerType", (Object)project.get("ownerType"));
            sProfile.setProperty("projectType", (Object)project.get("projectType"));
            sProfile.setProperty("nbBuildings", (Object)project.get("nbBuildings"));
            sProfile.setProperty("storiesAboveGrd", (Object)project.get("storiesAboveGrd"));
            sProfile.setProperty("storiesBelowGrd", (Object)project.get("storiesBelowGrd"));
            sProfile.setProperty("totalSqFt", (Object)project.get("totalSqFt"));
            sProfile.setProperty("projectValuation", (Object)project.get("projectValuation"));
            sProfile.setProperty("projectStatus", (Object)project.get("projectStatus"));
            sProfile.setProperty("projectStatusId", (Object)project.get("projectStatusId"));
            sProfile.setProperty("preBidMeetingDate", (Object)project.get("preBidMeetingDate"));
            sProfile.setProperty("bidsDueDate", (Object)project.get("bidsDueDate"));
            sProfile.setProperty("startDate", (Object)project.get("startDate"));
            sProfile.setProperty("union", (Object)project.get("union"));
            sProfile.setProperty("nonUnion", (Object)project.get("nonUnion"));
            sProfile.setProperty("prevailingWage", (Object)project.get("prevailingWage"));
            sProfile.setProperty("chkleed", (Object)project.get("chkleed"));
            sProfile.setProperty("chkbim", (Object)project.get("chkbim"));
            sProfile.setProperty("goal1", (Object)project.get("goal1"));
            sProfile.setProperty("goal1Id", (Object)project.get("goal1Id"));
            sProfile.setProperty("goal2", (Object)project.get("goal2"));
            sProfile.setProperty("goal2Id", (Object)project.get("goal2Id"));
            sProfile.setProperty("goal3", (Object)project.get("goal3"));
            sProfile.setProperty("goal3Id", (Object)project.get("goal3Id"));
            sProfile.setProperty("goal1pct", (Object)project.get("goal1pct"));
            sProfile.setProperty("goal2pct", (Object)project.get("goal2pct"));
            sProfile.setProperty("goal3pct", (Object)project.get("goal3pct"));
            sProfile.setProperty("bidSecurity", (Object)project.get("bidSecurity"));
            sProfile.setProperty("performanceBond", (Object)project.get("performanceBond"));
            sProfile.setProperty("paymentBond", (Object)project.get("paymentBond"));
            sProfile.setProperty("mbeGoal", (Object)project.get("mbeGoal"));
            sProfile.setProperty("dbeGoal", (Object)project.get("dbeGoal"));
            sProfile.setProperty("hubzone", (Object)project.get("hubzone"));
            sProfile.setProperty("leed", (Object)project.get("leed"));
            sProfile.setProperty("bim", (Object)project.get("bim"));
            sProfile.setProperty("adress", (Object)project.get("adress"));
            sProfile.setProperty("city", (Object)project.get("city"));
            sProfile.setProperty("state", (Object)project.get("state"));
            sProfile.setProperty("zip", (Object)project.get("zip"));
            sProfile.setProperty("country", (Object)project.get("country"));
            sProfile.setProperty("architect", (Object)project.get("architect"));
            sProfile.setProperty("engineer", (Object)project.get("engineer"));
            sProfile.setProperty("owner", (Object)project.get("owner"));
            sProfile.setProperty("geoPosition", (Object)project.get("geoPosition"));
            Util.getIdentityManager((String)portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
            LOG.info((Object)"Project has been Updated successfully");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Project Updated");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getallprojects")
    public Response getAllProjects(@Context HttpServletRequest request, @QueryParam(value="beginby") String beginby, @QueryParam(value="searchcondition") String searchCondition, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            List<Object> projects = null;
            SpaceService spaceservice = Util.getSpaceService((String)portalContainerName);
            SettingService settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonGlobal = new JSONObject();
            int totalNumber = 0;
            SpaceFilter spaceFilter = new SpaceFilter();
            ListAccess projects_ = null;
            if (searchCondition != null && !searchCondition.equals("") && !searchCondition.equals("undefined")) {
                spaceFilter.setSpaceNameSearchCondition(searchCondition);
                projects_ = spaceservice.getAllSpacesByFilter(spaceFilter);
            } else if (beginby != null && !beginby.equals("") && !beginby.equals("undefined")) {
                spaceFilter.setFirstCharacterOfSpaceName(beginby.charAt(0));
                projects_ = spaceservice.getAllSpacesByFilter(spaceFilter);
            } else {
                projects_ = spaceservice.getAllSpacesWithListAccess();
            }
            String accountSequence = "";
            totalNumber = projects_.getSize();
            if (limit == 0) {
                limit = projects_.getSize();
            }
            projects = Arrays.asList(projects_.load(offset, limit));
            for (Space space : projects) {
                JSONObject json = new JSONObject();
                json.put("projectId", (Object)space.getPrettyName());
                json.put("projectName", (Object)space.getDisplayName());
                json.put("projectDescription", (Object)space.getDescription());
                json.put("url", (Object)space.getUrl());
                json.put("avatar", (Object)space.getAvatarUrl());
                json.put("contact", (Object)space.getEditor());
                org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", space.getPrettyName(), true);
                Profile sProfile = prIdentity.getProfile();
                json.put("ownerType", (Object)ProjectRestService.getOwnerType(sProfile.getProperty("ownerTypeId")));
                json.put("ownerTypeId", (Object)sProfile.getProperty("ownerTypeId").toString());
                json.put("projectStatus", sProfile.getProperty("projectStatus"));
                json.put("projectStatusId", (Object)sProfile.getProperty("projectStatusId").toString());
                json.put("projectType", (Object)ProjectRestService.getType(sProfile.getProperty("projectTypeId")));
                json.put("projectTypeId", (Object)sProfile.getProperty("projectTypeId").toString());
                json.put("nbBuildings", sProfile.getProperty("nbBuildings"));
                json.put("storiesAboveGrd", sProfile.getProperty("storiesAboveGrd"));
                json.put("storiesBelowGrd", sProfile.getProperty("storiesBelowGrd"));
                json.put("totalSqFt", sProfile.getProperty("totalSqFt"));
                json.put("projectValuation", sProfile.getProperty("projectValuation"));
                CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                CalendarEvent duedateevent = calService.getEventById(space.getPrettyName() + " - bidsDueDate");
                CalendarEvent prebiddateevent = calService.getEventById(space.getPrettyName() + " - preBidMeeting");
                CalendarEvent startdateevent = calService.getEventById(space.getPrettyName() + " - startDate");
                SimpleDateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
                SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy");
                formatter1.setTimeZone(TimeZone.getTimeZone("GMT"));
                json.put("bidsDueDate", (Object)(duedateevent != null ? formatter1.format(duedateevent.getFromDateTime()) : ""));
                json.put("preBidMeetingDate", (Object)(prebiddateevent != null ? formatter1.format(prebiddateevent.getFromDateTime()) : ""));
                json.put("startDate", (Object)(startdateevent != null ? formatter2.format(startdateevent.getFromDateTime()) : ""));
                json.put("creator", sProfile.getProperty("creator"));
                json.put("union", Boolean.parseBoolean((String)sProfile.getProperty("union")));
                json.put("nonUnion", Boolean.parseBoolean((String)sProfile.getProperty("nonUnion")));
                json.put("prevailingWage", Boolean.parseBoolean((String)sProfile.getProperty("prevailingWage")));
                json.put("chkleed", Boolean.parseBoolean((String)sProfile.getProperty("chkleed")));
                json.put("chkbim", Boolean.parseBoolean((String)sProfile.getProperty("chkbim")));
                json.put("goal1", sProfile.getProperty("goal1"));
                json.put("goal1Id", sProfile.getProperty("goal1Id"));
                json.put("goal2", sProfile.getProperty("goal2"));
                json.put("goal2Id", sProfile.getProperty("goal2Id"));
                json.put("goal3", sProfile.getProperty("goal3"));
                json.put("goal3Id", sProfile.getProperty("goal3Id"));
                json.put("goal1pct", sProfile.getProperty("goal1pct"));
                json.put("goal2pct", sProfile.getProperty("goal2pct"));
                json.put("goal3pct", sProfile.getProperty("goal3pct"));
                json.put("bidSecurity", sProfile.getProperty("bidSecurity"));
                json.put("performanceBond", sProfile.getProperty("performanceBond"));
                json.put("paymentBond", sProfile.getProperty("paymentBond"));
                json.put("mbeGoal", sProfile.getProperty("mbeGoal"));
                json.put("dbeGoal", sProfile.getProperty("dbeGoal"));
                json.put("hubzone", sProfile.getProperty("hubzone"));
                json.put("leed", sProfile.getProperty("leed"));
                json.put("bim", sProfile.getProperty("bim"));
                json.put("adress", sProfile.getProperty("adress"));
                json.put("city", sProfile.getProperty("city"));
                json.put("state", sProfile.getProperty("state"));
                json.put("zip", sProfile.getProperty("zip"));
                json.put("country", sProfile.getProperty("country"));
                json.put("architect", sProfile.getProperty("architect"));
                json.put("engineer", sProfile.getProperty("engineer"));
                json.put("owner", sProfile.getProperty("owner"));
                json.put("geoPosition", sProfile.getProperty("geoPosition"));
                json.put("url", sProfile.getProperty("url"));
                json.put("bidScop", (Object)(sProfile.getProperty("bidScop") != null ? ProjectRestService.getStructure(sProfile.getProperty("bidScop")) : "false"));
                if (settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "accountSequence") != null) {
                    accountSequence = (String)settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "accountSequence").getValue();
                }
                json.put("accountSequence", (Object)accountSequence);
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("totalNbOfProjects", totalNumber);
            jsonGlobal.put("projects", (Object)jsonArray);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getmyspaces")
    public Response getMySpaces(@Context HttpServletRequest request, @QueryParam(value="beginby") String beginby, @QueryParam(value="searchcondition") String searchCondition, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (userIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List<Object> mySpaces = null;
            SpaceService spaceservice = Util.getSpaceService((String)portalContainerName);
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonGlobal = new JSONObject();
            int totalNumber = 0;
            SpaceFilter spaceFilter = new SpaceFilter();
            ListAccess mySpaces_ = null;
            if (searchCondition != null && !searchCondition.equals("") && !searchCondition.equals("undefined")) {
                spaceFilter.setSpaceNameSearchCondition(searchCondition);
                mySpaces_ = spaceservice.getMemberSpacesByFilter(userIdentity.getRemoteId(), spaceFilter);
            } else if (beginby != null && !beginby.equals("") && !beginby.equals("undefined")) {
                spaceFilter.setFirstCharacterOfSpaceName(beginby.charAt(0));
                mySpaces_ = spaceservice.getMemberSpacesByFilter(userIdentity.getRemoteId(), spaceFilter);
            } else {
                mySpaces_ = spaceservice.getMemberSpaces(userIdentity.getRemoteId());
            }
            boolean isgcmember = false;
            MembershipHandler mHandler = this.orgService.getMembershipHandler();
            if (mHandler.findMembershipByUserGroupAndType(userIdentity.getRemoteId(), SUBS_GROUP, "member") == null) {
                isgcmember = true;
            }
            jsonGlobal.put("isgcmember", isgcmember);
            totalNumber = mySpaces_.getSize();
            if (limit == 0) {
                limit = mySpaces_.getSize();
            }
            mySpaces = Arrays.asList(mySpaces_.load(offset, limit));
            for (Space space : mySpaces) {
                org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", space.getPrettyName(), true);
                Profile sProfile = prIdentity.getProfile();
                JSONObject json = new JSONObject();
                json.put("projectName", (Object)space.getPrettyName());
                json.put("projectDisplayName", (Object)space.getDisplayName());
                json.put("projectDescription", (Object)space.getDescription());
                json.put("projectLocation", (Object)(sProfile.getProperty("city") + ", " + sProfile.getProperty("state")));
                json.put("projectBidDue", sProfile.getProperty("bidsDueDate"));
                json.put("projectPreBidMeeting", sProfile.getProperty("preBidMeetingDate"));
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("totalNbOfMySpaces", totalNumber);
            jsonGlobal.put("mySpaces", (Object)jsonArray);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getsubsbystatus/{projectId}/{status}")
    public Response getSubsbyStatus(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="projectId") String projectId, @PathParam(value="status") String status, @QueryParam(value="isinvitedtable") boolean isinvitedtable, @QueryParam(value="isvendor") boolean isvendor, @QueryParam(value="filteredgroups") String filteredgroups, @QueryParam(value="filteredclassif") String filteredclassifications, @QueryParam(value="searchkey") String SearchKey, @QueryParam(value="isreport") Boolean isreport, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        try {
            int displaylength;
            String sortBy;
            String sortDir;
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            int displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int sEcho = request.getParameter("sEcho") == null ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = request.getParameter("iSortCol_0") == null ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String string = sortDir = request.getParameter("sSortDir_0") == null ? "" : request.getParameter("sSortDir_0");
            if (isinvitedtable) {
                switch (iSortCol) {
                    case 1: {
                        sortBy = "tbb:relCompany";
                        break;
                    }
                    case 2: {
                        sortBy = "tbb:subName";
                        break;
                    }
                    case 3: {
                        sortBy = "tbb:catCsiDesc";
                        break;
                    }
                    case 4: {
                        sortBy = "tbb:status";
                        break;
                    }
                    case 5: {
                        sortBy = "tbb:note";
                        break;
                    }
                    case 6: {
                        sortBy = "tbb:bid";
                        break;
                    }
                    default: {
                        sortBy = "";
                        break;
                    }
                }
            } else {
                switch (iSortCol) {
                    case 0: {
                        sortBy = "tbb:subId";
                        break;
                    }
                    case 1: {
                        sortBy = "tbb:relCompany";
                        break;
                    }
                    case 2: {
                        sortBy = "tbb:subName";
                        break;
                    }
                    case 3: {
                        sortBy = "tbb:catCsiDesc";
                        break;
                    }
                    case 4: {
                        sortBy = "tbb:relPhone";
                        break;
                    }
                    case 5: {
                        sortBy = "tbb:relCity";
                        break;
                    }
                    case 6: {
                        sortBy = "tbb:relState";
                        break;
                    }
                    case 7: {
                        sortBy = "tbb:relCounty";
                        break;
                    }
                    case 8: {
                        sortBy = "tbb:relRank";
                        break;
                    }
                    default: {
                        sortBy = "";
                    }
                }
            }
            String string2 = filteredclassifications = filteredclassifications == null || filteredclassifications.equals("undefined") ? "" : filteredclassifications;
            SearchKey = SearchKey == null || SearchKey.equals("undefined") ? (request.getParameter("sSearch") == null ? "" : request.getParameter("sSearch")) : SearchKey;
            ArrayList<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(request.getParameter("sSearch_1") == null ? "" : request.getParameter("sSearch_1"));
            SearchConditions.add(request.getParameter("sSearch_2") == null ? "" : request.getParameter("sSearch_2"));
            SearchConditions.add(request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("") ? filteredclassifications : request.getParameter("sSearch_3"));
            SearchConditions.add(status == null ? "" : status);
            SearchConditions.add(request.getParameter("sSearch_4") == null ? "" : request.getParameter("sSearch_4"));
            SearchConditions.add(request.getParameter("sSearch_5") == null ? "" : request.getParameter("sSearch_5"));
            SearchConditions.add(request.getParameter("sSearch_6") == null ? "" : request.getParameter("sSearch_6"));
            SearchConditions.add(request.getParameter("sSearch_7") == null ? "" : request.getParameter("sSearch_7"));
            SearchConditions.add(request.getParameter("sSearch_9") == null ? "" : request.getParameter("sSearch_9"));
            SearchConditions.add(request.getParameter("sSearch_10") == null ? "" : request.getParameter("sSearch_10"));
            ArrayList<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            if (filteredgroups != null && filteredgroups.compareTo("") != 0) {
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                String[] filteredarraygroups = filteredgroups.split("\\,");
                for (String filteredgroup : filteredarraygroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        ProjectSubEntity relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                        if (relationShip == null) continue;
                        included.add(relationShip);
                    }
                }
                if (included.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", (Object)jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
                }
            }
            ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(isinvitedtable, isvendor, false, SearchKey, SearchConditions, included, sortBy, sortDir, projectId);
            int n = displaylength = request.getParameter("iDisplayLength") == null ? relList.getSize() : Integer.parseInt(request.getParameter("iDisplayLength"));
            if (isreport != null && isreport.booleanValue()) {
                String[] categoriesinproject = filteredclassifications.split(",");
                int total = 0;
                for (String categoryId : categoriesinproject) {
                    List<ProjectSubEntity> relcatList = projectSubRelationShipStorage.getRelationShipByProjectIdAndCatId(projectId, categoryId, displaystart, displaylength);
                    JSONArray jsoncategories = new JSONArray();
                    for (ProjectSubEntity sub : relcatList) {
                        if (!sub.getStatus().equals("NOT_MESS")) continue;
                        ++total;
                        JSONObject json = new JSONObject();
                        json.put("company", (Object)sub.getSubContractor().getCompany());
                        json.put("rank", (Object)sub.getSubContractor().getRank());
                        json.put("phone", (Object)sub.getSubContractor().getPhone());
                        json.put("faxnumber", (Object)"");
                        json.put("notes", (Object)sub.getNote());
                        json.put("bid", (Object)(sub.getBid() != null ? sub.getBid() : ""));
                        json.put("contact", (Object)sub.getSubContractor().getDisplayName());
                        json.put("categories", (Object)(sub.getCategory().getId() + "-" + sub.getCategory().getCatCsiDesc()));
                        json.put("status", (Object)sub.getStatus());
                        json.put("union", (Object)sub.getSubContractor().getUnion());
                        json.put("nonUnion", (Object)sub.getSubContractor().getNonUnion());
                        if (json.get("categories").toString().contains("(DBE,WBE)")) {
                            json.put("cat_minority", true);
                        } else {
                            json.put("cat_minority", false);
                        }
                        jsoncategories.put((Object)json);
                    }
                    if (jsoncategories.isNull(0)) continue;
                    jsonArray.put((Object)jsoncategories);
                }
            } else {
                for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(displaystart, displaylength)) {
                    SubCatEntity subCat = subCatStorage.getSubCat(sub.getSubContractor().getId() + "_" + sub.getCategory().getId());
                    JSONObject json = new JSONObject();
                    json.put("userName", (Object)sub.getSubContractor().getId());
                    json.put("categories", (Object)(sub.getCategory().getId() + "-" + sub.getCategory().getCatCsiDesc()));
                    json.put("relName", (Object)sub.getId());
                    json.put("company", (Object)sub.getSubContractor().getCompany());
                    json.put("weburl", (Object)subCat.getSubContractor().getWeburl());
                    json.put("proview", (Object)subCat.getSubContractor().getProview());
                    json.put("union", (Object)subCat.getSubContractor().getUnion());
                    json.put("nonUnion", (Object)subCat.getSubContractor().getNonUnion());
                    json.put("phone", (Object)sub.getSubContractor().getPhone());
                    json.put("contact", (Object)sub.getSubContractor().getDisplayName());
                    json.put("subCatId", (Object)(sub.getSubContractor().getId() + "_" + sub.getCategory().getId()));
                    json.put("notes", (Object)sub.getNote());
                    json.put("bid", (Object)(sub.getBid() != null && !sub.getBid().equals("0") ? sub.getBid() : ""));
                    json.put("city", (Object)sub.getSubContractor().getCity());
                    json.put("state", (Object)sub.getSubContractor().getState());
                    json.put("county", (Object)(sub.getSubContractor().getCountry() != null ? sub.getSubContractor().getCountry() : ""));
                    json.put("rank", (Object)sub.getSubContractor().getRank());
                    json.put("categoryId", (Object)sub.getCategory().getId());
                    json.put("status", (Object)sub.getStatus());
                    json.put("selected", (Object)"true");
                    json.put("bbgroups", (Object)"");
                    Boolean isgcmember = this.orgService.getMembershipHandler().findMembershipByUserGroupAndType(sourceIdentity.getRemoteId(), GCS_GROUP, "gcmember") != null;
                    json.put("isgcmember", (Object)isgcmember);
                    jsonArray.put((Object)json);
                }
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", relList.getSize());
            jsonGlobal.put("iTotalDisplayRecords", relList.getSize());
            jsonGlobal.put("aaData", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getallinvitedsubs/{projectId}")
    public Response getAllInvitedSubs(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="projectId") String projectId, @QueryParam(value="isvendor") boolean isvendor, @QueryParam(value="filteredgroups") String filteredgroups, @QueryParam(value="filteredclassif") String filteredclassifications, @QueryParam(value="searchkey") String SearchKey, @QueryParam(value="isreport") Boolean isreport, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            String sortBy;
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            int sEcho = request.getParameter("sEcho") == null ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = request.getParameter("iSortCol_0") == null ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String sortDir = request.getParameter("sSortDir_0") == null ? "" : request.getParameter("sSortDir_0");
            switch (iSortCol) {
                case 1: {
                    sortBy = "tbb:relCompany";
                    break;
                }
                case 2: {
                    sortBy = "tbb:subName";
                    break;
                }
                case 3: {
                    sortBy = "tbb:catCsiDesc";
                    break;
                }
                case 4: {
                    sortBy = "tbb:status";
                    break;
                }
                case 5: {
                    sortBy = "tbb:note";
                    break;
                }
                case 6: {
                    sortBy = "tbb:bid";
                    break;
                }
                default: {
                    sortBy = "";
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            String string = filteredclassifications = filteredclassifications == null || filteredclassifications.equals("undefined") ? "" : filteredclassifications;
            SearchKey = SearchKey == null || SearchKey.equals("undefined") ? (request.getParameter("sSearch") == null ? "" : request.getParameter("sSearch")) : SearchKey;
            ArrayList<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(request.getParameter("sSearch_1") == null ? "" : request.getParameter("sSearch_1"));
            SearchConditions.add(request.getParameter("sSearch_2") == null ? "" : request.getParameter("sSearch_2"));
            SearchConditions.add(request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("") ? filteredclassifications : request.getParameter("sSearch_3"));
            SearchConditions.add(request.getParameter("sSearch_4") == null ? "" : request.getParameter("sSearch_4"));
            SearchConditions.add(request.getParameter("sSearch_5") == null ? "" : request.getParameter("sSearch_5"));
            SearchConditions.add(request.getParameter("sSearch_6") == null ? "" : request.getParameter("sSearch_6"));
            SearchConditions.add("");
            SearchConditions.add("");
            SearchConditions.add(request.getParameter("sSearch_7") == null ? "" : request.getParameter("sSearch_7"));
            SearchConditions.add(request.getParameter("sSearch_8") == null ? "" : request.getParameter("sSearch_8"));
            ArrayList<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            if (filteredgroups != null && filteredgroups.compareTo("") != 0) {
                String[] filteredarraygroups;
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                for (String filteredgroup : filteredarraygroups = filteredgroups.split("\\,")) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        ProjectSubEntity relationShiptoinclude = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                        if (relationShiptoinclude == null) continue;
                        included.add(relationShiptoinclude);
                    }
                }
                if (included.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", (Object)jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
                }
            }
            int displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = request.getParameter("iDisplayLength") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayLength"));
            int total = 0;
            if (isreport == null || !isreport.booleanValue()) {
                ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(true, isvendor, true, SearchKey, SearchConditions, included, sortBy, sortDir, projectId);
                total = relList.getSize();
                for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(displaystart, displaylength)) {
                    SubCatEntity subCat = subCatStorage.getSubCat(sub.getSubContractor().getId() + "_" + sub.getCategory().getId());
                    JSONObject json = new JSONObject();
                    json.put("userName", (Object)sub.getSubContractor().getId());
                    json.put("company", (Object)sub.getSubContractor().getCompany());
                    json.put("weburl", (Object)subCat.getSubContractor().getWeburl());
                    json.put("proview", (Object)subCat.getSubContractor().getProview());
                    json.put("union", (Object)subCat.getSubContractor().getUnion());
                    json.put("nonUnion", (Object)subCat.getSubContractor().getNonUnion());
                    json.put("refUID", (Object)"");
                    json.put("rank", (Object)sub.getSubContractor().getRank());
                    json.put("email", (Object)"");
                    json.put("phone", (Object)sub.getSubContractor().getPhone());
                    json.put("faxnumber", (Object)"");
                    json.put("itbsent", (Object)"");
                    json.put("notes", (Object)sub.getNote());
                    json.put("bid", (Object)(sub.getBid() != null && !sub.getBid().equals("0") ? sub.getBid() : ""));
                    json.put("contact", (Object)sub.getSubContractor().getDisplayName());
                    json.put("categories", (Object)(sub.getCategory().getId() + "-" + sub.getCategory().getCatCsiDesc()));
                    json.put("categoryId", (Object)sub.getCategory().getId());
                    json.put("relName", (Object)sub.getId());
                    json.put("status", (Object)sub.getStatus());
                    json.put("union", (Object)sub.getSubContractor().getUnion());
                    json.put("nonUnion", (Object)sub.getSubContractor().getNonUnion());
                    json.put("bidScoped", (Object)(sub.getBidScoped() != null ? sub.getBidScoped() : "no"));
                    json.put("selected", (Object)"true");
                    json.put("bbgroups", (Object)"");
                    if (json.get("categories").toString().contains("(DBE,WBE)")) {
                        json.put("cat_minority", true);
                    } else {
                        json.put("cat_minority", false);
                    }
                    jsonArray.put((Object)json);
                }
            } else {
                String[] categoriesinproject;
                for (String categoryId : categoriesinproject = filteredclassifications.split(",")) {
                    List<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndCatId(projectId, categoryId, displaystart, displaylength);
                    JSONArray jsoncategories = new JSONArray();
                    for (ProjectSubEntity sub : relList) {
                        if (sub.getStatus().equals("NOT_MESS")) continue;
                        ++total;
                        JSONObject json = new JSONObject();
                        json.put("company", (Object)sub.getSubContractor().getCompany());
                        json.put("rank", (Object)sub.getSubContractor().getRank());
                        json.put("phone", (Object)sub.getSubContractor().getPhone());
                        json.put("faxnumber", (Object)"");
                        json.put("notes", (Object)sub.getNote());
                        json.put("bid", (Object)(sub.getBid() != null ? sub.getBid() : ""));
                        json.put("contact", (Object)sub.getSubContractor().getDisplayName());
                        json.put("categories", (Object)sub.getCategory().getCatCsiDesc());
                        json.put("status", (Object)sub.getStatus());
                        if (json.get("categories").toString().contains("(DBE,WBE)")) {
                            json.put("cat_minority", true);
                        } else {
                            json.put("cat_minority", false);
                        }
                        jsoncategories.put((Object)json);
                    }
                    jsonArray.put((Object)jsoncategories);
                }
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", total);
            jsonGlobal.put("iTotalDisplayRecords", total);
            jsonGlobal.put("aaData", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="getinvitedsubsforreport/{projectId}")
    public Response getInvitedSubsForReport(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="projectId") String projectId, @QueryParam(value="filteredclassif") String filteredclassifications, @QueryParam(value="notinvited") boolean notinvited, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            boolean filtred = false;
            int total = 0;
            try {
                ListAccess<ProjectSubEntity> relList;
                ArrayList<String> SearchConditions;
                ArrayList<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
                List<String> filteredgroups = searchRequest.getFilteredGroups();
                if (filteredgroups != null && filteredgroups.size() > 0) {
                    SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                    for (String filteredgroup : filteredgroups) {
                        List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                        for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                            ProjectSubEntity relationShip = null;
                            try {
                                relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                if (included.contains(relationShip.getId())) continue;
                                included.add(relationShip);
                            }
                            catch (Exception e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
                if (searchRequest.getsSearch_3() != null && !searchRequest.getsSearch_3().equals("")) {
                    filteredclassifications = searchRequest.getsSearch_3();
                    filtred = true;
                }
                String[] categoriesinproject = filtred ? filteredclassifications.split("\\|") : filteredclassifications.split(",");
                if (notinvited) {
                    for (String categoryId : categoriesinproject) {
                        if (!filtred) {
                            categoryId = bBCategoryStorage.getBBCategory(categoryId).getCatCsiDesc();
                        }
                        SearchConditions = new ArrayList<String>();
                        SearchConditions.add(searchRequest.getsSearch_1());
                        SearchConditions.add(searchRequest.getsSearch_2());
                        SearchConditions.add(categoryId);
                        SearchConditions.add("NOT_MESS");
                        SearchConditions.add(searchRequest.getsSearch_5());
                        SearchConditions.add(searchRequest.getsSearch_6());
                        SearchConditions.add(searchRequest.getsSearch_7());
                        SearchConditions.add(searchRequest.getsSearch_9());
                        SearchConditions.add(searchRequest.getsSearch_10());
                        SearchConditions.add(searchRequest.getSearchsubs());
                        relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, false, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);
                        JSONArray jsoncategories = new JSONArray();
                        if (relList.getSize() > 0) {
                            for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                                ++total;
                                JSONObject json = new JSONObject();
                                json.put("company", (Object)sub.getSubContractor().getCompany());
                                json.put("rank", (Object)sub.getSubContractor().getRank());
                                json.put("phone", (Object)sub.getSubContractor().getPhone());
                                json.put("faxnumber", (Object)"");
                                json.put("notes", (Object)sub.getNote());
                                json.put("bid", (Object)(sub.getBid() != null ? sub.getBid() : ""));
                                json.put("contact", (Object)sub.getSubContractor().getDisplayName());
                                json.put("categories", (Object)sub.getCategory().getCatCsiDesc());
                                json.put("status", (Object)sub.getStatus());
                                json.put("city", (Object)sub.getSubContractor().getCity());
                                if (json.get("categories").toString().contains("(DBE,WBE)")) {
                                    json.put("cat_minority", true);
                                } else {
                                    json.put("cat_minority", false);
                                }
                                jsoncategories.put((Object)json);
                            }
                        }
                        jsonArray.put((Object)jsoncategories);
                    }
                } else {
                    for (String categoryId : categoriesinproject) {
                        if (!filtred) {
                            categoryId = bBCategoryStorage.getBBCategory(categoryId).getCatCsiDesc();
                        }
                        SearchConditions = new ArrayList();
                        SearchConditions.add(searchRequest.getsSearch_1());
                        SearchConditions.add(searchRequest.getsSearch_2());
                        SearchConditions.add(categoryId);
                        SearchConditions.add(searchRequest.getsSearch_4());
                        SearchConditions.add(searchRequest.getsSearch_5());
                        SearchConditions.add(searchRequest.getsSearch_6());
                        SearchConditions.add(searchRequest.getsSearch_7());
                        SearchConditions.add(searchRequest.getsSearch_9());
                        SearchConditions.add(searchRequest.getsSearch_10());
                        SearchConditions.add(searchRequest.getSearchsubs());
                        relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, true, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);
                        JSONArray jsoncategories = new JSONArray();
                        if (relList.getSize() > 0) {
                            for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                                if (sub.getStatus().equals("NOT_MESS")) continue;
                                ++total;
                                JSONObject json = new JSONObject();
                                json.put("company", (Object)sub.getSubContractor().getCompany());
                                json.put("rank", (Object)sub.getSubContractor().getRank());
                                json.put("phone", (Object)sub.getSubContractor().getPhone());
                                json.put("faxnumber", (Object)"");
                                json.put("notes", (Object)sub.getNote());
                                json.put("bid", (Object)(sub.getBid() != null ? sub.getBid() : ""));
                                json.put("contact", (Object)sub.getSubContractor().getDisplayName());
                                json.put("categories", (Object)sub.getCategory().getCatCsiDesc());
                                json.put("status", (Object)sub.getStatus());
                                json.put("city", (Object)sub.getSubContractor().getCity());
                                if (json.get("categories").toString().contains("(DBE,WBE)")) {
                                    json.put("cat_minority", true);
                                } else {
                                    json.put("cat_minority", false);
                                }
                                jsoncategories.put((Object)json);
                            }
                        }
                        jsonArray.put((Object)jsoncategories);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error ", new Object[]{e.getMessage()});
            }
            jsonGlobal.put("iTotalRecords", total);
            jsonGlobal.put("iTotalDisplayRecords", total);
            jsonGlobal.put("aaData", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getbbsubs/{projectId}")
    public Response getBbSubs(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="projectId") String projectId, @QueryParam(value="status") String status) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project_ = spaceService.getSpaceByPrettyName(projectId);
            if (project_ == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            org.exoplatform.social.core.identity.model.Identity prIdentity = identityManager.getOrCreateIdentity("space", project_.getPrettyName(), true);
            Profile sProfile = prIdentity.getProfile();
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
            if (status != null && !status.equals("") && !status.equals("undefined")) {
                if (status.equals("notmess")) {
                    status = "NOT_MESS";
                } else if (status.equals("invited")) {
                    status = "INVITED";
                } else if (status.equals("rev")) {
                    status = "REVIEWING";
                } else if (status.equals("bid")) {
                    status = "BIDDING";
                } else if (status.equals("nbid")) {
                    status = "NOT_BIDDING";
                } else if (status.equals("submit")) {
                    status = "AWARDED";
                } else {
                    LOG.info((Object)"Unknown Status");
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unknown Status").build();
                }
                ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndStatusListAccess(projectId, status);
                JSONObject jsonGlobal = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                    SubContractorEntity subinfo = subUserInfoStorage.getSubUserInfo(sub.getSubContractor().getId());
                    JSONObject json = new JSONObject();
                    json.put("userName", (Object)sub.getSubContractor().getId());
                    if (subinfo.getCompany() == null) {
                        json.put("company", (Object)"");
                    } else {
                        json.put("company", (Object)subinfo.getCompany());
                    }
                    if (subinfo.getRefUID() == null) {
                        json.put("refUID", (Object)"");
                    } else {
                        json.put("refUID", (Object)subinfo.getRefUID());
                    }
                    if (subinfo.getDisplayName() == null) {
                        json.put("contact", (Object)"");
                    } else {
                        json.put("contact", (Object)subinfo.getDisplayName());
                    }
                    json.put("categories", (Object)sub.getCategory().getId());
                    json.put("email", (Object)subinfo.getEmail());
                    if (!status.equals("NOT_MESS")) {
                        json.put("accessUrl", (Object)URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + sub.getSubContractor().getId() + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings"));
                    }
                    if (subinfo.getRank() == null) {
                        json.put("rank", 8);
                    } else {
                        json.put("rank", (Object)subinfo.getRank());
                    }
                    if (sProfile.getProperty("url") == null) {
                        json.put("projectUrl", (Object)"");
                    } else {
                        json.put("projectUrl", sProfile.getProperty("url"));
                    }
                    jsonArray.put((Object)json);
                }
                jsonGlobal.put(status, (Object)jsonArray);
                response.setContentType("application/json");
                response.setHeader("Cache-Control", "no-store");
                return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
            }
            String[] status_ = new String[]{"NOT_MESS", "INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "AWARDED"};
            JSONObject jsonGlobal = new JSONObject();
            JSONObject jsonByStat = new JSONObject();
            for (String st : status_) {
                ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndStatusListAccess(projectId, st);
                JSONArray jsonArray = new JSONArray();
                for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                    SubContractorEntity subinfo = subUserInfoStorage.getSubUserInfo(sub.getSubContractor().getId());
                    JSONObject json = new JSONObject();
                    json.put("userName", (Object)sub.getSubContractor().getId());
                    if (subinfo.getCompany() == null) {
                        json.put("company", (Object)"");
                    } else {
                        json.put("company", (Object)subinfo.getCompany());
                    }
                    if (subinfo.getRefUID() == null) {
                        json.put("refUID", (Object)"");
                    } else {
                        json.put("refUID", (Object)subinfo.getRefUID());
                    }
                    if (subinfo.getDisplayName() == null) {
                        json.put("contact", (Object)"");
                    } else {
                        json.put("contact", (Object)subinfo.getDisplayName());
                    }
                    if (subinfo.getFirstName() == null) {
                        json.put("firstname", (Object)"");
                    } else {
                        json.put("firstname", (Object)subinfo.getFirstName());
                    }
                    if (subinfo.getLastName() == null) {
                        json.put("lastname", (Object)"");
                    } else {
                        json.put("lastname", (Object)subinfo.getLastName());
                    }
                    if (subinfo.getPhone() == null) {
                        json.put("phone", (Object)"");
                    } else {
                        json.put("phone", (Object)subinfo.getPhone());
                    }
                    if (subinfo.getStreet() == null) {
                        json.put("address", (Object)"");
                    } else if (subinfo.getAddress2() == null || subinfo.getAddress2().equals("")) {
                        json.put("address", (Object)subinfo.getStreet());
                    } else {
                        json.put("address", (Object)(subinfo.getStreet() + " ; " + subinfo.getAddress2()));
                    }
                    if (subinfo.getCity() == null) {
                        json.put("city", (Object)"");
                    } else {
                        json.put("city", (Object)subinfo.getCity());
                    }
                    if (subinfo.getState() == null) {
                        json.put("state", (Object)"");
                    } else {
                        json.put("state", (Object)subinfo.getState());
                    }
                    if (subinfo.getZip() == null) {
                        json.put("zip", (Object)"");
                    } else {
                        json.put("zip", (Object)subinfo.getZip());
                    }
                    json.put("categories", (Object)sub.getCategory().getId());
                    json.put("bidScoped", (Object)sub.getBidScoped());
                    json.put("email", (Object)subinfo.getEmail());
                    if (!st.equals("NOT_MESS")) {
                        json.put("accessUrl", (Object)URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + sub.getSubContractor().getId() + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings"));
                    }
                    if (subinfo.getRank() == null) {
                        json.put("rank", 8);
                    } else {
                        json.put("rank", (Object)subinfo.getRank());
                    }
                    if (sProfile.getProperty("url") == null) {
                        json.put("projectUrl", (Object)"");
                    } else {
                        json.put("projectUrl", sProfile.getProperty("url"));
                    }
                    jsonArray.put((Object)json);
                }
                jsonByStat.put(st, (Object)jsonArray);
            }
            jsonGlobal.put("vendors", (Object)jsonByStat);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="setbidscop/{projectId}/{bidscop}")
    public Response setBidscop(@Context HttpServletRequest request, @PathParam(value="projectId") String projectId, @PathParam(value="bidscop") String bidscop) {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!bidscop.equals("true") && !bidscop.equals("false")) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"Bid Scope should be true or false").build();
        }
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", projectId, true);
            Profile sProfile = prIdentity.getProfile();
            sProfile.setProperty("bidScop", (Object)bidscop);
            Util.getIdentityManager((String)portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
            LOG.info((Object)"Project bidScop has been Updated successfully");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Project bidScop Updated");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="setsubstatus/{projectId}/{status}/{catId}")
    public Response setsubstatus(@Context HttpServletRequest request, @PathParam(value="projectId") String projectId, @PathParam(value="status") String status, @PathParam(value="catId") String catId, @QueryParam(value="subId") String subId, @QueryParam(value="notes") String notes, @QueryParam(value="bid") String bid) {
        org.exoplatform.social.core.identity.model.Identity userIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (userIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (bid != null && !ProjectRestService.isNumeric(bid)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"Bid Ammount should be a number").build();
        }
        if (subId == null) {
            subId = userIdentity.getRemoteId();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {
            if (status.equals("null")) {
                status = projectSubRelationShipStorage.getRelationShip(subId, projectId, catId).getStatus();
            }
            projectSubRelationShipStorage.updateProjectSubRelationShip(subId + "_" + projectId + "_" + catId, null, status, notes, bid, null, null);
            LOG.info((Object)"Sub Field has been updated successfully");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Field Updated Successfully");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="emailsetsubstatus/{projectId}/{catId}/{subId}/{status}")
    public Response emailSetsubstatus(@Context HttpServletRequest request, @PathParam(value="projectId") String projectId, @PathParam(value="status") String status, @PathParam(value="catId") String catId, @PathParam(value="subId") String subId) {
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {
            projectSubRelationShipStorage.updateProjectSubRelationShip(subId + "_" + projectId + "_" + catId, null, status, null, null, null, null);
            LOG.info((Object)"Sub status has been updated successfully");
            return Response.seeOther((URI)URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + subId + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings")).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="bidscopesubstatus/{projectId}/{subId}/{status}")
    public Response bidScopeSubStatus(@Context HttpServletRequest request, @PathParam(value="projectId") String projectId, @PathParam(value="status") String status, @PathParam(value="subId") String subId) {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {
            ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSubIdListAccess(projectId, subId);
            if (status.equals("UNDECIDED")) {
                status = "REVIEWING";
            }
            if (!(status.equals("BIDDING") || status.equals("NOT_BIDDING") || status.equals("REVIEWING"))) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Wrong Status").build();
            }
            if (relList.getSize() > 0) {
                for (ProjectSubEntity projectSubRelationShip : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                    projectSubRelationShipStorage.updateProjectSubRelationShip(subId + "_" + projectId + "_" + projectSubRelationShip.getCategory().getId(), null, status, null, null, null, null);
                }
                LOG.info((Object)"Sub status has been updated successfully");
                return Response.seeOther((URI)URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + subId + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings")).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No Trades Founds for this Sub in this project").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="getusersreports/{projectId}")
    public Response getUsersReports(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="projectId") String projectId, @QueryParam(value="categoriesId") String categoriesId, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            Node reportingNode;
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            boolean filtred = false;
            boolean total = false;
            ArrayList<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            List<String> filteredgroups = searchRequest.getFilteredGroups();
            if (filteredgroups != null && filteredgroups.size() > 0) {
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                for (String filteredgroup : filteredgroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        ProjectSubEntity relationShip = null;
                        try {
                            relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                            if (included.contains(relationShip.getId())) continue;
                            included.add(relationShip);
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            if (searchRequest.getsSearch_3() != null && !searchRequest.getsSearch_3().equals("")) {
                categoriesId = searchRequest.getsSearch_3();
                filtred = true;
            }
            String[] categoriesinproject = filtred ? categoriesId.split("\\|") : categoriesId.split(",");
            int displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = request.getParameter("iDisplayLength") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayLength"));
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session socialSession = manageableRepository.getSystemSession("social");
            Node socialProductionNode = (Node)socialSession.getItem("/production");
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            if (socialProductionNode.hasNode("reporting") && (reportingNode = socialProductionNode.getNode("reporting")).hasNode(projectId)) {
                Node projectReportingNode = reportingNode.getNode(projectId);
                for (String categoryId : categoriesinproject) {
                    if (!filtred) {
                        categoryId = bBCategoryStorage.getBBCategory(categoryId).getCatCsiDesc();
                    }
                    ArrayList<String> SearchConditions = new ArrayList<String>();
                    SearchConditions.add(searchRequest.getsSearch_1());
                    SearchConditions.add(searchRequest.getsSearch_2());
                    SearchConditions.add(categoryId);
                    SearchConditions.add(searchRequest.getsSearch_4());
                    SearchConditions.add(searchRequest.getsSearch_5());
                    SearchConditions.add(searchRequest.getsSearch_6());
                    SearchConditions.add(searchRequest.getsSearch_7());
                    SearchConditions.add(searchRequest.getsSearch_9());
                    SearchConditions.add(searchRequest.getsSearch_10());
                    SearchConditions.add(searchRequest.getSearchsubs());
                    ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, true, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);
                    JSONArray jsoncategories = new JSONArray();
                    for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                        JSONObject json = new JSONObject();
                        JSONArray docsJsonArray = new JSONArray();
                        json.put("category", (Object)sub.getCategory().getCatCsiDesc());
                        org.exoplatform.social.core.identity.model.Identity subIdentity = identityManager.getOrCreateIdentity("organization", sub.getSubContractor().getId(), true);
                        String subIndentityRemoteId = subIdentity.getRemoteId();
                        if (projectReportingNode.hasNode(subIndentityRemoteId)) {
                            Node userReportingNode = projectReportingNode.getNode(subIndentityRemoteId);
                            json.put("totalVisits", (Object)(userReportingNode.hasProperty(TOTAL_VISITS) ? userReportingNode.getProperty(TOTAL_VISITS).getString() : "0"));
                            json.put("lastVisit", (Object)(userReportingNode.hasProperty(LAST_VISIT) ? userReportingNode.getProperty(LAST_VISIT).getString() : ""));
                            NodeIterator nodeIterator = userReportingNode.getNodes();
                            while (nodeIterator.hasNext()) {
                                Node docReportingNode = nodeIterator.nextNode();
                                JSONObject docJson = new JSONObject();
                                Session collaborationSession = manageableRepository.getSystemSession(COLLABORATION_WORKSPACE);
                                Node docNode = collaborationSession.getNodeByUUID(docReportingNode.getName());
                                docJson.put("documentTitle", (Object)docNode.getName());
                                docJson.put("documentParentPath", (Object)docNode.getParent().getPath());
                                docJson.put("totalViews", (Object)(docReportingNode.hasProperty(TOTAL_VIEWS) ? docReportingNode.getProperty(TOTAL_VIEWS).getString() : "0"));
                                docJson.put("totalDownloads", (Object)(docReportingNode.hasProperty(TOTAL_DOWNLOADS) ? docReportingNode.getProperty(TOTAL_DOWNLOADS).getString() : "0"));
                                docsJsonArray.put((Object)docJson);
                            }
                        } else {
                            json.put("totalVisits", (Object)"0");
                            json.put("lastVisit", (Object)"");
                        }
                        json.put("company", (Object)sub.getSubContractor().getCompany());
                        json.put("vendor", (Object)sub.getSubContractor().getDisplayName());
                        json.put("docs", (Object)docsJsonArray);
                        jsoncategories.put((Object)json);
                    }
                    jsonArray.put((Object)jsoncategories);
                }
            }
            jsonGlobal.put("aaData", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getcategories")
    public Response getCategories(@Context HttpServletRequest request, @Context HttpServletResponse response, @QueryParam(value="projectId") String projectId, @QueryParam(value="notmessaged") Boolean notmessaged) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ArrayList<String> catList = new ArrayList<String>();
            JSONArray jsonArray = new JSONArray();
            if (projectId != null) {
                ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
                List<ProjectSubEntity> relList = null;
                if (notmessaged != null && notmessaged.booleanValue()) {
                    relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndStatus(projectId, "NOT_MESS", 0, 0);
                    for (ProjectSubEntity sub : relList) {
                        if (catList.contains(sub.getCategory().getId())) continue;
                        catList.add(sub.getCategory().getId());
                    }
                } else {
                    relList = projectSubRelationShipStorage.getRelationShipByProjectId(projectId, 0, 0);
                    for (ProjectSubEntity sub : relList) {
                        if (catList.contains(sub.getCategory().getId()) || sub.getStatus().equals("NOT_MESS")) continue;
                        catList.add(sub.getCategory().getId());
                    }
                }
                for (ProjectSubEntity sub : relList) {
                    if (catList.contains(sub.getCategory().getId()) || sub.getStatus().equals("NOT_MESS")) continue;
                    catList.add(sub.getCategory().getId());
                }
                for (String cat : catList) {
                    if (bBCategoryStorage.getBBCategory(cat) != null) {
                        JSONObject json = new JSONObject();
                        json.put("CategoryId", (Object)cat);
                        json.put("Category", (Object)bBCategoryStorage.getBBCategory(cat).getCatCsiDesc());
                        jsonArray.put((Object)json);
                        continue;
                    }
                    LOG.error((Object)("Can not get Category with ID: " + cat));
                }
            } else {
                for (CategoryEntity bbcat : bBCategoryStorage.getBBCategories(0, 0)) {
                    JSONObject json = new JSONObject();
                    json.put("CategoryId", (Object)bbcat.getFieldName());
                    json.put("Category", (Object)bbcat.getCatCsiDesc());
                    jsonArray.put((Object)json);
                }
            }
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonArray.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value=">/{projectId}")
    public Response getCategoriesStats(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="projectId") String projectId, @QueryParam(value="notinvited") boolean notinvited, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            ArrayList<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            List<String> filteredgroups = searchRequest.getFilteredGroups();
            if (filteredgroups != null && filteredgroups.size() > 0) {
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                for (String filteredgroup : filteredgroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        ProjectSubEntity relationShip = null;
                        try {
                            relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                            if (included.contains(relationShip.getId())) continue;
                            included.add(relationShip);
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            ListAccess<ProjectSubEntity> relList = null;
            ArrayList<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(searchRequest.getsSearch_1());
            SearchConditions.add(searchRequest.getsSearch_2());
            SearchConditions.add(searchRequest.getsSearch_3());
            SearchConditions.add(searchRequest.getsSearch_4());
            SearchConditions.add(searchRequest.getsSearch_5());
            SearchConditions.add(searchRequest.getsSearch_6());
            SearchConditions.add(searchRequest.getsSearch_7());
            SearchConditions.add(searchRequest.getsSearch_9());
            SearchConditions.add(searchRequest.getsSearch_10());
            SearchConditions.add(searchRequest.getSearchsubs());
            relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, !notinvited, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);
            int displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = request.getParameter("iDisplayLength") == null ? relList.getSize() : Integer.parseInt(request.getParameter("iDisplayLength"));
            int sEcho = request.getParameter("sEcho") == null ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            ArrayList<String> catList = new ArrayList<String>();
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (ProjectSubEntity sub : (ProjectSubEntity[])relList.load(displaystart, displaylength)) {
                if (!notinvited && sub.getStatus().equals("NOT_MESS") || catList.contains(sub.getCategory().getId())) continue;
                catList.add(sub.getCategory().getId());
            }
            List<String> status = null;
            status = notinvited ? Arrays.asList("NOT_MESS") : Arrays.asList("INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "AWARDED");
            for (String cat : catList) {
                if (bBCategoryStorage.getBBCategory(cat) == null) {
                    LOG.warn((Object)("Can not find the category with this ID: " + cat));
                    continue;
                }
                JSONObject json = new JSONObject();
                for (String status_ : status) {
                    json.put("Category", (Object)bBCategoryStorage.getBBCategory(cat).getCatCsiDesc());
                    json.put(status_, projectSubRelationShipStorage.getRelationShipsCountbyProjectIdCatIdAndstatus(projectId, cat, status_));
                }
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", catList.size());
            jsonGlobal.put("iTotalDisplayRecords", catList.size());
            jsonGlobal.put("aaData", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getmessinfo/{projectId}")
    @Consumes(value={"application/json"})
    public Response getMessInfo(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !ProjectRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        String status = "";
        CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            JSONObject jsGlobal = new JSONObject();
            JSONObject sender = new JSONObject();
            JSONObject company = new JSONObject();
            JSONObject json = new JSONObject();
            json.put("projectId", (Object)project.getPrettyName());
            json.put("projectName", (Object)project.getDisplayName());
            json.put("projectDescription", (Object)project.getDescription());
            json.put("url", (Object)project.getUrl());
            if (project.getAvatarUrl() != null && project.getAvatarUrl() != "") {
                json.put("avatar", (Object)project.getAvatarUrl());
            } else {
                json.put("avatar", (Object)"/ProjectSpace-portlets/skin/images/article-cnt1.jpg");
            }
            org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", projectId, true);
            Profile sProfile = prIdentity.getProfile();
            json.put("ownerType", (Object)ProjectRestService.getOwnerType(sProfile.getProperty("ownerType")));
            json.put("ownerTypeId", (Object)sProfile.getProperty("ownerTypeId").toString());
            json.put("projectStatus", (Object)sProfile.getProperty("projectStatus").toString());
            json.put("projectStatusId", (Object)sProfile.getProperty("projectStatusId").toString());
            json.put("projectType", (Object)ProjectRestService.getType(sProfile.getProperty("projectType")));
            json.put("projectTypeId", (Object)sProfile.getProperty("projectTypeId").toString());
            json.put("nbBuildings", sProfile.getProperty("nbBuildings"));
            json.put("storiesAboveGrd", sProfile.getProperty("storiesAboveGrd"));
            json.put("storiesBelowGrd", sProfile.getProperty("storiesBelowGrd"));
            json.put("totalSqFt", sProfile.getProperty("totalSqFt"));
            json.put("projectValuation", sProfile.getProperty("projectValuation"));
            json.put("preBidMeetingDate", sProfile.getProperty("preBidMeetingDate"));
            json.put("bidsDueDate", sProfile.getProperty("bidsDueDate"));
            json.put("startDate", sProfile.getProperty("startDate"));
            json.put("creator", sProfile.getProperty("creator"));
            json.put("union", Boolean.parseBoolean((String)sProfile.getProperty("union")));
            json.put("nonUnion", Boolean.parseBoolean((String)sProfile.getProperty("nonUnion")));
            json.put("prevailingWage", Boolean.parseBoolean((String)sProfile.getProperty("prevailingWage")));
            json.put("chkleed", Boolean.parseBoolean((String)sProfile.getProperty("chkleed")));
            json.put("chkbim", Boolean.parseBoolean((String)sProfile.getProperty("chkbim")));
            json.put("goal1", sProfile.getProperty("goal1"));
            json.put("goal1Id", sProfile.getProperty("goal1Id"));
            json.put("goal2", sProfile.getProperty("goal2"));
            json.put("goal2Id", sProfile.getProperty("goal2Id"));
            json.put("goal3", sProfile.getProperty("goal3"));
            json.put("goal3Id", sProfile.getProperty("goal3Id"));
            json.put("goal1pct", sProfile.getProperty("goal1pct"));
            json.put("goal2pct", sProfile.getProperty("goal2pct"));
            json.put("goal3pct", sProfile.getProperty("goal3pct"));
            json.put("bidSecurity", sProfile.getProperty("bidSecurity"));
            json.put("performanceBond", sProfile.getProperty("performanceBond"));
            json.put("paymentBond", sProfile.getProperty("paymentBond"));
            json.put("mbeGoal", sProfile.getProperty("mbeGoal"));
            json.put("dbeGoal", sProfile.getProperty("dbeGoal"));
            json.put("hubzone", sProfile.getProperty("hubzone"));
            json.put("leed", sProfile.getProperty("leed"));
            json.put("bim", sProfile.getProperty("bim"));
            json.put("adress", sProfile.getProperty("adress"));
            json.put("city", sProfile.getProperty("city"));
            json.put("state", sProfile.getProperty("state"));
            json.put("zip", sProfile.getProperty("zip"));
            json.put("country", sProfile.getProperty("country"));
            json.put("architect", sProfile.getProperty("architect"));
            json.put("engineer", sProfile.getProperty("engineer"));
            json.put("owner", sProfile.getProperty("owner"));
            json.put("geoPosition", sProfile.getProperty("geoPosition"));
            json.put("url", sProfile.getProperty("url"));
            json.put("status", (Object)status);
            JSONArray qualification = new JSONArray();
            ArrayList<String> qualiList = new ArrayList<String>();
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdListAccess(projectId);
            for (ProjectSubEntity rel : (ProjectSubEntity[])relList.load(0, relList.getSize())) {
                if (qualiList.contains(rel.getCategory().getId())) continue;
                JSONObject cat = new JSONObject();
                if (bBCategoryStorage.getBBCategory(rel.getCategory().getId()) != null) {
                    cat.put("categorieName", (Object)bBCategoryStorage.getBBCategory(rel.getCategory().getId()).getCatCsiDesc());
                    cat.put("categoryId", (Object)rel.getCategory().getId());
                    qualiList.add(rel.getCategory().getId());
                    qualification.put((Object)cat);
                    continue;
                }
                LOG.error((Object)("Can not get Category with ID: " + rel.getCategory().getId()));
            }
            json.put("classifications", (Object)qualification);
            UserHandler uh = this.orgService.getUserHandler();
            User user = uh.findUserByName(sourceIdentity.getRemoteId());
            if (user == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            org.exoplatform.social.core.identity.model.Identity userId = identityManager.getOrCreateIdentity("organization", user.getUserName());
            sender.put("senderId", (Object)sourceIdentity.getRemoteId());
            sender.put("firstName", (Object)user.getFirstName());
            sender.put("lastName", (Object)user.getLastName());
            sender.put("displayName", (Object)user.getDisplayName());
            sender.put("email", (Object)user.getEmail());
            Profile uProfile = userId.getProfile();
            if (uProfile.getPhones() != null) {
                sender.put("phone", ((Map)uProfile.getPhones().get(0)).get("value"));
            }
            sender.put("fax", uProfile.getProperty("faxnumber") == null ? "" : uProfile.getProperty("faxnumber"));
            HashMap uiMap = new HashMap();
            if (!sender.has("position") || sender.get("position") == null) {
                sender.put("position", (Object)"Employee");
            }
            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            company.put("companyName", (Object)companyInfo.getCompanyName());
            company.put("companyProview", (Object)companyInfo.getCompanyProview());
            company.put("companyStreet", (Object)companyInfo.getCompanyStreet());
            company.put("companyState", (Object)companyInfo.getCompanyState());
            company.put("companyCity", (Object)companyInfo.getCompanyCity());
            company.put("companyZip", (Object)companyInfo.getCompanyZip());
            company.put("companyWebSite", (Object)companyInfo.getCompanyWebSite());
            company.put("companyPhone", (Object)companyInfo.getCompanyPhone());
            company.put("companyAvatar", (Object)"/portal/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png");
            jsGlobal.put("project", (Object)json);
            jsGlobal.put("sender", (Object)sender);
            jsGlobal.put("company", (Object)company);
            return Response.ok((Object)jsGlobal.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    public void updateBidScopStatus(String uid, String projectId, String refuid, String bidStatus) {
        ChangeBidScopeStatusRunner changeBidScopeStatusRunner = new ChangeBidScopeStatusRunner(uid, projectId, refuid, bidStatus, ConversationState.getCurrent());
        Thread changeBidScopeStatusThread = new Thread((Runnable)changeBidScopeStatusRunner, "Change BidScope Status Runner Thread");
        changeBidScopeStatusThread.start();
    }
}

