/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FilterComponentPluginsFromContainer
extends BaseContainerLifecyclePlugin {
    private static final Log LOG = ExoLogger.getLogger((String)"FilterComponentPluginsFromContainer");
    private Set<String> toDeletedComponents = new HashSet<String>();
    private Set<String> filteredComponents = new HashSet<String>();
    private Set<String> toDeletePlugins = new HashSet<String>();
    private Set<String> toDeletePluginNames = new HashSet<String>();

    public void initContainer(ExoContainer container) {
        this.addEntries("exo.container.delete.components", this.toDeletedComponents);
        this.addEntries("exo.container.filter.components", this.filteredComponents);
        this.filteredComponents.removeAll(this.toDeletedComponents);
        this.addEntries("exo.container.delete.plugins.types", this.toDeletePlugins);
        this.addEntries("exo.container.delete.plugins.names", this.toDeletePluginNames);
        for (String componentKey : this.toDeletedComponents) {
            LOG.info((Object)("Delete component : " + componentKey));
            try {
                Class<?> compponentClass = Class.forName(componentKey);
                ComponentAdapter componentAdapter = container.getComponentAdapterOfType(compponentClass);
                if (componentAdapter == null) {
                    LOG.warn("'{}' component wasn't found in container, coponent deletion ignored.", new Object[]{componentKey});
                    continue;
                }
                container.unregisterComponent(compponentClass);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Can't delete component '{}' because class is not found.", new Object[]{componentKey});
            }
        }
        ConfigurationManager cm = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
        Configuration configuration = cm.getConfiguration();
        Collection loadedComponents = configuration.getComponents();
        for (Component component : loadedComponents) {
            List componentPlugins = component.getComponentPlugins();
            String componentKey = component.getKey();
            this.filterComponentPlugins(componentPlugins, componentKey);
        }
        Iterator iterator = configuration.getExternalComponentPluginsIterator();
        while (iterator.hasNext()) {
            ExternalComponentPlugins externalComponentPlugins = (ExternalComponentPlugins)iterator.next();
            String componentKey = externalComponentPlugins.getTargetComponent();
            List componentPlugins = externalComponentPlugins.getComponentPlugins();
            this.filterComponentPlugins(componentPlugins, componentKey);
        }
    }

    private void addEntries(String propertyName, Set<String> impactedEntries) {
        String[] componentsArray;
        System.setProperty("exo.notifications.portalname", "Jeremy & Ella Construction");
        String entries = "";
        if (propertyName.equals("exo.container.filter.components")) {
            entries = "org.exoplatform.calendar.service.CalendarService";
        }
        if (propertyName.equals("exo.container.delete.plugins.types")) {
            entries = "org.exoplatform.cs.ext.impl.CalendarSpaceActivityPublisher";
        }
        if (entries.isEmpty()) {
            return;
        }
        for (String componentKey : componentsArray = entries.split(",")) {
            if (componentKey == null || componentKey.isEmpty()) continue;
            try {
                Class.forName(componentKey);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Uknown Class '{}', verify settings putted in configuration.properties file.", new Object[]{componentKey});
            }
            impactedEntries.add(componentKey.trim());
        }
    }

    private void filterComponentPlugins(List<ComponentPlugin> componentPlugins, String componentKey) {
        if (!this.filteredComponents.contains(componentKey)) {
            return;
        }
        LOG.info("Delete some component plugins of component '{}'", new Object[]{componentKey});
        if (componentPlugins == null || componentPlugins.isEmpty()) {
            return;
        }
        Iterator<ComponentPlugin> iterator = componentPlugins.iterator();
        while (iterator.hasNext()) {
            ComponentPlugin componentPlugin = iterator.next();
            if (!this.toDeletePlugins.contains(componentPlugin.getType()) && !this.toDeletePluginNames.contains(componentPlugin.getName())) continue;
            LOG.info((Object)("Disable component plugin : " + componentPlugin.getType()));
            iterator.remove();
        }
    }
}

