package org.exoplatform.ps.DAO;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.List;

public class StaffDAO extends GenericDAOJPAImpl<StaffEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(StaffDAO.class);
    private  StaffEntity staffEntity = new StaffEntity();

    public List<StaffEntity> getStaffByGcAndRole(String role, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("pSStaffEntity.getStaffByGcAndRole", StaffEntity.class)
                        .setParameter("role",role)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("pSStaffEntity.getStaffByGcAndRole", StaffEntity.class)
                        .setParameter("role",role)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", e);
            throw e;
        }
    }
    public List<StaffEntity> getStaffByGc(Long gcId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("pSStaffEntity.getStaffByGc", StaffEntity.class)
                        .setParameter("gcId",gcId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("pSStaffEntity.getStaffByGc", StaffEntity.class)
                        .setParameter("gcId",gcId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", e);
            throw e;
        }
    }

}