package org.exoplatform.ps.DTO;


import lombok.Data;
import org.exoplatform.ps.entity.ProjectSubEntity;

import java.util.Calendar;

@Data
public class ProjectRelClone {


    private String id;
    private String subId;
    private String catId;
    private String path;
    private String status;
    private String subName;
    private String projectId;
    private String relRank;
    private String relCompany;
    private String catCsiDesc;
    private String note;
    private String bid;
    private String relPhone;
    private String relCity;
    private String relState;
    private String relCounty;
    private Calendar createdTime;



    public ProjectRelClone(ProjectSubEntity projectSubEntity) {
        this.id = projectSubEntity.getId();
        this.subId = projectSubEntity.getSubContractor().getId();
        this.catId = projectSubEntity.getCategory().getId();
        this.path = projectSubEntity.getPath();
        this.status = projectSubEntity.getStatus();
        this.subName = projectSubEntity.getSubContractor().getDisplayName();
        this.projectId = projectSubEntity.getProjectId();
        this.relRank = projectSubEntity.getSubContractor().getRank();
        this.relCompany = projectSubEntity.getSubContractor().getCompany();
        this.catCsiDesc = projectSubEntity.getCategory().getCatCsiDesc();
        this.note = projectSubEntity.getNote();
        this.bid = projectSubEntity.getBid();
        this.relPhone = projectSubEntity.getSubContractor().getPhone();
        this.relCity = projectSubEntity.getSubContractor().getCity();
        this.relState = projectSubEntity.getSubContractor().getState();
        this.relCounty = projectSubEntity.getSubContractor().getCountry();
        this.createdTime = projectSubEntity.getUpdatedate();
    }


}
