/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.chromattic.entity;

import org.chromattic.api.annotations.*;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;

/**
 */
@PrimaryType(name = "tbb:subCatGroupRelation")
@FormattedBy(BaseEncodingObjectFormatter.class)
@NamingPrefix("tbb")
public abstract class SubCatGroupRelation {

    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Path
    public abstract String getPath();


    @Property(name = "tbb:subCatGroupRelationId")
    public abstract String getSubCatGroupRelationId();

    public abstract void setSubCatGroupRelationId(String subCatGroupRelationId);

    @Property(name = "tbb:subGroupId")
    public abstract String getSubGroupId();

    public abstract void setSubGroupId(String subGroupId);

    @Property(name = "tbb:subGroupName")
    public abstract String getSubGroupName();

    public abstract void setSubGroupName(String subGroupName);

    @Property(name = "tbb:subCatId")
    public abstract String getSubCatId();

    public abstract void setSubCatId(String subCatId);

    @Property(name = "tbb:subId")
    public abstract String getSubId();

    public abstract void setSubId(String subId);

    @Property(name = "tbb:subName")
    public abstract String getSubName();

    public abstract void setSubName(String subName);

    @Property(name = "tbb:catId")
    public abstract String getCatId();

    public abstract void setCatId(String catId);

    @Property(name = "tbb:catName")
    public abstract String getCatName();

    public abstract void setCatName(String catName);

}