/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.chromattic.entity;

import org.chromattic.api.annotations.*;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;

/**
 */
@PrimaryType(name = "tbb:subUserInfo")
@FormattedBy(BaseEncodingObjectFormatter.class)
@NamingPrefix("tbb")
public abstract class SubUserInfo {

    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Path
    public abstract String getPath();


    @Property(name = "tbb:firstName")
    public abstract String getFirstName();

    public abstract void setFirstName(String firstName);

    @Property(name = "tbb:lastName")
    public abstract String getLastName();

    public abstract void setLastName(String lastName);

    @Property(name = "tbb:displayName")
    public abstract String getDisplayName();

    public abstract void setDisplayName(String displayName);

    @Property(name = "tbb:email")
    public abstract String getEMail();

    public abstract void setEMail(String email);

    @Property(name = "tbb:secondemail")
    public abstract String getSecondemail();

    public abstract void setSecondemail(String secondemail);

    @Property(name = "tbb:webSite")
    public abstract String getWebSite();

    public abstract void setWebSite(String webSite);

    @Property(name = "tbb:notes")
    public abstract String getNotes();

    public abstract void setNotes(String notes);

    @Property(name = "tbb:phone")
    public abstract String getPhone();

    public abstract void setPhone(String phone);

    @Property(name = "tbb:mainPhoneType")
    public abstract String getMainPhoneType();

    public abstract void setMainPhoneType(String mainPhoneType);

    @Property(name = "tbb:secondPhone")
    public abstract String getSecondPhone();

    public abstract void setSecondPhone(String secondPhone);

    @Property(name = "tbb:secondPhoneType")
    public abstract String getSecondPhoneType();

    public abstract void setSecondPhoneType(String secondPhoneType);

    @Property(name = "tbb:faxnumber")
    public abstract String getFaxnumber();

    public abstract void setFaxnumber(String faxnumber);

    @Property(name = "tbb:company")
    public abstract String getCompany();

    public abstract void setCompany(String company);

    @Property(name = "tbb:refUID")
    public abstract String getRefUID();

    public abstract void setRefUID(String refUID);

    @Property(name = "tbb:city")
    public abstract String getCity();

    public abstract void setCity(String city);

    @Property(name = "tbb:state")
    public abstract String getState();

    public abstract void setState(String state);

    @Property(name = "tbb:county")
    public abstract String getCounty();

    public abstract void setCounty(String county);

    @Property(name = "tbb:country")
    public abstract String getCountry();

    public abstract void setCountry(String country);

    @Property(name = "tbb:lonlat")
    public abstract String getLonLat();

    public abstract void setLonLat(String lonLat);

    @Property(name = "tbb:street")
    public abstract String getStreet();

    public abstract void setStreet(String street);

    @Property(name = "tbb:address2")
    public abstract String getAddress2();

    public abstract void setAddress2(String address2);

    @Property(name = "tbb:zip")
    public abstract String getZip();

    public abstract void setZip(String zip);

    @Property(name = "tbb:skills")
    public abstract String[] getSkills();

    public abstract void setSkills(String[] skills);

    @Property(name = "tbb:rank")
    public abstract String getRank();

    public abstract void setRank(String rank);

    @Property(name = "tbb:proview")
    public abstract String getProview();

    public abstract void setProview(String proview);

    @Property(name = "tbb:prevailingWage")
    public abstract String getPrevailingWage();

    public abstract void setPrevailingWage(String prevailingWage);

    @Property(name = "tbb:union")
    public abstract String getUnion();

    public abstract void setUnion(String union);

    @Property(name = "tbb:nonUnion")
    public abstract String getNonUnion();

    public abstract void setNonUnion(String nonUnion);

    @Property(name = "tbb:categories")
    public abstract String getCategories();

    public abstract void setCategories(String categories);

    @Property(name = "tbb:categoriesId")
    public abstract String getCategoriesId();

    public abstract void setCategoriesId(String categoriesId);

    @Property(name = "tbb:StructureEntity")
    public abstract String getStructure();

    public abstract void setStructure(String structure);

    @Property(name = "tbb:structureId")
    public abstract String getStructureId();

    public abstract void setStructureId(String structureId);

    @Property(name = "tbb:weburl")
    public abstract String getWeburl();

    public abstract void setWeburl(String weburl);

    @Property(name = "tbb:tagsArray")
    public abstract String[] getTagsArray();

    public abstract void setTagsArray(String[] tagsArray);

}