package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.ps.DTO.SubContractor;

import javax.persistence.*;

@Entity(name = "PSSubGCEntity")
@ExoEntity
@Table(name = "PS_ADDON_SUB_GC")

@NamedQueries({
        @NamedQuery(name = "pSSubGCEntity.getSubsGcByGc", query = "SELECT a FROM PSSubGCEntity a where a.generalcontractor.id  = :gcId"),
        @NamedQuery(name = "pSSubGCEntity.getSubsByGc", query = "SELECT a.subContractor FROM PSSubGCEntity a where a.generalcontractor.id  = :gcId"),
        @NamedQuery(name = "pSSubGCEntity.getSubCatsByGcCount", query = "SELECT count(a.id) FROM PSSubGCEntity a where a.generalcontractor.id  = :gcId")

})


@Data
public class SubGcEntity {

    @Id
    @Column(name = "SUB_GC_ID", nullable = false)
    private String id;



    @ManyToOne
    @JoinColumn(name = "SUB_CONTRACTOR_ID", nullable = false)
    private SubContractorEntity subContractor ;

    @ManyToOne
    @JoinColumn(name = "GENERAL_CONTRACTOR_ID", nullable = false)
    private GeneralContractorEntity generalcontractor ;

    public SubGcEntity(SubContractorEntity subContractor, GeneralContractorEntity generalcontractor) {
        this.id=subContractor.getId()+"_"+generalcontractor.getId();
        this.subContractor = subContractor;
        this.generalcontractor = generalcontractor;
    }
}
