package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;

@Entity(name = "PSSubStaffCompanyEntity")
@ExoEntity
@Table(name = "PS_ADDON_COMPANY_STAFF")
@Data

@NamedQueries({
        @NamedQuery(name = "PSSubStaffCompanyEntity.getSubCompanyByStaff", query = "SELECT a FROM PSSubStaffCompanyEntity a where a.userid = :staffId"),

})

public class SubStaffCompanyEntity {

    @Id
    @Column(name = "USER_ID", nullable = false)
    private String  userid ;

    @ManyToOne
    @JoinColumn(name = "SUB_CONTRACTOR_ID")
    private SubContractorEntity subContractorEntity;


    @Column(name = "ROLE")
    private String role;

    public SubStaffCompanyEntity() {

    }

    public SubStaffCompanyEntity(SubContractorEntity subContractorEntity, String userid) {
        this.subContractorEntity = subContractorEntity;
        this.userid = userid;
    }
}
