/*
 * Copyright (C) 2003-2015 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.integration.notification;

import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate.ElementType;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.gatein.common.text.EntityEncoder;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@TemplateConfigs(templates = {

    @TemplateConfig(pluginId = PSSendITBPlugin.ID, template = "war:/notification/templates/mail/PSSendITBPlugin.gtmpl"),
    @TemplateConfig(pluginId = PSSendMsgPlugin.ID, template = "war:/notification/templates/mail/PSSendMsgPlugin.gtmpl"),
    @TemplateConfig(pluginId = PSCreateProjectPlugin.ID, template = "war:/notification/templates/mail/PSCreateProjectPlugin.gtmpl")

})
public class MailTemplateProvider extends TemplateProvider {
  //--- Use a dedicated DateFormatter to handle date pattern coming from underlying levels : Wed Mar 15 01:00:00 CET 2017
  // --- Create formatter
  protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
  //protected DateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
  protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);

  public MailTemplateProvider(InitParams initParams) {
    super(initParams);

    this.templateBuilders.put(PluginKey.key(PSSendITBPlugin.ID), new TemplateBuilder());
    this.templateBuilders.put(PluginKey.key(PSSendMsgPlugin.ID), new TemplateBuilder());
    this.templateBuilders.put(PluginKey.key(PSCreateProjectPlugin.ID), new TemplateBuilder());
  }


  private class TemplateBuilder extends AbstractTemplateBuilder {
    @Override
    protected MessageInfo makeMessage(NotificationContext ctx) {

      EntityEncoder encoder = HTMLEntityEncoder.getInstance();
      
      NotificationInfo notification = ctx.getNotificationInfo();
      String language = getLanguage(notification);
      log.info("Prepare Mail notif for "+ notification.getKey().getId());
      String creator = notification.getValueOwnerParameter(NotificationUtils.CREATOR);
      String creatorStaff = notification.getValueOwnerParameter(NotificationUtils.CREATORSTAFF);
      String gc_contact = notification.getValueOwnerParameter(NotificationUtils.GC_CONTACT);
      String gc_phone = notification.getValueOwnerParameter(NotificationUtils.GC_PHONE);
      String description = notification.getValueOwnerParameter(NotificationUtils.PROJECT_DESCRIPTION);
      String companyname = notification.getValueOwnerParameter(NotificationUtils.COMPANY_NAME);
      String projectname = notification.getValueOwnerParameter(NotificationUtils.PROJECTNAME);
      String ProjectUrl = notification.getValueOwnerParameter(NotificationUtils.PROJECTURL);
      String url = notification.getValueOwnerParameter(NotificationUtils.URLPROJECT);
      String subcontractor = notification.getValueOwnerParameter(NotificationUtils.SUB_CONTRACTOR);
      String projectStatus = notification.getValueOwnerParameter(NotificationUtils.PROJECTSTATUS);
      String projectType = notification.getValueOwnerParameter(NotificationUtils.PROJECTTYPE);
      String totalSqFt = notification.getValueOwnerParameter(NotificationUtils.TOTALSQFT);
      String ownerType = notification.getValueOwnerParameter(NotificationUtils.OWNERTYPE);
      String categorie = notification.getValueOwnerParameter(NotificationUtils.CATEGORIE);
      String bidsDueDate = notification.getValueOwnerParameter(NotificationUtils.BIDS_DUE);
      String mail = notification.getValueOwnerParameter(NotificationUtils.EMAIL);
      String sub_company = notification.getValueOwnerParameter(NotificationUtils.SUB_COMPANY);
      String phone = notification.getValueOwnerParameter(NotificationUtils.PHONE);
      String pre_bid = notification.getValueOwnerParameter(NotificationUtils.PRE_BID);
      String pre_bid_meeting = notification.getValueOwnerParameter(NotificationUtils.PRE_BID_MEETING);
      String stories_above_grd = notification.getValueOwnerParameter(NotificationUtils.STORIES_ABOVE_GRD);
      String nbBuildings = notification.getValueOwnerParameter(NotificationUtils.NBRBUILDING);
      String contact = notification.getValueOwnerParameter(NotificationUtils.CONTACT);
      String endDate = notification.getValueOwnerParameter(NotificationUtils.END_DATE);
      String start_date = notification.getValueOwnerParameter(NotificationUtils.START_DATE);
      String period = notification.getValueOwnerParameter(NotificationUtils.PERIOD);
      TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
      IdentityManager identityManager = CommonsUtils.getService(IdentityManager.class);
      Identity author = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, creator, true);
      Profile profile = author.getProfile();
      //creator
      templateContext.put("USER", encoder.encode(profile.getFullName()));
      templateContext.put("AVATAR", LinkProviderUtils.getUserAvatarUrl(profile));
      templateContext.put("PROFILE_URL", LinkProviderUtils.getRedirectUrl("user", author.getRemoteId()));
      //receiver
      Identity receiver = CommonsUtils.getService(IdentityManager.class).getOrCreateIdentity(OrganizationIdentityProvider.NAME, notification.getTo(), true);
      templateContext.put("FIRST_NAME", encoder.encode(receiver.getProfile().getProperty(Profile.FIRST_NAME).toString()));




      //
        if(contact !=null) {
            templateContext.put("CONTACT", contact);
        }
        if(description !=null) {
            templateContext.put("PROJECT_DESCRIPTION", description);
        }

        if(sub_company !=null) {
            templateContext.put("SUB_COMPANY", sub_company);
        }

        if(subcontractor !=null) {
            templateContext.put("SUB_CONTRACTOR", subcontractor);
        }
        if(companyname !=null) {
            templateContext.put("COMPANY_NAME", companyname);
        }


        if(gc_contact !=null) {
            templateContext.put("GC_CONTACT", gc_contact);
        }
        if(gc_phone !=null) {
            templateContext.put("GC_PHONE", gc_phone);
        }
         if(creatorStaff !=null) {
            templateContext.put("CREATORSTAFF", creatorStaff);
        }


        if(phone !=null) {
            templateContext.put("PHONE", phone);
        }

        if(start_date !=null) {
            templateContext.put("START_DATE", start_date);
        }

        if(nbBuildings !=null) {
            templateContext.put("NBRBUILDING", nbBuildings);
        }

        if(stories_above_grd !=null) {
            templateContext.put("STORIES_ABOVE_GRD", stories_above_grd);
        }

        templateContext.put("URLPROJECT", url != null ? url:"");

      if(ProjectUrl!=null) {
        templateContext.put("PROJECTURL", ProjectUrl);
      }

      if(pre_bid_meeting!=null) {
        templateContext.put("PRE_BID_MEETING", pre_bid_meeting);
      }

      if(mail!=null) {
        templateContext.put("EMAIL", mail);
      }

      if(pre_bid!=null) {
        templateContext.put("PRE_BID", pre_bid);
      }

      if(projectname!=null) {
        templateContext.put("PROJECTNAME", projectname);
      }
      if(projectStatus!=null) {
        templateContext.put("PROJECTSTATUS", projectStatus);
      }
      if(projectType!=null) {
        templateContext.put("PROJECTTYPE", projectType);
      }
      if(totalSqFt!=null) {
        templateContext.put("TOTALSQFT", totalSqFt);
      }
      if(ownerType!=null) {
        templateContext.put("OWNERTYPE", ownerType);
      }

      if(categorie!=null) {
        templateContext.put("CATEGORIE", categorie);
        }


      if(period!=null) {
        templateContext.put("PERIOD", period);
      }

      if(creator!=null) {
        templateContext.put("CREATOR", creator);
      }

      if(bidsDueDate!=null) {
        templateContext.put("BIDS_DUE", bidsDueDate);
      }

      if (endDate != null && !endDate.equals("")) {
        templateContext.put("END_DATE", CSUtils.formatDate(endDate, CSUtils.getUserTimezone(notification.getTo())));
      }




      templateContext.put("FOOTER_LINK", LinkProviderUtils.getRedirectUrl("notification_settings", receiver.getRemoteId()));
      String subject = TemplateUtils.processSubject(templateContext);

      String body = TemplateUtils.processGroovy(templateContext);
      //binding the exception throws by processing template
      ctx.setException(templateContext.getException());
      MessageInfo messageInfo = new MessageInfo();
      return messageInfo.subject(subject).body(body).end();
    }

    @Override
    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
      EntityEncoder encoder = HTMLEntityEncoder.getInstance();
      
      List<NotificationInfo> notifications = ctx.getNotificationInfos();
      NotificationInfo first = notifications.get(0);

      String language = getLanguage(first);
      TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
      //
      Identity receiver = CommonsUtils.getService(IdentityManager.class).getOrCreateIdentity(OrganizationIdentityProvider.NAME, first.getTo(), true);
      templateContext.put("FIRST_NAME", encoder.encode(receiver.getProfile().getProperty(Profile.FIRST_NAME).toString()));
      templateContext.put("FOOTER_LINK", LinkProviderUtils.getRedirectUrl("notification_settings", receiver.getRemoteId()));
      
      try {
        writer.append(buildDigestMsg(notifications, templateContext));
      } catch (IOException e) {
        ctx.setException(e);
        return false;
      }
      return true;
    }

    protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
      EntityEncoder encoder = HTMLEntityEncoder.getInstance();

      Map<String, List<NotificationInfo>> map = new HashMap<String, List<NotificationInfo>>();
      for (NotificationInfo notif : notifications) {
        String subcontractor = notif.getValueOwnerParameter(NotificationUtils.SUB_CONTRACTOR);
        List<NotificationInfo> tmp = map.get(subcontractor);
        if (tmp == null) {
          tmp = new LinkedList<NotificationInfo>();
          map.put(subcontractor, tmp);
        }
        tmp.add(notif);
      }

      StringBuilder sb = new StringBuilder();
      for (String subcontractor : map.keySet()) {
        List<NotificationInfo> notifs = map.get(subcontractor);
        NotificationInfo first = notifs.get(0);
        String categorie = first.getValueOwnerParameter(NotificationUtils.CATEGORIE);
        if (notifs.size() == 1) {
          templateContext.digestType(ElementType.DIGEST_ONE.getValue());
        } else {
          templateContext.digestType(ElementType.DIGEST_MORE.getValue());
        }
        sb.append("<li style=\"margin:0 0 13px 14px;font-size:13px;line-height:18px;font-family:HelveticaNeue,Helvetica,Arial,sans-serif\"><div style=\"color: #333;\">");
        String digester = TemplateUtils.processDigest(templateContext);
        sb.append(digester);
        sb.append("</div></li>");
      }
      return sb.toString();
    }
  }


  public static String getExcerpt(String str, int len) {
    if (str == null) {
      return "";
    } else if (str.length() > len) {
      str = str.substring(0, len);
      int lastSpace = str.lastIndexOf(" ");
      return ((lastSpace > 0) ? str.substring(0, lastSpace) : str) + "...";
    } else {
      return str;      
    }
  }


  protected String getDate(String date, String userName) {
    if (date != null) {
      Date date_ = new Date(Long.parseLong(date));
      return org.exoplatform.ps.integration.notification.TemplateUtils.format(date_,getUserTimezone(userName));
    } else {
      return "";
    }
  }


  public TimeZone getUserTimezone(String username) {
    try {
      CalendarService calService=  CommonsUtils.getService(CalendarService.class);
      CalendarSetting setting = calService.getCalendarSetting(username);
      return TimeZone.getTimeZone(setting.getTimeZone());
    } catch (Exception e) {
      log.error("Can't retrieve timezone", e);
    }
    return null;
  }

}
