/*
 * Copyright (C) 2003-2014 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.rest;

import org.exoplatform.ps.reporting.ReportingService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@Path("/bbdownloadservice")
public class DownloadRestService implements ResourceContainer {

    @GET
    @Path("/download/{nodesPath:.*}")
    public Response download(@PathParam("nodesPath") String nodesPath) throws Exception {
        String mimeType = "application/zip";
        List<Node> listNodes = new ArrayList<Node>();
        String[] splittedNodesPath = nodesPath.split(";");
        RepositoryService repositoryService = (RepositoryService) PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        ReportingService reportingService = (ReportingService) PortalContainer.getInstance().getComponentInstanceOfType(ReportingService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String projectDisplayName = new String();
        SpaceService spaceService = Util.getSpaceService("portal");
        for (String nodePath : splittedNodesPath) {
            Session session = manageableRepository.getSystemSession(nodePath.split(":")[0]);
            Node node = (Node) session.getItem(nodePath.split(":")[1]);
            if (node.isNodeType("nt:file")) {
                if (nodePath.split(":")[1].contains("/Groups/spaces/")) {
                    if (nodePath.split(":")[1].split("/Groups/spaces/")[1].split("/Documents/").length > 1) {
                        projectDisplayName = spaceService.getSpaceByPrettyName(nodePath.split(":")[1].split("/Groups/spaces/")[1].split("/Documents/")[0]).getDisplayName();
                        reportingService.docDownloadsReporting(node);
                        listNodes.add(node);
                    }
                } else {
                    projectDisplayName = "Personal Documents";
                    listNodes.add(node);
                }
            }
        }
        String fileName = projectDisplayName + ".zip";
        return Response.ok(zip(listNodes), mimeType).header("Content-Disposition", "attachment; filename=\"" + fileName + "\"").build();
    }

    private InputStream zip(List<Node> listNodes) throws Exception {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(byteArrayOutputStream);
        for (Node node : listNodes) {
            InputStream fin = node.getNode("jcr:content").getProperty("jcr:data").getStream();
            zout.putNextEntry(new ZipEntry(node.getName()));
            int length;
            while ((length = fin.read(buffer)) > 0) {
                zout.write(buffer, 0, length);
            }
            zout.closeEntry();
            fin.close();
        }
        zout.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }
}