/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.storage.api;

import org.exoplatform.ps.entity.CategoryEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubContractorEntity;

import java.util.List;

/**

 */
public interface SubCatStorage {

    public abstract SubCatEntity createSubCat(String subId, String catId, SubContractorEntity userProfile, String subRank, String catAbrDesc, String catFullDesc, String catCsiDesc) throws Exception;
    public abstract SubCatEntity createSubCat(String subcatId, CategoryEntity cat, SubContractorEntity sub, String subRank) throws Exception;

    public abstract void deleteSubCat(String subCatName) throws Exception;

    public abstract void updateSubCat(String subCatName, SubContractorEntity userProfile, String subRank) throws Exception;

    public abstract SubCatEntity getSubCat(String subCatName) throws Exception;

    public abstract List<SubCatEntity> getSubCatsBySubId(String subId, int offset, int limit) throws Exception;

    public abstract List<SubCatEntity> getSubCatsByCatId(String catId, int offset, int limit) throws Exception;

    public abstract List<SubCatEntity> subCatSearch(boolean isVendor, String searchCondition, List<String> SearchConditions, List<SubCatEntity> excluded, List<SubCatEntity> include, String orderBy, String order, long offset, long limit) throws Exception;

    public abstract int subCatSearchCount(boolean isVendor, String searchCondition, List<String> SearchConditions, List<SubCatEntity> excluded, List<SubCatEntity> include) throws Exception;

}
