package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.chromattic.entity.SimpleNotification;
import org.exoplatform.ps.chromattic.entity.SimpleNotificationsLocation;
import org.exoplatform.ps.storage.api.SimpleNotifServiceStorage;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.impl.StorageUtils;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.WhereExpression;

import javax.jcr.Node;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Medamine on 20/10/2014.
 * <p/>
 * type of notif can be: "success","info","warn","error"
 */
public class SimpleNotifServiceStorageImpl extends AbstractStorage implements SimpleNotifServiceStorage {


    /**
     * Logger
     */
    private static final Log LOG = ExoLogger.getLogger(SimpleNotifServiceStorageImpl.class);
    private static final String CHROMATTIC_LIFECYCLE_NAME = "tbb";
    private ChromatticLifeCycle lifeCycle;

    public SimpleNotifServiceStorageImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator) {
        this.lifeCycle = chromatticManager.getLifeCycle("tbb");
    }

    public ChromatticSession getSession() {
        return lifeCycle.getChromattic().openSession();
    }

    @Override
    public void createSimpleNotification(String userId, String summary, String type, int number) throws Exception {
        Node node = getSession().getJCRSession().getRootNode();
        node = node.getNode("production");
        if (!node.hasNode("simplenotifs")) {
            node = node.addNode("simplenotifs", "tbb:simpleNotificationLocation");
            node.addMixin("mix:referenceable");
            node.getSession().save();
        } else {
            node = node.getNode("simplenotifs");
        }
        Long lId = System.currentTimeMillis();
        while ((SimpleNotification) getSession().findByPath(SimpleNotification.class, "/production/simplenotifs/" + String.valueOf(userId + lId), true) != null) {
            lId++;
        }

        SimpleNotificationsLocation parentNode = (SimpleNotificationsLocation) getSession().findByPath(SimpleNotificationsLocation.class, node.getPath(), true);
        SimpleNotification notif = (SimpleNotification) getSession().create(SimpleNotification.class, userId + lId);
        getSession().persist(parentNode, notif);
        getSession().save();
        notif.setSummary(summary);
        notif.setType(type);
        notif.setUserId(userId);
        notif.setNumber(number);
        getSession().save();

    }

    @Override
    public void deleteSimpleNotification(String notifId) throws Exception {
        ChromatticSession session = getSession();
        try {
            SimpleNotification notif = (SimpleNotification) session.findByPath(SimpleNotification.class, "/production/simplenotifs/" + notifId, true);
            if (notif != null) {
                session.remove(notif);
                session.save();
            } else {
                LOG.error("Node to delete not found");
            }
        } catch (Exception e) {

            LOG.error(e.getMessage(), e);
        } finally {
            //session.close();
        }
    }

    @Override
    public List<SimpleNotification> getSimpleNotificationsByUserId(String userId, long offset, long limit) throws Exception {
        QueryBuilder<SimpleNotification> builder = getSession().createQueryBuilder(SimpleNotification.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, "/production/simplenotifs" + StorageUtils.SLASH_STR + StorageUtils.PERCENT_STR);
        PropertyLiteralExpression<String> condition = new PropertyLiteralExpression(String.class, "tbb:userId");
        whereExpression.and().equals(condition, userId);
        builder.where(whereExpression.toString());
        org.chromattic.core.query.QueryImpl<SimpleNotification> queryImpl = (org.chromattic.core.query.QueryImpl) builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl) queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult<SimpleNotification> results = null;
        if (Long.valueOf(limit) == 0) {
            results = queryImpl.objects();

        } else {
            results = queryImpl.objects(Long.valueOf(offset), Long.valueOf(limit));

        }
        List<SimpleNotification> sResult = new ArrayList();
        while (results.hasNext()) sResult.add((SimpleNotification) results.next());

        return sResult;
    }


}
