package org.exoplatform.ps.web;

import org.exoplatform.web.filter.Filter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by Medamine on 13/01/2015.
 */
public class WrongSiteFilter implements Filter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse) servletResponse;
        String initialURI = httpServletRequest.getRequestURI();
        if (initialURI.contains("/portal/intranet/")) {
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.sendRedirect(initialURI.replace("intranet", "gc-portal"));
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}
