/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.listeners;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;

public class CustomizeProjectDriveListener
extends SpaceListenerPlugin {
    public static final String SPECIAL_CHARACTER_REPLACEMENT = "___";
    private static final Log LOG = ExoLogger.getLogger(CustomizeProjectDriveListener.class);
    private static final String GROUPS_PATH = "groupsPath";
    public static String WORKSPACE = "collaboration";
    private static final String PLAN_ROOM_TEAM = "planroomteam";
    private static final String INTEGRATION_USER = "integrationuser";
    private final RepositoryService repositoryService_;
    private ManageDriveService driveService_;
    private SpaceService spaceService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String groupsPath_;
    private Identity userIdentity;
    private IdentityManager identityManager;
    private static final String SYMLINK_PARENT_NAME = "My Project Documents";
    private static final String SYMLIN_TYPE = "exo:symlink";
    private static final String PRIVATE_DRIVE_EXT = "/Private";
    private static final String WORKSPACE_PROPERTY = "exo:workspace";
    private static final String UUID = "exo:uuid";
    private static final String GROP_FOLDER_PATH = "/Groups";
    private static final String PRIMARY_TYPE = "exo:primaryType";
    private static final String EXO_OWNER = "exo:owner";

    public CustomizeProjectDriveListener(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, ManageDriveService driveService, SpaceService spaceService) throws Exception {
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.driveService_ = driveService;
        this.spaceService_ = spaceService;
    }

    private static Node createFolder(Session session, Node parentNode, String name) throws Exception {
        Node orgIntServNode = parentNode.addNode(name, "nt:folder");
        if (orgIntServNode.canAddMixin("exo:privilegeable")) {
            orgIntServNode.addMixin("exo:privilegeable");
        }
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        String subgroupIdentity = "*:/organization/subcontractors";
        String gcsgroupIdentity = "*:/organization/gcs";
        String rootIdentity = PropertyManager.getProperty((String)"exo.super.user");
        permissionsMap.put(subgroupIdentity, PermissionType.DEFAULT_AC);
        permissionsMap.put(gcsgroupIdentity, PermissionType.ALL);
        permissionsMap.put(rootIdentity, PermissionType.ALL);
        permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
        permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
        if (permissionsMap != null && !permissionsMap.isEmpty()) {
            ((ExtendedNode)orgIntServNode).setPermissions(permissionsMap);
        }
        parentNode.getSession().save();
        orgIntServNode.getSession().save();
        return orgIntServNode;
    }

    private static Node createToBeTreatedFolder(Session session, Node parentNode, String name) throws Exception {
        Node orgIntServNode = parentNode.addNode(name, "nt:folder");
        if (orgIntServNode.canAddMixin("exo:privilegeable")) {
            orgIntServNode.addMixin("exo:privilegeable");
        }
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        String rootIdentity = PropertyManager.getProperty((String)"exo.super.user");
        String gcsAdminGroupIdentity = "gcadmin:/organization/gcs";
        String gcsManagerGroupIdentity = "gcmanager:/organization/gcs";
        permissionsMap.put(gcsAdminGroupIdentity, PermissionType.ALL);
        permissionsMap.put(gcsManagerGroupIdentity, PermissionType.ALL);
        permissionsMap.put(rootIdentity, PermissionType.ALL);
        permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
        permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
        if (permissionsMap != null && !permissionsMap.isEmpty()) {
            ((ExtendedNode)orgIntServNode).setPermissions(permissionsMap);
        }
        parentNode.getSession().save();
        orgIntServNode.getSession().save();
        return orgIntServNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spaceCreated(SpaceLifeCycleEvent event) {
        LOG.info((Object)"CustomizeProjectDriveListener Launched");
        Space space = event.getSpace();
        Session session = null;
        try {
            session = this.repositoryService_.getCurrentRepository().getSystemSession(WORKSPACE);
            Node rootNode = session.getRootNode();
            Node groupFolder = rootNode.getNode("Groups" + space.getGroupId() + "/Documents");
            HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
            String subgroupIdentity = "*:/organization/subcontractors";
            String gcsgroupIdentity = "*:/organization/gcs";
            String rootIdentity = PropertyManager.getProperty((String)"exo.super.user");
            permissionsMap.put(subgroupIdentity, PermissionType.DEFAULT_AC);
            permissionsMap.put(gcsgroupIdentity, PermissionType.ALL);
            permissionsMap.put(rootIdentity, PermissionType.ALL);
            permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
            permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
            if (permissionsMap != null && !permissionsMap.isEmpty()) {
                ((ExtendedNode)groupFolder).setPermissions(permissionsMap);
            }
            Node bid = CustomizeProjectDriveListener.createFolder(session, groupFolder, "BID DOCUMENTS");
            CustomizeProjectDriveListener.createFolder(session, bid, "Drawings");
            CustomizeProjectDriveListener.createFolder(session, bid, "Specs");
            CustomizeProjectDriveListener.createFolder(session, bid, "Addenda");
            CustomizeProjectDriveListener.createFolder(session, groupFolder, "Project Photos");
            CustomizeProjectDriveListener.createFolder(session, groupFolder, "Project Contracts");
            CustomizeProjectDriveListener.createFolder(session, groupFolder, "Transmittals");
            CustomizeProjectDriveListener.createToBeTreatedFolder(session, groupFolder, "DOCs to be TREATED");
            this.groupsPath_ = this.nodeHierarchyCreator_.getJcrPath(GROUPS_PATH);
            String groupId = space.getGroupId();
            String name = space.getPrettyName();
            String workspace = WORKSPACE;
            String permissions = "*:".concat(groupId);
            String homePath = this.groupsPath_ + groupId + "/Documents";
            String views = "BBIcons, BBList";
            String icon = "";
            boolean viewPreferences = false;
            boolean viewNonDocument = true;
            boolean viewSideBar = true;
            boolean showHiddenNode = false;
            String allowCreateFolder = "true";
            String allowNodeTypesOnTree = "*";
            this.driveService_.addDrive(name, workspace, permissions, homePath, views, icon, viewPreferences, viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
            session.save();
            org.exoplatform.ps.utils.Utils.addToSpace(space, PLAN_ROOM_TEAM);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
        Session session = null;
        Node userfolder = null;
        try {
            String companyName;
            session = this.repositoryService_.getCurrentRepository().getSystemSession(WORKSPACE);
            Node SubmittalsFolder = session.getRootNode().getNode("Groups" + event.getSpace().getGroupId() + "/Documents/Transmittals");
            SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
            SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo((String)event.getSource());
            if (userInfo != null && userInfo.getCompany() != null && !(companyName = userInfo.getCompany()).equals("")) {
                if (!SubmittalsFolder.hasNode(Text.escapeIllegalJcrChars((String)Utils.cleanString((String)companyName)))) {
                    userfolder = SubmittalsFolder.addNode(Text.escapeIllegalJcrChars((String)Utils.cleanString((String)companyName)), "nt:folder");
                }
                if ((userfolder = SubmittalsFolder.getNode(Text.escapeIllegalJcrChars((String)Utils.cleanString((String)companyName)))).canAddMixin("exo:privilegeable")) {
                    userfolder.addMixin("exo:privilegeable");
                }
                HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
                String gcsgroupIdentity = "*:/organization/gcs";
                String rootIdentity = PropertyManager.getProperty((String)"exo.super.user");
                permissionsMap.put(event.getTarget(), PermissionType.ALL);
                permissionsMap.put(gcsgroupIdentity, PermissionType.ALL);
                permissionsMap.put(rootIdentity, PermissionType.ALL);
                permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
                permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
                if (permissionsMap != null && !permissionsMap.isEmpty()) {
                    ((ExtendedNode)userfolder).setPermissions(permissionsMap);
                }
                SubmittalsFolder.getSession().save();
                userfolder.getSession().save();
            }
        }
        catch (PathNotFoundException PNFE) {
            LOG.error((Object)("Groups" + event.getSpace().getGroupId() + "/Documents/Transmittals Not Found"));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void left(SpaceLifeCycleEvent event) {
        Session session = null;
        try {
            String userName = (String)event.getSource();
            Space space = event.getSpace();
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            session = this.repositoryService_.getCurrentRepository().getSystemSession(WORKSPACE);
            Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userName);
            String privatePathUserFolder = userNode.getPath().concat(PRIVATE_DRIVE_EXT);
            Node symLinkParent = (Node)session.getItem(privatePathUserFolder);
            if (!symLinkParent.hasNode(SYMLINK_PARENT_NAME)) {
                return;
            }
            symLinkParent = symLinkParent.getNode(SYMLINK_PARENT_NAME);
            Node linkNode = null;
            if (symLinkParent.hasNode(space.getDisplayName())) {
                linkNode = symLinkParent.getNode(space.getDisplayName());
                linkNode.remove();
                symLinkParent.getSession().save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }

    public void addInvitedUser(SpaceLifeCycleEvent event) {
    }

    public void addPendingUser(SpaceLifeCycleEvent event) {
    }

    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceBannerEdited(SpaceLifeCycleEvent spaceLifeCycleEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLink(String userName, Session session, Space space) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String privatePathUserFolder = "";
        String groupPathFolder = "";
        try {
            Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userName);
            privatePathUserFolder = userNode.getPath().concat(PRIVATE_DRIVE_EXT);
            groupPathFolder = GROP_FOLDER_PATH;
            groupPathFolder = groupPathFolder + space.getGroupId() + "/Documents";
            Node symLinkParent = (Node)session.getItem(privatePathUserFolder);
            if (!symLinkParent.hasNode(SYMLINK_PARENT_NAME)) {
                if ((symLinkParent = symLinkParent.addNode(SYMLINK_PARENT_NAME, "nt:folder")).canAddMixin("exo:privilegeable")) {
                    symLinkParent.addMixin("exo:privilegeable");
                }
                ((ExtendedNode)symLinkParent).setPermission(IdentityConstants.ANY, new String[]{"read"});
                symLinkParent.getSession().save();
            } else {
                symLinkParent = symLinkParent.getNode(SYMLINK_PARENT_NAME);
            }
            Node targetNode = (Node)session.getItem(groupPathFolder);
            Node linkNode = null;
            if (!symLinkParent.hasNode(space.getDisplayName())) {
                linkNode = this.createLink(symLinkParent, SYMLIN_TYPE, targetNode, space.getDisplayName());
                ((ExtendedNode)linkNode).setPermission(IdentityConstants.ANY, new String[]{"read"});
                linkNode.save();
            }
        }
        catch (Exception e) {
            LOG.error("An error occurs while processing the creation of Spaces Symlink ", new Object[]{e.getMessage()});
        }
        finally {
            if (session != null) {
                session.logout();
            }
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private Node createLink(Node parent, String linkType, Node target, String linkName) throws RepositoryException {
        if (!target.isNodeType(SYMLIN_TYPE)) {
            Node linkNode;
            block6: {
                if (target.canAddMixin("mix:referenceable")) {
                    target.addMixin("mix:referenceable");
                    target.getSession().save();
                }
                if (linkType == null || linkType.trim().length() == 0) {
                    linkType = SYMLIN_TYPE;
                }
                if (linkName == null || linkName.trim().length() == 0) {
                    linkName = target.getName();
                }
                linkNode = parent.addNode(linkName, linkType);
                try {
                    this.updateAccessPermissionToLink(linkNode, target);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error("CAN NOT UPDATE ACCESS PERMISSIONS FROM TARGET NODE TO LINK NODE", new Object[]{e.getMessage()});
                }
            }
            linkNode.setProperty(WORKSPACE_PROPERTY, target.getSession().getWorkspace().getName());
            linkNode.setProperty(PRIMARY_TYPE, target.getPrimaryNodeType().getName());
            linkNode.setProperty(UUID, target.getUUID());
            linkNode.getSession().save();
            return linkNode;
        }
        return null;
    }

    private boolean canChangePermission(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission("add_node,set_property,remove");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private void updateAccessPermissionToLink(Node linkNode, Node targetNode) throws Exception {
        if (this.canChangePermission(linkNode)) {
            if (linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
                ((ExtendedNode)linkNode).setPermission(this.getNodeOwner(linkNode), PermissionType.ALL);
            }
            this.removeCurrentIdentites(linkNode);
            HashMap<String, String[]> perMap = new HashMap<String, String[]>();
            List permsList = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            for (AccessControlEntry accessEntry : ((ExtendedNode)targetNode).getACL().getPermissionEntries()) {
                if (idList.contains(accessEntry.getIdentity())) continue;
                idList.add(accessEntry.getIdentity());
                permsList = ((ExtendedNode)targetNode).getACL().getPermissions(accessEntry.getIdentity());
                perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[permsList.size()]));
            }
            ((ExtendedNode)linkNode).setPermissions(perMap);
        }
    }

    private String getNodeOwner(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (node.hasProperty(EXO_OWNER)) {
            return node.getProperty(EXO_OWNER).getString();
        }
        return IdentityConstants.SYSTEM;
    }

    private void removeCurrentIdentites(Node linkNode) throws AccessControlException, RepositoryException {
        String currentUser = linkNode.getSession().getUserID();
        if (currentUser != null) {
            ((ExtendedNode)linkNode).setPermission(currentUser, PermissionType.ALL);
        }
        for (AccessControlEntry accessEntry : ((ExtendedNode)linkNode).getACL().getPermissionEntries()) {
            if (!this.canRemovePermission(linkNode, accessEntry.getIdentity()) || ((ExtendedNode)linkNode).getACL().getPermissions(accessEntry.getIdentity()).size() <= 0 || accessEntry.getIdentity().equals(currentUser)) continue;
            ((ExtendedNode)linkNode).removePermission(accessEntry.getIdentity());
        }
    }

    private boolean canRemovePermission(Node node, String identity) throws ValueFormatException, PathNotFoundException, RepositoryException {
        String owner = this.getNodeOwner(node);
        if (identity.equals(IdentityConstants.SYSTEM)) {
            return false;
        }
        return owner == null || !owner.equals(identity);
    }
}

