/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.util.ArrayList;
import java.util.List;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.ps.DTO.SubContractor;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ImportRunner
implements Runnable {
    private static final Log LOG = ExoLogger.getLogger((String)ImportRunner.class.getName());
    private static final String portalContainerName = "portal";
    private static Boolean requestStarted = false;
    OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    private List<SubContractor> users = new ArrayList<SubContractor>(1);
    private Identity sourceIdentity;
    private String projectId;
    private ChromatticLifeCycle tbb;
    private ChromatticManager chromatticManager;
    private ConversationState myConversationState;

    ImportRunner(List<SubContractor> users, String projectId, Identity sourceIdentity, ConversationState conversationState) {
        this.users = users;
        this.projectId = projectId;
        this.sourceIdentity = sourceIdentity;
        this.myConversationState = conversationState;
    }

    @Override
    public void run() {
        LOG.info((Object)"==================Importing Runner Thread started==================");
        Long start = System.currentTimeMillis();
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            ConversationState.setCurrent((ConversationState)this.myConversationState);
            LOG.info((Object)("Conversation state import:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
            this.createVendors();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            LOG.info((Object)("=============================== Importing Runner Thread ended in " + String.valueOf(System.currentTimeMillis() - start) + " ms ===============================."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createVendors() throws Exception {
        IdentityManager identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
        UserHandler uh = this.orgService.getUserHandler();
        MembershipTypeHandler mtHandler = this.orgService.getMembershipTypeHandler();
        GroupHandler gHandler = this.orgService.getGroupHandler();
        MembershipHandler mHandler = this.orgService.getMembershipHandler();
        Space project = null;
        if (this.projectId != null && !this.projectId.equals("")) {
            project = spaceService.getSpaceByPrettyName(this.projectId);
        }
        LOG.info((Object)("Conversation state import:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
        LOG.info((Object)("PortalContainer import:   " + PortalContainer.getInstance().getName()));
        User user_ = null;
        int i = 0;
        for (SubContractor userIn : this.users) {
            LOG.info((Object)("Importing user " + userIn.getFirstName() + " " + userIn.getLastName()));
            String name = "gc_" + userIn.getUserid();
            name = name.toLowerCase();
            name = name.replace(" ", "");
            name = name.replace(".", "");
            Query query = new Query();
            query.setEmail(userIn.getEmail().toLowerCase());
            try {
                if (!this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0 && uh.findUserByName(name) == null) {
                    user_ = ((User[])uh.findUsersByQuery(query).load(0, 1))[0];
                    LOG.warn((Object)(userIn.getEmail() + " already exists, Email should be changed"));
                    String newEmail = "change_me" + user_.getUserName() + "@gmail.com";
                    user_.setEmail(newEmail);
                    this.startRequest();
                    uh.saveUser(user_, false);
                    this.endRequest();
                    SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
                    this.chromatticManager = (ChromatticManager)PortalContainer.getInstance().getComponentInstanceOfType(ChromatticManager.class);
                    this.tbb = this.chromatticManager.getLifeCycle("tbb");
                    this.chromatticManager.beginRequest();
                    ChromatticSession session = this.tbb.getChromattic().openSession();
                    SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(user_.getUserName());
                    userInfo.setEmail(newEmail);
                    session.save();
                    this.chromatticManager.endRequest(true);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (uh.findUserByName(name) != null) {
                    this.startRequest();
                    user_ = uh.findUserByName(name);
                    user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
                    if (this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                        user_.setPassword(Utils.getMd5(name));
                    } else {
                        user_.setPassword(name);
                    }
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.saveUser(user_, false);
                    this.endRequest();
                } else {
                    this.startRequest();
                    user_ = uh.createUserInstance(name);
                    user_.setDisplayName(userIn.getDisplayName());
                    if (this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                        user_.setPassword(Utils.getMd5(name));
                    } else {
                        user_.setPassword(name);
                    }
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.createUser(user_, false);
                    Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                    mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                    Group usersGroup = gHandler.findGroupById("/platform/users");
                    mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                    LOG.info((Object)("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " created"));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.endRequest();
            }
            if (!userIn.getStatus().equals("notmess") && project != null) {
                try {
                    identityManager.getOrCreateIdentity("space", project.getPrettyName(), true);
                    Utils.addToSpace(project, user_.getUserName());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ++i;
        }
        LOG.info((Object)"Vendors Created");
        ActivityManager activityManager = (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    private void startRequest() {
        if (this.orgService instanceof ComponentRequestLifecycle) {
            LOG.info((Object)("Conversation state import2:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
            LOG.info((Object)("PortalContainer import2:   " + PortalContainer.getInstance().getName()));
            ((ComponentRequestLifecycle)this.orgService).startRequest((ExoContainer)PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    private void endRequest() {
        if (requestStarted.booleanValue() && this.orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle)this.orgService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            requestStarted = false;
        }
    }
}

