/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.integration.notification;

import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="PSSendITBPlugin", template="war:/notification/templates/web/PSSendITBPlugin.gtmpl"), @TemplateConfig(pluginId="PSSendMsgPlugin", template="war:/notification/templates/web/PSSendMsgPlugin.gtmpl"), @TemplateConfig(pluginId="PSCreateProjectPlugin", template="war:/notification/templates/web/PSCreateProjectPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
    protected static Log log = ExoLogger.getLogger(WebTemplateProvider.class);

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"PSSendITBPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"PSSendMsgPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"PSCreateProjectPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String pluginId = notification.getKey().getId();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String creator = notification.getValueOwnerParameter("creator");
            String url = notification.getValueOwnerParameter("url");
            String subcontractor = notification.getValueOwnerParameter("subcontractor");
            String categorie = notification.getValueOwnerParameter("categorie");
            String projectname = notification.getValueOwnerParameter("projectname");
            String ProjectUrl = notification.getValueOwnerParameter("ProjectUrl");
            String userName = notification.getValueOwnerParameter("userName");
            String endDate = notification.getValueOwnerParameter("endDate");
            String period = notification.getValueOwnerParameter("period");
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", creator, true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName().toString()));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()));
            templateContext.put((Object)"URLPROJECT", (Object)(url != null ? url : ""));
            if (subcontractor != null) {
                templateContext.put((Object)"SUB_CONTRACTOR", (Object)subcontractor);
            }
            if (ProjectUrl != null) {
                templateContext.put((Object)"PROJECTURL", (Object)ProjectUrl);
            }
            if (categorie != null) {
                templateContext.put((Object)"CATEGORIE", (Object)categorie);
            }
            if (projectname != null) {
                templateContext.put((Object)"PROJECTNAME", (Object)projectname);
            }
            if (creator != null) {
                templateContext.put((Object)"CREATOR", (Object)creator);
            }
            if (period != null) {
                templateContext.put((Object)"PERIOD", (Object)period);
            }
            if (endDate != null && !endDate.equals("")) {
                templateContext.put((Object)"END_DATE", (Object)CSUtils.formatDate(endDate, CSUtils.getUserTimezone(notification.getTo())));
            }
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    }
}

