/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubStaffCompanyDAO;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.entity.SubStaffCompanyEntity;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.service.rest.Util;

public class Utils {
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "collaboration";
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String UPLOAD_FOLDER_NODE_URI = "uploadFolderNodeUri";
    private static final String UPLOAD_FOLDER_NODE_NAME = "uploadFolderNodeName";
    private static final String FILE_SPACES = "files:spaces";
    private static final String POPUP_COMPOSER = "UIPopupComposer";
    private static final String SUBS_GROUP = "/organization/subcontractors";
    private static OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    private static SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
    private static IdentityManager identityManager = (IdentityManager)PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
    private static ActivityManager activityManager = (ActivityManager)PortalContainer.getInstance().getComponentInstanceOfType(ActivityManager.class);
    private static RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
    private static String documentRefLink;
    private static String documentPath;
    private static String documentName;
    private static boolean isDocumentReady;
    private static String currentUser;
    private static String docIcon;
    private static final Log LOG;
    private static final ConcurrentMap<String, Lock> locks;

    public static String getMd5(String checksum) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(checksum.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static Date getTime() throws IOException {
        SimpleDateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
        formatter1.setTimeZone(TimeZone.getTimeZone("GMT+1"));
        formatter1.format(Calendar.getInstance().getTime());
        Date time1 = formatter1.getCalendar().getTime();
        LOG.info((Object)("Date  " + formatter1.getCalendar().get(2) + " _ " + formatter1.getCalendar().get(5) + " _ " + formatter1.getCalendar().get(10)));
        return time1;
    }

    private static boolean isGCMember(String userName) throws Exception {
        Collection groupsList = orgService.getGroupHandler().findGroupsOfUser(userName);
        for (Group group : groupsList) {
            if (!group.getId().equals(GCS_GROUP)) continue;
            return true;
        }
        return false;
    }

    public static String getCompanyName(String receiver) throws Exception {
        if (Utils.isGCMember(receiver)) {
            return "(Internal Employees)";
        }
        SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(receiver);
        if (userInfo != null && userInfo.getCompany() != null) {
            return "(" + userInfo.getCompany() + ")";
        }
        return "";
    }

    public static void createBBNDocActivity(Node currentNode, String receiver) {
    }

    public static void postActivityToSpace(String path, Map<String, String> activityParams) throws Exception {
        String space = path.split("/spaces/")[1].split("/")[0];
        Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space, false);
        String remoteUser = ConversationState.getCurrent().getIdentity().getUserId();
        ExoSocialActivity activity = Utils.saveActivity(activityParams, activityManager, identityManager, spaceIdentity, remoteUser);
    }

    public static ExoSocialActivity saveActivity(Map<String, String> activityParams, ActivityManager activityManager, IdentityManager identityManager, Identity ownerIdentity, String remoteUser) throws Exception {
        return null;
    }

    public static Node getDocNode(String repository, String workspace, String docPath) {
        NodeLocation nodeLocation = new NodeLocation(repository, workspace, docPath);
        return NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
    }

    public static String buildDocumentLink(String rawPath) {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        String restService = "jcr";
        return "/" + portalContainerName + "/" + restContextName + "/" + restService + "/" + REPOSITORY + "/" + WORKSPACE + "/" + rawPath;
    }

    private static boolean isSubMember(String userName) throws Exception {
        OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        Collection groupsList = orgService.getGroupHandler().findGroupsOfUser(userName);
        for (Group group : groupsList) {
            if (!group.getId().equals(SUBS_GROUP)) continue;
            return true;
        }
        return false;
    }

    public static String buildDocumentPath(String rawPath) {
        return "/" + rawPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addToSpace(Space project, String userName) {
        String currentTenant = ConversationState.getCurrent().getAttribute("currentTenant") == null ? "local" : ConversationState.getCurrent().getAttribute("currentTenant").toString();
        LOG.info((Object)("SubContractor is about to be added to " + project.getDisplayName() + " project in tenant " + currentTenant));
        Lock lock = Utils.getLock(project, currentTenant);
        lock.lock();
        try {
            String portalContainerName = "portal";
            Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("organization", userName, true);
            Util.getSpaceService((String)portalContainerName).addMember(project, userName);
            LOG.info((Object)("SubContractor has been added to " + project.getDisplayName() + " project in tenant " + currentTenant));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    private static Lock getLock(Space project, String tenantName) {
        String key = tenantName + "_" + project.getPrettyName();
        Lock lock = (Lock)locks.get(key);
        if (lock != null) {
            return lock;
        }
        lock = new InternalLock(key);
        Lock prevLock = locks.putIfAbsent(key, lock);
        if (prevLock != null) {
            lock = prevLock;
        }
        return lock;
    }

    public static InputStream getAvatarInputStream(Long avatarId) throws IOException {
        FileItem file = null;
        if (avatarId == null) {
            return null;
        }
        try {
            file = ((FileService)CommonsUtils.getService(FileService.class)).getFile(avatarId.longValue());
        }
        catch (FileStorageException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        return file.getAsStream();
    }

    public static String getCurrentCompanyName() {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        StaffDAO staffDAO = (StaffDAO)((Object)CommonsUtils.getService(StaffDAO.class));
        SubStaffCompanyDAO subStaffCompanyDAO = (SubStaffCompanyDAO)((Object)CommonsUtils.getService(SubStaffCompanyDAO.class));
        StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)userId));
        if (staffEntity != null) {
            return staffEntity.getGeneralContractorEntity().getCompanyName();
        }
        SubStaffCompanyEntity subStaffCompanyEntity = (SubStaffCompanyEntity)subStaffCompanyDAO.find((Serializable)((Object)userId));
        if (subStaffCompanyEntity != null) {
            return subStaffCompanyEntity.getSubContractorEntity().getCompany();
        }
        return "";
    }

    static {
        docIcon = "";
        LOG = ExoLogger.getLogger((String)Utils.class.getName());
        locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);
    }

    private static class InternalLock
    extends ReentrantLock {
        private static final long serialVersionUID = -3362387346368015145L;
        private final String fullPath;

        public InternalLock(String fullPath) {
            this.fullPath = fullPath;
        }

        @Override
        public void unlock() {
            if (!this.hasQueuedThreads()) {
                locks.remove(this.fullPath, this);
            }
            super.unlock();
        }
    }
}

