/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.ps.DAO.GeneralContractorDAO;
import org.exoplatform.ps.DAO.ProjectSubDAO;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubCatDAO;
import org.exoplatform.ps.DAO.SubGcDAO;
import org.exoplatform.ps.DAO.SubStaffCompanyDAO;
import org.exoplatform.ps.DTO.GeneralContractor;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.entity.SubStaffCompanyEntity;
import org.exoplatform.ps.model.BbUser;
import org.exoplatform.ps.model.StaffUser;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/generalcontarctorsservice")
public class GeneralContarctorsRestService
implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String DEFAULT_AVATAR_ICON_MIME_TYPE = "image/png";
    private static final String DEFAULT_AVATAR_ICON_NAMESPACE = "projectspace";
    private static final Log LOG = ExoLogger.getLogger((String)GeneralContarctorsRestService.class.getName());
    private final CacheControl cacheControl = new CacheControl();
    private final GeneralContractorDAO generalContractorDAO;
    private final UploadService uploadService;
    private final FileService fileService;
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public GeneralContarctorsRestService(GeneralContractorDAO generalContractorDAO, UploadService uploadService, FileService fileService) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.generalContractorDAO = generalContractorDAO;
        this.uploadService = uploadService;
        this.fileService = fileService;
    }

    @GET
    @Path(value="getcompanies")
    public Response getCompanies(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws com.sun.star.uno.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        JSONObject jsonGlobal = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            for (GeneralContractorEntity generalContractorEntity : this.generalContractorDAO.findAll()) {
                JSONObject data = new JSONObject();
                data.put("id", (Object)generalContractorEntity.getId());
                data.put("companyName", (Object)generalContractorEntity.getCompanyName());
                data.put("adress", (Object)generalContractorEntity.getCompanyStreet());
                data.put("city", (Object)generalContractorEntity.getCompanyCity());
                data.put("state", (Object)generalContractorEntity.getCompanyState());
                data.put("companyPhone", (Object)generalContractorEntity.getCompanyPhone());
                data.put("webSite", (Object)generalContractorEntity.getCompanyWebSite());
                jsonArray.put((Object)data);
            }
            int sEcho = request.getParameter("sEcho") == null ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", jsonArray.length());
            jsonGlobal.put("iTotalDisplayRecords", jsonArray.length());
            jsonGlobal.put("aaData", (Object)jsonArray);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="getgclist")
    public Response getCompaniesList(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws com.sun.star.uno.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        JSONObject jsonGlobal = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.generalContractorDAO.findAll(), (MediaType)mediaType).build();
    }

    @GET
    @Path(value="get/{id}")
    public Response getCompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="id") Long id) throws com.sun.star.uno.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            GeneralContractorEntity generalContractorEntity = (GeneralContractorEntity)this.generalContractorDAO.find(id);
            if (generalContractorEntity == null) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            JSONObject data = new JSONObject();
            data.put("id", (Object)generalContractorEntity.getId());
            data.put("companyName", (Object)generalContractorEntity.getCompanyName());
            data.put("companyStreet", (Object)generalContractorEntity.getCompanyStreet());
            data.put("companyCity", (Object)generalContractorEntity.getCompanyCity());
            data.put("companyState", (Object)generalContractorEntity.getCompanyState());
            data.put("companyPhone", (Object)generalContractorEntity.getCompanyPhone());
            data.put("companyWebsite", (Object)generalContractorEntity.getCompanyWebSite());
            data.put("companyProview", (Object)generalContractorEntity.getCompanyProview());
            data.put("companyZip", (Object)generalContractorEntity.getCompanyZip());
            data.put("companyCountry", (Object)generalContractorEntity.getCompanyCountry());
            data.put("gcUser", (Object)generalContractorEntity.getGcUser());
            return Response.ok((Object)data.toString(), (MediaType)mediaType).build();
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="getcompany")
    public Response getCurrentSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws com.sun.star.uno.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = GeneralContarctorsRestService.getService(StaffDAO.class, null);
        return Response.ok((Object)((StaffEntity)staffDAO.find((Serializable)((Object)sourceIdentity.getRemoteId()))).getGeneralContractorEntity(), (MediaType)mediaType).build();
    }

    @GET
    @Path(value="getcompany/{id}")
    public Response getCompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="id") String id) throws com.sun.star.uno.Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        Long gcId = new Long(0L);
        try {
            gcId = Long.valueOf(id);
        }
        catch (NumberFormatException e) {
            id = "";
        }
        if (id != null && id != "") {
            GeneralContractorEntity generalContractorEntity = (GeneralContractorEntity)this.generalContractorDAO.find(gcId);
            if (generalContractorEntity == null) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.ok((Object)generalContractorEntity, (MediaType)mediaType).build();
        }
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = GeneralContarctorsRestService.getService(StaffDAO.class, null);
        return Response.ok((Object)((StaffEntity)staffDAO.find((Serializable)((Object)sourceIdentity.getRemoteId()))).getGeneralContractorEntity(), (MediaType)mediaType).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="addgc")
    public Response add(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, GeneralContractorEntity gcuser) throws com.sun.star.uno.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            GeneralContractorDAO generalContractorDAO = GeneralContarctorsRestService.getService(GeneralContractorDAO.class, null);
            gcuser.setCreatedDate(new Date());
            gcuser = (GeneralContractorEntity)generalContractorDAO.create(gcuser);
            OrganizationService organizationService = GeneralContarctorsRestService.getService(OrganizationService.class, null);
            StaffDAO staffDAO = GeneralContarctorsRestService.getService(StaffDAO.class, null);
            StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)gcuser.getGcUser()));
            ArrayList<StaffEntity> staffList = new ArrayList<StaffEntity>();
            if (staffEntity != null) {
                staffList.add(staffEntity);
            } else {
                try {
                    User user = organizationService.getUserHandler().findUserByName(gcuser.getGcUser());
                    if (user != null) {
                        ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
                        GroupHandler gh = organizationService.getGroupHandler();
                        MembershipHandler mh = organizationService.getMembershipHandler();
                        MembershipTypeHandler mth = organizationService.getMembershipTypeHandler();
                        mh.linkMembership(user, gh.findGroupById("/organization/gcs"), mth.findMembershipType("manager"), true);
                        staffEntity = new StaffEntity();
                        staffEntity.setId(gcuser.getGcUser());
                        staffEntity.setFirstName(user.getFirstName());
                        staffEntity.setLastName(user.getLastName());
                        staffEntity.setRole("manager");
                        staffEntity.setGeneralContractorEntity(gcuser);
                        staffEntity = (StaffEntity)staffDAO.create(staffEntity);
                    } else if (staffEntity.getGeneralContractorEntity().getId() != gcuser.getId()) {
                        staffEntity.setGeneralContractorEntity(gcuser);
                        staffEntity = (StaffEntity)staffDAO.update(staffEntity);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" User Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="creategcstaff")
    public Response creategcstaff(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, StaffUser staffUser) throws com.sun.star.uno.Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        GeneralContractorEntity generalContractorEntity = (GeneralContractorEntity)this.generalContractorDAO.find(staffUser.getGcId());
        if (generalContractorEntity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            OrganizationService organizationService = GeneralContarctorsRestService.getService(OrganizationService.class, null);
            StaffDAO staffDAO = GeneralContarctorsRestService.getService(StaffDAO.class, null);
            StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)staffUser.getUserid()));
            if (staffEntity != null) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
            try {
                User user = organizationService.getUserHandler().findUserByName(staffUser.getUserid());
                if (user == null) {
                    ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)PortalContainer.getInstance());
                    UserHandler uh = organizationService.getUserHandler();
                    user = uh.createUserInstance(staffUser.getUserid());
                    user.setFirstName(staffUser.getFirstName());
                    user.setLastName(staffUser.getLastName());
                    user.setEmail(staffUser.getEmail());
                    user.setPassword(staffUser.getPassword());
                    uh.createUser(user, true);
                    GroupHandler gh = organizationService.getGroupHandler();
                    MembershipHandler mh = organizationService.getMembershipHandler();
                    MembershipTypeHandler mth = organizationService.getMembershipTypeHandler();
                    mh.linkMembership(user, gh.findGroupById("/organization/gcs"), mth.findMembershipType("manager"), true);
                    staffEntity = new StaffEntity();
                    staffEntity.setId(staffUser.getUserid());
                    staffEntity.setFirstName(user.getFirstName());
                    staffEntity.setLastName(user.getLastName());
                    staffEntity.setRole("manager");
                    staffEntity.setGeneralContractorEntity(generalContractorEntity);
                    staffEntity = (StaffEntity)staffDAO.create(staffEntity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" User Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="getmystaff")
    public Response getmystaff(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="projectid") String projectId) throws com.sun.star.uno.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        JSONArray jsonArray = new JSONArray();
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        StaffEntity staff = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (staff == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        Space project = null;
        if (projectId != null && (project = spaceService.getSpaceByPrettyName(projectId)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
        }
        try {
            MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
            List<StaffEntity> StaffList = staffDAO.getStaffByGc(staff.getGeneralContractorEntity().getId(), 0, 0);
            for (StaffEntity staff_ : StaffList) {
                JSONObject json = new JSONObject();
                json.put("userName", (Object)staff_.getId());
                json.put("fullName", (Object)(staff_.getFirstName() + " " + staff_.getLastName()));
                json.put("company", (Object)staff_.getGeneralContractorEntity().getCompanyName());
                json.put("position", (Object)staff_.getPosition());
                json.put("role", (Object)staff_.getRole());
                json.put("isMember", (Object)"Not invited");
                if (project != null) {
                    if (spaceService.isInvitedUser(project, staff_.getId())) {
                        json.put("isMember", (Object)"Invited");
                    }
                    if (spaceService.isMember(project, staff_.getId())) {
                        json.put("isMember", (Object)"Member");
                    }
                    if (spaceService.isManager(project, staff_.getId())) {
                        json.put("isMember", (Object)"Manager");
                    }
                }
                json.put("status", (Object)"Not Invited");
                jsonArray.put((Object)json);
            }
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonArray.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="editgc")
    public Response edit(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, GeneralContractor gcuser) throws com.sun.star.uno.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            UploadResource uploadResource;
            FileItem fileItem = null;
            if (gcuser.getUploadId() != null && (uploadResource = this.uploadService.getUploadResource(gcuser.getUploadId())) != null) {
                fileItem = new FileItem(null, Long.toString(gcuser.getId()), uploadResource.getMimeType(), DEFAULT_AVATAR_ICON_NAMESPACE, (long)uploadResource.getUploadedSize(), new Date(), sourceIdentity.getRemoteId(), false, (InputStream)new FileInputStream(uploadResource.getStoreLocation()));
                fileItem = this.fileService.writeFile(fileItem);
                LOG.info((Object)("=================================" + fileItem.getFileInfo().getId()));
            }
            gcuser.setAvatarId(fileItem.getFileInfo().getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            GeneralContractorEntity generalContractorEntity = (GeneralContractorEntity)this.generalContractorDAO.find(gcuser.getId());
            generalContractorEntity.setId(gcuser.getId());
            generalContractorEntity.setCompanyName(gcuser.getCompanyName());
            generalContractorEntity.setCompanyStreet(gcuser.getCompanyStreet());
            generalContractorEntity.setCompanyCity(gcuser.getCompanyCity());
            generalContractorEntity.setCompanyState(gcuser.getCompanyState());
            generalContractorEntity.setCompanyZip(gcuser.getCompanyZip());
            generalContractorEntity.setCompanyCountry(gcuser.getCompanyCountry());
            generalContractorEntity.setCompanyWebSite(gcuser.getCompanyWebSite());
            generalContractorEntity.setCompanyProview(gcuser.getCompanyProview());
            generalContractorEntity.setCompanyPhone(gcuser.getCompanyPhone());
            generalContractorEntity.setEmail(gcuser.getEmail());
            generalContractorEntity.setProjectExp(gcuser.getProjectExp());
            generalContractorEntity.setAssoMbr(gcuser.getAssoMbr());
            generalContractorEntity.setEntrepriseType(gcuser.getEntrepriseType());
            generalContractorEntity.setStory(gcuser.getStory());
            generalContractorEntity.setUnionStatus(gcuser.getUnionStatus());
            generalContractorEntity.setServiceArea(gcuser.getServiceArea());
            generalContractorEntity.setAvatarId(gcuser.getAvatarId());
            this.generalContractorDAO.update(generalContractorEntity);
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" User Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (JSONException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="gc/{gc}/avatar")
    public Response getSpaceAvatarById(@Context UriInfo uriInfo, @Context Request request, @PathParam(value="gc") Long gc) throws IOException {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            InputStream stream = null;
            try {
                Response.ResponseBuilder builder;
                GeneralContractorEntity gc_ = (GeneralContractorEntity)this.generalContractorDAO.find(gc);
                Long lastUpdated = null;
                if (gc_ != null && gc_.getAvatarId() != null) {
                    lastUpdated = gc_.getLastModifiedDate().getTime();
                } else {
                    stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                }
                EntityTag eTag = null;
                if (lastUpdated != null) {
                    eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                }
                Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
                if (builder == null) {
                    if (stream == null) {
                        if (gc_ != null) {
                            stream = Utils.getAvatarInputStream(gc_.getAvatarId());
                        } else {
                            throw new WebApplicationException(Response.Status.NOT_FOUND);
                        }
                    }
                    builder = Response.ok((Object)stream, (String)DEFAULT_AVATAR_ICON_MIME_TYPE);
                    builder.tag(eTag);
                }
                CacheControl cc = new CacheControl();
                cc.setMaxAge(86400);
                builder.cacheControl(cc);
                return builder.cacheControl(cc).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting badge's avatar", (Throwable)e);
                return Response.serverError().entity((Object)"Error getting badge's avatar").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="getcurrentcompany/avatar")
    public Response getCurrentCompany(@Context UriInfo uriInfo, @Context Request request) throws IOException {
        ConversationState conversationState = ConversationState.getCurrent();
        StaffDAO staffDAO = GeneralContarctorsRestService.getService(StaffDAO.class, null);
        SubStaffCompanyDAO subStaffCompanyDAO = GeneralContarctorsRestService.getService(SubStaffCompanyDAO.class, null);
        if (conversationState != null) {
            InputStream stream = null;
            String currentUser = conversationState.getIdentity().getUserId();
            StaffEntity staff = (StaffEntity)staffDAO.find((Serializable)((Object)currentUser));
            if (staff != null) {
                try {
                    Response.ResponseBuilder builder;
                    Long lastUpdated = staff.getGeneralContractorEntity().getLastModifiedDate().getTime();
                    EntityTag eTag = null;
                    if (lastUpdated != null) {
                        eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                    }
                    Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
                    if (builder == null) {
                        stream = staff.getGeneralContractorEntity().getAvatarId() != null ? Utils.getAvatarInputStream(staff.getGeneralContractorEntity().getAvatarId()) : GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                        builder = Response.ok((Object)stream, (String)DEFAULT_AVATAR_ICON_MIME_TYPE);
                        builder.tag(eTag);
                    }
                    CacheControl cc = new CacheControl();
                    cc.setMaxAge(86400);
                    builder.cacheControl(cc);
                    return builder.cacheControl(cc).build();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error getting badge's avatar", (Throwable)e);
                    return Response.serverError().entity((Object)"Error getting badge's avatar").build();
                }
            }
            SubStaffCompanyEntity sub = (SubStaffCompanyEntity)subStaffCompanyDAO.find((Serializable)((Object)currentUser));
            if (sub != null) {
                try {
                    Response.ResponseBuilder builder;
                    SubContractorEntity sub_ = sub.getSubContractorEntity();
                    Long lastUpdated = sub_.getLastModifiedDate().getTime();
                    EntityTag eTag = null;
                    if (lastUpdated != null) {
                        eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                    }
                    Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
                    if (builder == null) {
                        stream = sub_.getAvatarId() != null ? Utils.getAvatarInputStream(sub_.getAvatarId()) : GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                        builder = Response.ok((Object)stream, (String)DEFAULT_AVATAR_ICON_MIME_TYPE);
                        builder.tag(eTag);
                    }
                    CacheControl cc = new CacheControl();
                    cc.setMaxAge(86400);
                    builder.cacheControl(cc);
                    return builder.cacheControl(cc).build();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error getting badge's avatar", (Throwable)e);
                    return Response.serverError().entity((Object)"Error getting badge's avatar").build();
                }
            }
            stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
            Response.ResponseBuilder builder = Response.ok((Object)stream, (String)DEFAULT_AVATAR_ICON_MIME_TYPE);
            CacheControl cc = new CacheControl();
            cc.setMaxAge(86400);
            builder.cacheControl(cc);
            return builder.cacheControl(cc).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Unauthorized user").build();
    }

    @POST
    @Path(value="addstaff/{projectId}")
    @Consumes(value={"application/json"})
    public Response addNotInvited(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, List<String> users) throws com.sun.star.uno.Exception {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
            if (sourceIdentity == null) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn((Object)"Project not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            for (String user : users) {
                spaceService.addInvitedUser(project, user);
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="invitebymail")
    @Consumes(value={"application/json"})
    public Response inviteByMail(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, BbUser userIn) throws Exception {
        try {
            StaffDAO staffDAO = GeneralContarctorsRestService.getService(StaffDAO.class, null);
            StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
            if (staffEntity != null) {
                this.sendEmail(userIn, staffEntity.getGeneralContractorEntity().getId());
                return Response.ok((Object)"mail sent").build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Not A staff on any gc").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private String generateBodyEmail(BbUser user, Long gcId) throws FileNotFoundException {
        Object message = null;
        ProjectSubDAO projectSubDAO = (ProjectSubDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class));
        SubCatDAO subCatDAO = (SubCatDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class));
        SubGcDAO subGcDAO = (SubGcDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubGcDAO.class));
        StaffDAO staffDAO = GeneralContarctorsRestService.getService(StaffDAO.class, null);
        StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        String base_url = System.getProperty("gatein.email.domain.url");
        String confirmUrl = base_url + "/portal/gc-portal/subscribe?gcid=" + gcId + "&staff=true";
        String creator = staffEntity.getFirstName() + " " + staffEntity.getLastName() != null ? staffEntity.getLastName() : "";
        String phone = staffEntity.getGeneralContractorEntity().getCompanyPhone() != null ? staffEntity.getGeneralContractorEntity().getCompanyPhone() : "";
        String mail = staffEntity.getGeneralContractorEntity().getEmail() != null ? staffEntity.getGeneralContractorEntity().getEmail() : "";
        String companyName = staffEntity.getGeneralContractorEntity().getCompanyName() != null ? staffEntity.getGeneralContractorEntity().getCompanyName() : "";
        String contact = staffEntity.getGeneralContractorEntity().getCompanyCountry() + "" + staffEntity.getGeneralContractorEntity().getCompanyState() + " " + staffEntity.getGeneralContractorEntity().getCompanyCity();
        LOG.info((Object)(" send email hello " + user.getEmail() + " for gc = " + gcId));
        String imagePath = base_url + "/exo-community-webui-portlet/skin/images";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("imagepath", imagePath);
        props.put("confirmUrl", confirmUrl);
        props.put("CREATOR", creator);
        props.put("MAIL", mail);
        props.put("FULL_NAME", user.getFirstName() + " " + user.getLastName());
        props.put("FIRST_NAME", user.getFirstName());
        props.put("CONTACT", contact);
        props.put("PHONE", phone);
        props.put("COMPANYNAME", companyName);
        return this.resolveTemplate(props);
    }

    private String resolveTemplate(Map<String, String> properties) throws FileNotFoundException {
        String templateContent = this.generateBodyEmailContent();
        if (templateContent != null) {
            for (Map.Entry<String, String> property : properties.entrySet()) {
                if (null == property.getKey() || null == property.getValue()) continue;
                templateContent = templateContent.replace("${" + property.getKey() + "}", property.getValue());
            }
        }
        return templateContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateBodyEmailContent() {
        try {
            InputStream bodyEmailIS = this.getClass().getResourceAsStream("/html/template_gc_register_email.html");
            StringBuilder sb = new StringBuilder();
            try (Scanner scanner = new Scanner(bodyEmailIS);){
                while (scanner.hasNextLine()) {
                    sb.append(scanner.nextLine()).append(System.getProperty("line.separator"));
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            LOG.error((Object)" ==== ERR cannot get body email content ", (Throwable)e);
            return null;
        }
    }

    public void sendEmail(BbUser user, Long gcId) {
        LOG.debug((Object)("=== send register  email to " + user.getEmail() + ") "));
        MailService mailService = GeneralContarctorsRestService.getService(MailService.class, null);
        Message message = new Message();
        message.setReceiver(user.getEmail());
        message.setTo(user.getEmail());
        try {
            String body = this.generateBodyEmail(user, gcId);
            message.setBody(body);
            message.setFrom(System.getProperty("gatein.email.smtp.from"));
            message.setMimeType("text/html");
            message.setSubject("INVITATION TO COLLABORATE");
            mailService.sendMessage(message);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"=== register: send confirmation email: cannot file email temmplate ");
        }
        catch (Exception e) {
            LOG.error((Object)("=== Registration process: send confirmation email " + e.getMessage()));
        }
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }
}

