/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringEscapeUtils;
import org.chromattic.api.DuplicateNameException;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.ps.DAO.GeneralContractorDAO;
import org.exoplatform.ps.DAO.ProjectSubDAO;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubCatDAO;
import org.exoplatform.ps.DAO.SubContractorDAO;
import org.exoplatform.ps.DAO.SubGcDAO;
import org.exoplatform.ps.DAO.SubStaffCompanyDAO;
import org.exoplatform.ps.DTO.Category;
import org.exoplatform.ps.DTO.SubContractor;
import org.exoplatform.ps.chromattic.entity.SimpleNotification;
import org.exoplatform.ps.entity.CategoryEntity;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubCatGroupEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.entity.SubGcEntity;
import org.exoplatform.ps.entity.SubGroupEntity;
import org.exoplatform.ps.entity.SubStaffCompanyEntity;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.model.BbMessage;
import org.exoplatform.ps.model.BbSerachResult;
import org.exoplatform.ps.model.BbUser;
import org.exoplatform.ps.rest.ImportRunner;
import org.exoplatform.ps.rest.MessagingRunner;
import org.exoplatform.ps.rest.SubCatRunner;
import org.exoplatform.ps.storage.UsersSearch;
import org.exoplatform.ps.storage.api.BBCategoryStorage;
import org.exoplatform.ps.storage.api.CompanyInfoStorage;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.ps.storage.api.SimpleNotifServiceStorage;
import org.exoplatform.ps.storage.api.SubCatGroupRelationStorage;
import org.exoplatform.ps.storage.api.SubCatStorage;
import org.exoplatform.ps.storage.api.SubCompanyStorage;
import org.exoplatform.ps.storage.api.SubGcStorage;
import org.exoplatform.ps.storage.api.SubGroupStorage;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.RelationShipType;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.webui.exception.MessageException;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/bbusersservice")
public class UsersRestService
implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final Log LOG = ExoLogger.getLogger((String)UsersRestService.class.getName());
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String DefaultAvatar = "/project-space-portlets/skin/images/user-image-placeholder-large.png";
    private static final String BBIMPORT_NOTIF_TYPE = "bbimport-success";
    private static final String BSIMPORT_NOTIF_TYPE = "bsimport-success";
    private static final String SUPPORT_MAIL = "oneteamdbddd@oneteam.build";
    private static String MASTER_HOST_VARIABLE_NAME = "tenant.masterhost";
    private static String DEFAULT_MASTER_HOST_NAME = "localhost";
    private static Boolean requestStarted = false;
    private static final String LAST_ACCESS = "lastAccess";
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String ADMIN_GROUP = "/platform/administrators";
    private static final String PLAN_ROOM_TEAM = "planroomteam";
    private static final String INTEGRATION_USER = "integrationuser";
    private final CacheControl cacheControl;
    OrganizationService orgService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    RepositoryService repositoryService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);

    public UsersRestService() {
        this.cacheControl = new CacheControl();
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
    }

    public static boolean isAdmin(Identity userId) {
        return userId.isMemberOf(ADMIN_GROUP) || userId.isMemberOf(GCS_GROUP) || userId.getUserId().equals(PropertyManager.getProperty((String)"exo.super.user")) || userId.getUserId().equals(PLAN_ROOM_TEAM) || userId.getUserId().equals(INTEGRATION_USER);
    }

    public static boolean sendMail(String to, String subject, String mailText, Boolean isDaily) {
        LOG.info((Object)("ITB sent to " + to));
        return true;
    }

    private static boolean isLowerCaseLetterOrDigit(char character) {
        return Character.isDigit(character) || character >= 'a' && character <= 'z';
    }

    private static boolean isLowerCaseLetter(char character) {
        return character >= 'a' && character <= 'z';
    }

    @GET
    @Path(value="geteveryone")
    @Consumes(value={"application/json"})
    public Response getEveryone(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="projectId") String projectId, @QueryParam(value="searchkey") String searchKey, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            String sortBy;
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            UsersSearch mvSearch = new UsersSearch();
            int displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = request.getParameter("iDisplayLength") == null ? 30 : Integer.parseInt(request.getParameter("iDisplayLength"));
            int sEcho = request.getParameter("sEcho") == null ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = request.getParameter("iSortCol_0") == null ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String sortDir = request.getParameter("sSortDir_0") == null ? "" : request.getParameter("sSortDir_0");
            ProfileFilter filter = new ProfileFilter();
            ArrayList<org.exoplatform.social.core.identity.model.Identity> ecxluded = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
            if (projectId != null) {
                SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
                Space project = spaceService.getSpaceByPrettyName(projectId);
                if (project == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
                }
                ListAccess members = identityManager.getSpaceIdentityByProfileFilter(project, filter, SpaceMemberFilterListAccess.Type.MEMBER, true);
                ecxluded.addAll(Arrays.asList(members.load(0, members.getSize())));
                if (project.getInvitedUsers() != null) {
                    String[] stringArray = project.getInvitedUsers();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String invitedUser = stringArray[i];
                        ecxluded.add(identityManager.getOrCreateIdentity("organization", invitedUser, true));
                    }
                }
            }
            UserHandler uh = this.orgService.getUserHandler();
            ListAccess staffList = uh.findUsersByGroupId(GCS_GROUP);
            for (ListAccess staff : (ListAccess)staffList.load(0, staffList.getSize())) {
                ecxluded.add(identityManager.getOrCreateIdentity("organization", staff.getUserName(), true));
            }
            ecxluded.add(identityManager.getOrCreateIdentity("organization", "root", true));
            if (projectId != null) {
                switch (iSortCol) {
                    case 0: {
                        sortBy = "void-userName";
                        break;
                    }
                    case 1: {
                        sortBy = "void-fullName";
                        break;
                    }
                    case 2: {
                        sortBy = "void-company";
                        break;
                    }
                    case 3: {
                        sortBy = "void-categories";
                        break;
                    }
                    case 4: {
                        sortBy = "void-rank";
                        break;
                    }
                    default: {
                        sortBy = "";
                        break;
                    }
                }
            } else {
                switch (iSortCol) {
                    case 0: {
                        sortBy = "void-userName";
                        break;
                    }
                    case 1: {
                        sortBy = "void-fullName";
                        break;
                    }
                    case 2: {
                        sortBy = "void-company";
                        break;
                    }
                    case 3: {
                        sortBy = "void-categories";
                        break;
                    }
                    case 4: {
                        sortBy = "void-rank";
                        break;
                    }
                    default: {
                        sortBy = "";
                    }
                }
            }
            List<org.exoplatform.social.core.identity.model.Identity> users = mvSearch.search(false, searchKey, ecxluded, displaystart, displaylength, sortBy, sortDir);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (org.exoplatform.social.core.identity.model.Identity user : users) {
                Profile uProfile = user.getProfile();
                JSONObject json = new JSONObject();
                json.put("userName", (Object)user.getRemoteId());
                if (uProfile.getProperty("company") == null) {
                    json.put("company", (Object)"");
                } else {
                    json.put("company", uProfile.getProperty("company"));
                }
                if (uProfile.getFullName() == null) {
                    json.put("contact", (Object)"");
                } else {
                    json.put("contact", (Object)uProfile.getFullName());
                }
                if (uProfile.getProperty("categories") == null) {
                    json.put("categories", (Object)"");
                } else {
                    json.put("categories", uProfile.getProperty("categories"));
                }
                if (uProfile.getProperty("rank") == null) {
                    json.put("rank", 8);
                } else {
                    json.put("rank", uProfile.getProperty("rank"));
                }
                json.put("selected", false);
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", mvSearch.getSize());
            jsonGlobal.put("iTotalDisplayRecords", mvSearch.getSize());
            jsonGlobal.put("aaData", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="getallsubcats")
    @Consumes(value={"application/json"})
    public Response getAllSubcats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="projectId") String projectId, @QueryParam(value="searchkey") String searchKey, @QueryParam(value="isvendor") boolean isvendor, @QueryParam(value="notinvited") boolean notinvited, @QueryParam(value="filteredgroups") String filteredgroups, @QueryParam(value="filteredclassif") String filteredclassifications, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="selectall") boolean selectall) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        SubCatDAO subCatDAO = (SubCatDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class));
        StaffEntity staff = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (staff == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            void var38_51;
            String sortBy;
            int displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = request.getParameter("iDisplayLength") == null ? 30 : Integer.parseInt(request.getParameter("iDisplayLength"));
            int sEcho = request.getParameter("sEcho") == null ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = request.getParameter("iSortCol_0") == null ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String sortDir = request.getParameter("sSortDir_0") == null ? "" : request.getParameter("sSortDir_0");
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            ArrayList<SubCatEntity> excluded = new ArrayList<SubCatEntity>();
            ArrayList<SubCatEntity> includedStatus = new ArrayList<SubCatEntity>();
            ArrayList<SubCatEntity> includedGroups = new ArrayList<SubCatEntity>();
            ArrayList<SubCatEntity> included = new ArrayList<SubCatEntity>();
            ArrayList<ProjectSubEntity> includedRel = new ArrayList<ProjectSubEntity>();
            if (filteredgroups != null && filteredgroups.compareTo("") != 0) {
                String[] filteredarraygroups = filteredgroups.split(",");
                ProjectSubEntity projectSubRelationShip_ = null;
                for (String string : filteredarraygroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(string, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        SubCatEntity subCat = subCatStorage.getSubCat(subCatGroupRelation.getSubCat().getId());
                        if (subCat == null) continue;
                        includedGroups.add(subCat);
                        if (null == projectId || (projectSubRelationShip_ = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId())) == null) continue;
                        includedRel.add(projectSubRelationShip_);
                    }
                }
                if (includedGroups.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", (Object)jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
                }
            }
            switch (iSortCol) {
                case 0: {
                    sortBy = "tbb:subId";
                    break;
                }
                case 1: {
                    sortBy = "tbb:subCompany";
                    break;
                }
                case 2: {
                    sortBy = "tbb:subName";
                    break;
                }
                case 3: {
                    sortBy = "tbb:catCsiDesc";
                    break;
                }
                case 4: {
                    sortBy = "tbb:subPhone";
                    break;
                }
                case 5: {
                    sortBy = "tbb:subCity";
                    break;
                }
                case 6: {
                    sortBy = "tbb:subState";
                    break;
                }
                case 7: {
                    sortBy = "tbb:subCounty";
                    break;
                }
                case 8: {
                    sortBy = "tbb:subRank";
                    break;
                }
                case 9: {
                    sortBy = "tbb:subUnion";
                    break;
                }
                case 10: {
                    sortBy = "tbb:subNonUnion";
                    break;
                }
                default: {
                    sortBy = "";
                }
            }
            filteredclassifications = filteredclassifications == null || filteredclassifications.equals("undefined") ? "" : filteredclassifications;
            ArrayList<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(request.getParameter("sSearch_1") == null ? "" : request.getParameter("sSearch_1"));
            SearchConditions.add(request.getParameter("sSearch_2") == null ? "" : request.getParameter("sSearch_2"));
            SearchConditions.add(request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("") ? filteredclassifications : request.getParameter("sSearch_3"));
            SearchConditions.add(request.getParameter("sSearch_4") == null ? "" : request.getParameter("sSearch_4"));
            SearchConditions.add(request.getParameter("sSearch_5") == null ? "" : request.getParameter("sSearch_5"));
            SearchConditions.add(request.getParameter("sSearch_6") == null ? "" : request.getParameter("sSearch_6"));
            SearchConditions.add(request.getParameter("sSearch_7") == null ? "" : request.getParameter("sSearch_7"));
            SearchConditions.add(request.getParameter("sSearch_9") == null ? "" : request.getParameter("sSearch_9"));
            SearchConditions.add(request.getParameter("sSearch_10") == null ? "" : request.getParameter("sSearch_10"));
            ArrayList<String> RelSearchConditions = new ArrayList<String>();
            RelSearchConditions.add(request.getParameter("sSearch_1") == null ? "" : request.getParameter("sSearch_1"));
            RelSearchConditions.add(request.getParameter("sSearch_2") == null ? "" : request.getParameter("sSearch_2"));
            RelSearchConditions.add(request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("") ? filteredclassifications : request.getParameter("sSearch_3"));
            RelSearchConditions.add("");
            RelSearchConditions.add(request.getParameter("sSearch_4") == null ? "" : request.getParameter("sSearch_4"));
            RelSearchConditions.add(request.getParameter("sSearch_5") == null ? "" : request.getParameter("sSearch_5"));
            RelSearchConditions.add(request.getParameter("sSearch_6") == null ? "" : request.getParameter("sSearch_6"));
            RelSearchConditions.add(request.getParameter("sSearch_7") == null ? "" : request.getParameter("sSearch_7"));
            RelSearchConditions.add(request.getParameter("sSearch_9") == null ? "" : request.getParameter("sSearch_9"));
            RelSearchConditions.add(request.getParameter("sSearch_10") == null ? "" : request.getParameter("sSearch_10"));
            if (null != projectId && request.getParameter("sSearch_11") != null && request.getParameter("sSearch_11") != "") {
                ArrayList<String> SearchConditions1 = new ArrayList<String>();
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add(request.getParameter("sSearch_11") == null ? "" : request.getParameter("sSearch_11"));
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                ListAccess<ProjectSubEntity> byStatusList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(true, isvendor, notinvited, null, SearchConditions1, null, sortBy, sortDir, projectId);
                for (ProjectSubEntity relationShip : (ProjectSubEntity[])byStatusList.load(0, byStatusList.getSize())) {
                    String subcatid = relationShip.getSubContractor().getId() + "_" + relationShip.getCategory().getId();
                    SubCatEntity subCatEntity = subCatStorage.getSubCat(subcatid);
                    if (subCatEntity == null) continue;
                    includedStatus.add(subCatEntity);
                }
                if (includedStatus.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", (Object)jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
                }
            }
            if (includedGroups.size() == 0 && includedStatus.size() > 0) {
                included = includedStatus;
            }
            if (includedGroups.size() > 0 && includedStatus.size() == 0) {
                included = includedGroups;
            }
            if (includedGroups.size() > 0 && includedStatus.size() > 0) {
                for (SubCatEntity subCat : includedGroups) {
                    if (!includedStatus.contains(subCat)) continue;
                    included.add(subCat);
                }
            }
            List<Object> subCats = new ArrayList();
            int total = subCatStorage.subCatSearchCount(isvendor, searchKey, SearchConditions, excluded, included);
            boolean bl = false;
            if (null != projectId) {
                int n;
                int n2;
                ListAccess<ProjectSubEntity> tmpList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, isvendor, false, searchKey, RelSearchConditions, includedRel, sortBy, sortDir, projectId);
                if (notinvited) {
                    for (ProjectSubEntity projectSubEntity : (ProjectSubEntity[])tmpList.load(0, tmpList.getSize())) {
                        String subcatid = projectSubEntity.getSubContractor().getId() + "_" + projectSubEntity.getCategory().getId();
                        excluded.add(subCatStorage.getSubCat(subcatid));
                    }
                }
                if (request.getParameter("notInvitedCount") != null) {
                    n2 = Integer.parseInt(request.getParameter("notInvitedCount"));
                }
                if (n2 == -1) {
                    n = total - tmpList.getSize();
                }
                if (n <= 0) {
                    boolean bl2 = false;
                    if (filteredgroups != null) {
                        for (String string : filteredgroups.split("\\,")) {
                            List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(string, 0, 0);
                            for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                                ProjectSubEntity relationShip = null;
                                try {
                                    relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                    if (relationShip == null) {
                                        ++var38_51;
                                    }
                                }
                                catch (Exception e) {
                                    ++var38_51;
                                }
                                try {
                                    if (relationShip == null || !relationShip.getStatus().equals("NOT_MESS")) continue;
                                    ++var38_51;
                                }
                                catch (Exception e) {
                                    LOG.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
            SubGcDAO subGcDAO = (SubGcDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubGcDAO.class));
            subCats = subCatDAO.getSubCatByGc(staff.getGeneralContractorEntity().getId(), displaystart, displaylength);
            int subCatsSize = subCats.size();
            Boolean isgcmember = this.orgService.getMembershipHandler().findMembershipByUserGroupAndType(sourceIdentity.getRemoteId(), GCS_GROUP, "gcmember") != null;
            for (SubCatEntity subCatEntity : subCats) {
                JSONObject json = new JSONObject();
                String status = "Not Selected";
                try {
                    if (projectSubRelationShipStorage.getRelationShip(subCatEntity.getSubContractor().getId(), projectId, subCatEntity.getCategory().getId()) != null) {
                        status = projectSubRelationShipStorage.getRelationShip(subCatEntity.getSubContractor().getId(), projectId, subCatEntity.getCategory().getId()).getStatus();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                json.put("userName", (Object)subCatEntity.getSubContractor().getId());
                json.put("weburl", (Object)subCatEntity.getSubContractor().getWeburl());
                json.put("proview", (Object)subCatEntity.getSubContractor().getProview());
                json.put("company", (Object)subCatEntity.getSubContractor().getCompany());
                json.put("contact", (Object)subCatEntity.getSubContractor().getDisplayName());
                json.put("categories", (Object)subCatEntity.getCategory().getCatCsiDesc());
                json.put("phone", (Object)subCatEntity.getSubContractor().getPhone());
                json.put("rank", (Object)subCatEntity.getSubContractor().getRank());
                json.put("city", (Object)subCatEntity.getSubContractor().getCity());
                json.put("state", (Object)subCatEntity.getSubContractor().getState());
                json.put("county", (Object)subCatEntity.getSubContractor().getCountry());
                json.put("union", (Object)subCatEntity.getSubContractor().getUnion());
                json.put("nonUnion", (Object)subCatEntity.getSubContractor().getNonUnion());
                json.put("subCatId", (Object)subCatEntity.getId());
                json.put("status", (Object)status);
                json.put("selected", selectall);
                json.put("isgcmember", (Object)isgcmember);
                json.put("bbgroups", (Object)"");
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", subCatsSize);
            jsonGlobal.put("iTotalDisplayRecords", subCatsSize);
            jsonGlobal.put("iTotalNotInvited", (int)var38_51);
            jsonGlobal.put("aaData", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="get/{userName}")
    @Consumes(value={"application/json"})
    public Response getUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            JSONObject json = new JSONObject();
            identityManager.getOrCreateIdentity("organization", userName);
            SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(userName);
            if (userInfo == null) {
                org.exoplatform.social.core.identity.model.Identity userId = identityManager.getOrCreateIdentity("organization", userName);
                if (userId == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                UserHandler uh = this.orgService.getUserHandler();
                User user = uh.findUserByName(userName);
                if (user == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                json.put("firstName", (Object)user.getFirstName());
                json.put("lastName", (Object)user.getLastName());
                json.put("displayName", (Object)user.getDisplayName());
                json.put("email", (Object)user.getEmail());
                Profile uProfile = userId.getProfile();
                if (uProfile.getPhones() != null) {
                    json.put("phone", ((Map)uProfile.getPhones().get(0)).get("value"));
                }
                json.put("avatar", (Object)uProfile.getAvatarUrl());
                json.put("gcgroup", (Object)this.getGcGroup(userName));
                return Response.ok((Object)json.toString(), (String)"application/json").build();
            }
            json.put("firstName", (Object)userInfo.getFirstName());
            json.put("lastName", (Object)userInfo.getLastName());
            json.put("displayName", (Object)userInfo.getDisplayName());
            json.put("email", (Object)userInfo.getEmail());
            json.put("secondemail", (Object)userInfo.getSecondemail());
            json.put("webSite", (Object)userInfo.getWebSite());
            json.put("notes", (Object)userInfo.getNotes());
            json.put("phone", (Object)userInfo.getPhone());
            json.put("mainPhoneType", (Object)userInfo.getMainPhoneType());
            json.put("secondPhone", (Object)userInfo.getSecondPhone());
            json.put("secondPhoneType", (Object)userInfo.getSecondPhoneType());
            json.put("faxnumber", (Object)userInfo.getFaxnumber());
            json.put("company", (Object)userInfo.getCompany());
            json.put("refUID", (Object)userInfo.getRefUID());
            json.put("city", (Object)userInfo.getCity());
            json.put("state", (Object)userInfo.getState());
            json.put("county", (Object)userInfo.getCountry());
            json.put("country", (Object)userInfo.getCountry());
            json.put("lonlat", (Object)userInfo.getLonlat());
            json.put("street", (Object)userInfo.getStreet());
            json.put("address2", (Object)userInfo.getAddress2());
            json.put("zip", (Object)userInfo.getZip());
            json.put("rank", (Object)userInfo.getRank());
            json.put("weburl", (Object)userInfo.getWeburl());
            json.put("proview", (Object)userInfo.getProview());
            json.put("prevailingWage", (Object)userInfo.getPrevailingWage());
            json.put("union", (Object)userInfo.getUnion());
            json.put("nonUnion", (Object)userInfo.getNonUnion());
            JSONArray subbbgroups = new JSONArray();
            List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(userName, 0, 0);
            String categories = "";
            String categoriesId = "";
            for (SubCatEntity subcat : subcats) {
                categories = categories.equals("") ? subcat.getCategory().getCatCsiDesc() : categories + ";" + subcat.getCategory().getCatCsiDesc();
                categoriesId = categoriesId.equals("") ? subcat.getCategory().getId() : categoriesId + ";" + subcat.getCategory().getId();
                List<SubCatGroupEntity> subgroups = subCatGroupRelationStorage.getRelationShipBySubCatId(subcat.getId(), 0, 0);
                for (SubCatGroupEntity group : subgroups) {
                    subbbgroups.put((Object)group.getId());
                }
            }
            json.put("categories", (Object)categories);
            json.put("categoriesId", (Object)categoriesId);
            json.put("bbgroups", (Object)subbbgroups);
            org.exoplatform.social.core.identity.model.Identity userId = identityManager.getOrCreateIdentity("organization", userName, true);
            if (userId != null) {
                Profile uSProfile = userId.getProfile();
                if (uSProfile.getAvatarUrl() != null) {
                    json.put("avatar", (Object)uSProfile.getAvatarUrl());
                } else {
                    json.put("avatar", (Object)DefaultAvatar);
                }
            } else {
                json.put("avatar", (Object)DefaultAvatar);
            }
            return Response.ok((Object)json.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getgcuser/{userName}")
    @Consumes(value={"application/json"})
    public Response getGCUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            Profile uProfile;
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
            org.exoplatform.social.core.identity.model.Identity userId = identityManager.getOrCreateIdentity("organization", userName);
            if (userId == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            JSONObject json = new JSONObject();
            UserHandler uh = this.orgService.getUserHandler();
            User user = uh.findUserByName(userName);
            if (user == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            json.put("firstName", (Object)user.getFirstName());
            json.put("lastName", (Object)user.getLastName());
            json.put("displayName", (Object)user.getDisplayName());
            json.put("email", (Object)user.getEmail());
            json.put("userId", (Object)user.getUserName());
            String companyname = "";
            String position = "Employee";
            if (companyInfoStorage.getCompanyInfo() != null) {
                companyname = companyInfoStorage.getCompanyInfo().getCompanyName();
            }
            if ((uProfile = userId.getProfile()).getPhones() != null) {
                json.put("phone", ((Map)uProfile.getPhones().get(0)).get("value"));
            }
            if (!json.has("company") || json.get("company").equals("")) {
                json.put("company", (Object)companyname);
            }
            if (!json.has("position") || json.get("position").equals("")) {
                json.put("position", (Object)position);
            }
            if (uProfile.getAvatarUrl() != null) {
                json.put("avatar", (Object)uProfile.getAvatarUrl());
            } else {
                json.put("avatar", (Object)DefaultAvatar);
            }
            json.put("gcgroup", (Object)this.getGcGroup(userName));
            if (uProfile.getProperty("deleted") != null) {
                json.put("deleted", uProfile.getProperty("deleted"));
            }
            return Response.ok((Object)json.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="senditb")
    @Consumes(value={"application/json"})
    public Response sendItb(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="addall") boolean addall, @QueryParam(value="bidscop") boolean bidScop, BbMessage message) throws Exception {
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ListenerService listenerService = (ListenerService)PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
        ProjectSubDAO projectSubDAO = (ProjectSubDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class));
        Response tmpResponse = null;
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        Space project = spaceService.getSpaceByPrettyName(message.getProjectId());
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        StaffEntity staff = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (addall) {
            if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
            LOG.info((Object)("Conversation state messaging in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
            String bidscoped = "no";
            if (bidScop) {
                bidscoped = "yes";
            }
            MessagingRunner messagingRunner = new MessagingRunner(project, portalContainerName, message, ConversationState.getCurrent().getIdentity(), false, Util.getBaseUrl(), bidscoped, ConversationState.getCurrent());
            Thread messagingRunnerThread = new Thread((Runnable)messagingRunner, "Messaging Runner Thread");
            messagingRunnerThread.start();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Mails sent");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        tmpResponse = this.addEveryone(request, response, uriInfo, message.getProjectId(), message.getRelations());
        if (tmpResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            return tmpResponse;
        }
        ArrayList<ProjectSubEntity> relations = new ArrayList<ProjectSubEntity>();
        for (String subCat : message.getRelations()) {
            ProjectSubEntity relationShip;
            SubCatEntity subcat_ = subCatStorage.getSubCat(subCat);
            if (subcat_.getSubContractor().getId() == "" || subcat_.getCategory().getId() == "" || !(relationShip = projectSubRelationShipStorage.getRelationShip(subcat_.getSubContractor().getId(), message.getProjectId(), subcat_.getCategory().getId())).getStatus().equals("NOT_MESS")) continue;
            relations.add(relationShip);
        }
        if (relations.size() == 0) {
            return tmpResponse;
        }
        for (ProjectSubEntity projectSubEntity : relations) {
            spaceService.addMember(project, projectSubEntity.getSubContractor().getId());
            projectSubEntity.setStatus("INVITED");
            projectSubDAO.update(projectSubEntity);
            listenerService.broadcast("sendItb", (Object)projectSubEntity, (Object)sourceIdentity.getRemoteId());
        }
        return tmpResponse;
    }

    private Response addEveryone(HttpServletRequest request, HttpServletResponse response, UriInfo uriInfo, String projectId, List<String> relations) throws Exception {
        BbFilteredSearchRequest searchRequest = new BbFilteredSearchRequest();
        searchRequest.setSubcats(relations);
        return this.addEveryone(request, response, uriInfo, projectId, false, searchRequest);
    }

    @POST
    @Path(value="addeveryone/{projectId}")
    @Consumes(value={"application/json"})
    public Response addEveryone(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, @QueryParam(value="addall") boolean addall, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        UserHandler uh = this.orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        List<String> subCats = searchRequest.getSubcats();
        try {
            int displaystart;
            if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn((Object)"Project not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            Boolean isMulti = false;
            int n = displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            if (addall) {
                LOG.info((Object)("Conversation state subcat in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
                SubCatRunner subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.PROJECT_SUB, ConversationState.getCurrent());
                Thread createSubCatRelation = new Thread((Runnable)subCatRunner, "Sub Cat Runner Thread");
                createSubCatRelation.start();
                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", (Object)(searchRequest.getTotRecords() + " Company Contacts have now been added to your project " + project.getPrettyName() + " To message those vendors please click on the \"Not Yet Invited\" tab"));
                LOG.info(jsonGlobal.get("message"));
                return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
            }
            for (String subcat : subCats) {
                SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);
                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "NOT_MESS", "", subcat_.getSubContractor().getRank(), "no");
                    continue;
                }
                LOG.warn((Object)"Sub Id or categorie is null, relationship will not be created");
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="addtoproject/{projectId}/{status}")
    @Consumes(value={"application/json"})
    public Response addToProject(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, @PathParam(value="status") String status, @QueryParam(value="gcHost") String gcHost, @QueryParam(value="projectUrl") String projectUrl, List<String> subCats) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        UserHandler uh = this.orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        int i = 0;
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn((Object)"Project not found");
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            Boolean isMulti = false;
            if (status.equals("invited")) {
                status = "INVITED";
            } else if (status.equals("rev")) {
                status = "REVIEWING";
            } else if (status.equals("bid")) {
                status = "BIDDING";
            } else if (status.equals("nbid")) {
                status = "NOT_BIDDING";
            } else if (status.equals("submit")) {
                status = "AWARDED";
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"status should be in: {notmess,invited,rev,nbid,submit} ").build();
            }
            for (String subcat : subCats) {
                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);
                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    try {
                        String mailText;
                        String subject;
                        User user_ = uh.findUserByName(subcat_.getSubContractor().getId());
                        projectUrl = projectUrl.replaceAll("portal/", "");
                        org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", project.getPrettyName(), true);
                        Profile prProfile = prIdentity.getProfile();
                        Profile uProfile = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("organization", user_.getUserName(), true).getProfile();
                        uProfile.setProperty("itbsent", (Object)new SimpleDateFormat("dd/MM/yy").format(Utils.getTime()));
                        Util.getIdentityManager((String)portalContainerName).updateProfile(uProfile);
                        String url = "http://" + gcHost + "/portal/invitations?userName=" + subcat_.getSubContractor().getId() + "&initialURI=" + projectUrl + "/projectSettings";
                        String to = user_.getUserName();
                        if (!UsersRestService.sendMail(to, subject = "Invitation to bid on the " + project.getPrettyName() + " project", mailText = " <div align=center>\n\n        <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:90%; max-width:790px;\">\n          <tr>\n            <td width=\"100%\" style=\"border-top: 4px solid #707070; border-right: 4px solid #707070; border-bottom: 4px solid #707070; border-left: 4px solid #707070; padding: 8px 12px;\">\n\n\n        \t\t\n                  <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"8\">\n                    <tr>\n                      <td width=\"50%\" align=\"left\" style=\" border-right: 1px solid #c2c2c2;  border-bottom: 1px solid #c2c2c2;\">\n   \n                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n                          <tr>\n                            <td colspan=\"2\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px\">INVITATION TO BID</td>             \n                          </tr>\n                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>To</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + uProfile.getProperty("company") + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>ATTN</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getDisplayName() + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b>&nbsp;&nbsp;&nbsp;</td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(123) 456-7890</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Email</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getEmail() + "</td>\n                          </tr>\n                        </table>\n                      </td>\n                      <td width=\"50%\" align=\"center\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; border-bottom: 1px solid #c2c2c2; padding-left: 18px\">\n                        <IMG style=\"-ms-interpolation-mode: bicubic; width:55%; max-width:180px; max-height:60px\"\n                        border=0 \n                        \n                        align=\"middle\" src=\"http://" + gcHost + "/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png\">\n                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n\n                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n                          <tr>\n                            <td align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>From</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">General Contractor Inc<br><a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">ProView Listing</a></td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Contact</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getFullName() + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Title</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getPosition() + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(866) 558-5515 / (866) 558-5516</td>\n                          </tr>\n                          <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                        </table>\n                      </td>\n                    </tr>\n                    <tr>\n                      <td colspan=\"2\" align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; border-bottom: 1px solid #c2c2c2;\">\n                        Hi, <b>" + user_.getFirstName() + "</b>,\n                        <br><br>\n                        We have selected your company to submit a bid on the project listed below.  Please click on the &#8216;Project Details&#8217; for the full project overview and documents.\n                      </td>\n                    </tr>\n                    <tr>\n                      <td colspan=\"2\">\n                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n                          <tr>\n                            <td width=\"15.5%\" valign=\"top\"><img style=\"-ms-interpolation-mode: bicubic; width:100%; max-width:101px; max-height:101px\"\n                                border=0 \n                                alt=\"\" \n                                align=middle src=\"http://\"" + gcHost + project.getAvatarUrl() + ">\n                            </td>\n                            <td width=\"84.5%\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px; line-height: 18px;\">\n                              <b>" + project.getDisplayName() + "</b><br>\n                              <span style=\"font-size: 14px; line-height: 16px;\">" + prProfile.getProperty("adress") + "</span>\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                                <tr>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Bids Due</b>\n                                  </td>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("bidsDueDate") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Start Date:</b>\n                                  </td>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                   " + prProfile.getProperty("startDate") + "\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                              </table>\n                            </td>\n                          </tr>\n                          <tr>\n                            <td colspan=\"2\">\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n                                \n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Project Status</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                   " + prProfile.getProperty("projectStatus") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Number of Buildings</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("nbBuildings") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Stories above ground</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("storiesAboveGrd") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Square Footage</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("totalSqFt") + " sq. ft.\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Project Description</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + project.getDescription() + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td colspan=\"2\" align=\"center\" valign=\"middle\" bgcolor=\"#e0e0e0\" style=\"border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2; padding: 8px 0px\">\n                                    <a href=\"" + url + "\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:184px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/details.jpg\" target=\"_blank\"></a>\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                                <tr>\n                                  <td colspan=\"2\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; padding: 10px 0px\">\n                                    You&#8217;ve been selected to bid on the following trade(s). Please respond by clicking on one of the options below.\n                                  </td>\n                                </tr>\n                                <tr>  \n                              </table>\n\n                              <h1 style=\"text-align: center;\">" + bBCategoryStorage.getBBCategory(subcat_.getCategory().getId()).getCatCsiDesc() + "</h1>            \n\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n                                <tr>\n                                  <td align=\"right\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + subcat_.getCategory().getId() + "/" + subcat_.getSubContractor().getId() + "/NOT_BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n                                  </td>\n                                  <td align=\"center\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + subcat_.getCategory().getId() + "/" + subcat_.getSubContractor().getId() + "/UNDECIDED\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n                                  </td>\n                                  <td align=\"left\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + subcat_.getCategory().getId() + "/" + subcat_.getSubContractor().getId() + "/BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n                                <tr>\n                                  <td colspan=\"3\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; padding: 10px 0px;\">\n                                    If you no longer would lid to receive bid invitations <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">click here</a> or call (888) 303-2243\n                                  </td>\n                                </tr>\n                              </table>\n\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" bgcolor=\"#055092\">\n                                <tr>\n                                  <td align=\"left\" bgcolor=\"#055092\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:110px; height:44px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/tbb.jpg\">\n                                  </td>\n                                  <td align=\"left\" valign=\"middle\" bgcolor=\"#055092\" style=\"font-family:Helvetica, Arial, sans-serif; color:#FFFFFF; font-size: 12px;\">\n                                    <b>AndersonConstruction, Inc</b> has shared this project opportunity with you using BB-Build.  If you need  technical help, please call BB-Build Support at (888) 303-2243\n                                  </td>\n                                </tr>\n                              </table>\n                            </td>\n                          </tr>\n                        </table>\n                      </td>\n                    </tr>\n                  </table>\n          \n  \n\n\n        </td>\n        </tr>\n        </table>\n\n    </div>", false)) continue;
                        spaceService.addInvitedUser(project, subcat_.getSubContractor().getId());
                        projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "NOT_MESS", "", subcat_.getSubContractor().getRank(), "no");
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        ++i;
                    }
                    continue;
                }
                LOG.warn((Object)"Sub Id or categorie is null, relationship will not be created");
            }
            JSONObject jsonGlobal = new JSONObject();
            if (i == 0) {
                jsonGlobal.put("message", (Object)"Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            } else {
                jsonGlobal.put("message", (Object)"Some vendors were not added to the project, Please contact the support for assistance");
            }
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="importusers")
    @Consumes(value={"application/json"})
    public Response importUsers(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="projectid") String projectId, List<SubContractor> users) throws Exception {
        if (users == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Please select a CSV file").build();
        }
        LOG.info((Object)"service started");
        LOG.info((Object)this.orgService.getClass().getName());
        Long start = System.currentTimeMillis();
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        Node catLocationNode = null;
        Node subCatLocationNode = null;
        Node subUserInfoLocationNode = null;
        try {
            if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = manageableRepository.getSystemSession("social");
            Node socialProductionNode = (Node)session.getItem("/production");
            if (!socialProductionNode.hasNode("bbcategories")) {
                catLocationNode = socialProductionNode.addNode("bbcategories", "tbb:catLocation");
                catLocationNode.addMixin("mix:referenceable");
                catLocationNode.getSession().save();
            } else {
                catLocationNode = socialProductionNode.getNode("bbcategories");
            }
            if (!socialProductionNode.hasNode("subcategories")) {
                subCatLocationNode = socialProductionNode.addNode("subcategories", "tbb:subCatLocation");
                subCatLocationNode.addMixin("mix:referenceable");
                subCatLocationNode.getSession().save();
            } else {
                subCatLocationNode = socialProductionNode.getNode("subcategories");
            }
            if (!socialProductionNode.hasNode("subUserInfos")) {
                subUserInfoLocationNode = socialProductionNode.addNode("subUserInfos", "tbb:subUserInfoLocation");
                subUserInfoLocationNode.addMixin("mix:referenceable");
                subUserInfoLocationNode.getSession().save();
            } else {
                subUserInfoLocationNode = socialProductionNode.getNode("subUserInfos");
            }
            int i = 0;
            boolean save = false;
            try {
                for (SubContractor userIn : users) {
                    String name = "gc_" + userIn.getUserid();
                    String categories = "";
                    String categoriesId = "";
                    name = name.toLowerCase();
                    boolean ch = true;
                    name = name.replace(" ", "");
                    name = name.replace(".", "");
                    if (userIn.getCompany() != null) {
                        userIn.setCompany(StringEscapeUtils.unescapeHtml((String)userIn.getCompany()));
                    }
                    this.createUserInfo(subUserInfoLocationNode, name, userIn, false);
                    if (userIn.getCategories() != null) {
                        userIn.setCategories(StringEscapeUtils.unescapeHtml((String)userIn.getCategories()));
                        for (String cat : userIn.getCategories().split("\\^")) {
                            try {
                                String catId = cat.toLowerCase();
                                while (ch) {
                                    ch = false;
                                    if (UsersRestService.isLowerCaseLetterOrDigit(catId.charAt(catId.length() - 1))) continue;
                                    catId = catId.substring(0, catId.length() - 1);
                                    ch = true;
                                }
                                if (!(catId = catId.replace(" ", "")).split("\\|")[0].equals("")) {
                                    catId = catId.split("\\|")[0];
                                }
                                if (cat.split("\\|").length > 1) {
                                    this.createBBCategory(catLocationNode, catId, cat.split("\\|")[1], "", "", "", save);
                                    if (!this.createSubCat(subCatLocationNode, name, catId, userIn, "0", "", "", cat.split("\\|")[1], save)) {
                                        LOG.info((Object)("Vendor " + userIn.getFirstName() + " " + userIn.getLastName() + " with category " + cat.split("\\|")[1] + " already exists"));
                                    }
                                    if (categories.equals("")) {
                                        categories = cat.split("\\|")[1];
                                        categoriesId = catId;
                                        continue;
                                    }
                                    categories = categories + ";" + cat.split("\\|")[1];
                                    categoriesId = categoriesId + ";" + catId;
                                    continue;
                                }
                                this.createBBCategory(catLocationNode, catId, cat, "", "", "", save);
                                if (!this.createSubCat(subCatLocationNode, name, catId, userIn, "0", "", "", cat, save)) {
                                    LOG.info((Object)("Vendor " + userIn.getFirstName() + " " + userIn.getLastName() + " with category " + cat + " already exists"));
                                }
                                if (categories.equals("")) {
                                    categories = cat;
                                    categoriesId = catId;
                                    continue;
                                }
                                categories = categories + ";" + cat;
                                categoriesId = categoriesId + ";" + catId;
                            }
                            catch (Exception e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    LOG.info((Object)(++i));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                catLocationNode.getSession().save();
                subCatLocationNode.getSession().save();
                subUserInfoLocationNode.getSession().save();
            }
            LOG.info((Object)("Conversation state import in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
            ImportRunner importRunner = new ImportRunner(users, projectId, sourceIdentity, ConversationState.getCurrent());
            Thread importRunnerThread = new Thread((Runnable)importRunner, "Import Runner Thread");
            importRunnerThread.start();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)(i + " Users Imported"));
            LOG.info((Object)("Importing done " + String.valueOf(System.currentTimeMillis() - start) + " ms"));
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="importbbusers")
    @Consumes(value={"application/json"})
    public Response importBbUsers(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="maxvendors") int maxVendors, BbSerachResult result) throws Exception {
        LOG.info((Object)"service started");
        LOG.info((Object)this.orgService.getClass().getName());
        request.getRequestURI();
        Long start = System.currentTimeMillis();
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("organization", result.getUid(), true);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        Space project = null;
        Object user_ = null;
        try {
            if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (result.getProjectId() != null && !result.getProjectId().equals("") && (project = spaceService.getSpaceByPrettyName(result.getProjectId())) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = manageableRepository.getSystemSession("social");
            Node socialProductionNode = (Node)session.getItem("/production");
            Node catLocationNode = null;
            Node subCatLocationNode = null;
            Node subUserInfoLocationNode = null;
            Node relationShipLocationNode = null;
            if (!socialProductionNode.hasNode("bbcategories")) {
                catLocationNode = socialProductionNode.addNode("bbcategories", "tbb:catLocation");
                catLocationNode.addMixin("mix:referenceable");
                catLocationNode.getSession().save();
            } else {
                catLocationNode = socialProductionNode.getNode("bbcategories");
            }
            if (!socialProductionNode.hasNode("subcategories")) {
                subCatLocationNode = socialProductionNode.addNode("subcategories", "tbb:subCatLocation");
                subCatLocationNode.addMixin("mix:referenceable");
                subCatLocationNode.getSession().save();
            } else {
                subCatLocationNode = socialProductionNode.getNode("subcategories");
            }
            if (!socialProductionNode.hasNode("subUserInfos")) {
                subUserInfoLocationNode = socialProductionNode.addNode("subUserInfos", "tbb:subUserInfoLocation");
                subUserInfoLocationNode.addMixin("mix:referenceable");
                subUserInfoLocationNode.getSession().save();
            } else {
                subUserInfoLocationNode = socialProductionNode.getNode("subUserInfos");
            }
            if (!socialProductionNode.hasNode("relationships")) {
                relationShipLocationNode = socialProductionNode.addNode("relationships", "tbb:relationShipLocation");
                relationShipLocationNode.addMixin("mix:referenceable");
                relationShipLocationNode.getSession().save();
            } else {
                relationShipLocationNode = socialProductionNode.getNode("relationships");
            }
            if (maxVendors == 0) {
                maxVendors = 200;
            }
            LOG.info((Object)("Number of Vendors saved per transaction = " + maxVendors));
            int i = 0;
            int j = 0;
            boolean save = false;
            try {
                for (SubContractor userIn : result.getVendors()) {
                    LOG.info((Object)("Importing user " + userIn.getFirstName() + " " + userIn.getLastName()));
                    String name = "gc_" + userIn.getUserid();
                    String categories = "";
                    String categoriesId = "";
                    name = name.toLowerCase();
                    boolean ch = true;
                    name = name.replace(" ", "");
                    name = name.replace(".", "");
                    if (userIn.getCompany() != null) {
                        userIn.setCompany(StringEscapeUtils.unescapeHtml((String)userIn.getCompany()));
                    }
                    this.createUserInfo(subUserInfoLocationNode, name, userIn, false);
                    if (userIn.getCategories() != null) {
                        userIn.setCategories(StringEscapeUtils.unescapeHtml((String)userIn.getCategories()));
                        for (String cat : userIn.getCategories().split("\\^")) {
                            try {
                                String catId = cat.toLowerCase();
                                String catName = "";
                                while (ch) {
                                    ch = false;
                                    if (UsersRestService.isLowerCaseLetterOrDigit(catId.charAt(catId.length() - 1))) continue;
                                    catId = catId.substring(0, catId.length() - 1);
                                    ch = true;
                                }
                                if (!(catId = catId.replace(" ", "")).split("\\|")[0].equals("")) {
                                    catId = catId.split("\\|")[0];
                                }
                                if (cat.split("\\|").length > 1) {
                                    catName = cat.split("\\|")[1];
                                } else {
                                    LOG.warn((Object)("A category found without pipe delimeter: " + cat));
                                    catName = cat;
                                }
                                this.createBBCategory(catLocationNode, catId, catName, "", "", "", save);
                                if (!this.createSubCat(subCatLocationNode, name, catId, userIn, "0", "", "", catName, save)) {
                                    LOG.info((Object)("Vendor " + userIn.getFirstName() + " " + userIn.getLastName() + " with category " + catName + " already exists"));
                                }
                                if (categories.equals("")) {
                                    categories = catName;
                                    categoriesId = catId;
                                } else {
                                    categories = categories + ";" + catName;
                                    categoriesId = categoriesId + ";" + catId;
                                }
                                String status = "NOT_MESS";
                                if (project == null) continue;
                                try {
                                    if (userIn.getStatus() != null) {
                                        if (userIn.getStatus().equals("notmess")) {
                                            status = "NOT_MESS";
                                        } else if (userIn.getStatus().equals("invited")) {
                                            status = "INVITED";
                                        } else if (userIn.getStatus().equals("rev")) {
                                            status = "REVIEWING";
                                        } else if (userIn.getStatus().equals("bid")) {
                                            status = "BIDDING";
                                        } else if (userIn.getStatus().equals("nbid")) {
                                            status = "NOT_BIDDING";
                                        } else if (userIn.getStatus().equals("submit")) {
                                            status = "SUBMITTED";
                                        } else {
                                            LOG.info((Object)"Unknown Status, the vendor will be added to the project with not messaged status");
                                        }
                                    }
                                    this.createProjectSubRelationShip(relationShipLocationNode, name, project.getPrettyName(), catId, catName, status, "0", userIn, save);
                                    LOG.info((Object)("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " added to " + result.getProjectId()));
                                }
                                catch (DuplicateNameException e) {
                                    LOG.info((Object)("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " already invited, status has been changed "));
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    LOG.info((Object)(++i));
                    if (++j <= maxVendors) continue;
                    catLocationNode.getSession().save();
                    subCatLocationNode.getSession().save();
                    subUserInfoLocationNode.getSession().save();
                    relationShipLocationNode.getSession().save();
                    j = 0;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                catLocationNode.getSession().save();
                LOG.info((Object)"*Categories Created*");
                subCatLocationNode.getSession().save();
                LOG.info((Object)"*Categories Relations Created*");
                subUserInfoLocationNode.getSession().save();
                LOG.info((Object)"*Vendors Profiles Created*");
                relationShipLocationNode.getSession().save();
                LOG.info((Object)"*Vendors added to project*");
            }
            LOG.info((Object)("Conversation state import in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
            LOG.info((Object)("Conversation userid import in rest:   " + ConversationState.getCurrent().getIdentity().getUserId()));
            LOG.info((Object)("request url import in rest:   " + request.getRequestURL().toString()));
            if (System.getProperty(MASTER_HOST_VARIABLE_NAME) != null && ConversationState.getCurrent().getAttribute("currentTenant") == null) {
                ConversationState.getCurrent().setAttribute("currentTenant", (Object)UsersRestService.getTenantName(request.getRequestURL().toString()));
            }
            ImportRunner importRunner = new ImportRunner(result.getVendors(), result.getProjectId(), sourceIdentity, ConversationState.getCurrent());
            Thread importRunnerThread = new Thread((Runnable)importRunner, "Import Runner Thread");
            importRunnerThread.start();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)(i + " Users Imported"));
            LOG.info((Object)("Importing done " + String.valueOf(System.currentTimeMillis() - start) + " ms"));
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="importbidscoped/{projectId}")
    @Consumes(value={"application/json"})
    public Response importBidScoped(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, SubContractor userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            LOG.warn((Object)"UNAUTHORIZED");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        LOG.info((Object)this.orgService.getClass().getName());
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        UserHandler uh = this.orgService.getUserHandler();
        MembershipTypeHandler mtHandler = this.orgService.getMembershipTypeHandler();
        GroupHandler gHandler = this.orgService.getGroupHandler();
        MembershipHandler mHandler = this.orgService.getMembershipHandler();
        request.getRequestURI();
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        Space project = null;
        User user_ = null;
        if (projectId != null && !projectId.equals("") && (project = spaceService.getSpaceByPrettyName(projectId)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
        }
        try {
            LOG.info((Object)("Importing user " + userIn.getFirstName() + " " + userIn.getLastName() + " from BidScop"));
            String name = "gc_" + userIn.getUserid();
            String categories = "";
            String categoriesId = "";
            name = name.toLowerCase();
            boolean ch = true;
            name = name.replace(" ", "");
            name = name.replace(".", "");
            if (userIn.getCompany() != null) {
                userIn.setCompany(StringEscapeUtils.unescapeHtml((String)userIn.getCompany()));
            }
            Query query = new Query();
            query.setEmail(userIn.getEmail().toLowerCase());
            try {
                if (!this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0 && uh.findUserByName(name) == null) {
                    user_ = ((User[])uh.findUsersByQuery(query).load(0, 1))[0];
                    LOG.warn((Object)(userIn.getEmail() + " already exists, Email should be changed"));
                    String newEmail = "change_me" + user_.getUserName() + "@gmail.com";
                    user_.setEmail(newEmail);
                    this.startRequest();
                    uh.saveUser(user_, true);
                    this.endRequest();
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (uh.findUserByName(name) != null) {
                    this.startRequest();
                    user_ = uh.findUserByName(name);
                    user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
                    user_.setPassword(name);
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.saveUser(user_, true);
                    this.endRequest();
                } else {
                    this.startRequest();
                    user_ = uh.createUserInstance(name);
                    user_.setDisplayName(userIn.getDisplayName());
                    user_.setPassword(name);
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.createUser(user_, true);
                    Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                    mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                    String[] usersGroup = gHandler.findGroupById("/platform/users");
                    mHandler.linkMembership(user_, (Group)usersGroup, mtHandler.findMembershipType("member"), false);
                    LOG.info((Object)("SubContractor " + userIn.getDisplayName() + " imported"));
                    LOG.info((Object)("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " created"));
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                Response usersGroup = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
                return usersGroup;
            }
            finally {
                this.endRequest();
            }
            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(name, userIn);
            if (userIn.getCategories() != null) {
                userIn.setCategories(StringEscapeUtils.unescapeHtml((String)userIn.getCategories()));
                for (String cat : userIn.getCategories().split("\\^")) {
                    try {
                        String catId = cat.toLowerCase();
                        String catName = "";
                        while (ch) {
                            ch = false;
                            if (UsersRestService.isLowerCaseLetterOrDigit(catId.charAt(catId.length() - 1))) continue;
                            catId = catId.substring(0, catId.length() - 1);
                            ch = true;
                        }
                        if (!(catId = catId.replace(" ", "")).split("\\|")[0].equals("")) {
                            catId = catId.split("\\|")[0];
                        }
                        if (cat.split("\\|").length > 1) {
                            catName = cat.split("\\|")[1];
                        } else {
                            LOG.warn((Object)("A category found without pipe delimeter: " + cat));
                            catName = cat;
                        }
                        bBCategoryStorage.createBBCategory(catId, catName, "", "", "");
                        SubCatEntity subCat = subCatStorage.createSubCat(name, catId, subUserInfo, "0", "", "", catName);
                        if (categories.equals("")) {
                            categories = catName;
                            categoriesId = catId;
                        } else {
                            categories = categories + ";" + catName;
                            categoriesId = categoriesId + ";" + catId;
                        }
                        String status = "NOT_MESS";
                        if (project == null) continue;
                        try {
                            if (userIn.getStatus() != null) {
                                if (userIn.getStatus().equals("notmess")) {
                                    status = "NOT_MESS";
                                } else if (userIn.getStatus().equals("invited")) {
                                    status = "INVITED";
                                } else if (userIn.getStatus().equals("rev")) {
                                    status = "REVIEWING";
                                } else if (userIn.getStatus().equals("bid")) {
                                    status = "BIDDING";
                                } else if (userIn.getStatus().equals("nbid")) {
                                    status = "NOT_BIDDING";
                                } else if (userIn.getStatus().equals("submit")) {
                                    status = "SUBMITTED";
                                } else {
                                    LOG.info((Object)"Unknown Status, the vendor will be added to the project with not messaged status");
                                }
                            }
                            projectSubRelationShipStorage.createProjectSubRelationShip(subCat, project.getPrettyName(), status, "", "0", "yes");
                            if (!userIn.getStatus().equals("notmess")) {
                                Utils.addToSpace(project, user_.getUserName());
                            }
                            LOG.info((Object)("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " added to " + projectId));
                        }
                        catch (DuplicateNameException e) {
                            LOG.info((Object)("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " already invited, status has been changed "));
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage)PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);
            simpleNotifServiceStorage.createSimpleNotification(project.getEditor(), "New Vendor is imported fom Bidscop", BSIMPORT_NOTIF_TYPE, 1);
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("accessUrl", (Object)URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + name + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings"));
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="create")
    @Consumes(value={"application/json"})
    public Response createUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, SubContractor userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        if (staffEntity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubGcStorage subGcStorage = (SubGcStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
        CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        UserHandler uh = this.orgService.getUserHandler();
        MembershipTypeHandler mtHandler = this.orgService.getMembershipTypeHandler();
        GroupHandler gHandler = this.orgService.getGroupHandler();
        MembershipHandler mHandler = this.orgService.getMembershipHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        try {
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            if (userIn.getUnion() == "true") {
                userIn.setUnion("yes");
            }
            if (userIn.getUnion() == "false") {
                userIn.setUnion("no");
            }
            if (userIn.getUnion() == "") {
                userIn.setUnion("unknown");
            }
            if (userIn.getNonUnion() == "true") {
                userIn.setNonUnion("yes");
            }
            if (userIn.getNonUnion() == "false") {
                userIn.setNonUnion("no");
            }
            if (userIn.getNonUnion() == "") {
                userIn.setNonUnion("unknown");
            }
            Query query = new Query();
            query.setEmail(userIn.getEmail());
            if (!this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0) {
                LOG.warn((Object)("A Vendor with the email: " + userIn.getEmail() + " exists"));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("A Vendor with the email: " + userIn.getEmail() + " exists")).build();
            }
            String name = "gc_" + String.valueOf(date.getTime());
            while (!UsersRestService.isLowerCaseLetter(name.charAt(0))) {
                name = name.substring(1);
            }
            this.startRequest();
            User user = uh.createUserInstance(name);
            user.setPassword(name);
            user.setEmail(userIn.getEmail());
            user.setLastName(userIn.getLastName());
            user.setFirstName(userIn.getFirstName());
            user.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
            uh.createUser(user, true);
            Group subGroup = gHandler.findGroupById("/organization/subcontractors");
            mHandler.linkMembership(user, subGroup, mtHandler.findMembershipType("member"), false);
            if (userIn.getWebSite() != null && !userIn.getWebSite().equals("") && !userIn.getWebSite().contains("http")) {
                userIn.setWebSite("http://" + userIn.getWebSite());
            }
            if (userIn.getProview() != null && !userIn.getProview().equals("") && !userIn.getProview().contains("http")) {
                userIn.setProview("http://" + userIn.getProview());
            }
            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(name, userIn);
            Profile uProfile = null;
            try {
                org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", user.getUserName(), true);
                uProfile = userIdentity.getProfile();
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (userIn.getAvatar() != null && userIn.getAvatar().compareTo(DefaultAvatar) != 0) {
                try {
                    String userId;
                    ManageableRepository repository = this.repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService)PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String string = userId = state != null ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png") && userIn.getAvatar().contains("avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment((InputStream)inputStream, (int)200, (int)0, null, (String)"avatar", (String)"image/png", null);
                        uProfile.setProperty("avatar", (Object)avatar);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
                identityManager.updateProfile(uProfile);
            }
            Util.getIdentityManager((String)portalContainerName).updateProfile(uProfile);
            String[] categoriesId = userIn.getCategoriesId().split(";");
            String[] categories = userIn.getCategories().split(";");
            if (userIn.getCategoriesId() != null && userIn.getCategoriesId().compareTo("") != 0) {
                for (int i = 0; i < categoriesId.length; ++i) {
                    if (bBCategoryStorage.getBBCategory(categoriesId[i]) != null) continue;
                    CategoryEntity cat = bBCategoryStorage.createBBCategory(categoriesId[i], categories[i], "", "", "");
                    SubCatEntity subCatEntity = subCatStorage.createSubCat(name, cat, subUserInfo, "0");
                    String string = staffEntity.getId() + "_" + subCatEntity.getId();
                }
            }
            LOG.info((Object)("SubContractor " + userIn.getFirstName() + " " + userIn.getFirstName() + " imported"));
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="createsub")
    @Consumes(value={"application/json"})
    public Response createSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, SubContractor userIn) throws Exception {
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        SubGcStorage subGcStorage = (SubGcStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
        GeneralContractorDAO generalContractorDAO = (GeneralContractorDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(GeneralContractorDAO.class));
        UserHandler uh = this.orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            Query query = new Query();
            query.setEmail(userIn.getEmail());
            if (uh.findUsersByQuery(query).getSize() > 0) {
                LOG.warn((Object)("A Vendor with the email: " + userIn.getEmail() + " exists"));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("A Vendor with the email: " + userIn.getUserid() + " exists")).build();
            }
            if (uh.findUserByName(userIn.getUserid()) != null) {
                LOG.warn((Object)"A Vendor with the login  exists");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("A Vendor with the email: " + userIn.getUserid() + " exists")).build();
            }
            this.startRequest();
            User user = uh.createUserInstance(userIn.getUserid());
            user.setPassword(userIn.getPassword());
            user.setEmail(userIn.getEmail());
            user.setLastName(userIn.getLastName());
            user.setFirstName(userIn.getFirstName());
            user.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
            uh.createUser(user, true);
            SubStaffCompanyDAO subStaffCompanyDAO = UsersRestService.getService(SubStaffCompanyDAO.class, null);
            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(userIn.getUserid(), userIn);
            SubStaffCompanyEntity subStaffCompanyEntity = new SubStaffCompanyEntity(subUserInfo, userIn.getUserid());
            subStaffCompanyDAO.create(subStaffCompanyEntity);
            LOG.info((Object)("SubContractor " + userIn.getFirstName() + " " + userIn.getFirstName() + " imported"));
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="createsubcompany")
    @Consumes(value={"application/json"})
    public Response createsubcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, SubContractor userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        SubGcStorage subGcStorage = (SubGcStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
        GeneralContractorDAO generalContractorDAO = (GeneralContractorDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(GeneralContractorDAO.class));
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            userIn.setUserid(userIn.getCompany().replaceAll("\\W", ""));
            SubContractorEntity subUserInfo = subUserInfoStorage.updateSubUserInfo(userIn.getUserid(), userIn);
            if (userIn.getSelectedCats() != null) {
                for (String cat : userIn.getSelectedCats()) {
                    CategoryEntity cat_ = bBCategoryStorage.getBBCategory(cat);
                    if (cat_ == null) continue;
                    String subcatis = cat_.getId() + userIn.getUserid();
                    SubCatEntity subCatEntity = subCatStorage.createSubCat(subcatis, cat_, subUserInfo, "0");
                }
            }
            LOG.info((Object)"SubContractor imported");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="editsubcompany")
    @Consumes(value={"application/json"})
    public Response editsubcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, SubContractor userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        GeneralContractorDAO generalContractorDAO = (GeneralContractorDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(GeneralContractorDAO.class));
        UserHandler uh = this.orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(userIn.getUserid(), userIn);
            LOG.info((Object)"SubCompany created");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" Company Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="getsubcompany")
    public Response getsubcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        JSONObject jsonGlobal = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        SubContractorDAO subContractorDAO = UsersRestService.getService(SubContractorDAO.class, null);
        return Response.ok(subContractorDAO.getAll(0, 0), (MediaType)mediaType).build();
    }

    @POST
    @Path(value="createcats")
    @Consumes(value={"application/json"})
    public Response createCats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, CategoryEntity[] cats) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            for (CategoryEntity category : cats) {
                if (bBCategoryStorage.getBBCategory(category.getId()) != null) continue;
                CategoryEntity categoryEntity = bBCategoryStorage.createBBCategory(category.getId(), category.getCatCsiDesc(), "", "", "");
            }
            LOG.info((Object)"cats  imported");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @GET
    @Path(value="getallcats")
    public Response getAllCats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        try {
            List<CategoryEntity> cats = bBCategoryStorage.getBBCategories(0, 0);
            ArrayList<Category> catsDTOs = new ArrayList<Category>();
            for (CategoryEntity cat : cats) {
                catsDTOs.add(bBCategoryStorage.convert(cat));
            }
            return Response.ok(catsDTOs, (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="creategc")
    @Consumes(value={"application/json"})
    public Response createGCUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, Map<String, String> gcuser) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = this.orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            String gcgroup;
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            String name = gcuser.get("userId");
            User user = null;
            org.exoplatform.social.core.identity.model.Identity userIdentity = null;
            Profile uProfile = null;
            if (uh.findUserByName(name) != null) {
                userIdentity = identityManager.getOrCreateIdentity("organization", name, true);
                uProfile = userIdentity.getProfile();
                if (uProfile.getProperty("deleted") == null || uProfile.getProperty("deleted").equals("true")) {
                    user = uh.findUserByName(name);
                    this.startRequest();
                    user.setPassword(gcuser.get("password"));
                    uh.saveUser(user, true);
                    this.endRequest();
                    uProfile.setProperty("deleted", (Object)"false");
                } else {
                    LOG.warn((Object)(name + " user name already exists, SubContractor will not be Created"));
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(gcuser.get("firstname") + gcuser.get("lastname") + " user name already exists, SubContractor will not be Created")).build();
                }
            }
            if (user != null) {
                Query query = new Query();
                query.setEmail(gcuser.get("email"));
                if (!this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0) {
                    userIdentity = identityManager.getOrCreateIdentity("organization", ((User[])uh.findUsersByQuery(query).load(0, 1))[0].getUserName(), true);
                    uProfile = userIdentity.getProfile();
                    if (uProfile.getProperty("deleted") != null && uProfile.getProperty("deleted").toString().equals("true")) {
                        user = uh.findUserByName(userIdentity.getRemoteId());
                        this.startRequest();
                        user.setPassword(gcuser.get("password"));
                        uh.saveUser(user, true);
                        this.endRequest();
                        uProfile.setProperty("deleted", (Object)"false");
                    } else {
                        LOG.warn((Object)(gcuser.get("email") + " already exists, SubContractor will not be Created"));
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(gcuser.get("email") + " already exists, SubContractor will not be Created")).build();
                    }
                }
            }
            if (user == null) {
                this.startRequest();
                user = uh.createUserInstance(name);
                user.setDisplayName(gcuser.get("firstname") + " " + gcuser.get("lastname"));
                user.setPassword(gcuser.get("password"));
                user.setEmail(gcuser.get("email"));
                user.setLastName(gcuser.get("lastname"));
                user.setFirstName(gcuser.get("firstname"));
                uh.createUser(user, true);
                userIdentity = identityManager.getOrCreateIdentity("organization", user.getUserName(), true);
                uProfile = userIdentity.getProfile();
            }
            if (gcuser.get("phone").compareTo("") != 0) {
                ArrayList phones = new ArrayList();
                HashMap<String, String> phone1 = new HashMap<String, String>();
                phone1.put("key", "Work");
                phone1.put("value", gcuser.get("phone"));
                phones.add(phone1);
                uProfile.setProperty("phones", phones);
            }
            if (gcuser.get("avatar").compareTo(DefaultAvatar) != 0) {
                try {
                    String userId;
                    ManageableRepository repository = this.repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService)PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String string = userId = state != null ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment((InputStream)inputStream, (int)200, (int)0, null, (String)"avatar", (String)"image/png", null);
                        uProfile.setProperty("avatar", (Object)avatar);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            String string = gcgroup = gcuser.get("gcgroup") != "" && gcuser.get("gcgroup") != null ? gcuser.get("gcgroup") : "gcmember";
            if (gcgroup != "" && gcgroup != null) {
                GroupHandler gh = this.orgService.getGroupHandler();
                MembershipHandler mh = this.orgService.getMembershipHandler();
                MembershipTypeHandler mth = this.orgService.getMembershipTypeHandler();
                mh.linkMembership(user, gh.findGroupById(GCS_GROUP), mth.findMembershipType(gcgroup), true);
            }
            identityManager.updateProfile(uProfile);
            User user_ = uh.findUserByName(user.getUserName());
            if (gcuser.get("projectId") != null) {
                try {
                    SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
                    Space project = spaceService.getSpaceByPrettyName(gcuser.get("projectId"));
                    Utils.addToSpace(project, user_.getUserName());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            LOG.info((Object)("SubContractor " + gcuser.get("firstname") + gcuser.get("lastname") + " created"));
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="update/{userName}")
    @Consumes(value={"application/json"})
    public Response updateUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName, SubContractor userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        UserHandler uh = this.orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            User user_;
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            if (userIn.getUnion() == "true") {
                userIn.setUnion("yes");
            }
            if (userIn.getUnion() == "false") {
                userIn.setUnion("no");
            }
            if (userIn.getUnion() == "") {
                userIn.setUnion("unknown");
            }
            if (userIn.getNonUnion() == "true") {
                userIn.setNonUnion("yes");
            }
            if (userIn.getNonUnion() == "false") {
                userIn.setNonUnion("no");
            }
            if (userIn.getNonUnion() == "") {
                userIn.setNonUnion("unknown");
            }
            if ((user_ = uh.findUserByName(userName)) == null) {
                this.startRequest();
                MembershipTypeHandler mtHandler = this.orgService.getMembershipTypeHandler();
                GroupHandler gHandler = this.orgService.getGroupHandler();
                MembershipHandler mHandler = this.orgService.getMembershipHandler();
                ((ComponentRequestLifecycle)this.orgService).startRequest((ExoContainer)PortalContainer.getInstance());
                user_ = uh.createUserInstance(userName);
                user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
                if (this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                    user_.setPassword(Utils.getMd5(userName));
                } else {
                    user_.setPassword(userName);
                }
                user_.setEmail(userIn.getEmail());
                user_.setLastName(userIn.getLastName());
                user_.setFirstName(userIn.getFirstName());
                Date now = new Date();
                user_.setCreatedDate(now);
                uh.createUser(user_, false);
                Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                Group usersGroup = gHandler.findGroupById("/platform/users");
                mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                LOG.info((Object)("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " imported"));
                this.endRequest();
            } else {
                Query query = new Query();
                query.setEmail(userIn.getEmail());
                if (!this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0 && !((User[])uh.findUsersByQuery(query).load(0, 1))[0].getUserName().equals(userName)) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Email Already used").build();
                }
                this.startRequest();
                user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
                user_.setEmail(userIn.getEmail());
                user_.setLastName(userIn.getLastName());
                user_.setFirstName(userIn.getFirstName());
                uh.saveUser(user_, true);
                this.endRequest();
            }
            userIn.setWeburl(userIn.getWebSite());
            if (userIn.getWebSite() != null && !userIn.getWebSite().equals("") && !userIn.getWebSite().contains("http")) {
                userIn.setWebSite("shttp://" + userIn.getWebSite());
            }
            if (userIn.getWebSite() != null && !userIn.getWebSite().equals("") && !userIn.getWebSite().contains("http")) {
                userIn.setWeburl("http://" + userIn.getWebSite());
            }
            if (userIn.getProview() != null && !userIn.getProview().equals("") && !userIn.getProview().contains("http")) {
                userIn.setProview("http://" + userIn.getProview());
            }
            subUserInfoStorage.createSubUserInfo(userName, userIn);
            SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(userName);
            org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", user_.getUserName(), true);
            Profile uProfile = userIdentity.getProfile();
            if (userIn.getAvatar() != null) {
                try {
                    String userId;
                    ManageableRepository repository = this.repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService)PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String string = userId = state != null ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png") && userIn.getAvatar().contains("avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment((InputStream)inputStream, (int)200, (int)0, null, (String)"avatar", (String)"image/png", null);
                        uProfile.setProperty("avatar", (Object)avatar);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            Util.getIdentityManager((String)portalContainerName).updateProfile(uProfile);
            boolean ch = true;
            String[] categoriesId = userIn.getCategoriesId().split(";");
            String[] categories = userIn.getCategories().split(";");
            if (userIn.getCategoriesId() != null && userIn.getCategoriesId().compareTo("") != 0) {
                for (SubCatEntity subcat : subCatStorage.getSubCatsBySubId(userName, 0, 0)) {
                    if (Arrays.asList(categoriesId).contains(subcat.getCategory().getId())) continue;
                    List<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(subcat.getSubContractor().getId(), subcat.getCategory().getId(), 0, 0);
                    for (ProjectSubEntity sub : sublist) {
                        projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                    }
                    subCatStorage.deleteSubCat(subcat.getSubContractor().getId());
                }
                for (int i = 0; i < categoriesId.length; ++i) {
                    SubCatEntity subcat;
                    if (bBCategoryStorage.getBBCategory(categoriesId[i]) == null) {
                        bBCategoryStorage.createBBCategory(categoriesId[i], categories[i], "", "", "");
                    }
                    if ((subcat = subCatStorage.getSubCat(user_.getUserName() + "_" + categoriesId[i])) == null) {
                        subCatStorage.createSubCat(user_.getUserName(), categoriesId[i], subUserInfo, "0", "", "", categories[i]);
                    } else {
                        subCatStorage.updateSubCat(subcat.getId(), subUserInfo, userIn.getRank());
                    }
                    subcat = subCatStorage.getSubCat(user_.getUserName() + "_" + categoriesId[i]);
                    List<ProjectSubEntity> SubCatRelationShips = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(userName, categoriesId[i], 0, 0);
                    for (ProjectSubEntity subcatrelation : SubCatRelationShips) {
                        projectSubRelationShipStorage.updateProjectSubRelationShip(subcatrelation.getId(), subcat, null, null, null, null, null);
                    }
                }
            }
            LOG.info((Object)("SubContractor " + userIn.getFirstName() + " " + userIn.getFirstName() + " updated"));
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Updated");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="updategc/{userName}")
    @Consumes(value={"application/json"})
    public Response updateGCUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName, Map<String, String> userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = this.orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            String gcgroup;
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            User user = uh.findUserByName(userName);
            if (user == null) {
                LOG.warn((Object)(userName + " user name don't exists"));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(userIn.get("firstname") + userIn.get("lastname") + " user name don't exists")).build();
            }
            this.startRequest();
            user.setDisplayName(userIn.get("firstname") + " " + userIn.get("lastname"));
            user.setEmail(userIn.get("email"));
            if (!userIn.get("password").equals("")) {
                user.setPassword(userIn.get("password"));
            }
            user.setFirstName(userIn.get("firstname"));
            user.setLastName(userIn.get("lastname"));
            uh.saveUser(user, true);
            org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", user.getUserName(), true);
            Profile uProfile = userIdentity.getProfile();
            if (userIn.get("phone").compareTo("") != 0) {
                ArrayList phones = new ArrayList();
                HashMap<String, String> phone1 = new HashMap<String, String>();
                phone1.put("key", "Work");
                phone1.put("value", userIn.get("phone"));
                phones.add(phone1);
                uProfile.setProperty("phones", phones);
            }
            if (userIn.get("avatar") != null) {
                try {
                    String userId;
                    ManageableRepository repository = this.repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService)PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String string = userId = state != null ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png") && userIn.get("avatar").contains("avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment((InputStream)inputStream, (int)200, (int)0, null, (String)"avatar", (String)"image/png", null);
                        uProfile.setProperty("avatar", (Object)avatar);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            String string = gcgroup = userIn.get("gcgroup") != "" ? userIn.get("gcgroup") : "gcmember";
            if (gcgroup != "" && gcgroup != null) {
                GroupHandler gh = this.orgService.getGroupHandler();
                MembershipHandler mh = this.orgService.getMembershipHandler();
                MembershipTypeHandler mth = this.orgService.getMembershipTypeHandler();
                Membership gcmembership = mh.findMembershipByUserGroupAndType(userName, GCS_GROUP, gcgroup);
                if (gcmembership == null) {
                    mh.removeMembership(((Membership)mh.findMembershipsByUserAndGroup(userName, GCS_GROUP).toArray()[0]).getId(), true);
                    mh.linkMembership(user, gh.findGroupById(GCS_GROUP), mth.findMembershipType(gcgroup), true);
                }
            }
            identityManager.updateProfile(uProfile);
            LOG.info((Object)("SubContractor " + userIn.get("firstname") + userIn.get("lastname") + " updated"));
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Updated");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="delete/{userName}")
    @Consumes(value={"application/json"})
    public Response deleteUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName, @QueryParam(value="projectId") String projectId, @QueryParam(value="selectall") boolean selectall, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = this.orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (projectId != null && project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            if (selectall) {
                if (searchRequest.getSubSelect().size() > 0) {
                    BBCategoryStorage bbCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
                    for (String uName : searchRequest.getSubSelect()) {
                        if (searchRequest.getSubcats().contains(uName)) continue;
                        ListAccess<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdListAccess(uName);
                        for (ProjectSubEntity sub : (ProjectSubEntity[])sublist.load(0, sublist.getSize())) {
                            if (null != project) {
                                if (spaceService.isInvitedUser(project, sub.getSubContractor().getId())) {
                                    spaceService.removeInvitedUser(project, sub.getSubContractor().getId());
                                } else if (spaceService.isMember(project, sub.getSubContractor().getId())) {
                                    spaceService.removeMember(project, sub.getSubContractor().getId());
                                }
                            }
                            projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                        }
                        List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(uName, 0, 0);
                        ArrayList<String> subscategories = new ArrayList<String>();
                        for (SubCatEntity subcat : subcats) {
                            if (!subscategories.contains(subcat.getCategory().getId())) {
                                subscategories.add(subcat.getCategory().getId());
                            }
                            subCatStorage.deleteSubCat(subcat.getId());
                        }
                        for (String catid : subscategories) {
                            if (subCatStorage.getSubCatsByCatId(catid, 0, 0).size() != 0) continue;
                            bbCategoryStorage.deleteBBCategory(catid);
                        }
                        User user = uh.findUserByName(uName);
                        if (user == null) {
                            LOG.warn((Object)(uName + " user name don't exists"));
                            continue;
                        }
                        user.setPassword("pass");
                        uh.saveUser(user, true);
                        LOG.info((Object)"SubContractor  deleted");
                    }
                    JSONObject jsonGlobal = new JSONObject();
                    jsonGlobal.put("message", (Object)" SubContractor deleted");
                    return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
                }
                SubCatRunner subCatRunner = null;
                subCatRunner = null != projectId ? new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.DELETE_ALL, ConversationState.getCurrent()) : new SubCatRunner(searchRequest, RelationShipType.DELETE_ALL, ConversationState.getCurrent());
                Thread createSubCatRelation = new Thread((Runnable)subCatRunner, "Sub Cat Runner Thread");
                createSubCatRelation.start();
                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", (Object)(searchRequest.getTotRecords() + " Users Deleted"));
                while (subCatRunner.isRunning()) {
                    Thread.sleep(1000L);
                }
                return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
            }
            BBCategoryStorage bbCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ListAccess<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdListAccess(userName);
            for (ProjectSubEntity sub : (ProjectSubEntity[])sublist.load(0, sublist.getSize())) {
                if (null != project) {
                    if (spaceService.isInvitedUser(project, sub.getSubContractor().getId())) {
                        spaceService.removeInvitedUser(project, sub.getSubContractor().getId());
                    } else if (spaceService.isMember(project, sub.getSubContractor().getId())) {
                        spaceService.removeMember(project, sub.getSubContractor().getId());
                    }
                }
                projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
            }
            List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(userName, 0, 0);
            ArrayList<String> subscategories = new ArrayList<String>();
            for (SubCatEntity subcat : subcats) {
                if (!subscategories.contains(subcat.getCategory().getId())) {
                    subscategories.add(subcat.getCategory().getId());
                }
                subCatStorage.deleteSubCat(subcat.getCategory().getId());
            }
            for (String catid : subscategories) {
                if (subCatStorage.getSubCatsByCatId(catid, 0, 0).size() != 0) continue;
                bbCategoryStorage.deleteBBCategory(catid);
            }
            User user = uh.findUserByName(userName);
            if (user == null) {
                LOG.warn((Object)(userName + " user name don't exists"));
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"user don't exists").build();
            }
            user.setPassword("pass");
            uh.saveUser(user, true);
            LOG.info((Object)"SubContractor  deleted");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor deleted");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="deletegc/{userName}")
    @Consumes(value={"application/json"})
    public Response deleteGcUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = this.orgService.getUserHandler();
        MembershipHandler mh = this.orgService.getMembershipHandler();
        try {
            User user = uh.findUserByName(userName);
            if (user == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            ListAccess spaces = spaceService.getMemberSpaces(userName);
            for (Space space : (Space[])spaces.load(0, spaces.getSize())) {
                if (spaceService.isOnlyManager(space, userName)) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("This Gc is the Only Manager of the project " + space.getDisplayName())).build();
                }
                spaceService.removeMember(space, userName);
            }
            Collection memberships = mh.findMembershipsByUserAndGroup(userName, GCS_GROUP);
            for (Membership membership : memberships) {
                mh.removeMembership(membership.getId(), true);
            }
            this.startRequest();
            user.setPassword("pass1234");
            uh.saveUser(user, true);
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            org.exoplatform.social.core.identity.model.Identity userIdentity = identityManager.getOrCreateIdentity("organization", userName, true);
            Profile uProfile = userIdentity.getProfile();
            uProfile.setProperty("deleted", (Object)"true");
            identityManager.updateProfile(uProfile);
            this.endRequest();
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Gc SubContractor deleted").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="updaterank/{subCatId}/{rank}")
    @Consumes(value={"application/json"})
    public Response updateRank(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="subCatId") String subCatId, @PathParam(value="rank") String rank) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            subCatStorage.updateSubCat(subCatId, null, rank);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            List<ProjectSubEntity> SubCatRelationShips = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(subCatId.split("_")[0], subCatId.split("_")[1], 0, 0);
            for (ProjectSubEntity subcatrelation : SubCatRelationShips) {
                projectSubRelationShipStorage.updateProjectSubRelationShip(subcatrelation.getId(), null, null, null, null, rank, null);
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Rank Updated");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="updateranks/{userName}")
    @Consumes(value={"application/json"})
    public Response updateRanks(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName, String[][] ranks) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(userName);
        if (subUserInfo == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            for (String[] rank : ranks) {
                subCatStorage.updateSubCat(rank[0], null, rank[1]);
                List<ProjectSubEntity> SubCatRelationShips = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(rank[0].split("_")[0], rank[0].split("_")[1], 0, 0);
                for (ProjectSubEntity subcatrelation : SubCatRelationShips) {
                    projectSubRelationShipStorage.updateProjectSubRelationShip(subcatrelation.getId(), null, null, null, null, rank[1], null);
                }
                subUserInfo.setRank(rank[1]);
                LOG.info((Object)"Rank Updated");
            }
            LOG.info((Object)("SubContractor " + userName + " updated rank"));
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Rank Updated");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getmystaff")
    @Consumes(value={"application/json"})
    public Response getMyStaff(@Context HttpServletRequest request, @Context HttpServletResponse response, @QueryParam(value="projectId") String projectId, @Context UriInfo uriInfo) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            int sEcho;
            IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
            UserHandler uh = this.orgService.getUserHandler();
            ListAccess staffList = uh.findUsersByGroupId(GCS_GROUP);
            int displaystart = request.getParameter("iDisplayStart") == null ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = request.getParameter("iDisplayLength") == null ? staffList.getSize() : Integer.parseInt(request.getParameter("iDisplayLength"));
            int n = sEcho = request.getParameter("sEcho") == null ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            if (displaylength > staffList.getSize() - displaystart) {
                displaylength = staffList.getSize() - displaystart;
            }
            List<Object> staffList_ = Arrays.asList(staffList.load(displaystart, displaylength));
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project = null;
            if (projectId != null && (project = spaceService.getSpaceByPrettyName(projectId)) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            ArrayList<org.exoplatform.social.core.identity.model.Identity> users = new ArrayList<org.exoplatform.social.core.identity.model.Identity>();
            for (User user : staffList_) {
                try {
                    org.exoplatform.social.core.identity.model.Identity uid = identityManager.getOrCreateIdentity("organization", user.getUserName(), true);
                    users.add(uid);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            for (org.exoplatform.social.core.identity.model.Identity user : users) {
                Profile uProfile = user.getProfile();
                if (uProfile.getProperty("deleted") != null && uProfile.getProperty("deleted").toString().equals("true")) continue;
                JSONObject json = new JSONObject();
                json.put("userName", (Object)user.getRemoteId());
                json.put("fullName", (Object)uProfile.getFullName());
                json.put("company", (Object)"");
                json.put("position", (Object)"Employee");
                if (null != uProfile.getProperty("status")) {
                    json.put("status", uProfile.getProperty("status"));
                } else {
                    json.put("status", (Object)"Not Invited");
                }
                json.put("isMember", false);
                if (project != null && (spaceService.isInvitedUser(project, user.getRemoteId()) || spaceService.isMember(project, user.getRemoteId()))) {
                    json.put("isMember", true);
                }
                jSONArray.put((Object)json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", staffList.getSize());
            jsonGlobal.put("iTotalDisplayRecords", staffList.getSize());
            jsonGlobal.put("aaData", (Object)jSONArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getstaffrole")
    @Consumes(value={"application/json"})
    public Response getStaffRole(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
            String gcRole = "";
            String currentUser = "";
            if (this.getGcGroup(sourceIdentity.getRemoteId()) != null) {
                gcRole = this.getGcGroup(sourceIdentity.getRemoteId());
                currentUser = sourceIdentity.getRemoteId();
            }
            if (sourceIdentity.getRemoteId().equals(PropertyManager.getProperty((String)"exo.super.user"))) {
                gcRole = "gcadmin";
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("gcRole", (Object)gcRole);
            jsonGlobal.put("currentUser", (Object)currentUser);
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="cancelorreject/{projectId}")
    @Consumes(value={"application/json"})
    public Response CancelOrReject(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, @QueryParam(value="addall") boolean addall, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            if (addall) {
                SubCatRunner subCatRunner = null;
                subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.CANCEL_REJECT, ConversationState.getCurrent());
                Thread createSubCatRelation = new Thread((Runnable)subCatRunner, "Sub Cat Runner Thread");
                createSubCatRelation.start();
                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", (Object)(searchRequest.getTotRecords() + " Users canceled or rejected"));
                return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
            }
            JSONObject jsonGlobal = new JSONObject();
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            for (String rel : searchRequest.getSubSelect()) {
                ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);
                if (projectSubRelationShipStorage.getRelationShipCountBySubId(rel_.getSubContractor().getId()) == 0) {
                    if (spaceService.isInvitedUser(project, rel_.getSubContractor().getId())) {
                        spaceService.removeInvitedUser(project, rel_.getSubContractor().getId());
                        jsonGlobal.put("message", (Object)"invitation cancelled");
                    } else if (spaceService.isMember(project, rel_.getSubContractor().getId())) {
                        spaceService.removeMember(project, rel_.getSubContractor().getId());
                        jsonGlobal.put("message", (Object)"SubContractor removed from the project");
                    }
                }
                projectSubRelationShipStorage.deleteProjectSubRelationShip(rel);
            }
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="addstaff/{projectId}")
    @Consumes(value={"application/json"})
    public Response addStaff(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, @QueryParam(value="gcHost") String gcHost, @QueryParam(value="projectUrl") String projectUrl, @QueryParam(value="addall") boolean addall, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = this.orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        List<String> users = searchRequest.getSubcats();
        try {
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            if (addall) {
                ListAccess staffList = uh.findUsersByGroupId(GCS_GROUP);
                List<Object> userList = Arrays.asList(staffList.load(0, staffList.getSize()));
                for (User user : userList) {
                    String fullName;
                    if (users.contains(user.getUserName())) continue;
                    projectUrl = projectUrl.replaceAll("portal/", "");
                    String to = user.getUserName();
                    String url = "http://" + gcHost + "/portal/invitations?userName=" + to + "&initialURI=" + projectUrl + "/projectSettings";
                    String string = fullName = user.getDisplayName() != null ? user.getDisplayName() : user.getFirstName() + " " + user.getLastName();
                    String subject = "Invitation to Join";
                    String mailText = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"660\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#666666;line-height:20px;font-family:HelveticaNeue,verdana,arial,tahoma\">\n\t\t<tbody><tr>\n\t\t\t<td align=\"center\" valign=\"middle\">\n\t\t\t\t<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"#fff\" align=\"center\" style=\"border:1px solid #d8d8d8\">\n\t\t\t\t\t<tbody><tr>\n\t\t\t\t\t\t<td height=\"45\" valign=\"middle\" style=\"margin:0;height:45px;font-weight:bold;vertical-align:middle;background-color:#efefef;font-family:HelveticaNeue,arial,tahoma,serif;color:#2f5e92;font-size:18px;text-align:center\">\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\tInvitation to Join\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</tbody></table>\n\t\t\t\t\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t</font></span><table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" align=\"center\" style=\"border-left:1px solid #d8d8d8;border-right:1px solid #d8d8d8\">\n\t\t\t\t\t<tbody><tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t</font></span><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"92%\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#333;line-height:20px\">\n\t\t\t\t\t\t\t\t<tbody><tr>\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Hi " + fullName + ",</p>\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t You are invited to participate in the project " + project.getDisplayName() + ". To see the Project details, please click on <strong><a href=\"" + url + "\" target=\"_blank\">this link</a></strong> \n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t  </p>\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\"><strong>" + sourceIdentity.getProfile().getFullName() + "</strong></p><span class=\"HOEnZb\"><font color=\"#888888\"><br>\n\n\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\n\t\t\t\t\n\t\t\t</font></span></td></tr><tr> ";
                    if (!UsersRestService.sendMail(to, subject, mailText, false)) continue;
                    try {
                        org.exoplatform.social.core.identity.model.Identity userId = identityManager.getOrCreateIdentity("organization", user.getUserName(), true);
                        Profile uProfile = userId.getProfile();
                        Utils.addToSpace(project, user.getUserName());
                        spaceService.setManager(project, user.getUserName(), true);
                        uProfile.setProperty("status", (Object)"Invited");
                        identityManager.updateProfile(uProfile);
                    }
                    catch (MessageException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", (Object)"Invitation(s) sent successfully.");
                return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
            }
            for (String user : users) {
                String fullName;
                User user_ = uh.findUserByName(user);
                projectUrl = projectUrl.replaceAll("portal/", "");
                String string = user_.getUserName();
                String url = "http://" + gcHost + "/portal/invitations?userName=" + string + "&initialURI=" + projectUrl + "/projectSettings";
                String string2 = fullName = user_.getDisplayName() != null ? user_.getDisplayName() : user_.getFirstName() + " " + user_.getLastName();
                String subject = "Invitation to Join";
                String mailText = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"660\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#666666;line-height:20px;font-family:HelveticaNeue,verdana,arial,tahoma\">\n\t\t<tbody><tr>\n\t\t\t<td align=\"center\" valign=\"middle\">\n\t\t\t\t<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"#fff\" align=\"center\" style=\"border:1px solid #d8d8d8\">\n\t\t\t\t\t<tbody><tr>\n\t\t\t\t\t\t<td height=\"45\" valign=\"middle\" style=\"margin:0;height:45px;font-weight:bold;vertical-align:middle;background-color:#efefef;font-family:HelveticaNeue,arial,tahoma,serif;color:#2f5e92;font-size:18px;text-align:center\">\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\tInvitation to Join\n\t\t\t\t\t\t\t\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</tbody></table>\n\t\t\t\t\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t</font></span><table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" align=\"center\" style=\"border-left:1px solid #d8d8d8;border-right:1px solid #d8d8d8\">\n\t\t\t\t\t<tbody><tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t</font></span><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"92%\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#333;line-height:20px\">\n\t\t\t\t\t\t\t\t<tbody><tr>\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Hi " + fullName + ",</p>\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t You are invited to participate in the project " + project.getDisplayName() + ". To see the Project details, please click on <strong><a href=\"" + url + "\" target=\"_blank\">this link</a></strong> \n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t  </p>\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\"><strong>" + sourceIdentity.getProfile().getFullName() + "</strong></p><span class=\"HOEnZb\"><font color=\"#888888\"><br>\n\n\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\n\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\n\t\t\t\t\n\t\t\t</font></span></td></tr><tr> ";
                if (!UsersRestService.sendMail(string, subject, mailText, false)) continue;
                try {
                    org.exoplatform.social.core.identity.model.Identity userId = identityManager.getOrCreateIdentity("organization", user, true);
                    Utils.addToSpace(project, user);
                    spaceService.setManager(project, user, true);
                    Profile uProfile = userId.getProfile();
                    uProfile.setProperty("status", (Object)"Invited");
                    Util.getIdentityManager((String)portalContainerName).updateProfile(uProfile);
                }
                catch (MessageException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Invitation(s) sent successfully.");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="addnonmessaged/{projectId}")
    @Consumes(value={"application/json"})
    public Response addNonMsgd(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, @QueryParam(value="gcHost") String gcHost, @QueryParam(value="projectUrl") String projectUrl, List<String> relations) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = this.orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage)PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
            }
            for (String rel : relations) {
                String mailText;
                String subject;
                ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);
                User user_ = uh.findUserByName(rel_.getSubContractor().getId());
                projectUrl = projectUrl.replaceAll("portal/", "");
                Profile prProfile = null;
                Profile uProfile = null;
                try {
                    org.exoplatform.social.core.identity.model.Identity prIdentity = identityManager.getOrCreateIdentity("space", project.getPrettyName(), true);
                    prProfile = prIdentity.getProfile();
                    org.exoplatform.social.core.identity.model.Identity userId = identityManager.getOrCreateIdentity("organization", user_.getUserName(), true);
                    uProfile = userId.getProfile();
                    uProfile.setProperty("itbsent", (Object)new SimpleDateFormat("dd/MM/yy").format(Utils.getTime()));
                    identityManager.updateProfile(uProfile);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
                String url = "http://" + gcHost + "/portal/invitations?userName=" + rel_.getSubContractor().getId() + "&initialURI=" + projectUrl + "/projectSettings";
                String to = user_.getUserName();
                if (!UsersRestService.sendMail(to, subject = "Invitation to bid on the " + project.getPrettyName() + " project", mailText = " <div align=center>\n\n        <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:90%; max-width:790px;\">\n          <tr>\n            <td width=\"100%\" style=\"border-top: 4px solid #707070; border-right: 4px solid #707070; border-bottom: 4px solid #707070; border-left: 4px solid #707070; padding: 8px 12px;\">\n\n\n        \t\t\n                  <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"8\">\n                    <tr>\n                      <td width=\"50%\" align=\"left\" style=\" border-right: 1px solid #c2c2c2;  border-bottom: 1px solid #c2c2c2;\">\n   \n                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n                          <tr>\n                            <td colspan=\"2\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px\">INVITATION TO BID</td>             \n                          </tr>\n                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>To</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + uProfile.getProperty("company") + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>ATTN</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getDisplayName() + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b>&nbsp;&nbsp;&nbsp;</td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(123) 456-7890</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Email</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getEmail() + "</td>\n                          </tr>\n                        </table>\n                      </td>\n                      <td width=\"50%\" align=\"center\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; border-bottom: 1px solid #c2c2c2; padding-left: 18px\">\n                        <IMG style=\"-ms-interpolation-mode: bicubic; width:55%; max-width:180px; max-height:60px\"\n                        border=0 \n                        \n                        align=\"middle\" src=\"http://" + gcHost + "/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png\">\n                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n\n                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n                          <tr>\n                            <td align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>From</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">General Contractor Inc<br><a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">ProView Listing</a></td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Contact</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getFullName() + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Title</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getPosition() + "</td>\n                          </tr>\n                          <tr>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b></td>\n                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(866) 558-5515 / (866) 558-5516</td>\n                          </tr>\n                          <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                        </table>\n                      </td>\n                    </tr>\n                    <tr>\n                      <td colspan=\"2\" align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; border-bottom: 1px solid #c2c2c2;\">\n                        Hi, <b>" + user_.getFirstName() + "</b>,\n                        <br><br>\n                        We have selected your company to submit a bid on the project listed below.  Please click on the &#8216;Project Details&#8217; for the full project overview and documents.\n                      </td>\n                    </tr>\n                    <tr>\n                      <td colspan=\"2\">\n                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n                          <tr>\n                            <td width=\"15.5%\" valign=\"top\"><img style=\"-ms-interpolation-mode: bicubic; width:100%; max-width:101px; max-height:101px\"\n                                border=0 \n                                alt=\"\" \n                                align=middle src=\"http://\"" + gcHost + project.getAvatarUrl() + ">\n                            </td>\n                            <td width=\"84.5%\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px; line-height: 18px;\">\n                              <b>" + project.getDisplayName() + "</b><br>\n                              <span style=\"font-size: 14px; line-height: 16px;\">" + prProfile.getProperty("adress") + "</span>\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                                <tr>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Bids Due</b>\n                                  </td>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("bidsDueDate") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Start Date:</b>\n                                  </td>\n                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                   " + prProfile.getProperty("startDate") + "\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                              </table>\n                            </td>\n                          </tr>\n                          <tr>\n                            <td colspan=\"2\">\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n                                \n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Project Status</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                   " + prProfile.getProperty("projectStatus") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Number of Buildings</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("nbBuildings") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Stories above ground</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("storiesAboveGrd") + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Square Footage</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + prProfile.getProperty("totalSqFt") + " sq. ft.\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td align=\"left\" width=\"30%\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    <b>Project Description</b>\n                                  </td>\n                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n                                    " + project.getDescription() + "\n                                  </td>\n                                </tr>\n                                <tr>\n                                  <td colspan=\"2\" align=\"center\" valign=\"middle\" bgcolor=\"#e0e0e0\" style=\"border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2; padding: 8px 0px\">\n                                    <a href=\"" + url + "\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:184px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/details.jpg\" target=\"_blank\"></a>\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n                                <tr>\n                                  <td colspan=\"2\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; padding: 10px 0px\">\n                                    You&#8217;ve been selected to bid on the following trade(s). Please respond by clicking on one of the options below.\n                                  </td>\n                                </tr>\n                                <tr>  \n                              </table>\n\n                              <h1 style=\"text-align: center;\">" + bBCategoryStorage.getBBCategory(rel_.getCategory().getId()).getCatCsiDesc() + "</h1>            \n\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n                                <tr>\n                                  <td align=\"right\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + rel_.getProjectId() + "/" + rel_.getCategory().getId() + "/" + rel_.getSubContractor().getId() + "/NOT_BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n                                  </td>\n                                  <td align=\"center\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + rel_.getProjectId() + "/" + rel_.getCategory().getId() + "/" + rel_.getSubContractor().getId() + "/UNDECIDED\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n                                  </td>\n                                  <td align=\"left\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + rel_.getProjectId() + "/" + rel_.getCategory().getId() + "/" + rel_.getSubContractor().getId() + "/BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n                                <tr>\n                                  <td colspan=\"3\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; padding: 10px 0px;\">\n                                    If you no longer would lid to receive bid invitations <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">click here</a> or call (888) 303-2243\n                                  </td>\n                                </tr>\n                              </table>\n\n                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" bgcolor=\"#055092\">\n                                <tr>\n                                  <td align=\"left\" bgcolor=\"#055092\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:110px; height:44px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/tbb.jpg\">\n                                  </td>\n                                  <td align=\"left\" valign=\"middle\" bgcolor=\"#055092\" style=\"font-family:Helvetica, Arial, sans-serif; color:#FFFFFF; font-size: 12px;\">\n                                    <b>AndersonConstruction, Inc</b> has shared this project opportunity with you using BB-Build.  If you need  technical help, please call BB-Build Support at (888) 303-2243\n                                  </td>\n                                </tr>\n                              </table>\n                            </td>\n                          </tr>\n                        </table>\n                      </td>\n                    </tr>\n                  </table>\n          \n  \n\n\n        </td>\n        </tr>\n        </table>\n\n    </div>", false) || !Utils.addToSpace(project, rel_.getSubContractor().getId())) continue;
                projectSubRelationShipStorage.updateProjectSubRelationShip(rel, null, "INVITED", null, null, null, null);
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)(relations.size() + " Amount of Vendors have been sent an Invitation to Bid. To view those vendors add please click on \"Invited\" tab"));
            LOG.info(jsonGlobal.get("message"));
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private void endRequest() {
        if (requestStarted.booleanValue() && this.orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle)this.orgService).endRequest((ExoContainer)PortalContainer.getInstance());
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            requestStarted = false;
        }
    }

    private void startRequest() {
        if (this.orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)this.orgService).startRequest((ExoContainer)PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    @GET
    @Path(value="getproperties")
    @Consumes(value={"application/json"})
    public Response getProperties(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        try {
            org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
            if (sourceIdentity == null) {
                LOG.warn((Object)"UNAUTHORIZED");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            JSONObject json = new JSONObject();
            json.put("email", (Object)System.getProperty("gatein.email.smtp.from"));
            json.put("zip", (Object)companyInfo.getCompanyZip());
            Calendar calendar = Calendar.getInstance();
            Date date = null;
            try {
                date = Utils.getTime();
                calendar.setTime(date);
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            int month = calendar.get(2);
            String checksum = sourceIdentity.getRemoteId() + "_" + (month + 1) + "bbbuild2015";
            json.put("checksum", (Object)Utils.getMd5(checksum));
            return Response.ok((Object)json.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="creategroup/{groupName}")
    @Consumes(value={"application/json"})
    public Response createGroup(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="groupName") String groupName) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            LOG.warn((Object)"UNAUTHORIZED");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubGroupStorage subGroupStorage = (SubGroupStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            Date date = Utils.getTime();
            String name = "group" + String.valueOf(date.getTime());
            while (subGroupStorage.getSubGroup(name) != null) {
                name = "group" + String.valueOf(date.getTime() + 1L);
            }
            subGroupStorage.createSubGroup(name, groupName);
            LOG.info((Object)("Group " + groupName + " created"));
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" Group Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getallbbgroups")
    @Consumes(value={"application/json"})
    public Response getAllBBGroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubGroupStorage subGroupStorage = (SubGroupStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List<SubGroupEntity> groups = subGroupStorage.getSubGroups(0, 0);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (SubGroupEntity group : groups) {
                JSONObject json = new JSONObject();
                json.put("id", (Object)group.getId());
                json.put("name", (Object)group.getSubGroupName());
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("bbgroups", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getsubbbgroups/{userName}")
    @Consumes(value={"application/json"})
    public Response getSubBbgroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List<SubCatGroupEntity> relations = subCatGroupRelationStorage.getRelationShipBySubId(userName, 0, 0);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (SubCatGroupEntity relation : relations) {
                JSONObject json = new JSONObject();
                json.put("id", (Object)relation.getId());
                json.put("name", (Object)(relation.getSubGroup().getSubGroupName() + "-" + relation.getCategory().getFieldName()));
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("bbgroups", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="addtogroups")
    @Consumes(value={"application/json"})
    public Response AddToGroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="projectId") String projectId, @QueryParam(value="addtoselected") String addtoselected, @QueryParam(value="addall") boolean addall, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        List<String> subcats = searchRequest.getSubcats();
        try {
            if (addall) {
                SubCatRunner subCatRunner = new SubCatRunner(addtoselected, searchRequest, RelationShipType.SUB_CAT, ConversationState.getCurrent());
                Thread createSubCatRelation = new Thread((Runnable)subCatRunner, "Sub Cat Runner Thread");
                createSubCatRelation.start();
                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", (Object)(searchRequest.getTotRecords() + " Users added to the groups: " + addtoselected));
                return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
            }
            SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            SubGroupStorage subGroupStorage = (SubGroupStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);
            for (String subcatId : subcats) {
                String[] selectedarray;
                for (String selectedgroup : selectedarray = addtoselected.split(",")) {
                    SubGroupEntity subGroup = subGroupStorage.getSubGroup(selectedgroup);
                    SubCatEntity subcat = subCatStorage.getSubCat(subcatId);
                    if (subcat == null) {
                        List<SubCatEntity> subcatsofuser = subCatStorage.getSubCatsBySubId(subcatId, 0, 0);
                        for (SubCatEntity subcatofuser : subcatsofuser) {
                            subCatGroupRelationStorage.createSubCatGroupRelation(selectedgroup, subcatId, subcatofuser.getSubContractor().getId(), subcatofuser.getSubContractor().getDisplayName(), subcatofuser.getCategory().getId(), subcatofuser.getCategory().getCatCsiDesc(), subGroup.getSubGroupName());
                        }
                        continue;
                    }
                    subCatGroupRelationStorage.createSubCatGroupRelation(selectedgroup, subcatId, subcat.getSubContractor().getId(), subcat.getSubContractor().getDisplayName(), subcat.getCategory().getId(), subcat.getCategory().getCatCsiDesc(), subGroup.getSubGroupName());
                }
                LOG.info((Object)("SubContractor added to the groups: " + addtoselected));
                this.endRequest();
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)(subcats.size() + " users added to the groups: " + addtoselected));
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="removefromgroups/{userName}")
    @Consumes(value={"application/json"})
    public Response RemoveFromGroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName, @QueryParam(value="selected") String selected, List<String> subcats) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            List<SubCatGroupEntity> relations = subCatGroupRelationStorage.getRelationShipBySubId(userName, 0, 0);
            for (SubCatGroupEntity relation : relations) {
                if (selected.contains(relation.getId())) continue;
                subCatGroupRelationStorage.deleteSubCatGroupRelation(relation.getId());
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Groups Managing done");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getsubcatsbysubid")
    @Consumes(value={"application/json"})
    public Response getSubCatsBySubId(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="SubId") String SubId, @QueryParam(value="ProjectId") String ProjectId) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            SubCatStorage subCatStorage = (SubCatStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            List<ProjectSubEntity> relations = projectSubRelationShipStorage.getRelationShipByProjectIdAndSubId(ProjectId, SubId, 0, 0);
            if (relations.size() != 0) {
                for (ProjectSubEntity relation : relations) {
                    JSONObject json = new JSONObject();
                    json.put("Status", (Object)relation.getStatus());
                    SubCatEntity subcat = subCatStorage.getSubCat(relation.getSubContractor().getId() + "_" + relation.getCategory().getId());
                    json.put("CatId", (Object)subcat.getCategory().getId());
                    json.put("CatDesc", (Object)subcat.getCategory().getCatCsiDesc());
                    jsonArray.put((Object)json);
                }
            }
            jsonGlobal.put("Categories", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="getcountforselectall/{projectId}")
    @Consumes(value={"application/json"})
    public Response getcountforselectall(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="projectId") String projectId, BbFilteredSearchRequest searchRequest) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            JSONObject jsonGlobal = new JSONObject();
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            ArrayList<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(searchRequest.getsSearch_1());
            SearchConditions.add(searchRequest.getsSearch_2());
            SearchConditions.add(searchRequest.getsSearch_3());
            SearchConditions.add(searchRequest.getsSearch_4());
            SearchConditions.add(searchRequest.getsSearch_5());
            SearchConditions.add(searchRequest.getsSearch_6());
            SearchConditions.add(searchRequest.getsSearch_7());
            String SearchKey = searchRequest.getSearchsubs();
            ArrayList<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            List<String> filteredgroups = searchRequest.getFilteredGroups();
            if (filteredgroups != null && filteredgroups.size() > 0) {
                for (String filteredgroup : filteredgroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        included.add(projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId()));
                    }
                }
            }
            ListAccess<ProjectSubEntity> tmpList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(true, searchRequest.isVendor(), false, SearchKey, SearchConditions, included, "", "", projectId);
            jsonGlobal.put("invitedCount", tmpList.getSize());
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="sendmessage")
    @Consumes(value={"application/json"})
    public Response sendMessage(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam(value="addall") boolean addall, @QueryParam(value="bidScop") boolean bidScop, BbMessage message) throws Exception {
        Object oldDate;
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ListenerService listenerService = (ListenerService)PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
        SpaceService spaceService = Util.getSpaceService((String)portalContainerName);
        UserHandler uh = this.orgService.getUserHandler();
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        Boolean addNonInv = message.getAddNonInv();
        String projectId = message.getProjectId();
        IdentityManager identityManager = Util.getIdentityManager((String)portalContainerName);
        String bidScoped = "no";
        if (bidScop) {
            bidScoped = "yes";
        }
        Space project = null;
        if (addNonInv != null && addNonInv.booleanValue() && projectId != null && (project = spaceService.getSpaceByPrettyName(projectId)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Project not found").build();
        }
        org.exoplatform.social.core.identity.model.Identity prIdentity = Util.getIdentityManager((String)portalContainerName).getOrCreateIdentity("space", projectId, true);
        if (prIdentity != null && message.getNewEventDate() != null) {
            Profile sProfile = prIdentity.getProfile();
            oldDate = (String)sProfile.getProperty("bidsDueDate");
            String newDate = sProfile.getProperty("bidsDueDate") == "" ? message.getNewEventDate() : message.getNewEventDate() + ((String)oldDate).substring(10, ((String)oldDate).length());
            try {
                sProfile.setProperty("bidsDueDate", (Object)newDate);
            }
            catch (Exception e) {
                LOG.error((Object)"Unable to update bid due date.");
            }
            Util.getIdentityManager((String)portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
        }
        if (addall) {
            if (message.getFilteredSearchRequest().isSendAllMessages()) {
                ArrayList included = new ArrayList();
                oldDate = message.getFilteredSearchRequest().getFilteredGroups();
            }
            LOG.info((Object)("Conversation state messaging in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant")));
            LOG.info((Object)("Conversation userid messaging in rest:   " + ConversationState.getCurrent().getIdentity().getUserId()));
            MessagingRunner messagingRunner = new MessagingRunner(project, portalContainerName, message, ConversationState.getCurrent().getIdentity(), true, Util.getBaseUrl(), bidScoped, ConversationState.getCurrent());
            Thread messagingRunnerThread = new Thread((Runnable)messagingRunner, "Messaging Runner Thread");
            messagingRunnerThread.start();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Mails sent");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        String subject = message.getSubject();
        Boolean isDaily = message.getIsDaily();
        Boolean updateEvent = message.getUpdateEvent();
        String newEventDate = message.getNewEventDate();
        List<String> relations = message.getRelations();
        String mailText = message.getMailText();
        try {
            HashMap<String, String> userscategories = new HashMap<String, String>();
            HashMap<String, String> userscategoriesid = new HashMap<String, String>();
            for (String rel : relations) {
                ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);
                if (!userscategories.isEmpty() && userscategories.containsKey(rel_.getSubContractor().getId())) {
                    userscategories.put(rel_.getSubContractor().getId(), (String)userscategories.get(rel_.getSubContractor().getId()) + "<br />" + rel_.getCategory().getCatCsiDesc());
                    userscategoriesid.put(rel_.getSubContractor().getId(), (String)userscategoriesid.get(rel_.getSubContractor().getId()) + ";" + rel_.getId());
                    continue;
                }
                userscategories.put(rel_.getSubContractor().getId(), rel_.getCategory().getCatCsiDesc());
                userscategoriesid.put(rel_.getSubContractor().getId(), rel_.getId());
            }
            try {
                int totalSent = 0;
                Iterator iterator = userscategories.entrySet().iterator();
                Iterator iteratorid = userscategoriesid.entrySet().iterator();
                while (iteratorid.hasNext()) {
                    Map.Entry usercats = iterator.next();
                    Map.Entry usercatsid = iteratorid.next();
                    String[] categoriesofuser = usercats.getValue().toString().split("\\<br />");
                    MembershipHandler categoriesidofuser = usercatsid.getValue().toString().split(";");
                    String mailText_ = mailText;
                    String userName = usercatsid.getKey().toString();
                    User user_ = uh.findUserByName(userName);
                    if (user_ == null) {
                        LOG.info((Object)(userName + " Not yet created sub by the thread import, will try to creat it before messaging "));
                        this.startRequest();
                        MembershipTypeHandler mtHandler = this.orgService.getMembershipTypeHandler();
                        GroupHandler gHandler = this.orgService.getGroupHandler();
                        MembershipHandler mHandler = this.orgService.getMembershipHandler();
                        ((ComponentRequestLifecycle)this.orgService).startRequest((ExoContainer)PortalContainer.getInstance());
                        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
                        SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(userName);
                        user_ = uh.createUserInstance(userName);
                        user_.setDisplayName(subUserInfo.getDisplayName());
                        if (this.orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                            user_.setPassword(Utils.getMd5(userName));
                        } else {
                            user_.setPassword(userName);
                        }
                        user_.setEmail(subUserInfo.getEmail().toLowerCase());
                        user_.setLastName(subUserInfo.getLastName());
                        user_.setFirstName(subUserInfo.getFirstName());
                        Date now = new Date();
                        user_.setCreatedDate(now);
                        uh.createUser(user_, false);
                        Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                        mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                        Group usersGroup = gHandler.findGroupById("/platform/users");
                        mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                        LOG.info((Object)("SubContractor " + subUserInfo.getDisplayName() + " imported"));
                        this.endRequest();
                    }
                    String trbidbuttons = "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n";
                    int i = 0;
                    for (String rel : categoriesidofuser) {
                        ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);
                        trbidbuttons = trbidbuttons + "                                <tr><td colspan=\"3\" height=\"5\"><span>" + categoriesofuser[i] + "</span></td></tr>\n                                <tr>\n                                  <td align=\"right\" valign=\"middle\"><a href=\"" + Util.getBaseUrl() + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCategory().getId() + "/" + user_.getUserName() + "/NOT_BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n                                  </td>\n                                  <td align=\"center\" valign=\"middle\"><a href=\"" + Util.getBaseUrl() + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCategory().getId() + "/" + user_.getUserName() + "/UNDECIDED\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n                                  </td>\n                                  <td align=\"left\" valign=\"middle\"><a href=\"" + Util.getBaseUrl() + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCategory().getId() + "/" + user_.getUserName() + "/BIDDING\" target=\"_blank\">\n                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n                                      border=0 \n                                      alt=\"\" \n                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n                                  </td>\n                                </tr>\n                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n";
                        ++i;
                        ++totalSent;
                    }
                    trbidbuttons = trbidbuttons + "                              </table>\n";
                    mailText_ = mailText_.replace("{|CATID|}", trbidbuttons);
                    String to = user_.getUserName();
                    mailText_ = mailText_.replace("{|RECEIVERID|}", user_.getUserName());
                    mailText_ = mailText_.replace("{|RECEIVERFIRSTNAME|}", user_.getFirstName());
                    mailText_ = mailText_.replace("{|RECEIVERLASTNAME|}", user_.getLastName());
                    if (!UsersRestService.sendMail(to, subject, mailText_ = mailText_.replace("{|CLASSIFICATION|}", usercats.getValue().toString()), isDaily)) continue;
                    for (MembershipHandler rel : categoriesidofuser) {
                        if (addNonInv == null || !addNonInv.booleanValue() || project == null) continue;
                        try {
                            if (!Utils.addToSpace(project, user_.getUserName())) continue;
                            projectSubRelationShipStorage.updateProjectSubRelationShip((String)rel, null, "INVITED", null, null, null, bidScoped);
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                    if (updateEvent != null && updateEvent.booleanValue()) {
                        CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                        String CalendarId = project.getPrettyName() + "_space_calendar";
                        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                        Date duedate = formatter.parse(String.valueOf(newEventDate));
                        CalendarEvent duedateevent = calService.getEventById(project.getPrettyName() + " - bidsDueDate");
                        duedateevent.setFromDateTime(duedate);
                        duedateevent.setToDateTime(duedate);
                        duedateevent.setDescription(project.getDescription());
                        calService.savePublicEvent(CalendarId, duedateevent, false);
                    }
                    LOG.info((Object)("message is already sent to " + user_.getDisplayName() + " email= " + user_.getEmail()));
                }
                if (projectId != null) {
                    String rawMsgType = message.getMsgType();
                    String prettyMsgType = "";
                    if (rawMsgType != null) {
                        if (rawMsgType.equals("genericITB")) {
                            prettyMsgType = "Invitation to bid";
                        } else if (rawMsgType.equals("addendum")) {
                            prettyMsgType = "Notice of addendum";
                        } else if (rawMsgType.equals("biddateextended")) {
                            prettyMsgType = "Bid date extended";
                        } else if (rawMsgType.equals("remindertobid")) {
                            prettyMsgType = "Reminder to bid";
                        } else if (rawMsgType.equals("noticeofaward")) {
                            prettyMsgType = "Notice of award";
                        } else if (rawMsgType.equals("projectmemo")) {
                            prettyMsgType = "Memo";
                        }
                    }
                    if (projectId != null && !projectId.equals("")) {
                        project = spaceService.getSpaceByPrettyName(projectId);
                    }
                    LOG.warn((Object)project.toString());
                    totalSent = 0;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            for (String projectSubEntity : relations) {
                listenerService.broadcast("SendMessage", (Object)projectSubEntity, (Object)sourceIdentity.getRemoteId());
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)"Mails sent");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getusernotifications")
    @Consumes(value={"application/json"})
    public Response getUserNotifications(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage)PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            List<SimpleNotification> notifs = simpleNotifServiceStorage.getSimpleNotificationsByUserId(sourceIdentity.getRemoteId(), 0L, 0L);
            boolean bbimport = false;
            boolean bsimport = false;
            if (notifs.size() != 0) {
                for (SimpleNotification notif : notifs) {
                    JSONObject json = new JSONObject();
                    json.put("summary", (Object)notif.getSummary());
                    json.put("notifId", (Object)notif.getName());
                    json.put("type", (Object)notif.getType());
                    json.put("number", notif.getNumber());
                    jsonArray.put((Object)json);
                }
            }
            jsonGlobal.put("notifs", (Object)jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="deleteusernotifications")
    @Consumes(value={"application/json"})
    public Response deleteUserNotifications(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, List<String> notifs) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage)PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);
            JSONObject jsonGlobal = new JSONObject();
            if (notifs.size() != 0) {
                for (String notif : notifs) {
                    simpleNotifServiceStorage.deleteSimpleNotification(notif);
                }
            }
            jsonGlobal.put("message", (Object)"Delete done");
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getcompanyinfo")
    public Response getCompanyInfo(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
        try {
            JSONObject company = new JSONObject();
            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            company.put("companyName", (Object)companyInfo.getCompanyName());
            company.put("companyProview", (Object)companyInfo.getCompanyProview());
            company.put("companyStreet", (Object)companyInfo.getCompanyStreet());
            company.put("companyState", (Object)companyInfo.getCompanyState());
            company.put("companyCity", (Object)companyInfo.getCompanyCity());
            company.put("companyZip", (Object)companyInfo.getCompanyZip());
            company.put("companyWebSite", (Object)companyInfo.getCompanyWebSite());
            company.put("companyPhone", (Object)companyInfo.getCompanyPhone());
            company.put("companyAvatar", (Object)"/portal/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png");
            return Response.ok((Object)company.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getgeoposition")
    public Response getGeoPosition(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        try {
            PortalContainer portalContainer = PortalContainer.getInstance();
            SettingService settingService = (SettingService)portalContainer.getComponentInstanceOfType(SettingService.class);
            String geoPosition = String.valueOf(settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "geoPosition") == null ? "" : settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "geoPosition").getValue());
            String latitude = "";
            String longitude = "";
            if (!geoPosition.equals("") && geoPosition.split(",").length == 2) {
                latitude = geoPosition.split(",")[0].replace(" ", "");
                longitude = geoPosition.split(",")[1].replace(" ", "");
            }
            JSONObject position = new JSONObject();
            position.put("latitude", (Object)latitude);
            position.put("longitude", (Object)longitude);
            return Response.ok((Object)position.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="getlastaccess")
    public Response getLastAccess(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        SettingService settingService = (SettingService)portalContainer.getComponentInstanceOfType(SettingService.class);
        try {
            org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            JSONObject json = new JSONObject();
            SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            json.put(LAST_ACCESS, (Object)String.valueOf(format.format(settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, LAST_ACCESS).getValue())));
            return Response.ok((Object)json.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="upgradenodetype/{name}")
    public Response upgradeNodType(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="name") String name) throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager)portalContainer.getComponentInstanceOfType(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle)manager.getLifeCycle("soc");
        RepositoryService repositoryService = (RepositoryService)portalContainer.getComponentInstanceOfType(RepositoryService.class);
        Session session = null;
        ManageableRepository repository = repositoryService.getCurrentRepository();
        SessionProviderService sessionProviderService = (SessionProviderService)portalContainer.getComponentInstanceOfType(SessionProviderService.class);
        SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
        session = sProvider.getSession(lifeCycle.getWorkspaceName(), repository);
        ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
        try {
            NodeType nodeType = nodeTypeManager.findNodeType(InternalQName.parse((String)"[http://www.exoplatform.org/jcr/tbb/1.0/]projectSubRelationShip"));
            Boolean exist = false;
            for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
                if (!propertyDefinition.getName().equals("tbb:bidScoped")) continue;
                exist = true;
                break;
            }
            if (!exist.booleanValue()) {
                LOG.info((Object)"Update BBN nodeTypes");
                nodeTypeManager.registerNodeTypes(this.getModelIS(), 4, "text/xml");
                session.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
        return Response.ok((Object)("Tenant " + name + " Upgraded"), (String)"application/json").build();
    }

    @POST
    @Path(value="createimportnotification/{userId}/{number}")
    public Response createNotification(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userId") String userId, @PathParam(value="number") int i) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage)PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);
            simpleNotifServiceStorage.createSimpleNotification(userId, " users imported", BBIMPORT_NOTIF_TYPE, i);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
        return Response.ok((Object)"Notif sent").build();
    }

    @POST
    @Path(value="sendcsv/{FileName}")
    @Consumes(value={"multipart/form-data"})
    public Response sendcsv(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="FileName") String FileName, @QueryParam(value="type") String type, File csvfile) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        try {
            if (sourceIdentity == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (type == null || type.equals("")) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unsupported document type").build();
            }
            Attachment attachment = new Attachment();
            attachment.setInputStream((InputStream)new FileInputStream(csvfile));
            attachment.setMimeType(type);
            attachment.setName(FileName);
            CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage)PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            SpaceService spaceService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
            User user = this.orgService.getUserHandler().findUserByName(sourceIdentity.getRemoteId());
            String mailText = "<table align=\"center\" bgcolor=\"#fff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:12px;color:#666666;line-height:20px;font-family:HelveticaNeue,verdana,arial,tahoma\" width=\"660\">\n\t<tbody>\n\t\t<tr>\n\t\t\t<td align=\"center\" valign=\"middle\">\n\t\t\t<table align=\"center\" bgcolor=\"#fff\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:1px solid #d8d8d8\" width=\"100%\">\n\t\t\t\t<tbody>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td height=\"45\" style=\"margin:0;height:45px;font-weight:bold;vertical-align:middle;background-color:#efefef;font-family:HelveticaNeue,arial,tahoma,serif;color:#2f5e92;font-size:18px;text-align:center\" valign=\"middle\">Import CSV Request from Oneteam</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</tbody>\n\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t\t<td align=\"center\">\n\t\t\t<table align=\"center\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-left:1px solid #d8d8d8;border-right:1px solid #d8d8d8\" width=\"100%\">\n\t\t\t\t<tbody>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\t\t\t\t\t\t<table align=\"center\" bgcolor=\"#fff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:12px;color:#333;line-height:20px\" width=\"92%\">\n\t\t\t\t\t\t\t<tbody>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t<p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Hi team,</p>\n\n\t\t\t\t\t\t\t\t\t<p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Import CSV Request from Oneteam, the file is attached:</p>\n\n\t\t\t\t\t\t\t\t\t<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 500px;\">\n\t\t\t\t\t\t\t\t\t\t<tbody>\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td>Tenant</td>\n\t\t\t\t\t\t\t\t\t\t\t\t<td><strong><a href=\"" + Util.getBaseUrl() + "\" target=\"_blank\">" + UsersRestService.getTenantName(Util.getBaseUrl()) + "</a></strong></td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td>Gc Name</td>\n\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + user.getFullName() + "</span></td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td>Gc Email</td>\n\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + user.getEmail() + "</span></td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td>Company Name</td>\n\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + companyInfo.getCompanyName() + "</span></td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t\t\t<td>Company Phone number</td>\n\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + companyInfo.getCompanyPhone() + "</span></td>\n\t\t\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t\t\t</tbody>\n\t\t\t\t\t\t\t\t\t</table>\n\n\t\t\t\t\t\t\t\t\t<p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">&nbsp;</p>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</tbody>\n\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</tbody>\n\t\t\t</table>\n\t\t\t</td>\n\t\t</tr>\n\t\t<tr>\n\t\t</tr>\n\t</tbody>\n</table>\n";
            String subject = "Import CSV Request from eXo";
            return Response.ok((Object)"CSV File sent successfully").build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @GET
    @Path(value="authenticateuser/{userName}/{password}")
    @Consumes(value={"application/json"})
    public Response authenticateuser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="userName") String userName, @PathParam(value="password") String password) throws Exception {
        try {
            JSONObject json = new JSONObject();
            UserHandler uh = this.orgService.getUserHandler();
            json.put("authenticated", uh.authenticate(userName, password));
            return Response.ok((Object)json.toString(), (String)"application/json").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    private static void sendSimpleMail(String to, String subject, String mailText, Attachment attachment) {
        MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        Message message = new Message();
        message.setSubject(subject);
        message.setBody(mailText);
        message.setFrom(System.getProperty("gatein.email.smtp.from"));
        message.setMimeType("text/html");
        message.addAttachment(attachment);
        try {
            for (String reciever : to.split(",")) {
                message.setTo(reciever);
                mailService.sendMessage(message);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public InputStream getModelIS() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/portal/tbb-chromattic-nodetypes.xml");
    }

    public void createBBCategory(Node catLocationNode, String catId, String catCsiDesc, String catAbrDesc, String catFullDesc, String groupId, boolean save) throws Exception {
        if (!catLocationNode.hasNode(catId)) {
            Node catNode = catLocationNode.addNode(catId, "tbb:category");
            catNode.setProperty("tbb:catAbrDesc", catAbrDesc);
            catNode.setProperty("tbb:catFullDesc", catFullDesc);
            catNode.setProperty("tbb:catCsiDesc", catCsiDesc);
            catNode.setProperty("tbb:groupId", groupId);
            catNode.setProperty("tbb:catCreatedTime", Long.valueOf(System.currentTimeMillis()).longValue());
        }
        if (save) {
            catLocationNode.getSession().save();
        }
    }

    public boolean createSubCat(Node subCatLocationNode, String subId, String catId, SubContractor userProfile, String subRank, String catAbrDesc, String catFullDesc, String catCsiDesc, boolean save) throws Exception {
        if (subCatLocationNode.hasNode(subId + "_" + catId)) {
            if (save) {
                subCatLocationNode.getSession().save();
            }
            return false;
        }
        if (userProfile.getUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getUnion() == "") {
            userProfile.setUnion("unknown");
        }
        if (userProfile.getNonUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getNonUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getNonUnion() == "") {
            userProfile.setUnion("unknown");
        }
        Node subCatNode = subCatLocationNode.addNode(subId + "_" + catId, "tbb:subCat");
        subCatNode.setProperty("tbb:subCatId", subId + "_" + catId);
        subCatNode.setProperty("tbb:subId", subId);
        subCatNode.setProperty("tbb:catId", catId);
        subCatNode.setProperty("tbb:subName", userProfile.getFirstName() + " " + userProfile.getLastName());
        subCatNode.setProperty("tbb:subCompany", userProfile.getCompany() == null ? "" : userProfile.getCompany());
        subCatNode.setProperty("tbb:subRank", subRank);
        subCatNode.setProperty("tbb:catAbrDesc", catAbrDesc);
        subCatNode.setProperty("tbb:catFullDesc", catFullDesc);
        subCatNode.setProperty("tbb:catCsiDesc", catCsiDesc);
        subCatNode.setProperty("tbb:subPhone", userProfile.getPhone() == null ? "" : userProfile.getPhone());
        subCatNode.setProperty("tbb:subCity", userProfile.getCity() == null ? "" : userProfile.getCity());
        subCatNode.setProperty("tbb:subState", userProfile.getState() == null ? "" : userProfile.getState());
        subCatNode.setProperty("tbb:subCounty", userProfile.getCounty() == null ? "" : userProfile.getCounty());
        subCatNode.setProperty("tbb:subZip", userProfile.getZip() == null ? "" : userProfile.getZip());
        subCatNode.setProperty("tbb:subUnion", userProfile.getUnion() == null ? "" : userProfile.getUnion());
        subCatNode.setProperty("tbb:subNonUnion", userProfile.getNonUnion() == null ? "" : userProfile.getNonUnion());
        subCatNode.setProperty("tbb:subWeburl", "");
        if (userProfile.getWeburl() == null || userProfile.getWeburl().equals("")) {
            subCatNode.setProperty("tbb:subWeburl", "");
        } else if (userProfile.getWeburl().contains("http")) {
            subCatNode.setProperty("tbb:subWeburl", userProfile.getWeburl());
        } else {
            subCatNode.setProperty("tbb:subWeburl", "http://" + userProfile.getWeburl());
        }
        if (userProfile.getProview() == null || userProfile.getProview().equals("")) {
            subCatNode.setProperty("tbb:subProview", "");
        } else if (userProfile.getProview().contains("http")) {
            subCatNode.setProperty("tbb:subProview", userProfile.getProview());
        } else {
            subCatNode.setProperty("tbb:subProview", "http://" + userProfile.getProview());
        }
        if (userProfile.getProviewurl() != null) {
            if (userProfile.getProviewurl().equals("")) {
                subCatNode.setProperty("tbb:subProview", "");
            } else if (userProfile.getProviewurl().contains("http")) {
                subCatNode.setProperty("tbb:subProview", userProfile.getProviewurl());
            } else {
                subCatNode.setProperty("tbb:subProview", "http://" + userProfile.getProviewurl());
            }
        }
        return true;
    }

    public boolean createUserInfo(Node subUserInfoLocationNode, String userId, SubContractor userProfile, boolean save) throws Exception {
        if (subUserInfoLocationNode.hasNode(userId)) {
            if (save) {
                subUserInfoLocationNode.getSession().save();
            }
            return false;
        }
        if (userProfile.getUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getUnion() == "") {
            userProfile.setUnion("unknown");
        }
        if (userProfile.getNonUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getNonUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getNonUnion() == "") {
            userProfile.setUnion("unknown");
        }
        Node userInfoNode = subUserInfoLocationNode.addNode(userId, "tbb:subUserInfo");
        userInfoNode.setProperty("tbb:firstName", userProfile.getFirstName());
        userInfoNode.setProperty("tbb:lastName", userProfile.getLastName());
        userInfoNode.setProperty("tbb:displayName", userProfile.getFirstName() + " " + userProfile.getLastName());
        userInfoNode.setProperty("tbb:email", userProfile.getEmail().toLowerCase());
        userInfoNode.setProperty("tbb:notes", userProfile.getNotes());
        userInfoNode.setProperty("tbb:phone", userProfile.getPhone());
        userInfoNode.setProperty("tbb:company", userProfile.getCompany());
        userInfoNode.setProperty("tbb:refUID", userProfile.getRefUID());
        userInfoNode.setProperty("tbb:street", userProfile.getAddress1() == null ? userProfile.getStreet() : userProfile.getAddress1());
        userInfoNode.setProperty("tbb:address2", userProfile.getAddress2());
        userInfoNode.setProperty("tbb:city", userProfile.getCity());
        userInfoNode.setProperty("tbb:state", userProfile.getState());
        userInfoNode.setProperty("tbb:county", userProfile.getCounty() != null ? userProfile.getCounty() : "");
        userInfoNode.setProperty("tbb:country", userProfile.getCountry());
        userInfoNode.setProperty("tbb:zip", userProfile.getZip());
        userInfoNode.setProperty("tbb:skills", userProfile.getSkills());
        userInfoNode.setProperty("tbb:rank", "0");
        userInfoNode.setProperty("tbb:secondemail", userProfile.getSecondemail());
        userInfoNode.setProperty("tbb:mainPhoneType", userProfile.getMainPhoneType());
        userInfoNode.setProperty("tbb:secondPhone", userProfile.getSecondPhone());
        userInfoNode.setProperty("tbb:secondPhoneType", userProfile.getSecondPhoneType());
        userInfoNode.setProperty("tbb:faxnumber", userProfile.getFaxnumber());
        userInfoNode.setProperty("tbb:prevailingWage", userProfile.getPrevailingWage());
        userInfoNode.setProperty("tbb:union", userProfile.getUnion());
        userInfoNode.setProperty("tbb:nonUnion", userProfile.getNonUnion());
        userInfoNode.setProperty("tbb:tagsArray", userProfile.getTagsArray());
        userInfoNode.setProperty("tbb:StructureEntity", userProfile.getStructure());
        userInfoNode.setProperty("tbb:structureId", userProfile.getStructureId());
        userInfoNode.setProperty("tbb:weburl", "");
        if (userProfile.getWeburl() == null || userProfile.getWeburl().equals("")) {
            userInfoNode.setProperty("tbb:weburl", "");
        } else if (userProfile.getWeburl().contains("http")) {
            userInfoNode.setProperty("tbb:weburl", userProfile.getWeburl());
        } else {
            userInfoNode.setProperty("tbb:weburl", "http://" + userProfile.getWeburl());
        }
        if (userProfile.getProview() == null || userProfile.getProview().equals("")) {
            userInfoNode.setProperty("tbb:proview", "");
        } else if (userProfile.getProview().contains("http")) {
            userInfoNode.setProperty("tbb:proview", userProfile.getProview());
        } else {
            userInfoNode.setProperty("tbb:proview", "http://" + userProfile.getProview());
        }
        if (userProfile.getProviewurl() != null) {
            if (userProfile.getProviewurl().equals("")) {
                userInfoNode.setProperty("tbb:proview", "");
            } else if (userProfile.getProviewurl().contains("http")) {
                userInfoNode.setProperty("tbb:proview", userProfile.getProviewurl());
            } else {
                userInfoNode.setProperty("tbb:proview", "http://" + userProfile.getProviewurl());
            }
        }
        if (save) {
            subUserInfoLocationNode.getSession().save();
        }
        return true;
    }

    public boolean createProjectSubRelationShip(Node relationShipLocationNode, String subId, String projectId, String catId, String catCsiDesc, String status, String rank, SubContractor userProfile, boolean save) throws Exception {
        if (userProfile.getUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getUnion() == "") {
            userProfile.setUnion("unknown");
        }
        if (userProfile.getNonUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getNonUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getNonUnion() == "") {
            userProfile.setUnion("unknown");
        }
        if (relationShipLocationNode.hasNode(subId + "_" + projectId + "_" + catId)) {
            Node relation = relationShipLocationNode.getNode(subId + "_" + projectId + "_" + catId);
            relation.setProperty("tbb:subId", subId);
            relation.setProperty("tbb:subName", userProfile.getFirstName() + " " + userProfile.getLastName());
            relation.setProperty("tbb:relRank", rank);
            relation.setProperty("tbb:status", status);
            relation.setProperty("tbb:projectId", projectId);
            relation.setProperty("tbb:relCompany", userProfile.getCompany());
            relation.setProperty("tbb:catCsiDesc", catCsiDesc);
            relation.setProperty("tbb:catId", catId);
            relation.setProperty("tbb:note", "");
            relation.setProperty("tbb:bid", "0");
            relation.setProperty("tbb:relPhone", userProfile.getPhone());
            relation.setProperty("tbb:relCity", userProfile.getCity());
            relation.setProperty("tbb:relState", userProfile.getState());
            relation.setProperty("tbb:relCounty", userProfile.getCounty());
            relation.setProperty("tbb:relUnion", userProfile.getUnion());
            relation.setProperty("tbb:relNonUnion", userProfile.getNonUnion());
            relation.setProperty("tbb:createdTime", Long.valueOf(System.currentTimeMillis()).longValue());
            if (save) {
                relationShipLocationNode.getSession().save();
            }
            return false;
        }
        Node relation = relationShipLocationNode.addNode(subId + "_" + projectId + "_" + catId, "tbb:projectSubRelationShip");
        relation.setProperty("tbb:subId", subId);
        relation.setProperty("tbb:subName", userProfile.getFirstName() + " " + userProfile.getLastName());
        relation.setProperty("tbb:relRank", rank);
        relation.setProperty("tbb:status", status);
        relation.setProperty("tbb:projectId", projectId);
        relation.setProperty("tbb:relCompany", userProfile.getCompany());
        relation.setProperty("tbb:catCsiDesc", catCsiDesc);
        relation.setProperty("tbb:catId", catId);
        relation.setProperty("tbb:note", "");
        relation.setProperty("tbb:bid", "0");
        relation.setProperty("tbb:relPhone", userProfile.getPhone());
        relation.setProperty("tbb:relCity", userProfile.getCity());
        relation.setProperty("tbb:relState", userProfile.getState());
        relation.setProperty("tbb:relCounty", userProfile.getCounty());
        relation.setProperty("tbb:relUnion", userProfile.getUnion());
        relation.setProperty("tbb:relNonUnion", userProfile.getNonUnion());
        relation.setProperty("tbb:createdTime", Long.valueOf(System.currentTimeMillis()).longValue());
        if (save) {
            relationShipLocationNode.getSession().save();
        }
        return true;
    }

    public static String getTenantName(String requestUrl) {
        try {
            String tenant;
            int pointPosition;
            String masterHost;
            URL url = new URL(requestUrl);
            String host = url.getHost().toLowerCase();
            if (host.startsWith("www.")) {
                host = host.substring(4);
            }
            if ((masterHost = System.getProperty(MASTER_HOST_VARIABLE_NAME)) == null) {
                masterHost = DEFAULT_MASTER_HOST_NAME;
                LOG.error("System property {}  is not defined. Default value {} is used. ", new Object[]{MASTER_HOST_VARIABLE_NAME, DEFAULT_MASTER_HOST_NAME});
            }
            if (!host.equals(masterHost) && host.endsWith(masterHost) && (pointPosition = (tenant = host.split(masterHost)[0]).lastIndexOf(".")) > 0) {
                host = tenant.substring(0, pointPosition);
            }
            return host;
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getGcGroup(String userName) {
        try {
            Collection membershipTypes = this.orgService.getMembershipHandler().findMembershipsByUserAndGroup(userName, GCS_GROUP);
            ArrayList<String> memberShip_ = new ArrayList<String>();
            for (Membership membership : membershipTypes) {
                memberShip_.add(membership.getMembershipType());
            }
            if (memberShip_.contains("gcadmin")) {
                return "gcadmin";
            }
            if (memberShip_.contains("gcmanager")) {
                return "gcmanager";
            }
            if (memberShip_.contains("gcmember")) {
                return "gcmember";
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @POST
    @Path(value="createsubCompany")
    @Consumes(value={"application/json"})
    public Response createSubCompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, SubContractor userIn) throws Exception {
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)portalContainerName);
        if (sourceIdentity == null || !UsersRestService.isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        SubCompanyStorage subCompanyStorage = (SubCompanyStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubCompanyStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat((String)"json", (String[])SUPPORTED_FORMATS);
        try {
            LOG.info((Object)"cats  imported");
            this.endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", (Object)" SubContractor Created");
            return Response.ok((Object)jsonGlobal.toString(), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("An internal error has occured: " + e.getMessage())).build();
        }
    }

    @POST
    @Path(value="invitebymail")
    @Consumes(value={"application/json"})
    public Response inviteByMail(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, BbUser userIn) throws Exception {
        try {
            SubGcDAO subGcDAO = UsersRestService.getService(SubGcDAO.class, null);
            StaffDAO staffDAO = UsersRestService.getService(StaffDAO.class, null);
            SubContractorDAO subContractorDAO = UsersRestService.getService(SubContractorDAO.class, null);
            SubStaffCompanyDAO subStaffCompanyDAO = UsersRestService.getService(SubStaffCompanyDAO.class, null);
            StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
            if (staffEntity != null) {
                Long gcId = staffEntity.getGeneralContractorEntity().getId();
                UserHandler uh = this.orgService.getUserHandler();
                Query query = new Query();
                query.setEmail(userIn.getEmail().toLowerCase());
                ListAccess users = uh.findUsersByQuery(query);
                User user_ = null;
                if (users.getSize() > 0) {
                    user_ = ((User[])users.load(0, 1))[0];
                }
                if (user_ != null) {
                    SubStaffCompanyEntity subStaffCompanyEntity = (SubStaffCompanyEntity)subStaffCompanyDAO.find((Serializable)((Object)user_.getUserName()));
                    if (subStaffCompanyEntity != null) {
                        SubGcEntity subGcEntity = new SubGcEntity(subStaffCompanyEntity.getSubContractorEntity(), staffEntity.getGeneralContractorEntity());
                        subGcDAO.create(subGcEntity);
                        String confirmUrl = "/portal/login";
                        this.sendEmail(userIn, gcId, confirmUrl);
                    }
                    return Response.ok((Object)"This subcontractor already exists in the system, he has been added to your contacts").build();
                }
                String confirmUrl = "/portal/gc-portal/subscribe?gcid=" + gcId;
                this.sendEmail(userIn, gcId, confirmUrl);
                return Response.ok((Object)"mail sent").build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Not A staff on any gc").build();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
    }

    @POST
    @Path(value="invitebymailSub")
    @Consumes(value={"application/json"})
    public Response inviteByMailSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, List<SubCatEntity> usersIn) throws Exception {
        try {
            SubGcStorage subGcStorage = (SubGcStorage)PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
            StaffDAO staffDAO = UsersRestService.getService(StaffDAO.class, null);
            SubGcDAO subGcDAO = UsersRestService.getService(SubGcDAO.class, null);
            StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
            for (SubCatEntity userIn : usersIn) {
                if (subGcDAO.find((Serializable)((Object)(userIn.getSubContractor().getId() + "_" + staffEntity.getGeneralContractorEntity().getId()))) == null) {
                    SubGcEntity subGcEntity = new SubGcEntity(userIn.getSubContractor(), staffEntity.getGeneralContractorEntity());
                    subGcDAO.create(subGcEntity);
                    BbUser user = new BbUser();
                    user.setFirstName(userIn.getSubContractor().getFirstName());
                    user.setEmail(userIn.getSubContractor().getEmail());
                    user.setLastName(userIn.getSubContractor().getLastName());
                    String confirmUrl = "/portal/login";
                    this.sendEmail(user, staffEntity.getGeneralContractorEntity().getId(), confirmUrl);
                    continue;
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"The releation is already exist").build();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"An internal error has occured").build();
        }
        return Response.ok((Object)"mail sent").build();
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    private String generateBodyEmail(BbUser user, Long gcId, String confirmUrl) throws FileNotFoundException {
        Object message = null;
        ProjectSubDAO projectSubDAO = (ProjectSubDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class));
        SubCatDAO subCatDAO = (SubCatDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class));
        SubGcDAO subGcDAO = (SubGcDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(SubGcDAO.class));
        StaffDAO staffDAO = UsersRestService.getService(StaffDAO.class, null);
        StaffEntity staffEntity = (StaffEntity)staffDAO.find((Serializable)((Object)ConversationState.getCurrent().getIdentity().getUserId()));
        String base_url = System.getProperty("gatein.email.domain.url");
        confirmUrl = base_url + confirmUrl;
        confirmUrl.replace("http", "https");
        String creator = staffEntity.getFirstName() + " " + staffEntity.getLastName() != null ? staffEntity.getLastName() : "";
        String phone = staffEntity.getGeneralContractorEntity().getCompanyPhone() != null ? staffEntity.getGeneralContractorEntity().getCompanyPhone() : "";
        String mail = staffEntity.getGeneralContractorEntity().getEmail() != null ? staffEntity.getGeneralContractorEntity().getEmail() : "";
        String companyName = staffEntity.getGeneralContractorEntity().getCompanyName() != null ? staffEntity.getGeneralContractorEntity().getCompanyName() : "";
        String contact = staffEntity.getGeneralContractorEntity().getCompanyCountry() + "" + staffEntity.getGeneralContractorEntity().getCompanyState() + " " + staffEntity.getGeneralContractorEntity().getCompanyCity();
        LOG.info((Object)(" send email hello " + user.getEmail() + " for gc = " + gcId));
        String imagePath = base_url + "/exo-community-webui-portlet/skin/images";
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("imagepath", imagePath);
        props.put("confirmUrl", confirmUrl);
        props.put("CREATOR", creator);
        props.put("MAIL", mail);
        props.put("FULL_NAME", user.getFirstName() + " " + user.getLastName());
        props.put("FIRST_NAME", user.getFirstName());
        props.put("CONTACT", contact);
        props.put("PHONE", phone);
        props.put("COMPANYNAME", companyName);
        return this.resolveTemplate(props);
    }

    private String resolveTemplate(Map<String, String> properties) throws FileNotFoundException {
        String templateContent = this.generateBodyEmailContent();
        if (templateContent != null) {
            for (Map.Entry<String, String> property : properties.entrySet()) {
                if (null == property.getKey() || null == property.getValue()) continue;
                templateContent = templateContent.replace("${" + property.getKey() + "}", property.getValue());
            }
        }
        return templateContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateBodyEmailContent() {
        try {
            InputStream bodyEmailIS = this.getClass().getResourceAsStream("/html/template_register_email.html");
            StringBuilder sb = new StringBuilder();
            try (Scanner scanner = new Scanner(bodyEmailIS);){
                while (scanner.hasNextLine()) {
                    sb.append(scanner.nextLine()).append(System.getProperty("line.separator"));
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            LOG.error((Object)" ==== ERR cannot get body email content ", (Throwable)e);
            return null;
        }
    }

    public void sendEmail(BbUser user, Long gcId, String confirmUrl) {
        LOG.debug((Object)("=== send register  email to " + user.getEmail() + ") "));
        MailService mailService = UsersRestService.getService(MailService.class, null);
        Message message = new Message();
        message.setReceiver(user.getEmail());
        message.setTo(user.getEmail());
        try {
            String body = this.generateBodyEmail(user, gcId, confirmUrl);
            message.setBody(body);
            message.setFrom(System.getProperty("gatein.email.smtp.from"));
            message.setMimeType("text/html");
            message.setSubject("INVITATION TO COLLABORATE");
            mailService.sendMessage(message);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"=== register: send confirmation email: cannot file email temmplate ");
        }
        catch (Exception e) {
            LOG.error((Object)("=== Registration process: send confirmation email " + e.getMessage()));
        }
    }
}

