/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.storage.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.query.QueryImpl;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.ps.chromattic.entity.SimpleNotification;
import org.exoplatform.ps.chromattic.entity.SimpleNotificationsLocation;
import org.exoplatform.ps.storage.api.SimpleNotifServiceStorage;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class SimpleNotifServiceStorageImpl
extends AbstractStorage
implements SimpleNotifServiceStorage {
    private static final Log LOG = ExoLogger.getLogger(SimpleNotifServiceStorageImpl.class);
    private static final String CHROMATTIC_LIFECYCLE_NAME = "tbb";
    private ChromatticLifeCycle lifeCycle;

    public SimpleNotifServiceStorageImpl(ChromatticManager chromatticManager, NodeHierarchyCreator nodeHierarchyCreator) {
        this.lifeCycle = chromatticManager.getLifeCycle(CHROMATTIC_LIFECYCLE_NAME);
    }

    @Override
    public ChromatticSession getSession() {
        return this.lifeCycle.getChromattic().openSession();
    }

    @Override
    public void createSimpleNotification(String userId, String summary, String type, int number) throws Exception {
        Node node = this.getSession().getJCRSession().getRootNode();
        if (!(node = node.getNode("production")).hasNode("simplenotifs")) {
            node = node.addNode("simplenotifs", "tbb:simpleNotificationLocation");
            node.addMixin("mix:referenceable");
            node.getSession().save();
        } else {
            node = node.getNode("simplenotifs");
        }
        Long lId = System.currentTimeMillis();
        while ((SimpleNotification)this.getSession().findByPath(SimpleNotification.class, "/production/simplenotifs/" + String.valueOf(userId + lId), true) != null) {
            Long l = lId;
            Long l2 = lId = Long.valueOf(lId + 1L);
        }
        SimpleNotificationsLocation parentNode = (SimpleNotificationsLocation)this.getSession().findByPath(SimpleNotificationsLocation.class, node.getPath(), true);
        SimpleNotification notif = (SimpleNotification)this.getSession().create(SimpleNotification.class, userId + lId);
        this.getSession().persist((Object)parentNode, (Object)notif);
        this.getSession().save();
        notif.setSummary(summary);
        notif.setType(type);
        notif.setUserId(userId);
        notif.setNumber(number);
        this.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSimpleNotification(String notifId) throws Exception {
        block5: {
            ChromatticSession session = this.getSession();
            try {
                SimpleNotification notif = (SimpleNotification)session.findByPath(SimpleNotification.class, "/production/simplenotifs/" + notifId, true);
                if (notif != null) {
                    session.remove((Object)notif);
                    session.save();
                    break block5;
                }
                LOG.error((Object)"Node to delete not found");
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public List<SimpleNotification> getSimpleNotificationsByUserId(String userId, long offset, long limit) throws Exception {
        QueryBuilder builder = this.getSession().createQueryBuilder(SimpleNotification.class);
        WhereExpression whereExpression = new WhereExpression();
        whereExpression.like(JCRProperties.path, (Object)"/production/simplenotifs/%");
        PropertyLiteralExpression condition = new PropertyLiteralExpression(String.class, "tbb:userId");
        whereExpression.and().equals(condition, (Object)userId);
        builder.where(whereExpression.toString());
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult results = null;
        results = Long.valueOf(limit) == 0L ? queryImpl.objects() : queryImpl.objects(Long.valueOf(offset), Long.valueOf(limit));
        ArrayList<SimpleNotification> sResult = new ArrayList<SimpleNotification>();
        while (results.hasNext()) {
            sResult.add((SimpleNotification)results.next());
        }
        return sResult;
    }
}

